/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Processor.Paths;

import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.Namespaces.ContainerNamespace;
import com.rookout.rook.Processor.Namespaces.JavaObjectNamespace;
import com.rookout.rook.Processor.Namespaces.ListNamespace;
import com.rookout.rook.Processor.Namespaces.Namespace;
import com.rookout.rook.Processor.Paths.ArithmeticPathInternal.Actions;
import com.rookout.rook.Processor.Paths.ArithmeticPathInternal.Maps;
import com.rookout.rook.Processor.Paths.ArithmeticPathInternal.ParseError;
import com.rookout.rook.Processor.Paths.ArithmeticPathInternal.TreeNode;
import com.rookout.rook.Processor.Paths.ArithmeticPathUtils;
import com.rookout.rook.Processor.Paths.Path;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import rook.com.udojava.evalex.Expression;
import rook.org.json.JSONObject;

public class ArithmeticPath
implements Path {
    private static final Class[] primitiveClassesList = new Class[]{Integer.class, Long.class, Double.class, Float.class, Character.class, Boolean.class, Byte.class, Short.class, String.class, ArrayList.class, LinkedList.class, CopyOnWriteArrayList.class, Vector.class, HashMap.class, ConcurrentHashMap.class, Hashtable.class, LinkedHashMap.class, TreeMap.class, WeakHashMap.class, Enum.class, HashSet.class};
    private static final Set<Class> primitiveClasses = new HashSet<Class>(Arrays.asList(primitiveClassesList));
    private static final Class[] specialNodesList = new Class[]{Text.class, NamespaceResult.class, NonPrimitiveNamespaceResult.class, Bool.class};
    private static final Set<Class> specialNodesClasses = new HashSet<Class>(Arrays.asList(specialNodesList));
    private String path;

    public ArithmeticPath(String path) throws Exceptions.ToolException {
        if (path.isEmpty()) {
            throw new Exceptions.RookInvalidArithmeticPath(path, null);
        }
        this.path = path;
    }

    public ArithmeticPath(JSONObject object) throws Exceptions.ToolException {
        this(object.getString("path"));
    }

    @Override
    public Namespace ReadFrom(Namespace namespace) throws Exceptions.ToolException {
        MapsActions context = new MapsActions(namespace);
        try {
            TreeNode result = Maps.parse(this.path, context);
            return this.normalizeResult(result);
        }
        catch (ParseError e) {
            throw new Exceptions.RookInvalidArithmeticPath(this.path, e);
        }
    }

    private Namespace normalizeResult(TreeNode result) throws Exceptions.ToolException {
        String className;
        switch (className = result.getClass().getSimpleName()) {
            case "Array": {
                ArrayList<String> arr = new ArrayList<String>();
                for (TreeNode res : ((Array)result).list) {
                    arr.add(res.toString());
                }
                return new JavaObjectNamespace(arr);
            }
            case "NamespaceResult": {
                return ((NamespaceResult)result).namespace;
            }
            case "ToolException": {
                throw ((ToolException)result).exc;
            }
            case "NonPrimitiveNamespaceResult": {
                return ((NonPrimitiveNamespaceResult)result).namespace;
            }
        }
        if (result.toString().equals("true") || result.toString().equals("false")) {
            return new JavaObjectNamespace(Boolean.parseBoolean(result.toString()));
        }
        return new JavaObjectNamespace(result.toString());
    }

    @Override
    public void WriteTo(Namespace namespace, Namespace value) throws Exceptions.ToolException {
        int i;
        MapsActions context = new MapsActions(namespace);
        try {
            Maps.parse(this.path, context);
        }
        catch (ParseError e) {
            throw new Exceptions.RookInvalidArithmeticPath(this.path, e);
        }
        int size = context.operations.size();
        if (size == 0) {
            throw new Exceptions.RookInvalidArithmeticPath(this.path, null);
        }
        for (i = 0; i < size - 1; ++i) {
            namespace = ((PathOperation)context.operations.get(i)).Read(namespace, true);
        }
        ((PathOperation)context.operations.get(i)).Write(namespace, value);
    }

    class MapsActions
    implements Actions {
        private Namespace namespace;
        private ArrayList<PathOperation> operations = new ArrayList();

        MapsActions(Namespace namespace) {
            this.namespace = namespace;
        }

        @Override
        public TreeNode make_lookup_operation(String input, int start, int end, List<TreeNode> elements) {
            return new LookupOperation(input.substring(start + 1, end - 1));
        }

        @Override
        public TreeNode make_function_operation(String input, int start, int end, List<TreeNode> elements) {
            String functionName = elements.get((int)0).text + elements.get((int)1).text;
            if (elements.get(3) instanceof ToolException) {
                return elements.get(3);
            }
            String args = elements.get((int)3).text;
            return new FunctionOperation(functionName, args);
        }

        @Override
        public TreeNode make_function_operation_access(String input, int start, int end, List<TreeNode> elements) {
            String functionName = elements.get((int)1).text + elements.get((int)2).text;
            if (elements.get(4) instanceof ToolException) {
                return elements.get(4);
            }
            String args = elements.get((int)4).text;
            return new FunctionOperation(functionName, args);
        }

        @Override
        public TreeNode make_attribute_operation(String input, int start, int end, List<TreeNode> elements) {
            return new AttributeOperation(input.substring(start + 1, end));
        }

        @Override
        public TreeNode make_attribute(String input, int start, int end, List<TreeNode> elements) {
            return new AttributeOperation(input.substring(start, end));
        }

        @Override
        public TreeNode make_and_execute_namespace_operation(String input, int start, int end, List<TreeNode> elements) {
            try {
                if (elements.get(1) instanceof ToolException) {
                    return elements.get(1);
                }
                this.operations = new ArrayList();
                this.operations.add((PathOperation)elements.get(1));
                for (TreeNode a : elements.get(2)) {
                    if (a instanceof ToolException) {
                        return a;
                    }
                    this.operations.add((PathOperation)a);
                }
                Class<?> cls = elements.get(1).getClass();
                if (cls != AttributeOperation.class && cls != FunctionOperation.class && cls != LookupOperation.class) {
                    return new ToolException(new Exceptions.RookInvalidArithmeticPath("Unexpected path: " + input, null));
                }
                Namespace result = ((PathOperation)elements.get(1)).Read(this.namespace, false);
                for (TreeNode a : elements.get(2)) {
                    result = ((PathOperation)a).Read(result, false);
                }
                if (JavaObjectNamespace.class == result.getClass()) {
                    JavaObjectNamespace obj = (JavaObjectNamespace)result;
                    if (obj.obj != null) {
                        if (JavaObjectNamespace.class == obj.obj.getClass()) {
                            obj = (JavaObjectNamespace)obj.obj;
                        }
                        if (obj.obj != null) {
                            Class<?> objCls = obj.obj.getClass();
                            if (!primitiveClasses.contains(objCls)) {
                                if (objCls.isEnum()) {
                                    result = new JavaObjectNamespace(((Enum)obj.obj).name());
                                } else if (objCls.isArray()) {
                                    int l = java.lang.reflect.Array.getLength(obj.obj);
                                    ArrayList<Namespace> list = new ArrayList<Namespace>();
                                    for (int i = 0; i < l; ++i) {
                                        list.add(new JavaObjectNamespace(java.lang.reflect.Array.get(obj.obj, i)));
                                    }
                                    result = new ListNamespace(list);
                                } else {
                                    return new NonPrimitiveNamespaceResult(result, input.substring(start, end));
                                }
                            }
                        }
                    }
                }
                return new NamespaceResult(result);
            }
            catch (Exceptions.ToolException e) {
                return new ToolException(e);
            }
        }

        @Override
        public Text make_apostrophe_string(String input, int start, int end, List<TreeNode> elements) {
            return new Text(elements.get((int)2).text);
        }

        @Override
        public Text make_string(String input, int start, int end, List<TreeNode> elements) {
            return new Text(elements.get((int)2).text);
        }

        @Override
        public Array make_list(String input, int start, int end, List<TreeNode> elements) {
            TreeFlatter treeFlatter = new TreeFlatter();
            List<TreeNode> list = treeFlatter.run(elements.get(3));
            return new Array(list, input.substring(start, end));
        }

        @Override
        public TreeNode make_comp_exp(String input, int start, int end, List<TreeNode> elements) {
            if (elements.get((int)1).elements.size() == 0) {
                return elements.get(0);
            }
            ArrayList<TreeNode> flatElements = new ArrayList<TreeNode>();
            flatElements.add(elements.get(0));
            for (TreeNode nn : elements.get((int)1).elements) {
                flatElements.add(nn.elements.get(0));
                flatElements.add(nn.elements.get(1));
            }
            while (flatElements.size() > 1) {
                boolean shouldStop = false;
                block2: for (int level = 0; level < ArithmeticPathUtils.allLevels.length && !shouldStop; ++level) {
                    for (int i = 1; i < flatElements.size(); i += 2) {
                        if (((TreeNode)flatElements.get(i)).getClass() != Opt.class) {
                            return new ToolException(new Exceptions.RookInvalidArithmeticPath("Could not convert opt: " + ((TreeNode)flatElements.get(i)).toString(), null));
                        }
                        Opt currentOpt = (Opt)flatElements.get(i);
                        if (currentOpt.level != level) continue;
                        TreeNode result = ((TreeNode)flatElements.get(i - 1)).getClass().getSimpleName().equals("ToolException") ? (TreeNode)flatElements.get(i - 1) : (((TreeNode)flatElements.get(i + 1)).getClass().getSimpleName().equals("ToolException") ? (TreeNode)flatElements.get(i + 1) : currentOpt.executeOperation((TreeNode)flatElements.get(i - 1), (TreeNode)flatElements.get(i + 1)));
                        flatElements.set(i - 1, result);
                        flatElements.remove(i + 1);
                        flatElements.remove(i);
                        shouldStop = true;
                        continue block2;
                    }
                }
            }
            return (TreeNode)flatElements.get(0);
        }

        @Override
        public TreeNode make_comp_exp_ex(String input, int start, int end, List<TreeNode> elements) {
            return elements.get(2);
        }

        @Override
        public FloatNumber make_float(String input, int start, int end, List<TreeNode> elements) {
            return new FloatNumber(input.substring(start, end).replace(" ", ""));
        }

        @Override
        public Number make_number(String input, int start, int end, List<TreeNode> elements) {
            return new Number(input.substring(start, end).replace(" ", ""));
        }

        @Override
        public Char make_char(String input, int start, int end, List<TreeNode> elements) {
            return new Char(Character.valueOf(input.charAt(start + 1)));
        }

        @Override
        public Bool make_bool(String input, int start, int end, List<TreeNode> elements) {
            return new Bool(input.substring(start, end).replaceAll(" ", ""));
        }

        @Override
        public Text make_null(String input, int start, int end, List<TreeNode> elements) {
            return new None();
        }

        @Override
        public Text make_undefined(String input, int start, int end, List<TreeNode> elements) {
            return new None();
        }

        @Override
        public TreeNode make_opt(String input, int start, int end, List<TreeNode> elements) {
            try {
                return new Opt(input.substring(start, end).replaceAll(" ", ""));
            }
            catch (Exceptions.RookInvalidArithmeticPath e) {
                return new ToolException(e);
            }
        }

        class TreeFlatter {
            List<TreeNode> flatList = new ArrayList<TreeNode>();

            TreeFlatter() {
            }

            List<TreeNode> run(TreeNode currentElements) {
                if (currentElements instanceof Marker) {
                    this.flatList.add(currentElements);
                }
                for (TreeNode temp : currentElements.elements) {
                    if (temp instanceof Marker) {
                        this.flatList.add(temp);
                        continue;
                    }
                    this.run(temp);
                }
                return this.flatList;
            }
        }

        public class GenSet<E> {
            private List<E> a;

            public GenSet(Class<E> c, int s) {
                ArrayList a = new ArrayList();
                this.a = a;
            }

            public void add(E el) {
                this.a.add(el);
            }

            E get(int i) {
                return this.a.get(i);
            }
        }
    }

    class Opt
    extends TreeNode {
        private String opt;
        int level;

        private boolean isNone(TreeNode node) {
            return None.class == node.getClass();
        }

        private TreeNode ifNonPrimitiveType(TreeNode a, TreeNode b, TreeNode defaultResult) {
            if (NonPrimitiveNamespaceResult.class == a.getClass() && !this.isNone(b)) {
                return new ToolException(new Exceptions.RookNonPrimitiveObjectType(((NonPrimitiveNamespaceResult)a).path));
            }
            if (NonPrimitiveNamespaceResult.class == b.getClass() && !this.isNone(a)) {
                return new ToolException(new Exceptions.RookNonPrimitiveObjectType(((NonPrimitiveNamespaceResult)b).path));
            }
            return defaultResult;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public TreeNode executeOperation(TreeNode a, TreeNode b) {
            switch (this.level) {
                case 0: 
                case 1: 
                case 2: 
                case 4: {
                    if (specialNodesClasses.contains(a.getClass()) || specialNodesClasses.contains(b.getClass())) {
                        boolean res = a.toString().equals(b.toString());
                        if (this.opt.equals("==")) {
                            if (!res) return this.ifNonPrimitiveType(a, b, new Bool("false"));
                            return new Bool("true");
                        }
                        if (this.opt.equals("!=")) {
                            if (res) return this.ifNonPrimitiveType(a, b, new Bool("false"));
                            return new Bool("true");
                        }
                        if (NonPrimitiveNamespaceResult.class == a.getClass()) {
                            return new ToolException(new Exceptions.RookNonPrimitiveObjectType(((NonPrimitiveNamespaceResult)a).path));
                        }
                        if (NonPrimitiveNamespaceResult.class == b.getClass()) {
                            return new ToolException(new Exceptions.RookNonPrimitiveObjectType(((NonPrimitiveNamespaceResult)b).path));
                        }
                    }
                    String operation = a.toString() + " " + this.opt + " " + b.toString();
                    Expression expression = new Expression(operation, MathContext.DECIMAL128);
                    String result = "";
                    try {
                        result = expression.eval().toPlainString();
                    }
                    catch (Exception e) {
                        String firstElement = a.toString();
                        char firstCensoredChar = firstElement.charAt(0);
                        if (firstElement.length() > 1) {
                            firstCensoredChar = firstElement.charAt(1);
                        }
                        String secondElement = b.toString();
                        char secondCensoredChar = secondElement.charAt(0);
                        if (secondElement.length() > 1) {
                            secondCensoredChar = secondElement.charAt(1);
                        }
                        String censoredOperation = firstCensoredChar + "... " + this.opt + " " + secondCensoredChar + "...";
                        return new ToolException(new Exceptions.RookExceptionEvaluationFailed(censoredOperation));
                    }
                    if (!expression.isBoolean()) return new TextResult(result);
                    if (!result.equals("1")) return new Bool("false");
                    return new Bool("true");
                }
                case 3: {
                    if (b instanceof Array) {
                        for (TreeNode itr : ((Array)b).list) {
                            if (itr.getClass() != a.getClass() || !itr.text.equals(a.text)) continue;
                            return new TextResult("true");
                        }
                        return new TextResult("false");
                    } else {
                        if (!(b instanceof NamespaceResult)) return new ToolException(new Exceptions.RookInvalidArithmeticPath("Bad 'in' operation, probably non-primitive element is found", null));
                        if (!(((NamespaceResult)b).namespace instanceof ListNamespace)) return new ToolException(new Exceptions.RookInvalidArithmeticPath("Bad 'in' operation, probably non-primitive element is found", null));
                        ListNamespace listNamespace = (ListNamespace)((NamespaceResult)b).namespace;
                        for (Namespace itr : listNamespace.list) {
                            if (!((JavaObjectNamespace)itr).obj.toString().equals(a.text)) continue;
                            return new TextResult("true");
                        }
                    }
                    return new TextResult("false");
                }
            }
            return new TextResult("false");
        }

        Opt(String opt) throws Exceptions.RookInvalidArithmeticPath {
            this.text = opt;
            String optUpperCase = opt.toUpperCase();
            this.opt = opt;
            for (Map.Entry<String, String> itr : ArithmeticPathUtils.ops.entrySet()) {
                if (!optUpperCase.equals(itr.getKey())) continue;
                this.opt = itr.getValue();
                break;
            }
            Boolean found = false;
            block1: for (int i = 0; i < ArithmeticPathUtils.allLevels.length && !found.booleanValue(); ++i) {
                for (int j = 0; j < ArithmeticPathUtils.allLevels[i].length; ++j) {
                    if (!opt.equals(ArithmeticPathUtils.allLevels[i][j])) continue;
                    this.level = i;
                    found = true;
                    continue block1;
                }
            }
            if (!found.booleanValue()) {
                throw new Exceptions.RookInvalidArithmeticPath("Condition could not be resolved: " + opt, null);
            }
        }
    }

    class Bool
    extends Marker {
        private boolean bool;

        Bool(String bool) {
            this.bool = Boolean.parseBoolean(bool);
            this.text = bool;
        }

        public String toString() {
            return Boolean.toString(this.bool);
        }
    }

    class Char
    extends Marker {
        private Character chr;

        Char(Character chr) {
            this.chr = chr;
            this.text = "'" + chr.toString() + "'";
        }

        public String toString() {
            return this.chr.toString();
        }
    }

    class Number
    extends Marker {
        private long number;

        Number(String number) {
            this.number = Long.parseLong(number, 10);
            this.text = number;
        }

        public String toString() {
            return Long.toString(this.number);
        }
    }

    class FloatNumber
    extends Marker {
        private BigDecimal number;

        FloatNumber(String number) {
            this.number = new BigDecimal(number);
            this.text = number;
        }

        public String toString() {
            return this.number.toString();
        }
    }

    class Array
    extends Marker {
        List<TreeNode> list;

        Array(List<TreeNode> list, String str) {
            this.list = list;
            this.text = str;
        }

        public String toString() {
            return this.text;
        }
    }

    class TextResult
    extends Text {
        TextResult(String string) {
            super(string);
            this.string = "\"" + string + "\"";
            this.text = string;
        }

        @Override
        public String toString() {
            return this.text;
        }
    }

    class None
    extends Text {
        None() {
            super("null");
        }
    }

    class Text
    extends Marker {
        String string;

        Text(String string) {
            this.string = "\"" + string + "\"";
            this.text = string;
        }

        public String toString() {
            return this.string;
        }
    }

    class NonPrimitiveNamespaceResult
    extends NamespaceResult {
        String path;

        NonPrimitiveNamespaceResult(Namespace namespace, String path) {
            super(namespace);
            this.path = path;
        }

        public String GetPath() {
            return this.path;
        }

        @Override
        public String toString() {
            return "NonPrimitiveNamespaceResult";
        }
    }

    class NamespaceResult
    extends Marker {
        Namespace namespace;

        NamespaceResult(Namespace namespace) {
            this.namespace = namespace;
            this.text = "true";
            if (this.namespace instanceof JavaObjectNamespace) {
                Object obj = ((JavaObjectNamespace)this.namespace).obj;
                this.text = obj != null ? (obj instanceof String ? "\"" + obj.toString() + "\"" : (obj instanceof Double || obj instanceof Float ? new BigDecimal(obj.toString()).toString() : obj.toString())) : "\"null\"";
            }
        }

        public String toString() {
            return this.text;
        }
    }

    class AttributeOperation
    extends PathOperation {
        private String name;

        AttributeOperation(String name) {
            this.name = name;
        }

        @Override
        public Namespace Read(Namespace namespace, boolean create) throws Exceptions.ToolException {
            try {
                return namespace.ReadAttribute(this.name);
            }
            catch (Exceptions.RookAttributeNotFound e) {
                if (create) {
                    ContainerNamespace newNamespace = new ContainerNamespace();
                    namespace.WriteAttribute(this.name, newNamespace);
                    return newNamespace;
                }
                throw e;
            }
        }

        @Override
        public void Write(Namespace namespace, Namespace value) throws Exceptions.ToolException {
            namespace.WriteAttribute(this.name, value);
        }

        public String toString() {
            return this.text;
        }
    }

    class FunctionOperation
    extends PathOperation {
        private String functionName;
        private String args;

        FunctionOperation(String functionName, String args) {
            this.functionName = functionName;
            this.args = args;
        }

        @Override
        public Namespace Read(Namespace namespace, boolean create) throws Exceptions.ToolException {
            return namespace.CallMethod(this.functionName, this.args);
        }

        @Override
        public void Write(Namespace namespace, Namespace value) throws Exceptions.ToolException {
            throw new Exceptions.RookOperationReadOnly(this.getClass());
        }

        public String toString() {
            return this.text;
        }
    }

    class LookupOperation
    extends PathOperation {
        private Object key;

        LookupOperation(String name) {
            this.key = name.startsWith("'") && name.endsWith("'") || name.startsWith("\"") && name.endsWith("\"") ? name.substring(1, name.length() - 1) : Integer.valueOf(Integer.parseInt(name));
        }

        @Override
        public Namespace Read(Namespace namespace, boolean create) throws Exceptions.ToolException {
            return namespace.ReadKey(this.key);
        }

        @Override
        public void Write(Namespace namespace, Namespace value) throws Exceptions.ToolException {
            throw new Exceptions.RookOperationReadOnly(this.getClass());
        }

        public String toString() {
            return this.text;
        }
    }

    private abstract class PathOperation
    extends Marker {
        private PathOperation() {
        }

        abstract Namespace Read(Namespace var1, boolean var2) throws Exceptions.ToolException;

        abstract void Write(Namespace var1, Namespace var2) throws Exceptions.ToolException;
    }

    class ToolException
    extends Marker {
        Exceptions.ToolException exc;

        ToolException(Exceptions.ToolException exc) {
            this.exc = exc;
        }

        public String toString() {
            return this.exc.toString();
        }
    }

    class Marker
    extends TreeNode {
        Marker() {
        }
    }
}

