/*
 * Decompiled with CFR 0.152.
 */
package rook.io.grpc.internal;

import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import rook.com.google.common.base.MoreObjects;
import rook.com.google.common.base.Preconditions;
import rook.io.grpc.Attributes;
import rook.io.grpc.CallCredentials;
import rook.io.grpc.CallOptions;
import rook.io.grpc.ChannelLogger;
import rook.io.grpc.Metadata;
import rook.io.grpc.MethodDescriptor;
import rook.io.grpc.SecurityLevel;
import rook.io.grpc.Status;
import rook.io.grpc.internal.ClientStream;
import rook.io.grpc.internal.ClientTransportFactory;
import rook.io.grpc.internal.ConnectionClientTransport;
import rook.io.grpc.internal.ForwardingConnectionClientTransport;
import rook.io.grpc.internal.GrpcAttributes;
import rook.io.grpc.internal.MetadataApplierImpl;

final class CallCredentialsApplyingTransportFactory
implements ClientTransportFactory {
    private final ClientTransportFactory delegate;
    private final Executor appExecutor;

    CallCredentialsApplyingTransportFactory(ClientTransportFactory delegate, Executor appExecutor) {
        this.delegate = Preconditions.checkNotNull(delegate, "delegate");
        this.appExecutor = Preconditions.checkNotNull(appExecutor, "appExecutor");
    }

    @Override
    public ConnectionClientTransport newClientTransport(SocketAddress serverAddress, ClientTransportFactory.ClientTransportOptions options, ChannelLogger channelLogger) {
        return new CallCredentialsApplyingTransport(this.delegate.newClientTransport(serverAddress, options, channelLogger), options.getAuthority());
    }

    @Override
    public ScheduledExecutorService getScheduledExecutorService() {
        return this.delegate.getScheduledExecutorService();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    private class CallCredentialsApplyingTransport
    extends ForwardingConnectionClientTransport {
        private final ConnectionClientTransport delegate;
        private final String authority;

        CallCredentialsApplyingTransport(ConnectionClientTransport delegate, String authority) {
            this.delegate = Preconditions.checkNotNull(delegate, "delegate");
            this.authority = Preconditions.checkNotNull(authority, "authority");
        }

        @Override
        protected ConnectionClientTransport delegate() {
            return this.delegate;
        }

        @Override
        public ClientStream newStream(final MethodDescriptor<?, ?> method, Metadata headers, final CallOptions callOptions) {
            CallCredentials creds = callOptions.getCredentials();
            if (creds != null) {
                MetadataApplierImpl applier = new MetadataApplierImpl(this.delegate, method, headers, callOptions);
                CallCredentials.RequestInfo requestInfo = new CallCredentials.RequestInfo(){

                    @Override
                    public MethodDescriptor<?, ?> getMethodDescriptor() {
                        return method;
                    }

                    @Override
                    public SecurityLevel getSecurityLevel() {
                        return MoreObjects.firstNonNull(CallCredentialsApplyingTransport.this.delegate.getAttributes().get(GrpcAttributes.ATTR_SECURITY_LEVEL), SecurityLevel.NONE);
                    }

                    @Override
                    public String getAuthority() {
                        return MoreObjects.firstNonNull(callOptions.getAuthority(), CallCredentialsApplyingTransport.this.authority);
                    }

                    @Override
                    public Attributes getTransportAttrs() {
                        return CallCredentialsApplyingTransport.this.delegate.getAttributes();
                    }
                };
                try {
                    creds.applyRequestMetadata(requestInfo, MoreObjects.firstNonNull(callOptions.getExecutor(), CallCredentialsApplyingTransportFactory.this.appExecutor), applier);
                }
                catch (Throwable t) {
                    applier.fail(Status.UNAUTHENTICATED.withDescription("Credentials should use fail() instead of throwing exceptions").withCause(t));
                }
                return applier.returnStream();
            }
            return this.delegate.newStream(method, headers, callOptions);
        }
    }
}

