/*
 * Decompiled with CFR 0.152.
 */
package rook.io.opencensus.metrics;

import java.util.List;
import rook.io.opencensus.common.ToLongFunction;
import rook.io.opencensus.internal.Utils;
import rook.io.opencensus.metrics.LabelKey;
import rook.io.opencensus.metrics.LabelValue;
import rook.javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class DerivedLongGauge {
    public abstract <T> void createTimeSeries(List<LabelValue> var1, T var2, ToLongFunction<T> var3);

    public abstract void removeTimeSeries(List<LabelValue> var1);

    public abstract void clear();

    static DerivedLongGauge newNoopDerivedLongGauge(String name, String description, String unit, List<LabelKey> labelKeys) {
        return NoopDerivedLongGauge.create(name, description, unit, labelKeys);
    }

    private static final class NoopDerivedLongGauge
    extends DerivedLongGauge {
        private final int labelKeysSize;

        static NoopDerivedLongGauge create(String name, String description, String unit, List<LabelKey> labelKeys) {
            return new NoopDerivedLongGauge(name, description, unit, labelKeys);
        }

        NoopDerivedLongGauge(String name, String description, String unit, List<LabelKey> labelKeys) {
            Utils.checkNotNull(name, "name");
            Utils.checkNotNull(description, "description");
            Utils.checkNotNull(unit, "unit");
            Utils.checkListElementNotNull(Utils.checkNotNull(labelKeys, "labelKeys"), "labelKey");
            this.labelKeysSize = labelKeys.size();
        }

        @Override
        public <T> void createTimeSeries(List<LabelValue> labelValues, T obj, ToLongFunction<T> function) {
            Utils.checkListElementNotNull(Utils.checkNotNull(labelValues, "labelValues"), "labelValue");
            Utils.checkArgument(this.labelKeysSize == labelValues.size(), "Label Keys and Label Values don't have same size.");
            Utils.checkNotNull(function, "function");
        }

        @Override
        public void removeTimeSeries(List<LabelValue> labelValues) {
            Utils.checkNotNull(labelValues, "labelValues");
        }

        @Override
        public void clear() {
        }
    }
}

