/*
 * Decompiled with CFR 0.152.
 */
package rook.io.opencensus.trace;

import rook.io.opencensus.common.Clock;
import rook.io.opencensus.internal.ZeroTimeClock;
import rook.io.opencensus.trace.Tracer;
import rook.io.opencensus.trace.config.TraceConfig;
import rook.io.opencensus.trace.export.ExportComponent;
import rook.io.opencensus.trace.propagation.PropagationComponent;

public abstract class TraceComponent {
    public abstract Tracer getTracer();

    public abstract PropagationComponent getPropagationComponent();

    public abstract Clock getClock();

    public abstract ExportComponent getExportComponent();

    public abstract TraceConfig getTraceConfig();

    static TraceComponent newNoopTraceComponent() {
        return new NoopTraceComponent();
    }

    private static final class NoopTraceComponent
    extends TraceComponent {
        private final ExportComponent noopExportComponent = ExportComponent.newNoopExportComponent();

        @Override
        public Tracer getTracer() {
            return Tracer.getNoopTracer();
        }

        @Override
        public PropagationComponent getPropagationComponent() {
            return PropagationComponent.getNoopPropagationComponent();
        }

        @Override
        public Clock getClock() {
            return ZeroTimeClock.getInstance();
        }

        @Override
        public ExportComponent getExportComponent() {
            return this.noopExportComponent;
        }

        @Override
        public TraceConfig getTraceConfig() {
            return TraceConfig.getNoopTraceConfig();
        }

        private NoopTraceComponent() {
        }
    }
}

