/*
 * Decompiled with CFR 0.152.
 */
package com.antonyt.infiniteviewpager;

import android.content.Context;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import hirondelle.date4j.DateTime;
import java.util.ArrayList;

public class InfiniteViewPager
extends ViewPager {
    public static final int OFFSET = 1000;
    private ArrayList<DateTime> datesInMonth;
    private boolean enabled = true;
    private boolean sixWeeksInCalendar = false;
    private int rowHeight = 0;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isSixWeeksInCalendar() {
        return this.sixWeeksInCalendar;
    }

    public ArrayList<DateTime> getDatesInMonth() {
        return this.datesInMonth;
    }

    public void setDatesInMonth(ArrayList<DateTime> datesInMonth) {
        this.datesInMonth = datesInMonth;
    }

    public void setSixWeeksInCalendar(boolean sixWeeksInCalendar) {
        this.sixWeeksInCalendar = sixWeeksInCalendar;
        this.rowHeight = 0;
    }

    public InfiniteViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public InfiniteViewPager(Context context) {
        super(context);
    }

    public void setAdapter(PagerAdapter adapter) {
        super.setAdapter(adapter);
        this.setCurrentItem(1000);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.enabled) {
            return super.onTouchEvent(event);
        }
        return false;
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        if (this.enabled) {
            return super.onInterceptTouchEvent(event);
        }
        return false;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int rows = this.datesInMonth.size() / 7;
        if (this.getChildCount() > 0 && this.rowHeight == 0) {
            View firstChild = this.getChildAt(0);
            int width = this.getMeasuredWidth();
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000);
            firstChild.measure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
            this.rowHeight = firstChild.getMeasuredHeight();
        }
        int calHeight = this.sixWeeksInCalendar ? this.rowHeight * 6 : this.rowHeight * rows;
        heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(calHeight -= 12), (int)0x40000000);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }
}

