/*
 * Decompiled with CFR 0.152.
 */
package com.roomorama.caldroid;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.text.format.DateUtils;
import android.text.format.Time;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.GridView;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.antonyt.infiniteviewpager.InfinitePagerAdapter;
import com.antonyt.infiniteviewpager.InfiniteViewPager;
import com.caldroid.R;
import com.roomorama.caldroid.CaldroidGridAdapter;
import com.roomorama.caldroid.CaldroidListener;
import com.roomorama.caldroid.CalendarHelper;
import com.roomorama.caldroid.DateGridFragment;
import com.roomorama.caldroid.MonthPagerAdapter;
import com.roomorama.caldroid.WeekdayArrayAdapter;
import hirondelle.date4j.DateTime;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

@SuppressLint(value={"DefaultLocale"})
public class CaldroidFragment
extends DialogFragment {
    public String TAG = "CaldroidFragment";
    public static int SUNDAY = 1;
    public static int MONDAY = 2;
    public static int TUESDAY = 3;
    public static int WEDNESDAY = 4;
    public static int THURSDAY = 5;
    public static int FRIDAY = 6;
    public static int SATURDAY = 7;
    private static final int MONTH_YEAR_FLAG = 52;
    private Time firstMonthTime = new Time();
    private final StringBuilder monthYearStringBuilder = new StringBuilder(50);
    private Formatter monthYearFormatter = new Formatter(this.monthYearStringBuilder, Locale.getDefault());
    public static final int NUMBER_OF_PAGES = 4;
    public static int disabledBackgroundDrawable = -1;
    public static int disabledTextColor = -7829368;
    private Button leftArrowButton;
    private Button rightArrowButton;
    private TextView monthTitleTextView;
    private GridView weekdayGridView;
    private InfiniteViewPager dateViewPager;
    private DatePageChangeListener pageChangeListener;
    private ArrayList<DateGridFragment> fragments;
    private int themeResource = R.style.CaldroidDefault;
    public static final String DIALOG_TITLE = "dialogTitle";
    public static final String MONTH = "month";
    public static final String YEAR = "year";
    public static final String SHOW_NAVIGATION_ARROWS = "showNavigationArrows";
    public static final String DISABLE_DATES = "disableDates";
    public static final String SELECTED_DATES = "selectedDates";
    public static final String MIN_DATE = "minDate";
    public static final String MAX_DATE = "maxDate";
    public static final String ENABLE_SWIPE = "enableSwipe";
    public static final String START_DAY_OF_WEEK = "startDayOfWeek";
    public static final String SIX_WEEKS_IN_CALENDAR = "sixWeeksInCalendar";
    public static final String ENABLE_CLICK_ON_DISABLED_DATES = "enableClickOnDisabledDates";
    public static final String SQUARE_TEXT_VIEW_CELL = "squareTextViewCell";
    public static final String THEME_RESOURCE = "themeResource";
    public static final String _MIN_DATE_TIME = "_minDateTime";
    public static final String _MAX_DATE_TIME = "_maxDateTime";
    public static final String _BACKGROUND_FOR_DATETIME_MAP = "_backgroundForDateTimeMap";
    public static final String _TEXT_COLOR_FOR_DATETIME_MAP = "_textColorForDateTimeMap";
    protected String dialogTitle;
    protected int month = -1;
    protected int year = -1;
    protected ArrayList<DateTime> disableDates = new ArrayList();
    protected ArrayList<DateTime> selectedDates = new ArrayList();
    protected DateTime minDateTime;
    protected DateTime maxDateTime;
    protected ArrayList<DateTime> dateInMonthsList;
    protected HashMap<String, Object> caldroidData = new HashMap();
    protected HashMap<String, Object> extraData = new HashMap();
    protected HashMap<DateTime, Integer> backgroundForDateTimeMap = new HashMap();
    protected HashMap<DateTime, Integer> textColorForDateTimeMap = new HashMap();
    protected int startDayOfWeek = SUNDAY;
    private boolean sixWeeksInCalendar = true;
    protected ArrayList<CaldroidGridAdapter> datePagerAdapters = new ArrayList();
    protected boolean enableSwipe = true;
    protected boolean showNavigationArrows = true;
    protected boolean enableClickOnDisabledDates = false;
    protected boolean squareTextViewCell;
    private AdapterView.OnItemClickListener dateItemClickListener;
    private AdapterView.OnItemLongClickListener dateItemLongClickListener;
    private CaldroidListener caldroidListener;

    public int getMonth() {
        return this.month;
    }

    public int getYear() {
        return this.year;
    }

    public CaldroidListener getCaldroidListener() {
        return this.caldroidListener;
    }

    public CaldroidGridAdapter getNewDatesGridAdapter(int month, int year) {
        return new CaldroidGridAdapter((Context)this.getActivity(), month, year, this.getCaldroidData(), this.extraData);
    }

    public WeekdayArrayAdapter getNewWeekdayAdapter(int themeResource) {
        return new WeekdayArrayAdapter((Context)this.getActivity(), 17367043, this.getDaysOfWeek(), themeResource);
    }

    public GridView getWeekdayGridView() {
        return this.weekdayGridView;
    }

    public ArrayList<DateGridFragment> getFragments() {
        return this.fragments;
    }

    public InfiniteViewPager getDateViewPager() {
        return this.dateViewPager;
    }

    public HashMap<DateTime, Integer> getBackgroundForDateTimeMap() {
        return this.backgroundForDateTimeMap;
    }

    public HashMap<DateTime, Integer> getTextColorForDateTimeMap() {
        return this.textColorForDateTimeMap;
    }

    public Button getLeftArrowButton() {
        return this.leftArrowButton;
    }

    public Button getRightArrowButton() {
        return this.rightArrowButton;
    }

    public TextView getMonthTitleTextView() {
        return this.monthTitleTextView;
    }

    public void setMonthTitleTextView(TextView monthTitleTextView) {
        this.monthTitleTextView = monthTitleTextView;
    }

    public ArrayList<CaldroidGridAdapter> getDatePagerAdapters() {
        return this.datePagerAdapters;
    }

    public HashMap<String, Object> getCaldroidData() {
        this.caldroidData.clear();
        this.caldroidData.put(DISABLE_DATES, this.disableDates);
        this.caldroidData.put(SELECTED_DATES, this.selectedDates);
        this.caldroidData.put(_MIN_DATE_TIME, this.minDateTime);
        this.caldroidData.put(_MAX_DATE_TIME, this.maxDateTime);
        this.caldroidData.put(START_DAY_OF_WEEK, this.startDayOfWeek);
        this.caldroidData.put(SIX_WEEKS_IN_CALENDAR, this.sixWeeksInCalendar);
        this.caldroidData.put(SQUARE_TEXT_VIEW_CELL, this.squareTextViewCell);
        this.caldroidData.put(THEME_RESOURCE, this.themeResource);
        this.caldroidData.put(_BACKGROUND_FOR_DATETIME_MAP, this.backgroundForDateTimeMap);
        this.caldroidData.put(_TEXT_COLOR_FOR_DATETIME_MAP, this.textColorForDateTimeMap);
        return this.caldroidData;
    }

    public HashMap<String, Object> getExtraData() {
        return this.extraData;
    }

    public void setExtraData(HashMap<String, Object> extraData) {
        this.extraData = extraData;
    }

    public void setBackgroundResourceForDates(HashMap<Date, Integer> backgroundForDateMap) {
        if (backgroundForDateMap == null || backgroundForDateMap.size() == 0) {
            return;
        }
        this.backgroundForDateTimeMap.clear();
        for (Date date : backgroundForDateMap.keySet()) {
            Integer resource = backgroundForDateMap.get(date);
            DateTime dateTime = CalendarHelper.convertDateToDateTime(date);
            this.backgroundForDateTimeMap.put(dateTime, resource);
        }
    }

    public void clearBackgroundResourceForDates(List<Date> dates) {
        if (dates == null || dates.size() == 0) {
            return;
        }
        for (Date date : dates) {
            this.clearBackgroundResourceForDate(date);
        }
    }

    public void setBackgroundResourceForDateTimes(HashMap<DateTime, Integer> backgroundForDateTimeMap) {
        this.backgroundForDateTimeMap.putAll(backgroundForDateTimeMap);
    }

    public void clearBackgroundResourceForDateTimes(List<DateTime> dateTimes) {
        if (dateTimes == null || dateTimes.size() == 0) {
            return;
        }
        for (DateTime dateTime : dateTimes) {
            this.backgroundForDateTimeMap.remove(dateTime);
        }
    }

    public void setBackgroundResourceForDate(int backgroundRes, Date date) {
        DateTime dateTime = CalendarHelper.convertDateToDateTime(date);
        this.backgroundForDateTimeMap.put(dateTime, backgroundRes);
    }

    public void clearBackgroundResourceForDate(Date date) {
        DateTime dateTime = CalendarHelper.convertDateToDateTime(date);
        this.backgroundForDateTimeMap.remove(dateTime);
    }

    public void setBackgroundResourceForDateTime(int backgroundRes, DateTime dateTime) {
        this.backgroundForDateTimeMap.put(dateTime, backgroundRes);
    }

    public void clearBackgroundResourceForDateTime(DateTime dateTime) {
        this.backgroundForDateTimeMap.remove(dateTime);
    }

    public void setTextColorForDates(HashMap<Date, Integer> textColorForDateMap) {
        if (textColorForDateMap == null || textColorForDateMap.size() == 0) {
            return;
        }
        this.textColorForDateTimeMap.clear();
        for (Date date : textColorForDateMap.keySet()) {
            Integer resource = textColorForDateMap.get(date);
            DateTime dateTime = CalendarHelper.convertDateToDateTime(date);
            this.textColorForDateTimeMap.put(dateTime, resource);
        }
    }

    public void clearTextColorForDates(List<Date> dates) {
        if (dates == null || dates.size() == 0) {
            return;
        }
        for (Date date : dates) {
            this.clearTextColorForDate(date);
        }
    }

    public void setTextColorForDateTimes(HashMap<DateTime, Integer> textColorForDateTimeMap) {
        this.textColorForDateTimeMap.putAll(textColorForDateTimeMap);
    }

    public void setTextColorForDate(int textColorRes, Date date) {
        DateTime dateTime = CalendarHelper.convertDateToDateTime(date);
        this.textColorForDateTimeMap.put(dateTime, textColorRes);
    }

    public void clearTextColorForDate(Date date) {
        DateTime dateTime = CalendarHelper.convertDateToDateTime(date);
        this.textColorForDateTimeMap.remove(dateTime);
    }

    public void setTextColorForDateTime(int textColorRes, DateTime dateTime) {
        this.textColorForDateTimeMap.put(dateTime, textColorRes);
    }

    public Bundle getSavedStates() {
        Bundle bundle = new Bundle();
        bundle.putInt(MONTH, this.month);
        bundle.putInt(YEAR, this.year);
        if (this.dialogTitle != null) {
            bundle.putString(DIALOG_TITLE, this.dialogTitle);
        }
        if (this.selectedDates != null && this.selectedDates.size() > 0) {
            bundle.putStringArrayList(SELECTED_DATES, CalendarHelper.convertToStringList(this.selectedDates));
        }
        if (this.disableDates != null && this.disableDates.size() > 0) {
            bundle.putStringArrayList(DISABLE_DATES, CalendarHelper.convertToStringList(this.disableDates));
        }
        if (this.minDateTime != null) {
            bundle.putString(MIN_DATE, this.minDateTime.format("YYYY-MM-DD"));
        }
        if (this.maxDateTime != null) {
            bundle.putString(MAX_DATE, this.maxDateTime.format("YYYY-MM-DD"));
        }
        bundle.putBoolean(SHOW_NAVIGATION_ARROWS, this.showNavigationArrows);
        bundle.putBoolean(ENABLE_SWIPE, this.enableSwipe);
        bundle.putInt(START_DAY_OF_WEEK, this.startDayOfWeek);
        bundle.putBoolean(SIX_WEEKS_IN_CALENDAR, this.sixWeeksInCalendar);
        bundle.putInt(THEME_RESOURCE, this.themeResource);
        return bundle;
    }

    public void saveStatesToKey(Bundle outState, String key) {
        outState.putBundle(key, this.getSavedStates());
    }

    public void restoreStatesFromKey(Bundle savedInstanceState, String key) {
        if (savedInstanceState != null && savedInstanceState.containsKey(key)) {
            Bundle caldroidSavedState = savedInstanceState.getBundle(key);
            this.setArguments(caldroidSavedState);
        }
    }

    public void restoreDialogStatesFromKey(FragmentManager manager, Bundle savedInstanceState, String key, String dialogTag) {
        this.restoreStatesFromKey(savedInstanceState, key);
        CaldroidFragment existingDialog = (CaldroidFragment)manager.findFragmentByTag(dialogTag);
        if (existingDialog != null) {
            existingDialog.dismiss();
            this.show(manager, dialogTag);
        }
    }

    public int getCurrentVirtualPosition() {
        int currentPage = this.dateViewPager.getCurrentItem();
        return this.pageChangeListener.getCurrent(currentPage);
    }

    public void moveToDate(Date date) {
        this.moveToDateTime(CalendarHelper.convertDateToDateTime(date));
    }

    public void moveToDateTime(DateTime dateTime) {
        DateTime firstOfMonth = new DateTime(Integer.valueOf(this.year), Integer.valueOf(this.month), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0));
        DateTime lastOfMonth = firstOfMonth.getEndOfMonth();
        if (dateTime.lt(firstOfMonth)) {
            DateTime firstDayNextMonth = dateTime.plus(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), DateTime.DayOverflow.LastDay);
            this.pageChangeListener.setCurrentDateTime(firstDayNextMonth);
            int currentItem = this.dateViewPager.getCurrentItem();
            this.pageChangeListener.refreshAdapters(currentItem);
            this.dateViewPager.setCurrentItem(currentItem - 1);
        } else if (dateTime.gt(lastOfMonth)) {
            DateTime firstDayLastMonth = dateTime.minus(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), DateTime.DayOverflow.LastDay);
            this.pageChangeListener.setCurrentDateTime(firstDayLastMonth);
            int currentItem = this.dateViewPager.getCurrentItem();
            this.pageChangeListener.refreshAdapters(currentItem);
            this.dateViewPager.setCurrentItem(currentItem + 1);
        }
    }

    public void setCalendarDate(Date date) {
        this.setCalendarDateTime(CalendarHelper.convertDateToDateTime(date));
    }

    public void setCalendarDateTime(DateTime dateTime) {
        this.month = dateTime.getMonth();
        this.year = dateTime.getYear();
        if (this.caldroidListener != null) {
            this.caldroidListener.onChangeMonth(this.month, this.year);
        }
        this.refreshView();
    }

    public void prevMonth() {
        this.dateViewPager.setCurrentItem(this.pageChangeListener.getCurrentPage() - 1);
    }

    public void nextMonth() {
        this.dateViewPager.setCurrentItem(this.pageChangeListener.getCurrentPage() + 1);
    }

    public void clearDisableDates() {
        this.disableDates.clear();
    }

    public void setDisableDates(ArrayList<Date> disableDateList) {
        if (disableDateList == null || disableDateList.size() == 0) {
            return;
        }
        this.disableDates.clear();
        for (Date date : disableDateList) {
            DateTime dateTime = CalendarHelper.convertDateToDateTime(date);
            this.disableDates.add(dateTime);
        }
    }

    public void setDisableDatesFromString(ArrayList<String> disableDateStrings) {
        this.setDisableDatesFromString(disableDateStrings, null);
    }

    public void setDisableDatesFromString(ArrayList<String> disableDateStrings, String dateFormat) {
        if (disableDateStrings == null) {
            return;
        }
        this.disableDates.clear();
        for (String dateString : disableDateStrings) {
            DateTime dateTime = CalendarHelper.getDateTimeFromString(dateString, dateFormat);
            this.disableDates.add(dateTime);
        }
    }

    public void clearSelectedDates() {
        this.selectedDates.clear();
    }

    public void setSelectedDates(Date fromDate, Date toDate) {
        if (fromDate == null || toDate == null || fromDate.after(toDate)) {
            return;
        }
        this.selectedDates.clear();
        DateTime fromDateTime = CalendarHelper.convertDateToDateTime(fromDate);
        DateTime toDateTime = CalendarHelper.convertDateToDateTime(toDate);
        DateTime dateTime = fromDateTime;
        while (dateTime.lt(toDateTime)) {
            this.selectedDates.add(dateTime);
            dateTime = dateTime.plusDays(Integer.valueOf(1));
        }
        this.selectedDates.add(toDateTime);
    }

    public void setSelectedDateStrings(String fromDateString, String toDateString, String dateFormat) throws ParseException {
        Date fromDate = CalendarHelper.getDateFromString(fromDateString, dateFormat);
        Date toDate = CalendarHelper.getDateFromString(toDateString, dateFormat);
        this.setSelectedDates(fromDate, toDate);
    }

    public void setSelectedDate(Date date) {
        if (date == null) {
            return;
        }
        DateTime dateTime = CalendarHelper.convertDateToDateTime(date);
        this.selectedDates.add(dateTime);
    }

    public void clearSelectedDate(Date date) {
        if (date == null) {
            return;
        }
        DateTime dateTime = CalendarHelper.convertDateToDateTime(date);
        this.selectedDates.remove(dateTime);
    }

    public boolean isSelectedDate(Date date) {
        if (date == null) {
            return false;
        }
        DateTime dateTime = CalendarHelper.convertDateToDateTime(date);
        return this.selectedDates.contains(dateTime);
    }

    public boolean isShowNavigationArrows() {
        return this.showNavigationArrows;
    }

    public void setShowNavigationArrows(boolean showNavigationArrows) {
        this.showNavigationArrows = showNavigationArrows;
        if (showNavigationArrows) {
            this.leftArrowButton.setVisibility(0);
            this.rightArrowButton.setVisibility(0);
        } else {
            this.leftArrowButton.setVisibility(4);
            this.rightArrowButton.setVisibility(4);
        }
    }

    public boolean isEnableSwipe() {
        return this.enableSwipe;
    }

    public void setEnableSwipe(boolean enableSwipe) {
        this.enableSwipe = enableSwipe;
        this.dateViewPager.setEnabled(enableSwipe);
    }

    public void setMinDate(Date minDate) {
        this.minDateTime = minDate == null ? null : CalendarHelper.convertDateToDateTime(minDate);
    }

    public boolean isSixWeeksInCalendar() {
        return this.sixWeeksInCalendar;
    }

    public void setSixWeeksInCalendar(boolean sixWeeksInCalendar) {
        this.sixWeeksInCalendar = sixWeeksInCalendar;
        this.dateViewPager.setSixWeeksInCalendar(sixWeeksInCalendar);
    }

    public void setMinDateFromString(String minDateString, String dateFormat) {
        if (minDateString == null) {
            this.setMinDate(null);
        } else {
            this.minDateTime = CalendarHelper.getDateTimeFromString(minDateString, dateFormat);
        }
    }

    public void setMaxDate(Date maxDate) {
        this.maxDateTime = maxDate == null ? null : CalendarHelper.convertDateToDateTime(maxDate);
    }

    public void setMaxDateFromString(String maxDateString, String dateFormat) {
        if (maxDateString == null) {
            this.setMaxDate(null);
        } else {
            this.maxDateTime = CalendarHelper.getDateTimeFromString(maxDateString, dateFormat);
        }
    }

    public void setCaldroidListener(CaldroidListener caldroidListener) {
        this.caldroidListener = caldroidListener;
    }

    public AdapterView.OnItemClickListener getDateItemClickListener() {
        if (this.dateItemClickListener == null) {
            this.dateItemClickListener = new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    DateTime dateTime = CaldroidFragment.this.dateInMonthsList.get(position);
                    if (CaldroidFragment.this.caldroidListener != null) {
                        if (!CaldroidFragment.this.enableClickOnDisabledDates && (CaldroidFragment.this.minDateTime != null && dateTime.lt(CaldroidFragment.this.minDateTime) || CaldroidFragment.this.maxDateTime != null && dateTime.gt(CaldroidFragment.this.maxDateTime) || CaldroidFragment.this.disableDates != null && CaldroidFragment.this.disableDates.indexOf(dateTime) != -1)) {
                            return;
                        }
                        Date date = CalendarHelper.convertDateTimeToDate(dateTime);
                        CaldroidFragment.this.caldroidListener.onSelectDate(date, view);
                    }
                }
            };
        }
        return this.dateItemClickListener;
    }

    public AdapterView.OnItemLongClickListener getDateItemLongClickListener() {
        if (this.dateItemLongClickListener == null) {
            this.dateItemLongClickListener = new AdapterView.OnItemLongClickListener(){

                public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
                    DateTime dateTime = CaldroidFragment.this.dateInMonthsList.get(position);
                    if (CaldroidFragment.this.caldroidListener != null) {
                        if (!CaldroidFragment.this.enableClickOnDisabledDates && (CaldroidFragment.this.minDateTime != null && dateTime.lt(CaldroidFragment.this.minDateTime) || CaldroidFragment.this.maxDateTime != null && dateTime.gt(CaldroidFragment.this.maxDateTime) || CaldroidFragment.this.disableDates != null && CaldroidFragment.this.disableDates.indexOf(dateTime) != -1)) {
                            return false;
                        }
                        Date date = CalendarHelper.convertDateTimeToDate(dateTime);
                        CaldroidFragment.this.caldroidListener.onLongClickDate(date, view);
                    }
                    return true;
                }
            };
        }
        return this.dateItemLongClickListener;
    }

    protected void refreshMonthTitleTextView() {
        this.firstMonthTime.year = this.year;
        this.firstMonthTime.month = this.month - 1;
        this.firstMonthTime.monthDay = 15;
        long millis = this.firstMonthTime.toMillis(true);
        this.monthYearStringBuilder.setLength(0);
        String monthTitle = DateUtils.formatDateRange((Context)this.getActivity(), (Formatter)this.monthYearFormatter, (long)millis, (long)millis, (int)52).toString();
        this.monthTitleTextView.setText((CharSequence)monthTitle.toUpperCase(Locale.getDefault()));
    }

    public void refreshView() {
        if (this.month == -1 || this.year == -1) {
            return;
        }
        this.refreshMonthTitleTextView();
        for (CaldroidGridAdapter adapter : this.datePagerAdapters) {
            adapter.setCaldroidData(this.getCaldroidData());
            adapter.setExtraData(this.extraData);
            adapter.updateToday();
            adapter.notifyDataSetChanged();
        }
    }

    protected void retrieveInitialArgs() {
        Bundle args = this.getArguments();
        CalendarHelper.setup();
        if (args != null) {
            String maxDateTimeString;
            String minDateTimeString;
            ArrayList selectedDateStrings;
            this.month = args.getInt(MONTH, -1);
            this.year = args.getInt(YEAR, -1);
            this.dialogTitle = args.getString(DIALOG_TITLE);
            Dialog dialog = this.getDialog();
            if (dialog != null) {
                if (this.dialogTitle != null) {
                    dialog.setTitle((CharSequence)this.dialogTitle);
                } else {
                    dialog.requestWindowFeature(1);
                }
            }
            this.startDayOfWeek = args.getInt(START_DAY_OF_WEEK, 1);
            if (this.startDayOfWeek > 7) {
                this.startDayOfWeek %= 7;
            }
            this.showNavigationArrows = args.getBoolean(SHOW_NAVIGATION_ARROWS, true);
            this.enableSwipe = args.getBoolean(ENABLE_SWIPE, true);
            this.sixWeeksInCalendar = args.getBoolean(SIX_WEEKS_IN_CALENDAR, true);
            int orientation = this.getResources().getConfiguration().orientation;
            this.squareTextViewCell = orientation == 1 ? args.getBoolean(SQUARE_TEXT_VIEW_CELL, true) : args.getBoolean(SQUARE_TEXT_VIEW_CELL, false);
            this.enableClickOnDisabledDates = args.getBoolean(ENABLE_CLICK_ON_DISABLED_DATES, false);
            ArrayList disableDateStrings = args.getStringArrayList(DISABLE_DATES);
            if (disableDateStrings != null && disableDateStrings.size() > 0) {
                this.disableDates.clear();
                for (String dateString : disableDateStrings) {
                    DateTime dt = CalendarHelper.getDateTimeFromString(dateString, null);
                    this.disableDates.add(dt);
                }
            }
            if ((selectedDateStrings = args.getStringArrayList(SELECTED_DATES)) != null && selectedDateStrings.size() > 0) {
                this.selectedDates.clear();
                for (String dateString : selectedDateStrings) {
                    DateTime dt = CalendarHelper.getDateTimeFromString(dateString, null);
                    this.selectedDates.add(dt);
                }
            }
            if ((minDateTimeString = args.getString(MIN_DATE)) != null) {
                this.minDateTime = CalendarHelper.getDateTimeFromString(minDateTimeString, null);
            }
            if ((maxDateTimeString = args.getString(MAX_DATE)) != null) {
                this.maxDateTime = CalendarHelper.getDateTimeFromString(maxDateTimeString, null);
            }
            this.themeResource = args.getInt(THEME_RESOURCE, R.style.CaldroidDefault);
        }
        if (this.month == -1 || this.year == -1) {
            DateTime dateTime = DateTime.today((TimeZone)TimeZone.getDefault());
            this.month = dateTime.getMonth();
            this.year = dateTime.getYear();
        }
    }

    public static CaldroidFragment newInstance(String dialogTitle, int month, int year) {
        CaldroidFragment f = new CaldroidFragment();
        Bundle args = new Bundle();
        args.putString(DIALOG_TITLE, dialogTitle);
        args.putInt(MONTH, month);
        args.putInt(YEAR, year);
        f.setArguments(args);
        return f;
    }

    public void onDestroyView() {
        if (this.getDialog() != null && this.getRetainInstance()) {
            this.getDialog().setDismissMessage(null);
        }
        super.onDestroyView();
    }

    public void setThemeResource(int id2) {
        this.themeResource = id2;
    }

    public int getThemeResource() {
        return this.themeResource;
    }

    public static LayoutInflater getLayoutInflater(Context context, LayoutInflater origInflater, int themeResource) {
        ContextThemeWrapper wrapped = new ContextThemeWrapper(context, themeResource);
        return origInflater.cloneInContext((Context)wrapped);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.retrieveInitialArgs();
        if (this.getDialog() != null) {
            try {
                this.setRetainInstance(true);
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
        }
        LayoutInflater localInflater = CaldroidFragment.getLayoutInflater((Context)this.getActivity(), inflater, this.themeResource);
        View view = localInflater.inflate(R.layout.calendar_view, container, false);
        this.monthTitleTextView = (TextView)view.findViewById(R.id.calendar_month_year_textview);
        this.leftArrowButton = (Button)view.findViewById(R.id.calendar_left_arrow);
        this.rightArrowButton = (Button)view.findViewById(R.id.calendar_right_arrow);
        this.leftArrowButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CaldroidFragment.this.prevMonth();
            }
        });
        this.rightArrowButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CaldroidFragment.this.nextMonth();
            }
        });
        this.setShowNavigationArrows(this.showNavigationArrows);
        this.weekdayGridView = (GridView)view.findViewById(R.id.weekday_gridview);
        WeekdayArrayAdapter weekdaysAdapter = this.getNewWeekdayAdapter(this.themeResource);
        this.weekdayGridView.setAdapter((ListAdapter)weekdaysAdapter);
        this.setupDateGridPages(view);
        this.refreshView();
        return view;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (this.caldroidListener != null) {
            this.caldroidListener.onCaldroidViewCreated();
        }
    }

    protected int getGridViewRes() {
        return R.layout.date_grid_fragment;
    }

    private void setupDateGridPages(View view) {
        DateTime currentDateTime = new DateTime(Integer.valueOf(this.year), Integer.valueOf(this.month), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0));
        this.pageChangeListener = new DatePageChangeListener();
        this.pageChangeListener.setCurrentDateTime(currentDateTime);
        CaldroidGridAdapter adapter0 = this.getNewDatesGridAdapter(currentDateTime.getMonth(), currentDateTime.getYear());
        this.dateInMonthsList = adapter0.getDatetimeList();
        DateTime nextDateTime = currentDateTime.plus(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), DateTime.DayOverflow.LastDay);
        CaldroidGridAdapter adapter1 = this.getNewDatesGridAdapter(nextDateTime.getMonth(), nextDateTime.getYear());
        DateTime next2DateTime = nextDateTime.plus(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), DateTime.DayOverflow.LastDay);
        CaldroidGridAdapter adapter2 = this.getNewDatesGridAdapter(next2DateTime.getMonth(), next2DateTime.getYear());
        DateTime prevDateTime = currentDateTime.minus(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), DateTime.DayOverflow.LastDay);
        CaldroidGridAdapter adapter3 = this.getNewDatesGridAdapter(prevDateTime.getMonth(), prevDateTime.getYear());
        this.datePagerAdapters.add(adapter0);
        this.datePagerAdapters.add(adapter1);
        this.datePagerAdapters.add(adapter2);
        this.datePagerAdapters.add(adapter3);
        this.pageChangeListener.setCaldroidGridAdapters(this.datePagerAdapters);
        this.dateViewPager = (InfiniteViewPager)view.findViewById(R.id.months_infinite_pager);
        this.dateViewPager.setEnabled(this.enableSwipe);
        this.dateViewPager.setSixWeeksInCalendar(this.sixWeeksInCalendar);
        this.dateViewPager.setDatesInMonth(this.dateInMonthsList);
        MonthPagerAdapter pagerAdapter = new MonthPagerAdapter(this.getChildFragmentManager());
        this.fragments = pagerAdapter.getFragments();
        for (int i = 0; i < 4; ++i) {
            DateGridFragment dateGridFragment = this.fragments.get(i);
            CaldroidGridAdapter adapter = this.datePagerAdapters.get(i);
            dateGridFragment.setGridViewRes(this.getGridViewRes());
            dateGridFragment.setGridAdapter(adapter);
            dateGridFragment.setOnItemClickListener(this.getDateItemClickListener());
            dateGridFragment.setOnItemLongClickListener(this.getDateItemLongClickListener());
        }
        InfinitePagerAdapter infinitePagerAdapter = new InfinitePagerAdapter((PagerAdapter)pagerAdapter);
        this.dateViewPager.setAdapter(infinitePagerAdapter);
        this.dateViewPager.setOnPageChangeListener(this.pageChangeListener);
    }

    protected ArrayList<String> getDaysOfWeek() {
        ArrayList<String> list = new ArrayList<String>();
        SimpleDateFormat fmt = new SimpleDateFormat("EEE", Locale.getDefault());
        DateTime sunday = new DateTime(Integer.valueOf(2013), Integer.valueOf(2), Integer.valueOf(17), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0));
        DateTime nextDay = sunday.plusDays(Integer.valueOf(this.startDayOfWeek - SUNDAY));
        for (int i = 0; i < 7; ++i) {
            Date date = CalendarHelper.convertDateTimeToDate(nextDay);
            list.add(fmt.format(date).toUpperCase());
            nextDay = nextDay.plusDays(Integer.valueOf(1));
        }
        return list;
    }

    public void onDetach() {
        super.onDetach();
        try {
            Field childFragmentManager = Fragment.class.getDeclaredField("mChildFragmentManager");
            childFragmentManager.setAccessible(true);
            childFragmentManager.set((Object)this, null);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public class DatePageChangeListener
    implements ViewPager.OnPageChangeListener {
        private int currentPage = 1000;
        private DateTime currentDateTime;
        private ArrayList<CaldroidGridAdapter> caldroidGridAdapters;

        public int getCurrentPage() {
            return this.currentPage;
        }

        public void setCurrentPage(int currentPage) {
            this.currentPage = currentPage;
        }

        public DateTime getCurrentDateTime() {
            return this.currentDateTime;
        }

        public void setCurrentDateTime(DateTime dateTime) {
            this.currentDateTime = dateTime;
            CaldroidFragment.this.setCalendarDateTime(this.currentDateTime);
        }

        public ArrayList<CaldroidGridAdapter> getCaldroidGridAdapters() {
            return this.caldroidGridAdapters;
        }

        public void setCaldroidGridAdapters(ArrayList<CaldroidGridAdapter> caldroidGridAdapters) {
            this.caldroidGridAdapters = caldroidGridAdapters;
        }

        private int getNext(int position) {
            return (position + 1) % 4;
        }

        private int getPrevious(int position) {
            return (position + 3) % 4;
        }

        public int getCurrent(int position) {
            return position % 4;
        }

        public void onPageScrollStateChanged(int position) {
        }

        public void onPageScrolled(int arg0, float arg1, int arg2) {
        }

        public void refreshAdapters(int position) {
            CaldroidGridAdapter currentAdapter = this.caldroidGridAdapters.get(this.getCurrent(position));
            CaldroidGridAdapter prevAdapter = this.caldroidGridAdapters.get(this.getPrevious(position));
            CaldroidGridAdapter nextAdapter = this.caldroidGridAdapters.get(this.getNext(position));
            if (position == this.currentPage) {
                currentAdapter.setAdapterDateTime(this.currentDateTime);
                currentAdapter.notifyDataSetChanged();
                prevAdapter.setAdapterDateTime(this.currentDateTime.minus(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), DateTime.DayOverflow.LastDay));
                prevAdapter.notifyDataSetChanged();
                nextAdapter.setAdapterDateTime(this.currentDateTime.plus(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), DateTime.DayOverflow.LastDay));
                nextAdapter.notifyDataSetChanged();
            } else if (position > this.currentPage) {
                this.currentDateTime = this.currentDateTime.plus(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), DateTime.DayOverflow.LastDay);
                nextAdapter.setAdapterDateTime(this.currentDateTime.plus(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), DateTime.DayOverflow.LastDay));
                nextAdapter.notifyDataSetChanged();
            } else {
                this.currentDateTime = this.currentDateTime.minus(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), DateTime.DayOverflow.LastDay);
                prevAdapter.setAdapterDateTime(this.currentDateTime.minus(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), DateTime.DayOverflow.LastDay));
                prevAdapter.notifyDataSetChanged();
            }
            this.currentPage = position;
        }

        public void onPageSelected(int position) {
            this.refreshAdapters(position);
            CaldroidFragment.this.setCalendarDateTime(this.currentDateTime);
            CaldroidGridAdapter currentAdapter = this.caldroidGridAdapters.get(position % 4);
            CaldroidFragment.this.dateInMonthsList.clear();
            CaldroidFragment.this.dateInMonthsList.addAll(currentAdapter.getDatetimeList());
        }
    }
}

