/*
 * Decompiled with CFR 0.152.
 */
package com.roomorama.caldroid;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.caldroid.R;
import com.roomorama.caldroid.CaldroidFragment;
import com.roomorama.caldroid.CalendarHelper;
import com.roomorama.caldroid.CellView;
import hirondelle.date4j.DateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

public class CaldroidGridAdapter
extends BaseAdapter {
    protected ArrayList<DateTime> datetimeList;
    protected int month;
    protected int year;
    protected Context context;
    protected ArrayList<DateTime> disableDates;
    protected ArrayList<DateTime> selectedDates;
    protected HashMap<DateTime, Integer> disableDatesMap = new HashMap();
    protected HashMap<DateTime, Integer> selectedDatesMap = new HashMap();
    protected DateTime minDateTime;
    protected DateTime maxDateTime;
    protected DateTime today;
    protected int startDayOfWeek;
    protected boolean sixWeeksInCalendar;
    protected boolean squareTextViewCell;
    protected int themeResource;
    protected Resources resources;
    protected int defaultCellBackgroundRes = -1;
    protected ColorStateList defaultTextColorRes;
    protected HashMap<String, Object> caldroidData;
    protected HashMap<String, Object> extraData;

    public void setAdapterDateTime(DateTime dateTime) {
        this.month = dateTime.getMonth();
        this.year = dateTime.getYear();
        this.datetimeList = CalendarHelper.getFullWeeks(this.month, this.year, this.startDayOfWeek, this.sixWeeksInCalendar);
    }

    public ArrayList<DateTime> getDatetimeList() {
        return this.datetimeList;
    }

    public DateTime getMinDateTime() {
        return this.minDateTime;
    }

    public void setMinDateTime(DateTime minDateTime) {
        this.minDateTime = minDateTime;
    }

    public DateTime getMaxDateTime() {
        return this.maxDateTime;
    }

    public void setMaxDateTime(DateTime maxDateTime) {
        this.maxDateTime = maxDateTime;
    }

    public ArrayList<DateTime> getDisableDates() {
        return this.disableDates;
    }

    public void setDisableDates(ArrayList<DateTime> disableDates) {
        this.disableDates = disableDates;
    }

    public ArrayList<DateTime> getSelectedDates() {
        return this.selectedDates;
    }

    public void setSelectedDates(ArrayList<DateTime> selectedDates) {
        this.selectedDates = selectedDates;
    }

    public int getThemeResource() {
        return this.themeResource;
    }

    public HashMap<String, Object> getCaldroidData() {
        return this.caldroidData;
    }

    public void setCaldroidData(HashMap<String, Object> caldroidData) {
        this.caldroidData = caldroidData;
        this.populateFromCaldroidData();
    }

    public HashMap<String, Object> getExtraData() {
        return this.extraData;
    }

    public void setExtraData(HashMap<String, Object> extraData) {
        this.extraData = extraData;
    }

    public CaldroidGridAdapter(Context context, int month, int year, HashMap<String, Object> caldroidData, HashMap<String, Object> extraData) {
        this.month = month;
        this.year = year;
        this.context = context;
        this.caldroidData = caldroidData;
        this.extraData = extraData;
        this.resources = context.getResources();
        this.populateFromCaldroidData();
    }

    private void populateFromCaldroidData() {
        this.disableDates = (ArrayList)this.caldroidData.get("disableDates");
        if (this.disableDates != null) {
            this.disableDatesMap.clear();
            for (DateTime dateTime : this.disableDates) {
                this.disableDatesMap.put(dateTime, 1);
            }
        }
        this.selectedDates = (ArrayList)this.caldroidData.get("selectedDates");
        if (this.selectedDates != null) {
            this.selectedDatesMap.clear();
            for (DateTime dateTime : this.selectedDates) {
                this.selectedDatesMap.put(dateTime, 1);
            }
        }
        this.minDateTime = (DateTime)this.caldroidData.get("_minDateTime");
        this.maxDateTime = (DateTime)this.caldroidData.get("_maxDateTime");
        this.startDayOfWeek = (Integer)this.caldroidData.get("startDayOfWeek");
        this.sixWeeksInCalendar = (Boolean)this.caldroidData.get("sixWeeksInCalendar");
        this.squareTextViewCell = (Boolean)this.caldroidData.get("squareTextViewCell");
        this.themeResource = (Integer)this.caldroidData.get("themeResource");
        this.datetimeList = CalendarHelper.getFullWeeks(this.month, this.year, this.startDayOfWeek, this.sixWeeksInCalendar);
        this.getDefaultResources();
    }

    private void getDefaultResources() {
        ContextThemeWrapper wrapped = new ContextThemeWrapper(this.context, this.themeResource);
        Resources.Theme theme = wrapped.getTheme();
        TypedValue styleCellVal = new TypedValue();
        if (this.squareTextViewCell) {
            theme.resolveAttribute(R.attr.styleCaldroidSquareCell, styleCellVal, true);
        } else {
            theme.resolveAttribute(R.attr.styleCaldroidNormalCell, styleCellVal, true);
        }
        TypedArray typedArray = wrapped.obtainStyledAttributes(styleCellVal.data, R.styleable.Cell);
        this.defaultCellBackgroundRes = typedArray.getResourceId(R.styleable.Cell_android_background, -1);
        this.defaultTextColorRes = typedArray.getColorStateList(R.styleable.Cell_android_textColor);
        typedArray.recycle();
    }

    public void updateToday() {
        this.today = CalendarHelper.convertDateToDateTime(new Date());
    }

    protected DateTime getToday() {
        if (this.today == null) {
            this.today = CalendarHelper.convertDateToDateTime(new Date());
        }
        return this.today;
    }

    protected void setCustomResources(DateTime dateTime, View backgroundView, TextView textView) {
        Integer textColorResource;
        HashMap textColorForDateTimeMap;
        Integer backgroundResource;
        HashMap backgroundForDateTimeMap = (HashMap)this.caldroidData.get("_backgroundForDateTimeMap");
        if (backgroundForDateTimeMap != null && (backgroundResource = (Integer)backgroundForDateTimeMap.get(dateTime)) != null) {
            backgroundView.setBackgroundResource(backgroundResource.intValue());
        }
        if ((textColorForDateTimeMap = (HashMap)this.caldroidData.get("_textColorForDateTimeMap")) != null && (textColorResource = (Integer)textColorForDateTimeMap.get(dateTime)) != null) {
            textView.setTextColor(this.resources.getColor(textColorResource.intValue()));
        }
    }

    private void resetCustomResources(CellView cellView) {
        cellView.setBackgroundResource(this.defaultCellBackgroundRes);
        cellView.setTextColor(this.defaultTextColorRes);
    }

    protected void customizeTextView(int position, CellView cellView) {
        int topPadding = cellView.getPaddingTop();
        int leftPadding = cellView.getPaddingLeft();
        int bottomPadding = cellView.getPaddingBottom();
        int rightPadding = cellView.getPaddingRight();
        DateTime dateTime = this.datetimeList.get(position);
        cellView.resetCustomStates();
        this.resetCustomResources(cellView);
        if (dateTime.equals((Object)this.getToday())) {
            cellView.addCustomState(CellView.STATE_TODAY);
        }
        if (dateTime.getMonth() != this.month) {
            cellView.addCustomState(CellView.STATE_PREV_NEXT_MONTH);
        }
        if (this.minDateTime != null && dateTime.lt(this.minDateTime) || this.maxDateTime != null && dateTime.gt(this.maxDateTime) || this.disableDates != null && this.disableDatesMap.containsKey(dateTime)) {
            cellView.addCustomState(CellView.STATE_DISABLED);
        }
        if (this.selectedDates != null && this.selectedDatesMap.containsKey(dateTime)) {
            cellView.addCustomState(CellView.STATE_SELECTED);
        }
        cellView.refreshDrawableState();
        cellView.setText("" + dateTime.getDay());
        this.setCustomResources(dateTime, (View)cellView, cellView);
        cellView.setPadding(leftPadding, topPadding, rightPadding, bottomPadding);
    }

    public int getCount() {
        return this.datetimeList.size();
    }

    public Object getItem(int position) {
        return this.datetimeList.get(position);
    }

    public long getItemId(int arg0) {
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        LayoutInflater inflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
        CellView cellView = (CellView)convertView;
        LayoutInflater localInflater = CaldroidFragment.getLayoutInflater(this.context, inflater, this.themeResource);
        if (convertView == null) {
            cellView = this.squareTextViewCell ? (CellView)localInflater.inflate(R.layout.square_date_cell, null) : (CellView)localInflater.inflate(R.layout.normal_date_cell, null);
        }
        this.customizeTextView(position, cellView);
        return cellView;
    }
}

