/*
 * Decompiled with CFR 0.152.
 */
package com.roomorama.caldroid;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.TextView;
import com.caldroid.R;
import java.util.ArrayList;

public class CellView
extends TextView {
    public static final int STATE_TODAY = R.attr.state_date_today;
    public static final int STATE_SELECTED = R.attr.state_date_selected;
    public static final int STATE_DISABLED = R.attr.state_date_disabled;
    public static final int STATE_PREV_NEXT_MONTH = R.attr.state_date_prev_next_month;
    private ArrayList<Integer> customStates = new ArrayList();

    public CellView(Context context) {
        super(context);
    }

    public CellView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public CellView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        if (null == this.customStates) {
            this.customStates = new ArrayList();
        }
    }

    public void resetCustomStates() {
        this.customStates.clear();
    }

    public void addCustomState(int state) {
        if (!this.customStates.contains(state)) {
            this.customStates.add(state);
        }
    }

    protected int[] onCreateDrawableState(int extraSpace) {
        this.init();
        int customStateSize = this.customStates.size();
        if (customStateSize > 0) {
            int[] drawableState = super.onCreateDrawableState(extraSpace + customStateSize);
            int[] stateArray = new int[customStateSize];
            int i = 0;
            for (Integer state : this.customStates) {
                stateArray[i] = state;
                ++i;
            }
            CellView.mergeDrawableStates((int[])drawableState, (int[])stateArray);
            return drawableState;
        }
        return super.onCreateDrawableState(extraSpace);
    }
}

