/*
 * Decompiled with CFR 0.152.
 */
package com.rosaloves.bitlyj;

import com.rosaloves.bitlyj.Bitly;
import com.rosaloves.bitlyj.BitlyMethod;
import com.rosaloves.bitlyj.MethodBase;
import com.rosaloves.bitlyj.ShortenedUrl;
import com.rosaloves.bitlyj.Url;
import com.rosaloves.bitlyj.UrlClicks;
import com.rosaloves.bitlyj.UrlInfo;
import com.rosaloves.bitlyj.data.Pair;
import com.rosaloves.bitlyj.utils.Dom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Methods {
    Methods() {
    }

    public static BitlyMethod<UrlInfo> info(String value) {
        return new MethodBase<UrlInfo>("info", Methods.getUrlMethodArgs(value)){

            @Override
            public UrlInfo apply(Bitly.Provider provider, Document document) {
                return Methods.parseInfo(provider, document.getElementsByTagName("info").item(0));
            }
        };
    }

    public static BitlyMethod<Set<UrlInfo>> info(String ... values) {
        return new MethodBase<Set<UrlInfo>>("info", Methods.getUrlMethodArgs(values)){

            @Override
            public Set<UrlInfo> apply(Bitly.Provider provider, Document document) {
                HashSet<UrlInfo> inf = new HashSet<UrlInfo>();
                NodeList infos = document.getElementsByTagName("info");
                for (int i = 0; i < infos.getLength(); ++i) {
                    inf.add(Methods.parseInfo(provider, infos.item(i)));
                }
                return inf;
            }
        };
    }

    public static BitlyMethod<Url> expand(String values) {
        return new MethodBase<Url>("expand", Methods.getUrlMethodArgs(values)){

            @Override
            public Url apply(Bitly.Provider provider, Document document) {
                return Methods.parseUrl(provider, document.getElementsByTagName("entry").item(0));
            }
        };
    }

    public static BitlyMethod<Set<Url>> expand(String ... values) {
        return new MethodBase<Set<Url>>("expand", Methods.getUrlMethodArgs(values)){

            @Override
            public Set<Url> apply(Bitly.Provider provider, Document document) {
                HashSet<Url> inf = new HashSet<Url>();
                NodeList infos = document.getElementsByTagName("entry");
                for (int i = 0; i < infos.getLength(); ++i) {
                    inf.add(Methods.parseUrl(provider, infos.item(i)));
                }
                return inf;
            }
        };
    }

    public static BitlyMethod<ShortenedUrl> shorten(String longUrl) {
        return new MethodBase<ShortenedUrl>("shorten", new Pair[]{Pair.p("longUrl", longUrl)}){

            @Override
            public ShortenedUrl apply(Bitly.Provider provider, Document document) {
                NodeList infos = document.getElementsByTagName("data");
                return Methods.parseShortenedUrl(provider, infos.item(0));
            }
        };
    }

    public static BitlyMethod<UrlClicks> clicks(String string) {
        return new MethodBase<UrlClicks>("clicks", new Pair[]{Pair.p(Methods.hashOrUrl(string), string)}){

            @Override
            public UrlClicks apply(Bitly.Provider provider, Document document) {
                return Methods.parseClicks(provider, document.getElementsByTagName("clicks").item(0));
            }
        };
    }

    public static BitlyMethod<Set<UrlClicks>> clicks(String ... string) {
        return new MethodBase<Set<UrlClicks>>("clicks", Methods.getUrlMethodArgs(string)){

            @Override
            public Set<UrlClicks> apply(Bitly.Provider provider, Document document) {
                HashSet<UrlClicks> clicks = new HashSet<UrlClicks>();
                NodeList nl = document.getElementsByTagName("clicks");
                for (int i = 0; i < nl.getLength(); ++i) {
                    clicks.add(Methods.parseClicks(provider, nl.item(i)));
                }
                return clicks;
            }
        };
    }

    static Collection<Pair<String, String>> getUrlMethodArgs(String ... value) {
        ArrayList<Pair<String, String>> pairs = new ArrayList<Pair<String, String>>();
        for (String p : value) {
            pairs.add(Pair.p(Methods.hashOrUrl(p), p));
        }
        return pairs;
    }

    static String hashOrUrl(String p) {
        return p.startsWith("http://") ? "shortUrl" : "hash";
    }

    static UrlClicks parseClicks(Bitly.Provider provider, Node item) {
        NodeList nl = item.getChildNodes();
        long user = 0L;
        long global = 0L;
        for (int i = 0; i < nl.getLength(); ++i) {
            String name = nl.item(i).getNodeName();
            String value = Dom.getTextContent(nl.item(i));
            if ("user_clicks".equals(name)) {
                user = Long.parseLong(value);
                continue;
            }
            if (!"global_clicks".equals(name)) continue;
            global = Long.parseLong(value);
        }
        return new UrlClicks(Methods.parseUrl(provider, item), user, global);
    }

    static ShortenedUrl parseShortenedUrl(Bitly.Provider provider, Node nl) {
        String gHash = "";
        String uHash = "";
        String sUrl = "";
        String lUrl = "";
        String isNew = "";
        NodeList il = nl.getChildNodes();
        for (int i = 0; i < il.getLength(); ++i) {
            Node n = il.item(i);
            String name = n.getNodeName();
            String value = Dom.getTextContent(n).trim();
            if ("new_hash".equals(name)) {
                isNew = value;
                continue;
            }
            if ("url".equals(name)) {
                sUrl = value;
                continue;
            }
            if ("long_url".equals(name)) {
                lUrl = value;
                continue;
            }
            if ("global_hash".equals(name)) {
                gHash = value;
                continue;
            }
            if (!"hash".equals(name)) continue;
            uHash = value;
        }
        return new ShortenedUrl(provider.getUrl(), gHash, uHash, sUrl, lUrl, isNew.equals("1"));
    }

    static Url parseUrl(Bitly.Provider provider, Node nl) {
        String gHash = "";
        String uHash = "";
        String sUrl = "";
        String lUrl = "";
        NodeList il = nl.getChildNodes();
        for (int i = 0; i < il.getLength(); ++i) {
            Node n = il.item(i);
            String name = n.getNodeName();
            String value = Dom.getTextContent(n);
            if ("short_url".equals(name)) {
                sUrl = value;
                continue;
            }
            if ("long_url".equals(name)) {
                lUrl = value;
                continue;
            }
            if ("global_hash".equals(name)) {
                gHash = value;
                continue;
            }
            if ("user_hash".equals(name)) {
                uHash = value;
                continue;
            }
            if (!"hash".equals(name)) continue;
            uHash = value;
        }
        return new Url(provider.getUrl(), gHash, uHash, sUrl, lUrl);
    }

    static UrlInfo parseInfo(Bitly.Provider provider, Node nl) {
        NodeList il = nl.getChildNodes();
        String title = "";
        String createdBy = "";
        for (int i = 0; i < il.getLength(); ++i) {
            Node n = il.item(i);
            String name = n.getNodeName();
            String value = Dom.getTextContent(n);
            if ("created_by".equals(name)) {
                createdBy = value;
                continue;
            }
            if (!"title".equals(name)) continue;
            title = value;
        }
        return new UrlInfo(Methods.parseUrl(provider, nl), createdBy, title);
    }
}

