/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.BroadcastReceiver;
import android.content.ComponentCallbacks;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.DatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.UserHandle;
import android.util.AttributeSet;
import android.view.Display;
import android.view.DisplayAdjustments;
import android.view.ViewDebug;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public abstract class Context {
    public static final int MODE_PRIVATE = 0;
    @Deprecated
    public static final int MODE_WORLD_READABLE = 1;
    @Deprecated
    public static final int MODE_WORLD_WRITEABLE = 2;
    public static final int MODE_APPEND = 32768;
    @Deprecated
    public static final int MODE_MULTI_PROCESS = 4;
    public static final int MODE_ENABLE_WRITE_AHEAD_LOGGING = 8;
    public static final int MODE_NO_LOCALIZED_COLLATORS = 16;
    public static final int BIND_AUTO_CREATE = 1;
    public static final int BIND_DEBUG_UNBIND = 2;
    public static final int BIND_NOT_FOREGROUND = 4;
    public static final int BIND_ABOVE_CLIENT = 8;
    public static final int BIND_ALLOW_OOM_MANAGEMENT = 16;
    public static final int BIND_WAIVE_PRIORITY = 32;
    public static final int BIND_IMPORTANT = 64;
    public static final int BIND_ADJUST_WITH_ACTIVITY = 128;
    public static final int BIND_ALLOW_WHITELIST_MANAGEMENT = 0x1000000;
    public static final int BIND_FOREGROUND_SERVICE_WHILE_AWAKE = 0x2000000;
    public static final int BIND_FOREGROUND_SERVICE = 0x4000000;
    public static final int BIND_TREAT_LIKE_ACTIVITY = 0x8000000;
    public static final int BIND_VISIBLE = 0x10000000;
    public static final int BIND_SHOWING_UI = 0x20000000;
    public static final int BIND_NOT_VISIBLE = 0x40000000;
    public static final int BIND_EXTERNAL_SERVICE = Integer.MIN_VALUE;
    public static final String POWER_SERVICE = "power";
    public static final String RECOVERY_SERVICE = "recovery";
    public static final String WINDOW_SERVICE = "window";
    public static final String LAYOUT_INFLATER_SERVICE = "layout_inflater";
    public static final String ACCOUNT_SERVICE = "account";
    public static final String ACTIVITY_SERVICE = "activity";
    public static final String ALARM_SERVICE = "alarm";
    public static final String NOTIFICATION_SERVICE = "notification";
    public static final String ACCESSIBILITY_SERVICE = "accessibility";
    public static final String CAPTIONING_SERVICE = "captioning";
    public static final String KEYGUARD_SERVICE = "keyguard";
    public static final String LOCATION_SERVICE = "location";
    public static final String COUNTRY_DETECTOR = "country_detector";
    public static final String SEARCH_SERVICE = "search";
    public static final String SENSOR_SERVICE = "sensor";
    public static final String STORAGE_SERVICE = "storage";
    public static final String WALLPAPER_SERVICE = "wallpaper";
    public static final String VIBRATOR_SERVICE = "vibrator";
    public static final String STATUS_BAR_SERVICE = "statusbar";
    public static final String CONNECTIVITY_SERVICE = "connectivity";
    public static final String IPSEC_SERVICE = "ipsec";
    public static final String UPDATE_LOCK_SERVICE = "updatelock";
    public static final String NETWORKMANAGEMENT_SERVICE = "network_management";
    public static final String NETWORK_STATS_SERVICE = "netstats";
    public static final String NETWORK_POLICY_SERVICE = "netpolicy";
    public static final String WIFI_SERVICE = "wifi";
    public static final String WIFI_P2P_SERVICE = "wifip2p";
    public static final String WIFI_AWARE_SERVICE = "wifiaware";
    public static final String WIFI_SCANNING_SERVICE = "wifiscanner";
    public static final String WIFI_RTT_SERVICE = "rttmanager";
    public static final String ETHERNET_SERVICE = "ethernet";
    public static final String NSD_SERVICE = "servicediscovery";
    public static final String AUDIO_SERVICE = "audio";
    public static final String FINGERPRINT_SERVICE = "fingerprint";
    public static final String MEDIA_ROUTER_SERVICE = "media_router";
    public static final String MEDIA_SESSION_SERVICE = "media_session";
    public static final String TELEPHONY_SERVICE = "phone";
    public static final String TELEPHONY_SUBSCRIPTION_SERVICE = "telephony_subscription_service";
    public static final String TELECOM_SERVICE = "telecom";
    public static final String CARRIER_CONFIG_SERVICE = "carrier_config";
    public static final String CLIPBOARD_SERVICE = "clipboard";
    public static final String INPUT_METHOD_SERVICE = "input_method";
    public static final String TEXT_SERVICES_MANAGER_SERVICE = "textservices";
    public static final String APPWIDGET_SERVICE = "appwidget";
    public static final String VOICE_INTERACTION_MANAGER_SERVICE = "voiceinteraction";
    public static final String SOUND_TRIGGER_SERVICE = "soundtrigger";
    public static final String BACKUP_SERVICE = "backup";
    public static final String DROPBOX_SERVICE = "dropbox";
    public static final String DEVICE_IDLE_CONTROLLER = "deviceidle";
    public static final String DEVICE_POLICY_SERVICE = "device_policy";
    public static final String UI_MODE_SERVICE = "uimode";
    public static final String DOWNLOAD_SERVICE = "download";
    public static final String BATTERY_SERVICE = "batterymanager";
    public static final String NFC_SERVICE = "nfc";
    public static final String BLUETOOTH_SERVICE = "bluetooth";
    public static final String SIP_SERVICE = "sip";
    public static final String USB_SERVICE = "usb";
    public static final String SERIAL_SERVICE = "serial";
    public static final String HDMI_CONTROL_SERVICE = "hdmi_control";
    public static final String INPUT_SERVICE = "input";
    public static final String DISPLAY_SERVICE = "display";
    public static final String USER_SERVICE = "user";
    public static final String LAUNCHER_APPS_SERVICE = "launcherapps";
    public static final String RESTRICTIONS_SERVICE = "restrictions";
    public static final String APP_OPS_SERVICE = "appops";
    public static final String CAMERA_SERVICE = "camera";
    public static final String PRINT_SERVICE = "print";
    public static final String CONSUMER_IR_SERVICE = "consumer_ir";
    public static final String TRUST_SERVICE = "trust";
    public static final String TV_INPUT_SERVICE = "tv_input";
    public static final String NETWORK_SCORE_SERVICE = "network_score";
    public static final String USAGE_STATS_SERVICE = "usagestats";
    public static final String JOB_SCHEDULER_SERVICE = "jobscheduler";
    public static final String PERSISTENT_DATA_BLOCK_SERVICE = "persistent_data_block";
    public static final String MEDIA_PROJECTION_SERVICE = "media_projection";
    public static final String MIDI_SERVICE = "midi";
    public static final String RADIO_SERVICE = "radio";
    public static final String HARDWARE_PROPERTIES_SERVICE = "hardware_properties";
    public static final String SHORTCUT_SERVICE = "shortcut";
    public static final String CONTEXTHUB_SERVICE = "contexthub";
    public static final String SYSTEM_HEALTH_SERVICE = "systemhealth";
    public static final String GATEKEEPER_SERVICE = "android.service.gatekeeper.IGateKeeperService";
    public static final String TIME_ZONE_RULES_MANAGER_SERVICE = "timezone";
    public static final int CONTEXT_INCLUDE_CODE = 1;
    public static final int CONTEXT_IGNORE_SECURITY = 2;
    public static final int CONTEXT_RESTRICTED = 4;
    public static final int CONTEXT_DEVICE_PROTECTED_STORAGE = 8;
    public static final int CONTEXT_CREDENTIAL_PROTECTED_STORAGE = 16;
    public static final int CONTEXT_REGISTER_PACKAGE = 0x40000000;

    public abstract AssetManager getAssets();

    public abstract Resources getResources();

    public abstract PackageManager getPackageManager();

    public abstract ContentResolver getContentResolver();

    public abstract Looper getMainLooper();

    public abstract Context getApplicationContext();

    public void registerComponentCallbacks(ComponentCallbacks callback) {
        this.getApplicationContext().registerComponentCallbacks(callback);
    }

    public void unregisterComponentCallbacks(ComponentCallbacks callback) {
        this.getApplicationContext().unregisterComponentCallbacks(callback);
    }

    public final CharSequence getText(int resId) {
        return this.getResources().getText(resId);
    }

    public final String getString(int resId) {
        return this.getResources().getString(resId);
    }

    public final String getString(int resId, Object ... formatArgs) {
        return this.getResources().getString(resId, formatArgs);
    }

    public final int getColor(int id) {
        throw new UnsupportedOperationException("STUB");
    }

    public final Drawable getDrawable(int id) {
        return this.getResources().getDrawable(id, this.getTheme());
    }

    public final ColorStateList getColorStateList(int id) {
        throw new UnsupportedOperationException("STUB");
    }

    public abstract void setTheme(int var1);

    public int getThemeResId() {
        return 0;
    }

    @ViewDebug.ExportedProperty(deepExport=true)
    public abstract Resources.Theme getTheme();

    public final TypedArray obtainStyledAttributes(int[] attrs) {
        throw new UnsupportedOperationException("STUB");
    }

    public final TypedArray obtainStyledAttributes(int resid, int[] attrs) throws Resources.NotFoundException {
        throw new UnsupportedOperationException("STUB");
    }

    public final TypedArray obtainStyledAttributes(AttributeSet set, int[] attrs) {
        throw new UnsupportedOperationException("STUB");
    }

    public final TypedArray obtainStyledAttributes(AttributeSet set, int[] attrs, int defStyleAttr, int defStyleRes) {
        return this.getTheme().obtainStyledAttributes(set, attrs, defStyleAttr, defStyleRes);
    }

    public abstract ClassLoader getClassLoader();

    public abstract String getPackageName();

    public String getBasePackageName() {
        throw new UnsupportedOperationException("STUB abstract");
    }

    public String getOpPackageName() {
        throw new UnsupportedOperationException("STUB abstract");
    }

    public abstract ApplicationInfo getApplicationInfo();

    public abstract String getPackageResourcePath();

    public abstract String getPackageCodePath();

    @Deprecated
    public File getSharedPrefsFile(String name) {
        return this.getSharedPreferencesPath(name);
    }

    public abstract SharedPreferences getSharedPreferences(String var1, int var2);

    public SharedPreferences getSharedPreferences(File file, int mode) {
        throw new UnsupportedOperationException("STUB abstract");
    }

    public abstract boolean moveSharedPreferencesFrom(Context var1, String var2);

    @Deprecated
    public boolean migrateSharedPreferencesFrom(Context sourceContext, String name) {
        return this.moveSharedPreferencesFrom(sourceContext, name);
    }

    public abstract boolean deleteSharedPreferences(String var1);

    public abstract FileInputStream openFileInput(String var1) throws FileNotFoundException;

    public abstract FileOutputStream openFileOutput(String var1, int var2) throws FileNotFoundException;

    public abstract boolean deleteFile(String var1);

    public abstract File getFileStreamPath(String var1);

    public File getSharedPreferencesPath(String name) {
        throw new UnsupportedOperationException("STUB abstract");
    }

    public abstract File getDataDir();

    public abstract File getFilesDir();

    public abstract File getNoBackupFilesDir();

    public abstract File getExternalFilesDir(String var1);

    public abstract File[] getExternalFilesDirs(String var1);

    public abstract File getObbDir();

    public abstract File[] getObbDirs();

    public abstract File getCacheDir();

    public abstract File getCodeCacheDir();

    public abstract File getExternalCacheDir();

    public abstract File[] getExternalCacheDirs();

    public abstract File[] getExternalMediaDirs();

    public abstract String[] fileList();

    public abstract File getDir(String var1, int var2);

    public abstract SQLiteDatabase openOrCreateDatabase(String var1, int var2, SQLiteDatabase.CursorFactory var3);

    public abstract SQLiteDatabase openOrCreateDatabase(String var1, int var2, SQLiteDatabase.CursorFactory var3, DatabaseErrorHandler var4);

    public abstract boolean moveDatabaseFrom(Context var1, String var2);

    @Deprecated
    public boolean migrateDatabaseFrom(Context sourceContext, String name) {
        return this.moveDatabaseFrom(sourceContext, name);
    }

    public abstract boolean deleteDatabase(String var1);

    public abstract File getDatabasePath(String var1);

    public abstract String[] databaseList();

    @Deprecated
    public abstract Drawable getWallpaper();

    @Deprecated
    public abstract Drawable peekWallpaper();

    @Deprecated
    public abstract int getWallpaperDesiredMinimumWidth();

    @Deprecated
    public abstract int getWallpaperDesiredMinimumHeight();

    @Deprecated
    public abstract void setWallpaper(Bitmap var1) throws IOException;

    @Deprecated
    public abstract void setWallpaper(InputStream var1) throws IOException;

    @Deprecated
    public abstract void clearWallpaper() throws IOException;

    public abstract void startActivity(Intent var1);

    public void startActivityAsUser(Intent intent, UserHandle user) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public abstract void startActivity(Intent var1, Bundle var2);

    public void startActivityAsUser(Intent intent, Bundle options, UserHandle userId) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public void startActivityForResult(String who, Intent intent, int requestCode, Bundle options) {
        throw new RuntimeException("This method is only implemented for Activity-based Contexts. Check canStartActivityForResult() before calling.");
    }

    public boolean canStartActivityForResult() {
        return false;
    }

    public abstract void startActivities(Intent[] var1);

    public abstract void startActivities(Intent[] var1, Bundle var2);

    public void startActivitiesAsUser(Intent[] intents, Bundle options, UserHandle userHandle) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public abstract void startIntentSender(IntentSender var1, Intent var2, int var3, int var4, int var5) throws IntentSender.SendIntentException;

    public abstract void startIntentSender(IntentSender var1, Intent var2, int var3, int var4, int var5, Bundle var6) throws IntentSender.SendIntentException;

    public abstract void sendBroadcast(Intent var1);

    public abstract void sendBroadcast(Intent var1, String var2);

    public void sendBroadcastMultiplePermissions(Intent intent, String[] receiverPermissions) {
        throw new UnsupportedOperationException("STUB abstract");
    }

    public void sendBroadcast(Intent intent, String receiverPermission, Bundle options) {
        throw new UnsupportedOperationException("STUB abstract");
    }

    public void sendBroadcast(Intent intent, String receiverPermission, int appOp) {
        throw new UnsupportedOperationException("STUB abstract");
    }

    public abstract void sendOrderedBroadcast(Intent var1, String var2);

    public abstract void sendOrderedBroadcast(Intent var1, String var2, BroadcastReceiver var3, Handler var4, int var5, String var6, Bundle var7);

    public void sendOrderedBroadcast(Intent intent, String receiverPermission, Bundle options, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras) {
        throw new UnsupportedOperationException("STUB abstract");
    }

    public void sendOrderedBroadcast(Intent intent, String receiverPermission, int appOp, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras) {
        throw new UnsupportedOperationException("STUB abstract");
    }

    public abstract void sendBroadcastAsUser(Intent var1, UserHandle var2);

    public abstract void sendBroadcastAsUser(Intent var1, UserHandle var2, String var3);

    public void sendBroadcastAsUser(Intent intent, UserHandle user, String receiverPermission, int appOp) {
        throw new UnsupportedOperationException("STUB abstract");
    }

    public abstract void sendOrderedBroadcastAsUser(Intent var1, UserHandle var2, String var3, BroadcastReceiver var4, Handler var5, int var6, String var7, Bundle var8);

    public void sendOrderedBroadcastAsUser(Intent intent, UserHandle user, String receiverPermission, int appOp, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras) {
        throw new UnsupportedOperationException("STUB abstract");
    }

    public void sendOrderedBroadcastAsUser(Intent intent, UserHandle user, String receiverPermission, int appOp, Bundle options, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras) {
        throw new UnsupportedOperationException("STUB abstract");
    }

    @Deprecated
    public abstract void sendStickyBroadcast(Intent var1);

    @Deprecated
    public abstract void sendStickyOrderedBroadcast(Intent var1, BroadcastReceiver var2, Handler var3, int var4, String var5, Bundle var6);

    @Deprecated
    public abstract void removeStickyBroadcast(Intent var1);

    @Deprecated
    public abstract void sendStickyBroadcastAsUser(Intent var1, UserHandle var2);

    @Deprecated
    public void sendStickyBroadcastAsUser(Intent intent, UserHandle user, Bundle options) {
        throw new UnsupportedOperationException("STUB abstract");
    }

    @Deprecated
    public abstract void sendStickyOrderedBroadcastAsUser(Intent var1, UserHandle var2, BroadcastReceiver var3, Handler var4, int var5, String var6, Bundle var7);

    @Deprecated
    public abstract void removeStickyBroadcastAsUser(Intent var1, UserHandle var2);

    public abstract Intent registerReceiver(BroadcastReceiver var1, IntentFilter var2);

    public abstract Intent registerReceiver(BroadcastReceiver var1, IntentFilter var2, String var3, Handler var4);

    public Intent registerReceiverAsUser(BroadcastReceiver receiver, UserHandle user, IntentFilter filter, String broadcastPermission, Handler scheduler) {
        throw new UnsupportedOperationException("STUB abstract");
    }

    public abstract void unregisterReceiver(BroadcastReceiver var1);

    public abstract ComponentName startService(Intent var1);

    public abstract boolean stopService(Intent var1);

    public ComponentName startServiceAsUser(Intent service, UserHandle user) {
        throw new UnsupportedOperationException("STUB abstract");
    }

    public boolean stopServiceAsUser(Intent service, UserHandle user) {
        throw new UnsupportedOperationException("STUB abstract");
    }

    public abstract boolean bindService(Intent var1, ServiceConnection var2, int var3);

    public boolean bindServiceAsUser(Intent service, ServiceConnection conn, int flags, UserHandle user) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public boolean bindServiceAsUser(Intent service, ServiceConnection conn, int flags, Handler handler, UserHandle user) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    public abstract void unbindService(ServiceConnection var1);

    public abstract boolean startInstrumentation(ComponentName var1, String var2, Bundle var3);

    public abstract Object getSystemService(String var1);

    public final <T> T getSystemService(Class<T> serviceClass) {
        String serviceName = this.getSystemServiceName(serviceClass);
        return (T)(serviceName != null ? this.getSystemService(serviceName) : null);
    }

    public abstract String getSystemServiceName(Class<?> var1);

    public abstract int checkPermission(String var1, int var2, int var3);

    public int checkPermission(String permission2, int pid, int uid, IBinder callerToken) {
        throw new UnsupportedOperationException("STUB abstract");
    }

    public abstract int checkCallingPermission(String var1);

    public abstract int checkCallingOrSelfPermission(String var1);

    public abstract int checkSelfPermission(String var1);

    public abstract void enforcePermission(String var1, int var2, int var3, String var4);

    public abstract void enforceCallingPermission(String var1, String var2);

    public abstract void enforceCallingOrSelfPermission(String var1, String var2);

    public abstract void grantUriPermission(String var1, Uri var2, int var3);

    public abstract void revokeUriPermission(Uri var1, int var2);

    public abstract int checkUriPermission(Uri var1, int var2, int var3, int var4);

    public int checkUriPermission(Uri uri, int pid, int uid, int modeFlags, IBinder callerToken) {
        throw new UnsupportedOperationException("STUB abstract");
    }

    public abstract int checkCallingUriPermission(Uri var1, int var2);

    public abstract int checkCallingOrSelfUriPermission(Uri var1, int var2);

    public abstract int checkUriPermission(Uri var1, String var2, String var3, int var4, int var5, int var6);

    public abstract void enforceUriPermission(Uri var1, int var2, int var3, int var4, String var5);

    public abstract void enforceCallingUriPermission(Uri var1, int var2, String var3);

    public abstract void enforceCallingOrSelfUriPermission(Uri var1, int var2, String var3);

    public abstract void enforceUriPermission(Uri var1, String var2, String var3, int var4, int var5, int var6, String var7);

    public abstract Context createPackageContext(String var1, int var2) throws PackageManager.NameNotFoundException;

    public Context createPackageContextAsUser(String packageName, int flags, UserHandle user) throws PackageManager.NameNotFoundException {
        throw new UnsupportedOperationException("STUB abstract");
    }

    public Context createApplicationContext(ApplicationInfo application, int flags) throws PackageManager.NameNotFoundException {
        throw new UnsupportedOperationException("STUB abstract");
    }

    public int getUserId() {
        throw new UnsupportedOperationException("STUB abstract");
    }

    public abstract Context createConfigurationContext(Configuration var1);

    public abstract Context createDisplayContext(Display var1);

    public abstract Context createDeviceProtectedStorageContext();

    @Deprecated
    public Context createDeviceEncryptedStorageContext() {
        return this.createDeviceProtectedStorageContext();
    }

    public Context createCredentialProtectedStorageContext() {
        throw new UnsupportedOperationException("STUB abstract");
    }

    @Deprecated
    public Context createCredentialEncryptedStorageContext() {
        return this.createCredentialProtectedStorageContext();
    }

    public DisplayAdjustments getDisplayAdjustments(int displayId) {
        throw new UnsupportedOperationException("STUB abstract");
    }

    public Display getDisplay() {
        throw new UnsupportedOperationException("STUB abstract");
    }

    public boolean isRestricted() {
        return false;
    }

    public boolean isDeviceProtectedStorage() {
        throw new UnsupportedOperationException("STUB abstract");
    }

    @Deprecated
    public boolean isDeviceEncryptedStorage() {
        return this.isDeviceProtectedStorage();
    }

    public boolean isCredentialProtectedStorage() {
        throw new UnsupportedOperationException("STUB abstract");
    }

    @Deprecated
    public boolean isCredentialEncryptedStorage() {
        return this.isCredentialProtectedStorage();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CreatePackageOptions {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ServiceName {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BindServiceFlags {
    }
}

