/*
 * Decompiled with CFR 0.152.
 */
package android.os.storage;

import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.storage.DiskInfo;
import android.os.storage.StorageVolume;
import android.util.ArrayMap;
import android.util.SparseArray;
import android.util.SparseIntArray;
import java.io.File;
import java.util.Comparator;

public class VolumeInfo
implements Parcelable {
    public static final String ACTION_VOLUME_STATE_CHANGED = "android.os.storage.action.VOLUME_STATE_CHANGED";
    public static final String EXTRA_VOLUME_ID = "android.os.storage.extra.VOLUME_ID";
    public static final String EXTRA_VOLUME_STATE = "android.os.storage.extra.VOLUME_STATE";
    public static final String ID_PRIVATE_INTERNAL = "private";
    public static final String ID_EMULATED_INTERNAL = "emulated";
    public static final int TYPE_PUBLIC = 0;
    public static final int TYPE_PRIVATE = 1;
    public static final int TYPE_EMULATED = 2;
    public static final int TYPE_ASEC = 3;
    public static final int TYPE_OBB = 4;
    public static final int STATE_UNMOUNTED = 0;
    public static final int STATE_CHECKING = 1;
    public static final int STATE_MOUNTED = 2;
    public static final int STATE_MOUNTED_READ_ONLY = 3;
    public static final int STATE_FORMATTING = 4;
    public static final int STATE_EJECTING = 5;
    public static final int STATE_UNMOUNTABLE = 6;
    public static final int STATE_REMOVED = 7;
    public static final int STATE_BAD_REMOVAL = 8;
    public static final int MOUNT_FLAG_PRIMARY = 1;
    public static final int MOUNT_FLAG_VISIBLE = 2;
    private static SparseArray<String> sStateToEnvironment = new SparseArray();
    private static ArrayMap<String, String> sEnvironmentToBroadcast = new ArrayMap();
    private static SparseIntArray sStateToDescrip = new SparseIntArray();
    public final String id;
    public final int type;
    public final DiskInfo disk;
    public final String partGuid;
    public int mountFlags = 0;
    public int mountUserId = -1;
    public int state = 0;
    public String fsType;
    public String fsUuid;
    public String fsLabel;
    public String path;
    public String internalPath;
    private static final String DOCUMENT_AUTHORITY = "com.android.externalstorage.documents";
    private static final String DOCUMENT_ROOT_PRIMARY_EMULATED = "primary";
    public static final Parcelable.Creator<VolumeInfo> CREATOR = new Parcelable.Creator<VolumeInfo>(){

        public VolumeInfo createFromParcel(Parcel in) {
            return new VolumeInfo(in);
        }

        public VolumeInfo[] newArray(int size) {
            return new VolumeInfo[size];
        }
    };

    public VolumeInfo(String id, int type, DiskInfo disk, String partGuid) {
        throw new UnsupportedOperationException("STUB");
    }

    public VolumeInfo(Parcel parcel) {
        throw new UnsupportedOperationException("STUB");
    }

    public static String getEnvironmentForState(int state) {
        String envState = (String)sStateToEnvironment.get(state);
        if (envState != null) {
            return envState;
        }
        return "unknown";
    }

    public static String getBroadcastForEnvironment(String envState) {
        return (String)sEnvironmentToBroadcast.get((Object)envState);
    }

    public static String getBroadcastForState(int state) {
        return VolumeInfo.getBroadcastForEnvironment(VolumeInfo.getEnvironmentForState(state));
    }

    public static Comparator<VolumeInfo> getDescriptionComparator() {
        throw new UnsupportedOperationException("STUB");
    }

    public String getId() {
        return this.id;
    }

    public DiskInfo getDisk() {
        return this.disk;
    }

    public String getDiskId() {
        throw new UnsupportedOperationException("STUB");
    }

    public int getType() {
        return this.type;
    }

    public int getState() {
        return this.state;
    }

    public int getStateDescription() {
        return sStateToDescrip.get(this.state, 0);
    }

    public String getFsUuid() {
        return this.fsUuid;
    }

    public int getMountUserId() {
        return this.mountUserId;
    }

    public String getDescription() {
        throw new UnsupportedOperationException("STUB");
    }

    public boolean isMountedReadable() {
        return this.state == 2 || this.state == 3;
    }

    public boolean isMountedWritable() {
        return this.state == 2;
    }

    public boolean isPrimary() {
        return (this.mountFlags & 1) != 0;
    }

    public boolean isPrimaryPhysical() {
        return this.isPrimary() && this.getType() == 0;
    }

    public boolean isVisible() {
        return (this.mountFlags & 2) != 0;
    }

    public boolean isVisibleForRead(int userId) {
        throw new UnsupportedOperationException("STUB");
    }

    public boolean isVisibleForWrite(int userId) {
        throw new UnsupportedOperationException("STUB");
    }

    public File getPath() {
        return this.path != null ? new File(this.path) : null;
    }

    public File getInternalPath() {
        return this.internalPath != null ? new File(this.internalPath) : null;
    }

    public File getPathForUser(int userId) {
        throw new UnsupportedOperationException("STUB");
    }

    public File getInternalPathForUser(int userId) {
        throw new UnsupportedOperationException("STUB");
    }

    public StorageVolume buildStorageVolume(Context context, int userId, boolean reportUnmounted) {
        throw new UnsupportedOperationException("STUB");
    }

    public static int buildStableMtpStorageId(String fsUuid) {
        throw new UnsupportedOperationException("STUB");
    }

    public Intent buildBrowseIntent() {
        throw new UnsupportedOperationException("STUB");
    }

    public String toString() {
        throw new UnsupportedOperationException("STUB");
    }

    public VolumeInfo clone() {
        throw new UnsupportedOperationException("STUB");
    }

    public boolean equals(Object o) {
        throw new UnsupportedOperationException("STUB");
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        throw new UnsupportedOperationException("STUB");
    }
}

