/*
 * Decompiled with CFR 0.152.
 */
package com.ruijc.structure.queue;

import com.ruijc.structure.queue.IRingQueue;
import com.ruijc.structure.queue.Slot;
import java.util.Queue;

public abstract class AbstractRingQueue<T>
implements IRingQueue<T> {
    protected Slot[] slots;
    protected int length;

    public AbstractRingQueue() {
        this(3600);
    }

    public AbstractRingQueue(int n) {
        this.length = n;
        this.slots = new Slot[n];
        for (int i = 0; i < n; ++i) {
            this.slots[i] = new Slot();
        }
    }

    public int getLength() {
        return this.length;
    }

    public abstract int index();

    @Override
    public void add(T t) {
        this.add(this.index(), t);
    }

    @Override
    public void remove(T t) {
        this.remove(this.index(), t);
    }

    @Override
    public Queue<T> next(int n) {
        return this.slots[n % this.length].getElements();
    }

    @Override
    public void add(int n, T t) {
        this.slots[n % this.length].add(t);
    }

    @Override
    public void remove(int n, T t) {
        this.slots[n].reomve(t);
    }

    @Override
    public void replace(T t) {
        this.remove(this.index(), t);
    }

    @Override
    public void replace(int n, T t) {
        this.remove(n % this.length, t);
        this.add(n % this.length, t);
    }
}

