/*
 * Decompiled with CFR 0.152.
 */
package com.ruleoftech.markdown.page.generator.plugin;

import org.parboiled.common.StringUtils;
import org.pegdown.FastEncoder;
import org.pegdown.LinkRenderer;
import org.pegdown.ast.ExpLinkNode;

class MDToHTMLExpLinkRender
extends LinkRenderer {
    private String inputFileExtension = "md";

    MDToHTMLExpLinkRender() {
    }

    MDToHTMLExpLinkRender(String inputFileExtension) {
        this.inputFileExtension = inputFileExtension;
    }

    public LinkRenderer.Rendering render(ExpLinkNode node, String text) {
        String url = node.url;
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            if (url.endsWith("." + this.inputFileExtension)) {
                url = url.substring(0, url.length() - this.inputFileExtension.length()) + "html";
            } else if (url.contains("." + this.inputFileExtension + "#")) {
                url = url.replace("." + this.inputFileExtension + "#", ".html#");
            }
        }
        LinkRenderer.Rendering rendering = new LinkRenderer.Rendering(url, text);
        return StringUtils.isEmpty((String)node.title) ? rendering : rendering.withAttribute("title", FastEncoder.encode((String)node.title));
    }
}

