/*
 * Decompiled with CFR 0.152.
 */
package com.ruleoftech.markdown.page.generator.plugin;

import com.ruleoftech.markdown.page.generator.plugin.PageGeneratorExtension;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ext.wikilink.internal.WikiLinkLinkResolver;
import com.vladsch.flexmark.html.IndependentLinkResolverFactory;
import com.vladsch.flexmark.html.LinkResolver;
import com.vladsch.flexmark.html.LinkResolverFactory;
import com.vladsch.flexmark.html.renderer.LinkResolverContext;
import com.vladsch.flexmark.html.renderer.LinkStatus;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.util.options.DataHolder;
import java.util.HashSet;
import java.util.Set;

public class FlexmarkLinkResolver
implements LinkResolver {
    final String inputFileExtension;

    public FlexmarkLinkResolver(LinkResolverContext context) {
        DataHolder options = context.getOptions();
        this.inputFileExtension = (String)options.get(PageGeneratorExtension.INPUT_FILE_EXTENSION);
    }

    public ResolvedLink resolveLink(Node node, LinkResolverContext context, ResolvedLink link) {
        ResolvedLink result = link;
        if (link.getLinkType() == LinkType.LINK) {
            String url = link.getUrl();
            if (!url.startsWith("http://") && !url.startsWith("https://")) {
                if (url.endsWith("." + this.inputFileExtension)) {
                    url = url.substring(0, url.length() - this.inputFileExtension.length()) + "html";
                } else if (url.contains("." + this.inputFileExtension + "#")) {
                    url = url.replace("." + this.inputFileExtension + "#", ".html#");
                }
                result = result.withStatus(LinkStatus.VALID).withUrl((CharSequence)url);
            }
            return result;
        }
        return result;
    }

    public static class Factory
    extends IndependentLinkResolverFactory {
        public Set<Class<? extends LinkResolverFactory>> getBeforeDependents() {
            HashSet<Class<? extends LinkResolverFactory>> set = new HashSet<Class<? extends LinkResolverFactory>>();
            set.add(WikiLinkLinkResolver.Factory.class);
            return set;
        }

        public LinkResolver create(LinkResolverContext context) {
            return new FlexmarkLinkResolver(context);
        }
    }
}

