/*
 * Decompiled with CFR 0.152.
 */
package com.ruleoftech.markdown.page.generator.plugin;

import com.ruleoftech.markdown.page.generator.plugin.PageGeneratorExtension;
import com.vladsch.flexmark.ext.wikilink.internal.WikiLinkLinkResolver;
import com.vladsch.flexmark.html.IndependentLinkResolverFactory;
import com.vladsch.flexmark.html.LinkResolver;
import com.vladsch.flexmark.html.LinkResolverFactory;
import com.vladsch.flexmark.html.renderer.LinkResolverContext;
import com.vladsch.flexmark.html.renderer.LinkStatus;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import java.util.HashSet;
import java.util.Set;

public class FlexmarkLinkResolver
implements LinkResolver {
    final String[] inputFileExtensions;

    public FlexmarkLinkResolver(LinkResolverContext context) {
        DataHolder options = context.getOptions();
        this.inputFileExtensions = ((String)options.get(PageGeneratorExtension.INPUT_FILE_EXTENSIONS)).trim().split("\\s*,\\s*");
    }

    public ResolvedLink resolveLink(Node node, LinkResolverContext context, ResolvedLink link) {
        ResolvedLink result = link;
        for (String inputFileExtension : this.inputFileExtensions) {
            String url;
            if (link.getLinkType() != LinkType.LINK || (url = link.getUrl()).startsWith("http://") || url.startsWith("https://")) continue;
            if (url.endsWith("." + inputFileExtension)) {
                url = url.substring(0, url.length() - inputFileExtension.length()) + "html";
                result = result.withStatus(LinkStatus.VALID).withUrl((CharSequence)url);
                return result;
            }
            if (!url.contains("." + inputFileExtension + "#")) continue;
            url = url.replace("." + inputFileExtension + "#", ".html#");
            result = result.withStatus(LinkStatus.VALID).withUrl((CharSequence)url);
            return result;
        }
        return result;
    }

    public static class Factory
    extends IndependentLinkResolverFactory {
        public Set<Class<? extends LinkResolverFactory>> getBeforeDependents() {
            HashSet<Class<? extends LinkResolverFactory>> set = new HashSet<Class<? extends LinkResolverFactory>>();
            set.add(WikiLinkLinkResolver.Factory.class);
            return set;
        }

        public LinkResolver apply(LinkResolverContext context) {
            return new FlexmarkLinkResolver(context);
        }
    }
}

