/*
 * Decompiled with CFR 0.152.
 */
package com.ruleoftech.markdown.page.generator.plugin;

import com.ruleoftech.markdown.page.generator.plugin.AttributesExtension;
import com.ruleoftech.markdown.page.generator.plugin.PageGeneratorExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.profiles.pegdown.Extensions;
import com.vladsch.flexmark.profiles.pegdown.PegdownOptionsAdapter;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.builder.Extension;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import com.vladsch.flexmark.util.html.Attributes;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.model.interpolation.MavenBuildTimestamp;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="generate", threadSafe=true)
public class MdPageGeneratorMojo
extends AbstractMojo {
    @Parameter(property="generate.defaultTitle")
    private String defaultTitle;
    @Parameter(property="generate.alwaysUseDefaultTitle", defaultValue="false")
    private boolean alwaysUseDefaultTitle;
    @Parameter(property="generate.inputDirectory", defaultValue="${project.basedir}/src/main/resources/markdown/")
    private String inputDirectory;
    @Parameter(property="generate.outputDirectory", defaultValue="${project.build.directory}/html/")
    private String outputDirectory;
    @Parameter(property="generate.headerHtmlFile")
    private String headerHtmlFile;
    @Parameter(property="generate.footerHtmlFile")
    private String footerHtmlFile;
    @Parameter(property="generate.failIfFilesAreMissing", defaultValue="true")
    private boolean failIfFilesAreMissing;
    @Parameter(property="generate.recursiveInput", defaultValue="false")
    private boolean recursiveInput;
    @Parameter(property="generate.transformRelativeMarkdownLinks", defaultValue="false")
    private boolean transformRelativeMarkdownLinks;
    @Parameter(property="generate.inputEncoding", defaultValue="${project.build.sourceEncoding}")
    private String inputEncoding;
    @Parameter(property="generate.outputEncoding", defaultValue="${project.build.sourceEncoding}")
    private String outputEncoding;
    @Parameter(property="generate.parsingTimeoutInMillis")
    private Long parsingTimeoutInMillis;
    @Parameter(property="generate.inputFileExtensions", defaultValue="md")
    private String inputFileExtensions = "md";
    @Parameter(property="generate.outputFileExtension", defaultValue="html")
    private String outputFileExtension = "html";
    @Parameter(property="generate.applyFiltering", defaultValue="false")
    private boolean applyFiltering;
    @Parameter(property="generate.timestampFormat", defaultValue="yyyy-MM-dd\\'T\\'HH:mm:ss\\'Z\\'")
    private String timestampFormat;
    @Parameter(property="generate.attributes")
    private String[] attributes;
    @Component
    private MavenProject project;
    @Component
    protected MavenSession session;
    @Parameter(property="generate.pegdownExtensions", defaultValue="TABLES")
    private String pegdownExtensions;
    @Parameter(property="generate.flexmarkParserOptions")
    private String flexmarkParserOptions;
    @Parameter(property="generate.flexmarkRendererOptions")
    private String flexmarkRendererOptions;
    @Parameter(property="generate.copyDirectories")
    private String copyDirectories;
    private List<MarkdownDTO> markdownDTOs = new ArrayList<MarkdownDTO>();
    @Parameter(property="generate.filteredOutputDirectory", defaultValue="${project.build.directory}/filtered-md/")
    private File filteredOutputDirectory;
    private List<MavenResourcesFiltering> mavenFilteringComponents = new ArrayList<MavenResourcesFiltering>();
    private PlexusContainer plexusContainer;
    private List<String> mavenFilteringHints;
    @Component(role=MavenResourcesFiltering.class, hint="default")
    protected MavenResourcesFiltering mavenResourcesFiltering;
    @Parameter
    protected List<String> nonFilteredFileExtensions;
    @Parameter(defaultValue="true")
    protected boolean addDefaultExcludes;
    @Parameter
    protected List<String> filters;
    @Parameter(defaultValue="true")
    protected boolean useBuildFilters;
    @Parameter(defaultValue="${project.build.filters}", readonly=true)
    protected List<String> buildFilters;

    public String getInputDirectory() {
        return this.inputDirectory;
    }

    public void setInputDirectory(String inputDirectory) {
        this.inputDirectory = inputDirectory;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String getCopyDirectories() {
        return this.copyDirectories;
    }

    public void setCopyDirectories(String copyDirectories) {
        this.copyDirectories = copyDirectories;
    }

    public void execute() throws MojoExecutionException {
        if (this.applyFiltering) {
            this.performMavenPropertyFiltering(new File(this.inputDirectory), this.filteredOutputDirectory, this.getInputEncoding());
            this.inputDirectory = this.filteredOutputDirectory.getAbsolutePath();
        }
        this.getLog().info((CharSequence)("Pre-processing markdown files from input directory: " + this.inputDirectory));
        if (!this.preprocessMarkdownFiles(new File(this.inputDirectory))) {
            this.getLog().info((CharSequence)("Pre-processing markdown files from input directory: markdown files not found" + this.inputDirectory));
            return;
        }
        if (!this.markdownDTOs.isEmpty()) {
            this.getLog().info((CharSequence)"Process Pegdown extension options");
            int pegdownOptions = this.getPegdownExtensions(this.pegdownExtensions);
            MutableDataHolder flexmarkParserOptions = this.getFlexmarkParserOptions(this.flexmarkParserOptions);
            MutableDataHolder flexmarkRendererOptions = this.getFlexmarkRendererOptions(this.flexmarkRendererOptions);
            Map<String, Attributes> attributesMap = this.processAttributes(this.attributes);
            this.getLog().info((CharSequence)"Parse Markdown to HTML");
            this.processMarkdown(this.markdownDTOs, pegdownOptions, flexmarkParserOptions, flexmarkRendererOptions, attributesMap);
        }
        if (StringUtils.isNotEmpty((String)this.copyDirectories)) {
            this.getLog().info((CharSequence)"Copy files from directories");
            for (String dir : this.copyDirectories.split(",")) {
                for (Map.Entry<String, String> copyAction : this.getFoldersToCopy(this.inputDirectory, this.outputDirectory, dir).entrySet()) {
                    this.copyFiles(copyAction.getKey(), copyAction.getValue());
                }
            }
        }
    }

    private Map<String, String> getFoldersToCopy(String inputDirectory, String outputDirectory, String dir) {
        HashMap<String, String> retValue = new HashMap<String, String>();
        Collection<Path> stream = this.getPathMatchingGlob(inputDirectory, dir);
        for (Path path : stream) {
            Path inFolderPath = new File(inputDirectory).toPath();
            Path relativePath = inFolderPath.relativize(path);
            Path resolvedOutPath = new File(outputDirectory).toPath().resolve(relativePath);
            Path resolvedInPath = new File(inputDirectory).toPath().resolve(relativePath);
            retValue.put(resolvedInPath.toFile().getAbsolutePath(), resolvedOutPath.toFile().getAbsolutePath());
        }
        return retValue;
    }

    private Collection<Path> getPathMatchingGlob(String inputDirectory1, String dir) {
        LinkedList<Path> retValue = new LinkedList<Path>();
        Iterator files = FileUtils.iterateFiles((File)new File(inputDirectory1), null, (boolean)true);
        while (files.hasNext()) {
            PathMatcher pathMatcher;
            File file = (File)files.next();
            if (!(file = file.getParentFile()).isDirectory()) continue;
            String expandedGlob = new File(inputDirectory1).getAbsolutePath() + File.separator + dir;
            if (File.separator.equals("\\")) {
                expandedGlob = expandedGlob.replaceAll("\\\\", "\\\\\\\\");
            }
            if (!(pathMatcher = file.toPath().getFileSystem().getPathMatcher("glob:" + expandedGlob)).matches(file.toPath()) || retValue.contains(file.toPath())) continue;
            retValue.add(file.toPath());
        }
        return retValue;
    }

    private Map<String, Attributes> processAttributes(String[] attributeList) {
        HashMap<String, Attributes> nodeAttributeMap = new HashMap<String, Attributes>();
        for (String attribute : attributeList) {
            String[] nodeAttributes = attribute.split("\\|");
            Attributes attributes = new Attributes();
            for (int i = 1; i < nodeAttributes.length; ++i) {
                String[] attributeNameValue = nodeAttributes[i].split("=", 2);
                if (attributeNameValue.length > 1) {
                    String value = attributeNameValue[1];
                    if (!value.isEmpty()) {
                        if (value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                            value = value.substring(1, value.length() - 1);
                        } else if (value.charAt(0) == '\'' && value.charAt(value.length() - 1) == '\'') {
                            value = value.substring(1, value.length() - 1);
                        }
                    }
                    attributes.addValue((CharSequence)attributeNameValue[0], (CharSequence)value);
                    continue;
                }
                attributes.addValue((CharSequence)attributeNameValue[0], (CharSequence)attributeNameValue[0]);
            }
            nodeAttributeMap.put(nodeAttributes[0], attributes);
        }
        return nodeAttributeMap;
    }

    private int getPegdownExtensions(String extensions) {
        if (extensions == null) {
            return 0;
        }
        int options = 0;
        for (String ext : extensions.split("\\s*,\\s*")) {
            try {
                if (ext.isEmpty()) continue;
                Field f = Extensions.class.getField(ext);
                options |= f.getInt(null);
                this.getLog().info((CharSequence)("Pegdown extension " + ext));
            }
            catch (NoSuchFieldException e) {
                throw new IllegalArgumentException("No such extension: " + ext);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Cannot read int value for extension " + ext + ": " + e, e);
            }
        }
        this.getLog().info((CharSequence)("Pegdown extension options = " + options));
        return options;
    }

    private <T> MutableDataHolder getFlexmarkParserOptions(String options) {
        MutableDataSet optionsAsDataKeys = new MutableDataSet();
        if (options == null) {
            return optionsAsDataKeys;
        }
        for (String opt : options.split("\\s*,\\s*")) {
            try {
                Field f = Parser.class.getField(opt);
                DataKey dataKey = (DataKey)f.get(null);
                optionsAsDataKeys.set(dataKey, dataKey.getDefaultValue(null));
                this.getLog().info((CharSequence)("Flexmark parser option " + opt));
            }
            catch (NoSuchFieldException e) {
                throw new IllegalArgumentException("No such parser option: " + opt);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Cannot read object value for extension " + opt + ": " + e, e);
            }
        }
        this.getLog().info((CharSequence)("Flexmark option count = " + optionsAsDataKeys.getKeys().size()));
        return optionsAsDataKeys;
    }

    private <T> MutableDataHolder getFlexmarkRendererOptions(String options) {
        MutableDataSet optionsAsDataKeys = new MutableDataSet();
        if (options == null) {
            return optionsAsDataKeys;
        }
        for (String opt : options.split("\\s*,\\s*")) {
            try {
                Field f = HtmlRenderer.class.getField(opt);
                DataKey dataKey = (DataKey)f.get(null);
                optionsAsDataKeys.set(dataKey, dataKey.getDefaultValue(null));
                this.getLog().info((CharSequence)("Flexmark renderer option " + opt));
            }
            catch (NoSuchFieldException e) {
                throw new IllegalArgumentException("No such renderer option: " + opt);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Cannot read object value for extension " + opt + ": " + e, e);
            }
        }
        this.getLog().info((CharSequence)("Flexmark option count = " + optionsAsDataKeys.getKeys().size()));
        return optionsAsDataKeys;
    }

    private boolean preprocessMarkdownFiles(File inputDirectory) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Read files from: " + inputDirectory));
        try {
            if (!inputDirectory.exists()) {
                this.getLog().info((CharSequence)"There is no input folder for the project. Skipping.");
                return false;
            }
            int baseDepth = StringUtils.countMatches((String)inputDirectory.getAbsolutePath(), (String)File.separator);
            List<File> markdownFiles = this.getFilesAsArray(FileUtils.iterateFiles((File)inputDirectory, (String[])this.getInputFileExtensions(), (boolean)this.recursiveInput));
            for (File file : markdownFiles) {
                this.getLog().debug((CharSequence)("File getName() " + file.getName()));
                this.getLog().debug((CharSequence)("File getAbsolutePath() " + file.getAbsolutePath()));
                this.getLog().debug((CharSequence)("File getPath() " + file.getPath()));
                MarkdownDTO dto = new MarkdownDTO();
                dto.markdownFile = file;
                dto.folderDepth = StringUtils.countMatches((String)file.getAbsolutePath(), (String)File.separator) - (baseDepth + 1);
                if (this.alwaysUseDefaultTitle) {
                    dto.title = this.defaultTitle;
                } else {
                    List raw = FileUtils.readLines((File)file, (String)this.getInputEncoding());
                    dto.title = this.getTitle(raw);
                }
                if (this.applyFiltering) {
                    for (String line : FileUtils.readLines((File)file, (String)this.getInputEncoding())) {
                        if (!MdPageGeneratorMojo.isVariableLine(line)) continue;
                        String key = line.replaceAll("(^\\{)|(=.*)", "");
                        String value = line.replaceAll("(^\\{(.*?)=)|(}$)", "");
                        this.getLog().debug((CharSequence)("Substitute: '" + key + "' -> '" + value + "'"));
                        dto.substitutes.put(key, value);
                    }
                }
                String inputFileExtension = FilenameUtils.getExtension((String)file.getName());
                dto.htmlFile = new File(this.recursiveInput ? this.outputDirectory + File.separator + file.getParentFile().getPath().substring(inputDirectory.getPath().length()) + File.separator + file.getName().replaceAll("\\." + inputFileExtension, "\\." + this.outputFileExtension) : this.outputDirectory + File.separator + file.getName().replaceAll("\\." + inputFileExtension, "\\." + this.outputFileExtension));
                this.getLog().debug((CharSequence)("File htmlFile() " + dto.htmlFile));
                this.markdownDTOs.add(dto);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to load file " + e.getMessage(), (Exception)e);
        }
        return true;
    }

    private String substituteVariables(String template, String patternString, Map<String, String> variables) {
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(template);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            if (!variables.containsKey(matcher.group(1))) continue;
            String replacement = variables.get(matcher.group(1));
            matcher.appendReplacement(buffer, replacement != null ? Matcher.quoteReplacement(replacement) : "null");
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private void processMarkdown(List<MarkdownDTO> markdownDTOs, int pegdownOptions, MutableDataHolder flexmarkParserOptions, MutableDataHolder flexmarkRendererOptions, Map<String, Attributes> attributesMap) throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Process Markdown");
        this.getLog().debug((CharSequence)("inputEncoding: '" + this.getInputEncoding() + "', outputEncoding: '" + this.getOutputEncoding() + "'"));
        this.getLog().debug((CharSequence)("applyFiltering: " + this.applyFiltering));
        MutableDataHolder finalFlexmarkOptions = PegdownOptionsAdapter.flexmarkOptions((int)pegdownOptions, (Extension[])new Extension[0]).toMutable();
        finalFlexmarkOptions.setAll((DataHolder)flexmarkParserOptions);
        finalFlexmarkOptions.setAll((DataHolder)flexmarkRendererOptions);
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        for (Object extension : (Iterable)finalFlexmarkOptions.get(Parser.EXTENSIONS)) {
            extensions.add((Extension)extension);
        }
        if (this.transformRelativeMarkdownLinks) {
            finalFlexmarkOptions.set(PageGeneratorExtension.INPUT_FILE_EXTENSIONS, (Object)this.inputFileExtensions);
            extensions.add(PageGeneratorExtension.create());
        }
        if (!attributesMap.isEmpty()) {
            finalFlexmarkOptions.set(AttributesExtension.ATTRIBUTE_MAP, attributesMap);
            extensions.add(AttributesExtension.create());
        }
        finalFlexmarkOptions.set(Parser.EXTENSIONS, extensions);
        StringBuilder finalOptions = new StringBuilder("final flexmark options: ");
        for (DataKey opt : finalFlexmarkOptions.keySet()) {
            finalOptions.append(opt.getName());
            finalOptions.append(" ");
        }
        this.getLog().debug((CharSequence)finalOptions.toString());
        Parser parser = Parser.builder((DataHolder)finalFlexmarkOptions).build();
        HtmlRenderer renderer = HtmlRenderer.builder((DataHolder)finalFlexmarkOptions).build();
        for (MarkdownDTO dto : markdownDTOs) {
            this.getLog().debug((CharSequence)("dto: " + dto));
            try {
                String headerHtml = "";
                String footerHtml = "";
                try {
                    if (StringUtils.isNotEmpty((String)this.headerHtmlFile)) {
                        headerHtml = FileUtils.readFileToString((File)new File(this.headerHtmlFile), (String)this.getInputEncoding());
                        headerHtml = this.addTitleToHtmlFile(headerHtml, dto.title);
                        headerHtml = this.replaceVariables(headerHtml, dto.substitutes);
                        headerHtml = this.updateRelativePaths(headerHtml, dto.folderDepth);
                    }
                    if (StringUtils.isNotEmpty((String)this.footerHtmlFile)) {
                        footerHtml = FileUtils.readFileToString((File)new File(this.footerHtmlFile), (String)this.getInputEncoding());
                        footerHtml = this.replaceVariables(footerHtml, dto.substitutes);
                        footerHtml = this.updateRelativePaths(footerHtml, dto.folderDepth);
                    }
                }
                catch (FileNotFoundException e) {
                    if (this.failIfFilesAreMissing) {
                        throw e;
                    }
                    this.getLog().warn((CharSequence)"header and/or footer file is missing.");
                    headerHtml = "";
                    footerHtml = "";
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Error while processing header/footer: " + e.getMessage(), e);
                }
                String markdown = FileUtils.readFileToString((File)dto.markdownFile, (String)this.getInputEncoding());
                markdown = this.replaceVariables(markdown, dto.substitutes);
                Document document = parser.parse(markdown);
                String markdownAsHtml = renderer.render((Node)document);
                String data = headerHtml + markdownAsHtml + footerHtml;
                FileUtils.writeStringToFile((File)dto.htmlFile, (String)data, (String)this.getOutputEncoding());
            }
            catch (MojoExecutionException e) {
                throw e;
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Error : " + e.getMessage()), (Throwable)e);
                throw new MojoExecutionException("Unable to write file " + e.getMessage(), (Exception)e);
            }
        }
    }

    private String getInputEncoding() {
        if (StringUtils.isBlank((String)this.inputEncoding)) {
            return Charset.defaultCharset().name();
        }
        return this.inputEncoding;
    }

    private String getOutputEncoding() {
        if (StringUtils.isBlank((String)this.outputEncoding)) {
            return Charset.defaultCharset().name();
        }
        return this.outputEncoding;
    }

    public String[] getInputFileExtensions() {
        return this.inputFileExtensions.trim().split("\\s*,\\s*");
    }

    public String[] getOutputFileExtensions() {
        return this.outputFileExtension.trim().split("\\s*,\\s*");
    }

    private String getTitle(List<String> raw) {
        if (raw == null) {
            return this.defaultTitle;
        }
        String previousLine = "";
        for (String line : raw) {
            if ((line = line.trim()).startsWith("#")) {
                line = line.replace("#", "");
                return line;
            }
            if (line.startsWith("=") && StringUtils.countMatches((String)line, (String)"=") == previousLine.length() && line.matches("^=+$") || line.startsWith("-") && StringUtils.countMatches((String)line, (String)"-") == previousLine.length() && line.matches("^-+$")) {
                return previousLine;
            }
            previousLine = line;
        }
        return this.defaultTitle;
    }

    private String addTitleToHtmlFile(String html, String title) {
        if (html == null) {
            return html;
        }
        if (title != null) {
            this.getLog().debug((CharSequence)("Setting the title in the HTML file to: " + title));
            return html.replaceFirst("titleToken", title);
        }
        this.getLog().debug((CharSequence)"Title was null, setting the title in the HTML file to an empty string");
        return html.replaceFirst("titleToken", "");
    }

    private String replaceVariables(String initialContent, Map<String, String> variables) {
        String newContent = initialContent;
        if (this.applyFiltering && newContent != null) {
            newContent = newContent.replaceAll("\\{\\w*=.*}", "");
            if (variables != null) {
                newContent = this.substituteVariables(newContent, "\\$\\{(.+?)\\}", variables);
            }
        }
        return newContent;
    }

    private static boolean isVariableLine(String line) {
        return line.matches("^\\{.*=.*\\}$");
    }

    private String updateRelativePaths(String html, int folderDepth) {
        if (html == null) {
            return html;
        }
        this.getLog().debug((CharSequence)"Updating relative paths in html includes (css, js).");
        return html.replaceAll("##SITE_BASE##", this.getSiteBasePrefix(folderDepth));
    }

    private String getSiteBasePrefix(int folderDepth) {
        String pathToBase = ".";
        while (folderDepth > 0) {
            pathToBase = pathToBase + "/..";
            --folderDepth;
        }
        return pathToBase;
    }

    private void copyFiles(String fromDir, String toDir) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("fromDir=" + fromDir + "; toDir=" + toDir));
        try {
            File fromDirFile = new File(fromDir);
            if (fromDirFile.exists()) {
                Iterator files = FileUtils.iterateFiles((File)new File(fromDir), null, (boolean)false);
                while (files.hasNext()) {
                    File file = (File)files.next();
                    if (file.exists()) {
                        FileUtils.copyFileToDirectory((File)file, (File)new File(toDir));
                        continue;
                    }
                    this.getLog().error((CharSequence)("File '" + file.getAbsolutePath() + "' does not exist. Skipping copy"));
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy file " + e.getMessage(), (Exception)e);
        }
    }

    private List<File> getFilesAsArray(Iterator<File> iterator) {
        ArrayList<File> files = new ArrayList<File>();
        while (iterator.hasNext()) {
            files.add(iterator.next());
        }
        return files;
    }

    public void contextualize(Context context) throws ContextException {
        this.plexusContainer = (PlexusContainer)context.get((Object)"plexus");
    }

    private void performMavenPropertyFiltering(File inputDirectory, File outputDirectory, String inputEncoding) throws MojoExecutionException {
        try {
            List<String> combinedFilters = this.getCombinedFiltersList();
            ArrayList<Resource> resources = new ArrayList<Resource>();
            Resource resource = new Resource();
            resource.setFiltering(true);
            resource.setDirectory(inputDirectory.getAbsolutePath());
            resources.add(resource);
            MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution(resources, outputDirectory, this.project, this.inputEncoding, combinedFilters, Collections.emptyList(), this.session);
            mavenResourcesExecution.setInjectProjectBuildFilters(false);
            mavenResourcesExecution.setOverwrite(true);
            mavenResourcesExecution.setAddDefaultExcludes(this.addDefaultExcludes);
            Properties additionalProperties = this.addSeveralSpecialProperties();
            mavenResourcesExecution.setAdditionalProperties(additionalProperties);
            if (this.nonFilteredFileExtensions != null) {
                mavenResourcesExecution.setNonFilteredFileExtensions(this.nonFilteredFileExtensions);
            }
            this.mavenResourcesFiltering.filterResources(mavenResourcesExecution);
            this.executeUserFilterComponents(mavenResourcesExecution);
            mavenResourcesExecution.getOutputDirectory();
        }
        catch (MavenFilteringException e) {
            throw new MojoExecutionException("Failure while processing/filtering markdown sources: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    private Properties addSeveralSpecialProperties() {
        String timeStamp = new MavenBuildTimestamp(new Date(), this.timestampFormat).formattedTimestamp();
        Properties additionalProperties = new Properties();
        additionalProperties.put("mdpagegenerator.timestamp", timeStamp);
        if (this.project.getBasedir() != null) {
            additionalProperties.put("project.baseUri", this.project.getBasedir().getAbsoluteFile().toURI().toString());
        }
        return additionalProperties;
    }

    protected void executeUserFilterComponents(MavenResourcesExecution mavenResourcesExecution) throws MojoExecutionException, MavenFilteringException {
        if (this.mavenFilteringHints != null) {
            for (String hint : this.mavenFilteringHints) {
                try {
                    this.mavenFilteringComponents.add((MavenResourcesFiltering)this.plexusContainer.lookup(MavenResourcesFiltering.class.getName(), hint));
                }
                catch (ComponentLookupException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
                }
            }
        } else {
            this.getLog().debug((CharSequence)"no use filter components");
        }
        if (this.mavenFilteringComponents != null && !this.mavenFilteringComponents.isEmpty()) {
            this.getLog().debug((CharSequence)"execute user filters");
            for (MavenResourcesFiltering filter : this.mavenFilteringComponents) {
                filter.filterResources(mavenResourcesExecution);
            }
        }
    }

    protected List<String> getCombinedFiltersList() {
        if (this.filters == null || this.filters.isEmpty()) {
            return this.useBuildFilters ? this.buildFilters : null;
        }
        ArrayList<String> result = new ArrayList<String>();
        if (this.useBuildFilters && this.buildFilters != null && !this.buildFilters.isEmpty()) {
            result.addAll(this.buildFilters);
        }
        result.addAll(this.filters);
        return result;
    }

    private class MarkdownDTO {
        String title;
        Map<String, String> substitutes = new HashMap<String, String>();
        File htmlFile;
        File markdownFile;
        int folderDepth = 0;

        private MarkdownDTO() {
        }
    }
}

