package com.s24.gs1;

import java.util.Arrays;

enum GtinFormat {

    GTIN_8(8),
    GTIN_12(12),
    GTIN_13(13),
    GTIN_14(14);

    private final int length;

    GtinFormat(int length) {
        this.length = length;
    }

    static boolean isValidLength(int length) {
        return Arrays.stream(values()).anyMatch(format -> format.length == length);
    }

    int getLength() {
        return length;
    }

}
