package com.s24.gs1;

/**
 * This class provides internal functions only and should not be used outside the library.
 */
class StringUtil {

    static String precedeWithZeros(String str, int intendedLength) {

        if (str == null) {
            throw new IllegalArgumentException("The string must not be null");
        }

        if (intendedLength < 1) {
            throw new IllegalArgumentException("The intended length must be greater than 0");
        }

        if (str.length() >= intendedLength) {
            return str;
        }

        StringBuilder sb = new StringBuilder(intendedLength);
        int zeroCount = str.length();
        while (zeroCount < intendedLength) {
            sb.append('0');
            zeroCount++;
        }

        sb.append(str);
        return sb.toString();

    }

    static boolean isBlank(CharSequence charSequence) {

        int length;

        if (charSequence == null || (length = charSequence.length()) == 0) {
            return true;
        }

        for (int charIndex = 0; charIndex < length; charIndex++) {
            if ((!Character.isWhitespace(charSequence.charAt(charIndex)))) {
                return false;
            }
        }

        return true;
    }

}
