/*
 * Decompiled with CFR 0.152.
 */
package com.s24.gs1;

import com.s24.gs1.GtinFormat;
import com.s24.gs1.StringUtil;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class GtinNormalizer {
    private static final Pattern NON_DIGITS = Pattern.compile("[^\\d]");
    private final int targetLength;

    public GtinNormalizer(int targetLength) {
        if (!GtinFormat.isValidLength(targetLength)) {
            String validLengths = Arrays.stream(GtinFormat.values()).map(GtinFormat::getLength).map(String::valueOf).collect(Collectors.joining(", "));
            throw new IllegalArgumentException(String.format("The target length must be one of %s", validLengths));
        }
        this.targetLength = targetLength;
    }

    public String normalize(CharSequence gtin) {
        if (StringUtil.isBlank(gtin)) {
            throw new IllegalArgumentException("GTIN must not be null or blank");
        }
        String onlyDigits = NON_DIGITS.matcher(gtin).replaceAll("");
        int length = onlyDigits.length();
        if (length > this.targetLength) {
            return onlyDigits.substring(length - this.targetLength);
        }
        if (length == this.targetLength) {
            return onlyDigits;
        }
        return StringUtil.precedeWithZeros(onlyDigits, this.targetLength);
    }
}

