/*
 * Decompiled with CFR 0.152.
 */
package com.s24.gs1;

import com.s24.gs1.GtinFormat;
import com.s24.gs1.StringUtil;

public class GtinValidator {
    private final CharSequence gtin;

    public GtinValidator(CharSequence gtin) {
        this.gtin = gtin;
    }

    public boolean validate() {
        if (StringUtil.isBlank(this.gtin)) {
            return false;
        }
        if (this.containsNonDigits()) {
            return false;
        }
        int length = this.gtin.length();
        if (!GtinFormat.isValidLength(length)) {
            return false;
        }
        int checksum = this.calculateChecksum();
        if (checksum == 0) {
            return false;
        }
        int checkDigit = (10 - checksum % 10) % 10;
        int lastDigit = this.getNumericValue(length - 1);
        return checkDigit == lastDigit;
    }

    private boolean containsNonDigits() {
        for (int charIndex = 0; charIndex < this.gtin.length(); ++charIndex) {
            if (Character.isDigit(this.gtin.charAt(charIndex))) continue;
            return true;
        }
        return false;
    }

    private int getNumericValue(int position) {
        char ch = this.gtin.charAt(position);
        return Character.getNumericValue(ch);
    }

    private int calculateChecksum() {
        int checksum = 0;
        int lastNonCheckDigitIndex = this.gtin.length() - 2;
        for (int charIndex = 0; charIndex < this.gtin.length() - 1; ++charIndex) {
            int charValue = this.getNumericValue(charIndex);
            int positionFromRight = lastNonCheckDigitIndex - charIndex;
            int weight = positionFromRight % 2 == 0 ? 3 : 1;
            checksum += charValue * weight;
        }
        return checksum;
    }
}

