/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.solon;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.noear.solon.core.AppContext;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.dao.LightDao;
import org.sagacity.sqltoy.dao.SqlToyLazyDao;
import org.sagacity.sqltoy.service.SqlToyCRUDService;
import org.sagacity.sqltoy.solon.dao.impl.LightDaoImpl;
import org.sagacity.sqltoy.solon.dao.impl.SqlToyLazyDaoImpl;
import org.sagacity.sqltoy.solon.service.impl.SqlToyCRUDServiceForSolon;

public class DbManager {
    private static Map<DataSource, SqlToyLazyDao> daoMap = new HashMap<DataSource, SqlToyLazyDao>();
    private static Map<DataSource, LightDao> lightDaoMap = new HashMap<DataSource, LightDao>();
    private static Map<DataSource, SqlToyCRUDService> serviceMap = new HashMap<DataSource, SqlToyCRUDService>();
    private static SqlToyContext context;

    public static void setContext(SqlToyContext context) {
        DbManager.context = context;
    }

    public static synchronized SqlToyLazyDao getDao(DataSource dataSource) {
        SqlToyLazyDao dao = daoMap.get(dataSource);
        if (dao == null) {
            SqlToyLazyDaoImpl sqlToyLazyDao = new SqlToyLazyDaoImpl();
            sqlToyLazyDao.setDataSource(dataSource);
            sqlToyLazyDao.setSqlToyContext(context);
            daoMap.put(dataSource, sqlToyLazyDao);
            dao = sqlToyLazyDao;
        }
        return dao;
    }

    public static synchronized LightDao getLightDao(DataSource dataSource) {
        LightDao dao = lightDaoMap.get(dataSource);
        if (dao == null) {
            LightDaoImpl sqlToyLazyDao = new LightDaoImpl();
            sqlToyLazyDao.setDataSource(dataSource);
            sqlToyLazyDao.setSqlToyContext(context);
            lightDaoMap.put(dataSource, sqlToyLazyDao);
            dao = sqlToyLazyDao;
        }
        return dao;
    }

    public static synchronized SqlToyCRUDService getService(AppContext context, DataSource dataSource) {
        SqlToyCRUDService service = serviceMap.get(dataSource);
        if (service == null) {
            SqlToyCRUDServiceForSolon crudService = (SqlToyCRUDServiceForSolon)context.beanMake(SqlToyCRUDServiceForSolon.class).get();
            crudService.setSqlToyLazyDao(DbManager.getDao(dataSource));
            serviceMap.put(dataSource, crudService);
            service = crudService;
        }
        return service;
    }

    public static Map<DataSource, SqlToyCRUDService> getServiceMap() {
        return serviceMap;
    }
}

