/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.solon.integration;

import com.mongodb.client.AggregateIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.integration.MongoQuery;

public class SolonMongoQuery
implements MongoQuery {
    private MongoDatabase db;

    public MongoCollection<Document> getCollection(String collectionName) {
        return this.db.getCollection(collectionName);
    }

    public <T> List<T> find(String query, Class<T> entityClass, String collectionName, Long skip, Integer limit) {
        MongoCollection<Document> collection = this.getCollection(collectionName);
        FindIterable findIterable = collection.find((Bson)BsonDocument.parse((String)query), entityClass);
        if (skip != null) {
            findIterable.skip(skip.intValue());
        }
        if (limit != null) {
            findIterable.limit(limit.intValue());
        }
        MongoCursor cur = findIterable.iterator();
        ArrayList<Object> data = new ArrayList<Object>();
        while (cur.hasNext()) {
            data.add(cur.next());
        }
        cur.close();
        return data;
    }

    public long count(String query, String collectionName) {
        MongoCollection<Document> collection = this.getCollection(collectionName);
        Document sum = new Document();
        sum.put("$sum", (Object)1);
        Document count = new Document();
        count.put("_id", null);
        count.put("count", (Object)sum);
        Document group = new Document();
        group.put("$group", (Object)count);
        ArrayList<Document> list = new ArrayList<Document>();
        list.add(group);
        AggregateIterable iterable = collection.aggregate(list);
        MongoCursor cursor = iterable.iterator();
        if (cursor.hasNext()) {
            Document docu = (Document)cursor.next();
            return (Long)docu.get((Object)"count");
        }
        return 0L;
    }

    public void initialize(SqlToyContext sqlToyContext) {
        this.db = (MongoDatabase)sqlToyContext.getAppContext().getBean(MongoDatabase.class);
    }
}

