/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.solon.integration;

import java.util.ArrayList;
import org.noear.solon.core.util.ClassUtil;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.config.model.ElasticEndpoint;
import org.sagacity.sqltoy.integration.AppContext;
import org.sagacity.sqltoy.integration.ConnectionFactory;
import org.sagacity.sqltoy.model.IgnoreKeyCaseMap;
import org.sagacity.sqltoy.plugins.FilterHandler;
import org.sagacity.sqltoy.plugins.FirstBizCodeTrace;
import org.sagacity.sqltoy.plugins.IUnifyFieldsHandler;
import org.sagacity.sqltoy.plugins.OverTimeSqlHandler;
import org.sagacity.sqltoy.plugins.SqlInterceptor;
import org.sagacity.sqltoy.plugins.TypeHandler;
import org.sagacity.sqltoy.plugins.datasource.DataSourceSelector;
import org.sagacity.sqltoy.plugins.ddl.DialectDDLGenerator;
import org.sagacity.sqltoy.plugins.formater.SqlFormater;
import org.sagacity.sqltoy.plugins.secure.DesensitizeProvider;
import org.sagacity.sqltoy.plugins.secure.FieldsSecureProvider;
import org.sagacity.sqltoy.solon.configure.Elastic;
import org.sagacity.sqltoy.solon.configure.ElasticConfig;
import org.sagacity.sqltoy.solon.configure.SqlToyContextProperties;
import org.sagacity.sqltoy.solon.configure.SqlToyContextTaskPoolProperties;
import org.sagacity.sqltoy.solon.integration.SolonConnectionFactory;
import org.sagacity.sqltoy.translate.DynamicCacheFetch;
import org.sagacity.sqltoy.translate.cache.TranslateCacheManager;
import org.sagacity.sqltoy.utils.StringUtil;

public class SqlToyContextBuilder {
    SqlToyContextProperties properties;
    AppContext appContext;

    public SqlToyContextBuilder(SqlToyContextProperties properties, AppContext appContext) {
        this.properties = properties;
        this.appContext = appContext;
    }

    public SqlToyContext build() throws Exception {
        String taskExecutorName;
        SqlToyContextTaskPoolProperties taskPoolProperties;
        String sqlFormater;
        String[] sqlInterceptors;
        String dynamicCacheFetch;
        String dialectDDLGenerator;
        String overTimeSqlHandler;
        String customFilterHandler;
        String desensitizeProvider;
        String fieldsSecureProvider;
        String connectionFactory;
        String dataSourceSelector;
        String typeHandler;
        String firstBizCodeTrace;
        String translateCacheManager;
        Elastic es;
        String unfiyHandler;
        if (StringUtil.isBlank((Object)this.properties.getSqlResourcesDir())) {
            this.properties.setSqlResourcesDir("classpath:sqltoy");
        }
        SqlToyContext sqlToyContext = new SqlToyContext();
        sqlToyContext.setAppContext(this.appContext);
        sqlToyContext.setConnectionFactory((ConnectionFactory)new SolonConnectionFactory());
        sqlToyContext.setDistributeIdGeneratorClass("org.noear.solon.extend.sqltoy.impl.SolonRedisIdGenerator");
        sqlToyContext.setTranslateCaffeineManagerClass("org.noear.solon.extend.sqltoy.translate.SolonTranslateCacheManager");
        sqlToyContext.setMongoQueryClass("org.noear.solon.extend.sqltoy.impl.SolonMongoQuery");
        sqlToyContext.setBreakWhenSqlRepeat(this.properties.isBreakWhenSqlRepeat());
        sqlToyContext.setAutoDDL(this.properties.getAutoDDL());
        sqlToyContext.setDefaultPageSize(this.properties.getDefaultPageSize());
        sqlToyContext.setDefaultPageOffset(this.properties.isDefaultPageOffset());
        sqlToyContext.setDialectMap(this.properties.getDialectMap());
        sqlToyContext.setLocalDateTimeFormat(this.properties.getLocalDateTimeFormat());
        sqlToyContext.setLocalTimeFormat(this.properties.getLocalTimeFormat());
        if (this.properties.getHumpMapResultTypeLabel() != null) {
            sqlToyContext.setHumpMapResultTypeLabel(this.properties.getHumpMapResultTypeLabel().booleanValue());
        }
        sqlToyContext.setSqlResourcesDir(this.properties.getSqlResourcesDir());
        if (this.properties.getSqlResources() != null && this.properties.getSqlResources().length > 0) {
            ArrayList<String> resList = new ArrayList<String>();
            for (String prop : this.properties.getSqlResources()) {
                resList.add(prop);
            }
            sqlToyContext.setSqlResources(resList);
        }
        if (this.properties.getEncoding() != null) {
            sqlToyContext.setEncoding(this.properties.getEncoding());
        }
        if (this.properties.getPackagesToScan() != null) {
            sqlToyContext.setPackagesToScan(this.properties.getPackagesToScan());
        }
        if (this.properties.getAnnotatedClasses() != null) {
            sqlToyContext.setAnnotatedClasses(this.properties.getAnnotatedClasses());
        }
        if (this.properties.getBatchSize() != null) {
            sqlToyContext.setBatchSize(this.properties.getBatchSize().intValue());
        }
        if (this.properties.getFetchSize() > 0) {
            sqlToyContext.setFetchSize(this.properties.getFetchSize());
        }
        if (this.properties.getPageFetchSizeLimit() != null) {
            sqlToyContext.setPageFetchSizeLimit(this.properties.getPageFetchSizeLimit().intValue());
        }
        if (this.properties.getScriptCheckIntervalSeconds() != null) {
            sqlToyContext.setScriptCheckIntervalSeconds(this.properties.getScriptCheckIntervalSeconds().intValue());
        }
        if (this.properties.getDelayCheckSeconds() != null) {
            sqlToyContext.setDelayCheckSeconds(this.properties.getDelayCheckSeconds().intValue());
        }
        if (this.properties.getDebug() != null) {
            sqlToyContext.setDebug(this.properties.getDebug().booleanValue());
        }
        if (this.properties.getPrintSqlTimeoutMillis() != null) {
            sqlToyContext.setPrintSqlTimeoutMillis(this.properties.getPrintSqlTimeoutMillis().intValue());
        }
        if (this.properties.getFunctionConverts() != null) {
            sqlToyContext.setFunctionConverts(this.properties.getFunctionConverts());
        }
        if (this.properties.getTranslateConfig() != null) {
            sqlToyContext.setTranslateConfig(this.properties.getTranslateConfig());
        }
        if (this.properties.getReservedWords() != null) {
            sqlToyContext.setReservedWords(this.properties.getReservedWords());
        }
        if (this.properties.getRedoDataSources() != null) {
            sqlToyContext.setRedoDataSources(this.properties.getRedoDataSources());
        }
        sqlToyContext.setDialect(this.properties.getDialect());
        sqlToyContext.setDialectConfig(this.properties.getDialectConfig());
        sqlToyContext.setCacheType(this.properties.getCacheType());
        sqlToyContext.setExecuteSqlBlankToNull(this.properties.isExecuteSqlBlankToNull());
        sqlToyContext.setSplitMergeInto(this.properties.isSplitMergeInto());
        if (null != this.properties.getColumnLabelUpperOrLower()) {
            sqlToyContext.setColumnLabelUpperOrLower(this.properties.getColumnLabelUpperOrLower().toLowerCase());
        }
        sqlToyContext.setSecurePrivateKey(this.properties.getSecurePrivateKey());
        sqlToyContext.setSecurePublicKey(this.properties.getSecurePublicKey());
        sqlToyContext.setUpdateTipCount(this.properties.getUpdateTipCount());
        if (this.properties.getOverPageToFirst() != null) {
            sqlToyContext.setOverPageToFirst(this.properties.getOverPageToFirst());
        }
        if (this.properties.getDialectReturnPrimaryColumnCase() != null) {
            sqlToyContext.setDialectReturnPrimaryColumnCase(new IgnoreKeyCaseMap(this.properties.getDialectReturnPrimaryColumnCase()));
        }
        if (StringUtil.isNotBlank((Object)(unfiyHandler = this.properties.getUnifyFieldsHandler()))) {
            try {
                IUnifyFieldsHandler handler = null;
                if (unfiyHandler.contains(".")) {
                    handler = (IUnifyFieldsHandler)ClassUtil.newInstance(Class.forName(unfiyHandler));
                } else if (this.appContext.containsBean(unfiyHandler) && (handler = (IUnifyFieldsHandler)this.appContext.getBean(unfiyHandler)) == null) {
                    throw new ClassNotFoundException("\u9879\u76ee\u4e2d\u672a\u5b9a\u4e49unifyFieldsHandler=" + unfiyHandler + " \u5bf9\u5e94\u7684bean!");
                }
                if (handler != null) {
                    sqlToyContext.setUnifyFieldsHandler(handler);
                }
            }
            catch (ClassNotFoundException cne) {
                System.err.println("------------------- \u9519\u8bef\u63d0\u793a ------------------------------------------- ");
                System.err.println("spring.sqltoy.unifyFieldsHandler=" + unfiyHandler + " \u5bf9\u5e94\u7c7b\u4e0d\u5b58\u5728,\u9519\u8bef\u539f\u56e0:");
                System.err.println("--1.\u60a8\u53ef\u80fd\u76f4\u63a5copy\u4e86\u53c2\u7167\u9879\u76ee\u7684\u914d\u7f6e\u6587\u4ef6,\u4f46\u6ca1\u6709\u5c06\u5177\u4f53\u7684\u7c7b\u4e5f\u540c\u6b65copy\u8fc7\u6765!");
                System.err.println("--2.\u5982\u60a8\u5e76\u4e0d\u9700\u8981\u6b64\u529f\u80fd\uff0c\u8bf7\u5c06\u914d\u7f6e\u6587\u4ef6\u4e2d\u6ce8\u91ca\u6389spring.sqltoy.unifyFieldsHandler");
                System.err.println("------------------------------------------------");
                cne.printStackTrace();
                throw cne;
            }
        }
        if ((es = this.properties.getElastic()) != null && es.getEndpoints() != null && !es.getEndpoints().isEmpty()) {
            sqlToyContext.setDefaultElastic(es.getDefaultId());
            ArrayList<ElasticEndpoint> endpoints = new ArrayList<ElasticEndpoint>();
            for (ElasticConfig esconfig : es.getEndpoints()) {
                ElasticEndpoint ep = new ElasticEndpoint(esconfig.getUrl(), esconfig.getSqlPath());
                ep.setId(esconfig.getId());
                if (esconfig.getCharset() != null) {
                    ep.setCharset(esconfig.getCharset());
                }
                if (esconfig.getRequestTimeout() != null) {
                    ep.setRequestTimeout(esconfig.getRequestTimeout().intValue());
                }
                if (esconfig.getConnectTimeout() != null) {
                    ep.setConnectTimeout(esconfig.getConnectTimeout().intValue());
                }
                if (esconfig.getSocketTimeout() != null) {
                    ep.setSocketTimeout(esconfig.getSocketTimeout().intValue());
                }
                ep.setAuthCaching(esconfig.isAuthCaching());
                ep.setUsername(esconfig.getUsername());
                ep.setPassword(esconfig.getPassword());
                ep.setKeyStore(esconfig.getKeyStore());
                ep.setKeyStorePass(esconfig.getKeyStorePass());
                ep.setKeyStoreSelfSign(esconfig.isKeyStoreSelfSign());
                ep.setKeyStoreType(esconfig.getKeyStoreType());
                endpoints.add(ep);
            }
            sqlToyContext.setElasticEndpoints(endpoints);
        }
        if (this.properties.getDefaultDataSource() != null) {
            sqlToyContext.setDefaultDataSourceName(this.properties.getDefaultDataSource());
        }
        if (StringUtil.isNotBlank((Object)(translateCacheManager = this.properties.getTranslateCacheManager()))) {
            if (this.appContext.containsBean(translateCacheManager)) {
                sqlToyContext.setTranslateCacheManager((TranslateCacheManager)this.appContext.getBean(translateCacheManager));
            } else if (translateCacheManager.contains(".")) {
                sqlToyContext.setTranslateCacheManager((TranslateCacheManager)ClassUtil.tryInstance((String)translateCacheManager));
            }
        }
        if (StringUtil.isNotBlank((Object)(firstBizCodeTrace = this.properties.getFirstBizCodeTrace()))) {
            if (this.appContext.containsBean(firstBizCodeTrace)) {
                sqlToyContext.setFirstBizCodeTrace((FirstBizCodeTrace)this.appContext.getBean(firstBizCodeTrace));
            } else if (firstBizCodeTrace.contains(".")) {
                sqlToyContext.setFirstBizCodeTrace((FirstBizCodeTrace)Class.forName(firstBizCodeTrace).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        if (StringUtil.isNotBlank((Object)(typeHandler = this.properties.getTypeHandler()))) {
            if (this.appContext.containsBean(typeHandler)) {
                sqlToyContext.setTypeHandler((TypeHandler)this.appContext.getBean(typeHandler));
            } else if (typeHandler.contains(".")) {
                sqlToyContext.setTypeHandler((TypeHandler)ClassUtil.tryInstance((String)typeHandler));
            }
        }
        if (StringUtil.isNotBlank((Object)(dataSourceSelector = this.properties.getDataSourceSelector()))) {
            if (this.appContext.containsBean(dataSourceSelector)) {
                sqlToyContext.setDataSourceSelector((DataSourceSelector)this.appContext.getBean(dataSourceSelector));
            } else if (dataSourceSelector.contains(".")) {
                sqlToyContext.setDataSourceSelector((DataSourceSelector)ClassUtil.tryInstance((String)dataSourceSelector));
            }
        }
        if (StringUtil.isNotBlank((Object)(connectionFactory = this.properties.getConnectionFactory()))) {
            if (this.appContext.containsBean(connectionFactory)) {
                sqlToyContext.setConnectionFactory((ConnectionFactory)this.appContext.getBean(connectionFactory));
            } else if (connectionFactory.contains(".")) {
                sqlToyContext.setConnectionFactory((ConnectionFactory)ClassUtil.tryInstance((String)connectionFactory));
            }
        }
        if (StringUtil.isNotBlank((Object)(fieldsSecureProvider = this.properties.getFieldsSecureProvider()))) {
            if (this.appContext.containsBean(fieldsSecureProvider)) {
                sqlToyContext.setFieldsSecureProvider((FieldsSecureProvider)this.appContext.getBean(fieldsSecureProvider));
            } else if (fieldsSecureProvider.contains(".")) {
                sqlToyContext.setFieldsSecureProvider((FieldsSecureProvider)ClassUtil.tryInstance((String)fieldsSecureProvider));
            }
        }
        if (StringUtil.isNotBlank((Object)(desensitizeProvider = this.properties.getDesensitizeProvider()))) {
            if (this.appContext.containsBean(desensitizeProvider)) {
                sqlToyContext.setDesensitizeProvider((DesensitizeProvider)this.appContext.getBean(desensitizeProvider));
            } else if (desensitizeProvider.contains(".")) {
                sqlToyContext.setDesensitizeProvider((DesensitizeProvider)ClassUtil.tryInstance((String)desensitizeProvider));
            }
        }
        if (StringUtil.isNotBlank((Object)(customFilterHandler = this.properties.getCustomFilterHandler()))) {
            if (this.appContext.containsBean(customFilterHandler)) {
                sqlToyContext.setCustomFilterHandler((FilterHandler)this.appContext.getBean(customFilterHandler));
            } else if (customFilterHandler.contains(".")) {
                sqlToyContext.setCustomFilterHandler((FilterHandler)ClassUtil.tryInstance((String)customFilterHandler));
            }
        }
        if (StringUtil.isNotBlank((Object)(overTimeSqlHandler = this.properties.getOverTimeSqlHandler()))) {
            if (this.appContext.containsBean(overTimeSqlHandler)) {
                sqlToyContext.setOverTimeSqlHandler((OverTimeSqlHandler)this.appContext.getBean(overTimeSqlHandler));
            } else if (overTimeSqlHandler.contains(".")) {
                sqlToyContext.setOverTimeSqlHandler((OverTimeSqlHandler)ClassUtil.tryInstance((String)overTimeSqlHandler));
            }
        }
        if (StringUtil.isNotBlank((Object)(dialectDDLGenerator = this.properties.getDialectDDLGenerator()))) {
            if (this.appContext.containsBean(dialectDDLGenerator)) {
                sqlToyContext.setDialectDDLGenerator((DialectDDLGenerator)this.appContext.getBean(dialectDDLGenerator));
            } else if (dialectDDLGenerator.contains(".")) {
                sqlToyContext.setDialectDDLGenerator((DialectDDLGenerator)Class.forName(dialectDDLGenerator).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        if (StringUtil.isNotBlank((Object)(dynamicCacheFetch = this.properties.getDynamicCacheFetch()))) {
            if (this.appContext.containsBean(dynamicCacheFetch)) {
                sqlToyContext.setDynamicCacheFetch((DynamicCacheFetch)this.appContext.getBean(dynamicCacheFetch));
            } else if (dynamicCacheFetch.contains(".")) {
                sqlToyContext.setDynamicCacheFetch((DynamicCacheFetch)Class.forName(dynamicCacheFetch).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        if (null != (sqlInterceptors = this.properties.getSqlInterceptors()) && sqlInterceptors.length > 0) {
            ArrayList<SqlInterceptor> sqlInterceptorList = new ArrayList<SqlInterceptor>();
            for (String interceptor : sqlInterceptors) {
                if (this.appContext.containsBean(interceptor)) {
                    sqlInterceptorList.add((SqlInterceptor)this.appContext.getBean(interceptor));
                    continue;
                }
                if (!interceptor.contains(".")) continue;
                sqlInterceptorList.add((SqlInterceptor)Class.forName(interceptor).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            sqlToyContext.setSqlInterceptors(sqlInterceptorList);
        }
        if (StringUtil.isNotBlank((Object)(sqlFormater = this.properties.getSqlFormater()))) {
            if (sqlFormater.equalsIgnoreCase("default") || sqlFormater.equalsIgnoreCase("defaultFormater") || sqlFormater.equalsIgnoreCase("defaultSqlFormater")) {
                sqlFormater = "org.sagacity.sqltoy.plugins.formater.impl.DefaultSqlFormater";
            }
            if (this.appContext.containsBean(sqlFormater)) {
                sqlToyContext.setSqlFormater((SqlFormater)this.appContext.getBean(sqlFormater));
            } else if (sqlFormater.contains(".")) {
                sqlToyContext.setSqlFormater((SqlFormater)Class.forName(sqlFormater).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        if ((taskPoolProperties = this.properties.getTaskExecutor()) != null && StringUtil.isNotBlank((Object)(taskExecutorName = taskPoolProperties.getTargetPoolName()))) {
            sqlToyContext.setTaskExecutorName(taskExecutorName);
        }
        return sqlToyContext;
    }
}

