/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy;

import com.alibaba.ttl.TransmittableThreadLocal;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sagacity.sqltoy.config.model.SqlExecuteLog;
import org.sagacity.sqltoy.config.model.SqlExecuteTrace;
import org.sagacity.sqltoy.model.OperateDetailType;
import org.sagacity.sqltoy.model.OverTimeSql;
import org.sagacity.sqltoy.plugins.FirstBizCodeTrace;
import org.sagacity.sqltoy.plugins.OverTimeSqlHandler;
import org.sagacity.sqltoy.plugins.formater.SqlFormater;
import org.sagacity.sqltoy.utils.SqlUtil;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlExecuteStat {
    private static final Logger logger = LoggerFactory.getLogger(SqlExecuteStat.class);
    private static boolean debug = false;
    private static int printSqlTimeoutMillis = 18000;
    private static final Pattern ARG_PATTERN = Pattern.compile("\\W\\?\\W");
    private static ThreadLocal<SqlExecuteTrace> threadLocal = new TransmittableThreadLocal();
    public static OverTimeSqlHandler overTimeSqlHandler;
    public static FirstBizCodeTrace firstBizCodeTrace;
    private static SqlFormater sqlFormater;

    public static void start(String sqlId, OperateDetailType type, Boolean debugPrint) {
        threadLocal.set(new SqlExecuteTrace(sqlId, type, debugPrint == null ? debug : debugPrint));
    }

    public static void start(String sqlId, OperateDetailType type, Long batchSize, Boolean debugPrint) {
        SqlExecuteTrace sqlExecuteTrace = new SqlExecuteTrace(sqlId, type, debugPrint == null ? debug : debugPrint);
        sqlExecuteTrace.setBatchSize(batchSize);
        threadLocal.set(sqlExecuteTrace);
    }

    public static void error(Exception exception) {
        if (threadLocal.get() != null) {
            threadLocal.get().setError(exception.getMessage());
        }
    }

    public static void showSql(String topic, String sql, Object[] paramValues) {
        try {
            if (threadLocal.get() != null) {
                threadLocal.get().addSqlLog(topic, sql, paramValues);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setDialect(String dialect) {
        if (threadLocal.get() != null) {
            threadLocal.get().setDialect(dialect);
        }
    }

    public static void debug(String topic, String message, Object ... args) {
        try {
            if (threadLocal.get() != null) {
                threadLocal.get().addLog(topic, message, args);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void destroyLog() {
        try {
            SqlExecuteTrace sqlTrace = threadLocal.get();
            if (sqlTrace == null) {
                return;
            }
            long runTime = sqlTrace.getExecuteTime();
            long overTime = runTime - (long)printSqlTimeoutMillis;
            if (overTime >= 0L) {
                sqlTrace.setOverTime(true);
                sqlTrace.addLog("slowSql\u6267\u884c\u8d85\u65f6", "\u8017\u65f6(\u6beb\u79d2):{} >={} (\u9600\u503c)!", runTime, printSqlTimeoutMillis);
            } else {
                sqlTrace.addLog("\u6267\u884c\u603b\u65f6\u957f", "\u8017\u65f6:{} \u6beb\u79d2 !", runTime);
            }
            SqlExecuteStat.printLogs(sqlTrace);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void printLogs(SqlExecuteTrace sqlTrace) {
        boolean errorLog = false;
        String reportStatus = "\u6210\u529f!";
        if (sqlTrace.isOverTime()) {
            errorLog = true;
            reportStatus = "\u6267\u884c\u8017\u65f6\u8d85\u9600\u503c!";
        }
        if (sqlTrace.isError()) {
            errorLog = true;
            reportStatus = "\u53d1\u751f\u5f02\u5e38\u9519\u8bef!";
        }
        if (!errorLog && !sqlTrace.isPrint()) {
            return;
        }
        String uid = sqlTrace.getUid();
        StringBuilder result = new StringBuilder();
        String optType = sqlTrace.getType() + (sqlTrace.getBatchSize() != null ? "[" + sqlTrace.getBatchSize() + "\u6761\u8bb0\u5f55]" : "");
        String codeTrace = SqlExecuteStat.getFirstTrace();
        result.append("\n/*|----------------------\u5f00\u59cb\u6267\u884c\u62a5\u544a\u8f93\u51fa --------------------------------------------------*/");
        result.append("\n/*|\u4efb \u52a1 ID: " + uid);
        result.append("\n/*|\u6267\u884c\u7ed3\u679c: " + reportStatus);
        result.append("\n/*|\u6570\u636e\u65b9\u8a00: " + sqlTrace.getDialect());
        result.append("\n/*|\u6267\u884c\u7c7b\u578b: " + optType);
        result.append("\n/*|\u4ee3\u7801\u5b9a\u4f4d: " + codeTrace);
        if (sqlTrace.getId() != null) {
            result.append("\n/*|\u5bf9\u5e94sqlId: " + sqlTrace.getId());
        }
        List<SqlExecuteLog> executeLogs = sqlTrace.getExecuteLogs();
        int step = 0;
        Object[] args = null;
        String sql = null;
        for (SqlExecuteLog log : executeLogs) {
            ++step;
            int logType = log.getType();
            String topic = log.getTopic();
            String content = log.getContent();
            args = log.getArgs();
            if (logType == 0) {
                result.append("\n/*|---- \u8fc7\u7a0b: " + step + "," + topic + "----------------");
                if (optType.startsWith("save") || optType.startsWith("deleteAll") || optType.startsWith("batchUpdate")) {
                    result.append("\n/*|     \u5185\u90e8sql: ").append(SqlExecuteStat.fitSqlParams(content, args));
                    result.append("\n/*|     save(All)|saveOrUpdate(All)|deleleAll|batchUpdate\u7b49\u4e0d\u8f93\u51fasql\u6267\u884c\u53c2\u6570");
                    continue;
                }
                sql = SqlExecuteStat.fitSqlParams(content, args);
                if (sqlFormater != null) {
                    sql = sqlFormater.format(sql, sqlTrace.getDialect());
                    result.append("\n/*|     \u6a21\u62df\u5165\u53c2\u540esql:\n").append(sql);
                } else {
                    result.append("\n/*|     \u6a21\u62df\u5165\u53c2\u540esql:").append(sql);
                }
                result.append("\n/*|     sql\u53c2\u6570: ");
                if (args != null && args.length > 0) {
                    StringBuilder paramStr = new StringBuilder();
                    for (int i = 0; i < args.length; ++i) {
                        if (i > 0) {
                            paramStr.append(",");
                        }
                        paramStr.append("p[" + i + "]=" + args[i]);
                    }
                    result.append((CharSequence)paramStr);
                    continue;
                }
                result.append("\u65e0\u53c2\u6570");
                continue;
            }
            result.append("\n/*|---- \u8fc7\u7a0b: " + step + "," + (null == topic ? "" : topic) + (null == content ? "" : ":" + StringUtil.fillArgs(content, args)));
        }
        result.append("\n/*|----------------------\u5b8c\u6210\u6267\u884c\u62a5\u544a\u8f93\u51fa --------------------------------------------------*/");
        result.append("\n");
        if (sqlTrace.isError()) {
            logger.error(result.toString());
        } else if (sqlTrace.isOverTime()) {
            logger.warn(result.toString());
            if (overTimeSqlHandler != null) {
                overTimeSqlHandler.log(new OverTimeSql(sqlTrace.getId(), sql, sqlTrace.getExecuteTime(), codeTrace));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug(result.toString());
        } else {
            System.out.println(result.toString());
        }
    }

    public static void destroy() {
        SqlExecuteStat.destroyLog();
        threadLocal.remove();
        threadLocal.set(null);
    }

    public static void setDebug(boolean debug) {
        SqlExecuteStat.debug = debug;
    }

    public static void setOverTimeSqlHandler(OverTimeSqlHandler overTimeSqlHandler) {
        SqlExecuteStat.overTimeSqlHandler = overTimeSqlHandler;
    }

    public static void setPrintSqlTimeoutMillis(int printSqlTimeoutMillis) {
        SqlExecuteStat.printSqlTimeoutMillis = printSqlTimeoutMillis;
    }

    public static void setSqlFormater(SqlFormater sqlFormater) {
        SqlExecuteStat.sqlFormater = sqlFormater;
    }

    private static String fitSqlParams(String sql, Object[] params) {
        if (sql == null || params == null || params.length == 0) {
            return sql;
        }
        StringBuilder lastSql = new StringBuilder();
        Matcher matcher = ARG_PATTERN.matcher(sql.concat(" "));
        int start = 0;
        int index = 0;
        int paramSize = params.length;
        while (matcher.find(start)) {
            lastSql.append(sql.substring(start, matcher.start() + 1));
            if (index >= paramSize) {
                return sql;
            }
            lastSql.append(SqlUtil.toSqlString(params[index], true));
            start = matcher.end() - 1;
            ++index;
        }
        lastSql.append(sql.substring(start));
        return lastSql.toString();
    }

    public static String getFirstTrace() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        if (stackTraceElements == null || stackTraceElements.length == 0) {
            return "\u672a\u77e5\u7c7b.\u672a\u77e5\u65b9\u6cd5[\u4ee3\u7801\u7b2c:null\u884c]";
        }
        StackTraceElement traceElement = null;
        String className = null;
        if (firstBizCodeTrace != null) {
            traceElement = firstBizCodeTrace.getFirstTrace(stackTraceElements);
        } else {
            int length = stackTraceElements.length;
            for (int i = length - 1; i > 0; --i) {
                traceElement = stackTraceElements[i];
                className = traceElement.getClassName();
                if (!className.startsWith("org.sagacity.sqltoy")) continue;
                if (i + 1 >= length) break;
                traceElement = stackTraceElements[i + 1];
                className = traceElement.getClassName();
                int nextIndex = 2;
                while (i + nextIndex < length && (Proxy.isProxyClass(traceElement.getClass()) || className.startsWith("java.") || className.startsWith("sun.") || className.startsWith("com.sun.") || className.startsWith("org.springframework.") || className.startsWith("org.noear.solon."))) {
                    traceElement = stackTraceElements[i + nextIndex];
                    className = traceElement.getClassName();
                    ++nextIndex;
                }
                break;
            }
        }
        return traceElement.getClassName() + "." + traceElement.getMethodName() + "[\u4ee3\u7801\u7b2c:" + traceElement.getLineNumber() + " \u884c]";
    }

    public static Long getExecuteTime() {
        SqlExecuteTrace sqlTrace = threadLocal.get();
        if (sqlTrace != null) {
            return sqlTrace.getExecuteTime();
        }
        return -1L;
    }

    public static SqlExecuteTrace get() {
        return threadLocal.get();
    }

    public static void set(SqlExecuteTrace sqlTrace) {
        threadLocal.set(sqlTrace);
    }
}

