/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy;

import com.alibaba.ttl.threadpool.TtlExecutors;
import java.sql.Connection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import javax.sql.DataSource;
import org.sagacity.sqltoy.SqlExecuteStat;
import org.sagacity.sqltoy.SqlToyConstants;
import org.sagacity.sqltoy.config.EntityManager;
import org.sagacity.sqltoy.config.SqlConfigParseUtils;
import org.sagacity.sqltoy.config.SqlScriptLoader;
import org.sagacity.sqltoy.config.model.ElasticEndpoint;
import org.sagacity.sqltoy.config.model.EntityMeta;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.config.model.SqlType;
import org.sagacity.sqltoy.integration.AppContext;
import org.sagacity.sqltoy.integration.ConnectionFactory;
import org.sagacity.sqltoy.integration.impl.SimpleConnectionFactory;
import org.sagacity.sqltoy.model.IgnoreKeyCaseMap;
import org.sagacity.sqltoy.model.OverTimeSql;
import org.sagacity.sqltoy.model.QueryExecutor;
import org.sagacity.sqltoy.plugins.FilterHandler;
import org.sagacity.sqltoy.plugins.FirstBizCodeTrace;
import org.sagacity.sqltoy.plugins.IUnifyFieldsHandler;
import org.sagacity.sqltoy.plugins.OverTimeSqlHandler;
import org.sagacity.sqltoy.plugins.SqlInterceptor;
import org.sagacity.sqltoy.plugins.TypeHandler;
import org.sagacity.sqltoy.plugins.datasource.DataSourceSelector;
import org.sagacity.sqltoy.plugins.datasource.impl.DefaultDataSourceSelector;
import org.sagacity.sqltoy.plugins.ddl.DDLFactory;
import org.sagacity.sqltoy.plugins.ddl.DialectDDLGenerator;
import org.sagacity.sqltoy.plugins.formater.SqlFormater;
import org.sagacity.sqltoy.plugins.function.FunctionUtils;
import org.sagacity.sqltoy.plugins.overtime.DefaultOverTimeHandler;
import org.sagacity.sqltoy.plugins.secure.DesensitizeProvider;
import org.sagacity.sqltoy.plugins.secure.FieldsSecureProvider;
import org.sagacity.sqltoy.plugins.secure.impl.DesensitizeDefaultProvider;
import org.sagacity.sqltoy.plugins.secure.impl.FieldsRSASecureProvider;
import org.sagacity.sqltoy.plugins.sharding.ShardingStrategy;
import org.sagacity.sqltoy.translate.DynamicCacheFetch;
import org.sagacity.sqltoy.translate.TranslateManager;
import org.sagacity.sqltoy.translate.cache.TranslateCacheManager;
import org.sagacity.sqltoy.utils.BeanUtil;
import org.sagacity.sqltoy.utils.DataSourceUtils;
import org.sagacity.sqltoy.utils.QueryExecutorBuilder;
import org.sagacity.sqltoy.utils.ReservedWordsUtil;
import org.sagacity.sqltoy.utils.SqlUtil;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlToyContext {
    protected final Logger logger = LoggerFactory.getLogger(SqlToyContext.class);
    private SqlScriptLoader scriptLoader = new SqlScriptLoader();
    private EntityManager entityManager = new EntityManager();
    private TranslateManager translateManager = new TranslateManager();
    private int delayCheckSeconds = 30;
    private int fetchSize = -1;
    private IUnifyFieldsHandler unifyFieldsHandler;
    private TranslateCacheManager translateCacheManager;
    private FilterHandler customFilterHandler;
    private boolean humpMapResultTypeLabel = true;
    private Boolean overPageToFirst;
    private boolean defaultPageOffset = true;
    private OverTimeSqlHandler overTimeSqlHandler = new DefaultOverTimeHandler();
    private HashMap<String, ShardingStrategy> shardingStrategys = new HashMap();
    private HashMap<String, ElasticEndpoint> elasticEndpoints = new HashMap();
    private IgnoreKeyCaseMap<String, String> dialectReturnPrimaryColumnCase = new IgnoreKeyCaseMap();
    private String defaultElastic = "default";
    private String cacheType = "ehcache";
    private String defaultDataSourceName;
    private int batchSize = 200;
    private int pageFetchSizeLimit = 100000;
    private boolean debug = false;
    private int printSqlTimeoutMillis = 30000;
    private int updateTipCount = 2000;
    private String columnLabelUpperOrLower = "default";
    private String dialect;
    private Integer workerId;
    private Integer dataCenterId;
    private Integer serverId;
    private DataSource defaultDataSource;
    private Integer scriptCheckIntervalSeconds;
    private TypeHandler typeHandler;
    private DataSourceSelector dataSourceSelector = new DefaultDataSourceSelector();
    private ConnectionFactory connectionFactory;
    private String translateCaffeineManagerClass = "org.sagacity.sqltoy.translate.cache.impl.TranslateCaffeineManager";
    private String mongoQueryClass = "org.sagacity.sqltoy.integration.impl.SpringMongoQuery";
    private String distributeIdGeneratorClass = "org.sagacity.sqltoy.integration.impl.SpringRedisIdGenerator";
    private AppContext appContext;
    private Map<String, String> dialectConfig;
    private String reservedWords;
    private String securePrivateKey;
    private String securePublicKey;
    private FieldsSecureProvider fieldsSecureProvider;
    private boolean breakWhenSqlRepeat = true;
    private String encoding = "UTF-8";
    private DesensitizeProvider desensitizeProvider;
    private String[] redoDataSources;
    private List<SqlInterceptor> sqlInterceptors;
    private IgnoreKeyCaseMap<String, String> dialectMap;
    private boolean splitMergeInto = false;
    private SqlFormater sqlFormater;
    private boolean executeSqlBlankToNull = true;
    private String localDateTimeFormat = "yyyy-MM-dd HH:mm:ss";
    private String localTimeFormat = "HH:mm:ss";
    private String taskExecutorName;
    private Executor taskExecutor = TtlExecutors.getTtlExecutor((Executor)ForkJoinPool.commonPool());
    private int defaultPageSize = 10;
    private Boolean autoDDL = false;
    private DialectDDLGenerator dialectDDLGenerator;
    private FirstBizCodeTrace firstBizCodeTrace;
    private DynamicCacheFetch dynamicCacheFetch;

    public void setUnifyFieldsHandler(IUnifyFieldsHandler unifyFieldsHandler) {
        this.unifyFieldsHandler = unifyFieldsHandler;
    }

    public IUnifyFieldsHandler getUnifyFieldsHandler() {
        return this.unifyFieldsHandler;
    }

    public TranslateManager getTranslateManager() {
        return this.translateManager;
    }

    public void initialize() throws Exception {
        this.logger.debug("start init sqltoy ..............................");
        SqlToyConstants.loadProperties(this.dialectConfig);
        ReservedWordsUtil.put(this.reservedWords);
        DataSourceUtils.initialize();
        if (this.firstBizCodeTrace != null) {
            SqlExecuteStat.firstBizCodeTrace = this.firstBizCodeTrace;
        }
        if (this.dialectMap != null && !this.dialectMap.isEmpty()) {
            DataSourceUtils.dialectMap = this.dialectMap;
        }
        if (this.dialectReturnPrimaryColumnCase != null) {
            SqlToyConstants.dialectReturnPrimaryColumnCase = this.dialectReturnPrimaryColumnCase;
        }
        if (this.appContext == null && this.connectionFactory == null) {
            this.connectionFactory = new SimpleConnectionFactory();
        }
        this.initDefaultDataSource();
        SqlToyConstants.setWorkerAndDataCenterId(this.workerId, this.dataCenterId, this.serverId);
        this.scriptLoader.initialize(this.debug, this.delayCheckSeconds, this.scriptCheckIntervalSeconds, this.breakWhenSqlRepeat);
        if (this.translateCacheManager == null && "caffeine".equalsIgnoreCase(this.cacheType)) {
            this.translateManager.initialize(this, (TranslateCacheManager)Class.forName(this.translateCaffeineManagerClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), this.delayCheckSeconds);
        } else {
            this.translateManager.initialize(this, this.translateCacheManager, this.delayCheckSeconds);
        }
        if (this.dynamicCacheFetch != null) {
            this.dynamicCacheFetch.initialize(this.appContext);
        }
        this.entityManager.initialize(this);
        SqlToyConstants.FETCH_SIZE = this.fetchSize;
        SqlToyConstants.executeSqlBlankToNull = this.executeSqlBlankToNull;
        SqlToyConstants.DEFAULT_PAGE_SIZE = this.defaultPageSize;
        SqlToyConstants.localDateTimeFormat = this.localDateTimeFormat;
        SqlToyConstants.localTimeFormat = this.localTimeFormat;
        SqlExecuteStat.setDebug(this.debug);
        SqlExecuteStat.setOverTimeSqlHandler(this.overTimeSqlHandler);
        SqlExecuteStat.setPrintSqlTimeoutMillis(this.printSqlTimeoutMillis);
        SqlExecuteStat.setSqlFormater(this.sqlFormater);
        if (null != this.fieldsSecureProvider) {
            this.fieldsSecureProvider.initialize(this.encoding, this.securePrivateKey, this.securePublicKey);
        } else if (StringUtil.isNotBlank(this.securePrivateKey) && StringUtil.isNotBlank(this.securePublicKey)) {
            if (this.fieldsSecureProvider == null) {
                this.fieldsSecureProvider = new FieldsRSASecureProvider();
            }
            this.fieldsSecureProvider.initialize(this.encoding, this.securePrivateKey, this.securePublicKey);
        }
        if (this.desensitizeProvider == null) {
            this.desensitizeProvider = new DesensitizeDefaultProvider();
        }
        if (this.autoDDL != null && this.autoDDL.booleanValue()) {
            DataSource createDDLDB = this.getDefaultDataSource();
            if (createDDLDB == null && this.dataSourceSelector != null) {
                createDDLDB = this.dataSourceSelector.getDataSource(this.appContext, null, null, null, null);
            }
            if (createDDLDB != null) {
                DDLFactory.createDDL(this, this.entityManager.getAllEntities(), createDDLDB);
            }
        }
        this.logger.debug("sqltoy init complete!");
    }

    public Object getServiceData(String beanName, String method, Object[] args) {
        if (StringUtil.isBlank(beanName) || StringUtil.isBlank(method)) {
            return null;
        }
        try {
            Object beanDefine = null;
            if (this.appContext.containsBean(beanName)) {
                beanDefine = this.appContext.getBean(beanName);
            } else if (beanName.indexOf(".") > 0) {
                beanDefine = this.appContext.getBean(Class.forName(beanName));
            } else {
                return null;
            }
            return BeanUtil.invokeMethod(beanDefine, method, args);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object getBean(Object beanName) {
        try {
            if (beanName instanceof String) {
                return this.appContext.getBean(beanName.toString());
            }
            return this.appContext.getBean((Class)beanName);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u4ecespringContext\u4e2d\u83b7\u53d6Bean:{} \u9519\u8bef!{}", (Object)e.getMessage());
            return null;
        }
    }

    public DataSource getDataSourceBean(String dataSourceName) {
        if (StringUtil.isBlank(dataSourceName)) {
            return null;
        }
        if (this.dataSourceSelector != null) {
            return this.dataSourceSelector.getDataSourceBean(this.appContext, dataSourceName);
        }
        if (this.appContext.containsBean(dataSourceName)) {
            return (DataSource)this.appContext.getBean(dataSourceName);
        }
        return null;
    }

    public SqlToyConfig getSqlToyConfig(String sqlKey) {
        return this.getSqlToyConfig(sqlKey, SqlType.search, this.getDialect() == null ? "" : this.getDialect(), null);
    }

    public SqlToyConfig getSqlToyConfig(String sqlKey, SqlType sqlType, String dialect) {
        if (StringUtil.isBlank(sqlKey)) {
            throw new IllegalArgumentException("sql or sqlId is null!");
        }
        return this.scriptLoader.getSqlConfig(sqlKey, sqlType, dialect, null, SqlType.search.equals((Object)sqlType) ? true : SqlToyConstants.executeSqlBlankToNull);
    }

    public SqlToyConfig getSqlToyConfig(String sqlKey, SqlType sqlType, String dialect, Object paramValues) {
        if (StringUtil.isBlank(sqlKey)) {
            throw new IllegalArgumentException("sql or sqlId is null!");
        }
        return this.scriptLoader.getSqlConfig(sqlKey, sqlType, dialect, paramValues, SqlType.search.equals((Object)sqlType) ? true : SqlToyConstants.executeSqlBlankToNull);
    }

    public SqlToyConfig getSqlToyConfig(QueryExecutor queryExecutor, SqlType sqlType, String dialect) {
        String sqlKey = queryExecutor.getInnerModel().sql;
        if (StringUtil.isBlank(sqlKey)) {
            throw new IllegalArgumentException("sql or sqlId is null!");
        }
        if (SqlType.search.equals((Object)sqlType)) {
            if (queryExecutor.getInnerModel().resultType != null) {
                sqlKey = SqlUtil.completionSql(this, (Class)queryExecutor.getInnerModel().resultType, sqlKey);
            } else if (!SqlConfigParseUtils.isNamedQuery(sqlKey) && StringUtil.matches(sqlKey.toLowerCase().trim(), "^from\\W")) {
                sqlKey = "select * ".concat(sqlKey);
            }
        }
        return this.scriptLoader.getSqlConfig(sqlKey, sqlType, dialect, QueryExecutorBuilder.getParamValues(queryExecutor), queryExecutor.getInnerModel().blankToNull);
    }

    public SqlScriptLoader getScriptLoader() {
        return this.scriptLoader;
    }

    public void setWorkerId(Integer workerId) {
        this.workerId = workerId;
    }

    public void setDataCenterId(Integer dataCenterId) {
        this.dataCenterId = dataCenterId;
    }

    public void setServerId(Integer serverId) {
        this.serverId = serverId;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        if (batchSize > 0) {
            this.batchSize = batchSize;
        }
    }

    public ShardingStrategy getShardingStrategy(String strategyName) {
        if (this.shardingStrategys.containsKey(strategyName)) {
            return this.shardingStrategys.get(strategyName);
        }
        ShardingStrategy shardingStrategy = (ShardingStrategy)this.appContext.getBean(strategyName);
        if (shardingStrategy != null) {
            this.shardingStrategys.put(strategyName, shardingStrategy);
        }
        return shardingStrategy;
    }

    public void setShardingStrategys(HashMap<String, ShardingStrategy> shardingStrategys) {
        this.shardingStrategys = shardingStrategys;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public EntityMeta getEntityMeta(Class<?> entityClass) {
        return this.entityManager.getEntityMeta(this, entityClass);
    }

    public EntityMeta getEntityMeta(String tableName) {
        return this.entityManager.getEntityMeta(tableName);
    }

    public boolean isEntity(Class<?> entityClass) {
        return this.entityManager.isEntity(this, entityClass);
    }

    public synchronized SqlToyConfig parseSqlSegment(Object sqlSegment) throws Exception {
        return this.scriptLoader.parseSqlSagment(sqlSegment);
    }

    public synchronized void putSqlToyConfig(SqlToyConfig sqlToyConfig) throws Exception {
        this.scriptLoader.putSqlToyConfig(sqlToyConfig);
    }

    public synchronized void parseSqlFile(Object sqlFile) throws Exception {
        this.scriptLoader.parseSqlFile(sqlFile);
    }

    public String getDialect() {
        return this.dialect;
    }

    public void setDialect(String dialect) {
        if (StringUtil.isBlank(dialect)) {
            return;
        }
        String tmp = dialect.toLowerCase();
        this.dialect = tmp.startsWith("mysql") ? "mysql" : (tmp.startsWith("oracle11") ? "oracle11" : (tmp.startsWith("oracle") ? "oracle" : (tmp.startsWith("postgresql") ? "postgresql" : (tmp.startsWith("greenplum") ? "postgresql" : (tmp.startsWith("db2") ? "db2" : (tmp.startsWith("sqlserver") ? "sqlserver" : (tmp.startsWith("sqlite") ? "sqlite" : (tmp.startsWith("gaussdb") ? "gaussdb" : (tmp.startsWith("mogdb") ? "mogdb" : (tmp.startsWith("mariadb") ? "mariadb" : (tmp.startsWith("clickhouse") ? "clickhouse" : (tmp.startsWith("oceanbase") ? "oceanbase" : (tmp.startsWith("dm") ? "dm" : (tmp.startsWith("tidb") ? "tidb" : (tmp.startsWith("kingbase") ? "kingbase" : (tmp.startsWith("impala") || tmp.contains("kudu") ? "impala" : (tmp.startsWith("tdengine") ? "tdengine" : (tmp.startsWith("elastic") ? "elastic" : (tmp.startsWith("h2") ? "h2" : (tmp.startsWith("oscar") ? "oscar" : (tmp.startsWith("vastbase") ? "vastbase" : (tmp.startsWith("opengauss") ? "opengauss" : (tmp.startsWith("stardb") ? "stardb" : dialect)))))))))))))))))))))));
        this.scriptLoader.setDialect(this.dialect);
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setPackagesToScan(String[] packagesToScan) {
        this.entityManager.setPackagesToScan(packagesToScan);
    }

    public int getPageFetchSizeLimit() {
        return this.pageFetchSizeLimit;
    }

    public void setPageFetchSizeLimit(int pageFetchSizeLimit) {
        this.pageFetchSizeLimit = pageFetchSizeLimit;
    }

    public void setRecursive(boolean recursive) {
        this.entityManager.setRecursive(recursive);
    }

    public void setAnnotatedClasses(String[] annotatedClasses) {
        this.entityManager.setAnnotatedClasses(annotatedClasses);
    }

    public void setDialectConfig(Map<String, String> dialectConfig) {
        this.dialectConfig = dialectConfig;
    }

    public void setSqlResourcesDir(String sqlResourcesDir) {
        this.scriptLoader.setSqlResourcesDir(sqlResourcesDir);
    }

    public void setSqlResources(List<String> sqlResources) {
        this.scriptLoader.setSqlResources(sqlResources);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
        this.scriptLoader.setEncoding(encoding);
    }

    public void setFunctionConverts(Object functionConverts) {
        if (functionConverts == null) {
            return;
        }
        if (functionConverts instanceof List) {
            FunctionUtils.setFunctionConverts((List)functionConverts);
        } else if (functionConverts instanceof String[]) {
            FunctionUtils.setFunctionConverts(Arrays.asList((String[])functionConverts));
        } else if (functionConverts instanceof String) {
            String converts = (String)functionConverts;
            if (StringUtil.isBlank(converts) || "default".equals(converts) || "defaults".equals(converts)) {
                FunctionUtils.setFunctionConverts(Arrays.asList("default"));
            } else if (!"close".equalsIgnoreCase(converts)) {
                FunctionUtils.setFunctionConverts(Arrays.asList(converts.split("\\,")));
            }
        }
    }

    public void setTranslateConfig(String translateConfig) {
        this.translateManager.setTranslateConfig(translateConfig);
    }

    public void setUncachedKeyResult(String uncachedKeyResult) {
        SqlToyConstants.setUncachedKeyResult(uncachedKeyResult);
    }

    public AppContext getAppContext() {
        return this.appContext;
    }

    public void setAppContext(AppContext appContext) {
        this.appContext = appContext;
    }

    public void initDefaultDataSource() {
        if (StringUtil.isNotBlank(this.defaultDataSourceName)) {
            this.defaultDataSource = this.getDataSourceBean(this.defaultDataSourceName);
        }
    }

    public DataSource getDefaultDataSource() {
        return this.defaultDataSource;
    }

    public void setElasticEndpoints(List<ElasticEndpoint> elasticEndpointList) {
        if (elasticEndpointList == null || elasticEndpointList.isEmpty()) {
            return;
        }
        if (StringUtil.isBlank(this.defaultElastic)) {
            this.defaultElastic = elasticEndpointList.get(0).getId();
        }
        for (ElasticEndpoint config : elasticEndpointList) {
            config.initRestClient();
            this.elasticEndpoints.put(config.getId().toLowerCase(), config);
        }
    }

    public ElasticEndpoint getElasticEndpoint(String id) {
        ElasticEndpoint result = this.elasticEndpoints.get(StringUtil.isBlank(id) ? this.defaultElastic : id.toLowerCase());
        if (result == null) {
            return new ElasticEndpoint(id);
        }
        return result;
    }

    public int getPrintSqlTimeoutMillis() {
        return this.printSqlTimeoutMillis;
    }

    public void setPrintSqlTimeoutMillis(int printSqlTimeoutMillis) {
        this.printSqlTimeoutMillis = printSqlTimeoutMillis;
    }

    public void setKeywordSign(String keywordSign) {
        SqlToyConstants.keywordSign = keywordSign;
    }

    public void setScriptCheckIntervalSeconds(int scriptCheckIntervalSeconds) {
        this.scriptCheckIntervalSeconds = scriptCheckIntervalSeconds;
    }

    public void setDelayCheckSeconds(int delayCheckSeconds) {
        this.delayCheckSeconds = delayCheckSeconds;
    }

    public void setTranslateCacheManager(TranslateCacheManager translateCacheManager) {
        this.translateCacheManager = translateCacheManager;
    }

    public String getDefaultElastic() {
        return this.defaultElastic;
    }

    public void setDefaultElastic(String defaultElastic) {
        this.defaultElastic = defaultElastic;
    }

    public void setReservedWords(String reservedWords) {
        this.reservedWords = reservedWords;
    }

    public TypeHandler getTypeHandler() {
        return this.typeHandler;
    }

    public void setTypeHandler(TypeHandler typeHandler) {
        this.typeHandler = typeHandler;
    }

    public void setCacheType(String cacheType) {
        this.cacheType = cacheType;
    }

    public void destroy() {
        try {
            this.scriptLoader.destroy();
            this.translateManager.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DataSourceSelector getDataSourceSelector() {
        return this.dataSourceSelector;
    }

    public void setDataSourceSelector(DataSourceSelector dataSourceSelector) {
        this.dataSourceSelector = dataSourceSelector;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setDefaultDataSource(DataSource defaultDataSource) {
        this.defaultDataSource = defaultDataSource;
    }

    public void setDefaultDataSourceName(String defaultDataSourceName) {
        this.defaultDataSourceName = defaultDataSourceName;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public Connection getConnection(DataSource datasource) {
        return this.connectionFactory.getConnection(datasource);
    }

    public void releaseConnection(Connection conn, DataSource dataSource) {
        this.connectionFactory.releaseConnection(conn, dataSource);
    }

    public void setBreakWhenSqlRepeat(boolean breakWhenSqlRepeat) {
        this.breakWhenSqlRepeat = breakWhenSqlRepeat;
    }

    public void setSecurePrivateKey(String securePrivateKey) {
        this.securePrivateKey = securePrivateKey;
    }

    public void setSecurePublicKey(String securePublicKey) {
        this.securePublicKey = securePublicKey;
    }

    public void setFieldsSecureProvider(FieldsSecureProvider fieldsSecureProvider) {
        this.fieldsSecureProvider = fieldsSecureProvider;
    }

    public FieldsSecureProvider getFieldsSecureProvider() {
        return this.fieldsSecureProvider;
    }

    public DesensitizeProvider getDesensitizeProvider() {
        return this.desensitizeProvider;
    }

    public void setDesensitizeProvider(DesensitizeProvider desensitizeProvider) {
        this.desensitizeProvider = desensitizeProvider;
    }

    public FilterHandler getCustomFilterHandler() {
        return this.customFilterHandler;
    }

    public void setCustomFilterHandler(FilterHandler customFilterHandler) {
        this.customFilterHandler = customFilterHandler;
    }

    public void setTranslateCaffeineManagerClass(String translateCaffeineManagerClass) {
        this.translateCaffeineManagerClass = translateCaffeineManagerClass;
    }

    public String getDistributeIdGeneratorClass() {
        return this.distributeIdGeneratorClass;
    }

    public void setDistributeIdGeneratorClass(String distributeIdGeneratorClass) {
        this.distributeIdGeneratorClass = distributeIdGeneratorClass;
    }

    public String getMongoQueryClass() {
        return this.mongoQueryClass;
    }

    public void setMongoQueryClass(String mongoQueryClass) {
        this.mongoQueryClass = mongoQueryClass;
    }

    public OverTimeSqlHandler getOverTimeSqlHandler() {
        return this.overTimeSqlHandler;
    }

    public void setOverTimeSqlHandler(OverTimeSqlHandler overTimeSqlHandler) {
        this.overTimeSqlHandler = overTimeSqlHandler;
    }

    public List<OverTimeSql> getSlowestSql(int size, boolean hasSqlId) {
        return this.overTimeSqlHandler.getSlowest(size, hasSqlId);
    }

    public String getColumnLabelUpperOrLower() {
        return this.columnLabelUpperOrLower;
    }

    public void setColumnLabelUpperOrLower(String columnLabelUpperOrLower) {
        this.columnLabelUpperOrLower = columnLabelUpperOrLower;
    }

    public String[] getRedoDataSources() {
        return this.redoDataSources;
    }

    public void setRedoDataSources(String[] redoDataSources) {
        this.redoDataSources = redoDataSources;
    }

    public List<SqlInterceptor> getSqlInterceptors() {
        return this.sqlInterceptors;
    }

    public boolean hasSqlInterceptors() {
        return this.sqlInterceptors != null && !this.sqlInterceptors.isEmpty();
    }

    public void setSqlInterceptors(List<SqlInterceptor> sqlInterceptors) {
        this.sqlInterceptors = sqlInterceptors;
    }

    public boolean isSplitMergeInto() {
        return this.splitMergeInto;
    }

    public void setSplitMergeInto(boolean splitMergeInto) {
        this.splitMergeInto = splitMergeInto;
    }

    public boolean isHumpMapResultTypeLabel() {
        return this.humpMapResultTypeLabel;
    }

    public void setHumpMapResultTypeLabel(boolean humpMapResultTypeLabel) {
        this.humpMapResultTypeLabel = humpMapResultTypeLabel;
    }

    public int getUpdateTipCount() {
        return this.updateTipCount;
    }

    public void setUpdateTipCount(int updateTipCount) {
        this.updateTipCount = updateTipCount;
    }

    public boolean isExecuteSqlBlankToNull() {
        return this.executeSqlBlankToNull;
    }

    public void setExecuteSqlBlankToNull(boolean executeSqlBlankToNull) {
        this.executeSqlBlankToNull = executeSqlBlankToNull;
    }

    public Boolean getOverPageToFirst() {
        return this.overPageToFirst;
    }

    public void setOverPageToFirst(Boolean overPageToFirst) {
        this.overPageToFirst = overPageToFirst;
    }

    public void setTaskExecutorName(String taskExecutorName) {
        this.taskExecutorName = taskExecutorName;
    }

    public Executor getTaskExecutor() {
        if (StringUtil.isBlank(this.taskExecutorName) || !this.appContext.containsBean(this.taskExecutorName)) {
            return this.taskExecutor;
        }
        return (Executor)this.appContext.getBean(this.taskExecutorName);
    }

    public void setTaskExecutor(Executor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setSqlFormater(SqlFormater sqlFormater) {
        this.sqlFormater = sqlFormater;
    }

    public void setDefaultPageSize(int defaultPageSize) {
        this.defaultPageSize = defaultPageSize;
    }

    public boolean isDefaultPageOffset() {
        return this.defaultPageOffset;
    }

    public void setDefaultPageOffset(boolean defaultPageOffset) {
        this.defaultPageOffset = defaultPageOffset;
    }

    public Boolean getAutoDDL() {
        return this.autoDDL;
    }

    public void setAutoDDL(Boolean autoDDL) {
        this.autoDDL = autoDDL;
    }

    public void setDialectMap(Map<String, String> dialectMap) {
        if (dialectMap != null && !dialectMap.isEmpty()) {
            this.dialectMap = new IgnoreKeyCaseMap<String, String>(dialectMap);
        }
    }

    public void setLocalDateTimeFormat(String localDateTimeFormat) {
        this.localDateTimeFormat = localDateTimeFormat;
    }

    public void setLocalTimeFormat(String localTimeFormat) {
        this.localTimeFormat = localTimeFormat;
    }

    public DialectDDLGenerator getDialectDDLGenerator() {
        return this.dialectDDLGenerator;
    }

    public void setDialectDDLGenerator(DialectDDLGenerator dialectDDLGenerator) {
        this.dialectDDLGenerator = dialectDDLGenerator;
    }

    public void setFirstBizCodeTrace(FirstBizCodeTrace firstBizCodeTrace) {
        this.firstBizCodeTrace = firstBizCodeTrace;
    }

    public IgnoreKeyCaseMap<String, String> getDialectReturnPrimaryColumnCase() {
        return this.dialectReturnPrimaryColumnCase;
    }

    public void setDialectReturnPrimaryColumnCase(IgnoreKeyCaseMap<String, String> dialectReturnPrimaryColumnCase) {
        this.dialectReturnPrimaryColumnCase = dialectReturnPrimaryColumnCase;
    }

    public DynamicCacheFetch getDynamicCacheFetch() {
        return this.dynamicCacheFetch;
    }

    public void setDynamicCacheFetch(DynamicCacheFetch dynamicCacheFetch) {
        this.dynamicCacheFetch = dynamicCacheFetch;
    }
}

