/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IllegalFormatFlagsException;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sagacity.sqltoy.SqlToyConstants;
import org.sagacity.sqltoy.config.model.IfLogicModel;
import org.sagacity.sqltoy.config.model.KeyAndIndex;
import org.sagacity.sqltoy.config.model.SqlParamsModel;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.config.model.SqlToyResult;
import org.sagacity.sqltoy.config.model.SqlType;
import org.sagacity.sqltoy.config.model.SqlWithAnalysis;
import org.sagacity.sqltoy.model.IgnoreKeyCaseMap;
import org.sagacity.sqltoy.plugins.function.FunctionUtils;
import org.sagacity.sqltoy.plugins.id.macro.AbstractMacro;
import org.sagacity.sqltoy.plugins.id.macro.MacroUtils;
import org.sagacity.sqltoy.plugins.id.macro.impl.SqlLoop;
import org.sagacity.sqltoy.utils.BeanUtil;
import org.sagacity.sqltoy.utils.CollectionUtil;
import org.sagacity.sqltoy.utils.DataSourceUtils;
import org.sagacity.sqltoy.utils.MacroIfLogic;
import org.sagacity.sqltoy.utils.ReservedWordsUtil;
import org.sagacity.sqltoy.utils.SqlUtil;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlConfigParseUtils {
    protected static final Logger logger = LoggerFactory.getLogger(SqlConfigParseUtils.class);
    public static final String SQL_PSEUDO_START_MARK = "#[";
    public static final String SQL_PSEUDO_SYM_START_MARK = "[";
    public static final int SQL_PSEUDO_START_MARK_LENGTH = "#[".length();
    public static final String SQL_PSEUDO_END_MARK = "]";
    public static final int SQL_PSEUDO_END_MARK_LENGTH = "]".length();
    public static final Pattern FAST_PATTERN = Pattern.compile("(?i)\\@fast(Page)?\\([\\w\\W]+\\)");
    public static final Pattern IN_PATTERN = Pattern.compile("(?i)\\s+in\\s*((\\(\\s*\\?(\\s*\\,\\s*\\?)*\\s*\\))|((\\(\\s*){2}\\?(\\s*\\,\\s*\\?)+(\\s*\\)){2}))");
    public static final Pattern LIKE_PATTERN = Pattern.compile("(?i)\\s+i?like\\s+\\?");
    public static final String BLANK_REGEX = "(?i)\\@blank\\s*\\(\\s*\\?\\s*\\)";
    public static final String BLANK_START_REGEX = "(?i)^\\@blank\\s*\\(\\s*\\?\\s*\\)";
    public static final Pattern BLANK_PATTERN = Pattern.compile("(?i)\\@blank\\s*\\(\\s*\\?\\s*\\)");
    public static final Pattern BLANK_START_PATTERN = Pattern.compile("(?i)^\\@blank\\s*\\(\\s*\\?\\s*\\)");
    public static final String VALUE_REGEX = "(?i)\\@value\\s*\\(\\s*(\\?|null)\\s*\\)";
    public static final Pattern VALUE_PATTERN = Pattern.compile("(?i)\\@value\\s*\\(\\s*(\\?|null)\\s*\\)");
    public static final Pattern IF_PATTERN = Pattern.compile("(?i)\\@if\\s*\\(");
    public static final Pattern START_IF_PATTERN = Pattern.compile("(?i)^\\s*\\@if\\s*\\(");
    public static final Pattern ELSEIF_PATTERN = Pattern.compile("(?i)\\@elseif\\s*\\(");
    public static final Pattern START_ELSEIF_PATTERN = Pattern.compile("(?i)^\\s*\\@elseif\\s*\\(");
    public static final Pattern ELSE_PATTERN = Pattern.compile("(?i)\\@else(\\s+|\\s*\\(\\s*\\))");
    public static final Pattern START_ELSE_PATTERN = Pattern.compile("(?i)^\\s*\\@else(\\s+|\\s*\\(\\s*\\))");
    public static final Pattern IF_ALL_PATTERN = Pattern.compile("(?i)\\@((if|elseif)\\s*\\(|else(\\s+|\\s*\\(\\s*\\)))");
    public static final String BLANK = " ";
    public static final Pattern IS_END_PATTERN = Pattern.compile("\\s+is\\s+(not)?\\s+$");
    public static final String ARG_NAME = "?";
    public static final String ARG_REGEX = "\\?";
    public static final String ARG_DBL_NAME = "??";
    public static final String ARG_DBL_REGEX = "\\?{2}";
    public static final Pattern ARG_NAME_PATTERN = Pattern.compile("\\?");
    public static final Pattern WHERE_END_PATTERN = Pattern.compile("(?i)\\Wwhere\\s*$");
    public static final Pattern WHERE_ONE_EQUAL_PATTERN = Pattern.compile("(?i)\\Wwhere\\s*1\\s*=\\s*1\\s*$");
    public static final Pattern AND_START_PATTERN = Pattern.compile("(?i)^and\\W");
    public static final Pattern OR_START_PATTERN = Pattern.compile("(?i)^or\\W");
    public static final Pattern UPDATE_SET_PATTERN = Pattern.compile("(?i)\\Wset\\s*$");
    public static final Pattern SQL_ID_PATTERN = Pattern.compile("^[A-Za-z_0-9\\-]+$");
    public static final Pattern WHERE_CLOSE_PATTERN = Pattern.compile("^((order|group)\\s+by|(inner|left|right|full)\\s+join|having|union|limit)\\W");
    public static final String DBL_QUESTMARK = "#sqltoy_dblqsmark_placeholder#";
    public static final Pattern EQUAL_PATTERN = Pattern.compile("[^\\>\\<\\!\\:]\\=\\s*$");
    public static final Pattern UPDATE_EQUAL_PATTERN = Pattern.compile("(?i)\\s*(set\\s+|,\\s*|update\\s+)([a-zA-Z_0-9\u4e00-\u9fa5]+\\.)?('|\"|\\`|\\[)?[a-zA-Z_0-9\u4e00-\u9fa5]+('|\"|\\`|\\])?\\s*=\\s*$");
    public static final Pattern NOT_EQUAL_PATTERN = Pattern.compile("(\\!\\=|\\<\\>|\\^\\=)\\s*$");
    public static final Pattern WHERE_PATTERN = Pattern.compile("(?i)\\Wwhere\\W");
    public static final String MORE_IN_FIELDS_REGEX = "[\\s\\(\\)\\}\\{\\]\\[]";
    public static final String NOT_IN_REGEX = "\\s*not$";
    private static Map<String, AbstractMacro> macros = new HashMap<String, AbstractMacro>();

    private SqlConfigParseUtils() {
    }

    public static boolean hasNamedParam(String sql) {
        if (sql == null) {
            return false;
        }
        return StringUtil.matches(sql, SqlToyConstants.SQL_NAMED_PATTERN);
    }

    public static boolean hasFast(String sql) {
        return StringUtil.matches(sql, FAST_PATTERN);
    }

    public static boolean hasWith(String sql) {
        return StringUtil.matches(BLANK + sql, SqlToyConstants.withPattern);
    }

    public static boolean isNamedQuery(String queryStr) {
        if (StringUtil.isBlank(queryStr)) {
            return false;
        }
        return StringUtil.matches(queryStr.trim(), SQL_ID_PATTERN);
    }

    public static SqlToyResult processSql(String queryStr, Map<String, Object> argMap) {
        return SqlConfigParseUtils.processSql(queryStr, argMap, null);
    }

    public static SqlToyResult processSql(String queryStr, Map<String, Object> argMap, String dialect) {
        IgnoreKeyCaseMap ignoreCaseMap = new IgnoreKeyCaseMap(argMap == null ? new HashMap() : argMap);
        String[] paramsNamed = SqlConfigParseUtils.getSqlParamsName(queryStr, true);
        Object[] paramsArg = null;
        if (paramsNamed != null) {
            paramsArg = new Object[paramsNamed.length];
            for (int i = 0; i < paramsNamed.length; ++i) {
                paramsArg[i] = ignoreCaseMap.get(paramsNamed[i]);
            }
        }
        return SqlConfigParseUtils.processSql(queryStr, paramsNamed, paramsArg, dialect);
    }

    public static SqlToyResult processSql(String queryStr, String[] paramsNamed, Object[] paramsArg) {
        return SqlConfigParseUtils.processSql(queryStr, paramsNamed, paramsArg, null);
    }

    public static SqlToyResult processSql(String queryStr, String[] paramsNamed, Object[] paramsArg, String dialect) {
        SqlParamsModel sqlParam;
        Object[] paramsValue = paramsArg;
        if (paramsNamed != null && paramsNamed.length > 0) {
            if (null == paramsArg || paramsArg.length == 0) {
                paramsValue = new Object[paramsNamed.length];
            }
        } else if (null == paramsArg || paramsArg.length == 0) {
            return new SqlToyResult(queryStr, paramsArg);
        }
        SqlToyResult sqlToyResult = new SqlToyResult();
        boolean isNamedArgs = StringUtil.matches(queryStr, SqlToyConstants.SQL_NAMED_PATTERN);
        String questionMark = "#sqltoy_qsmark_placeholder#";
        if (isNamedArgs) {
            String sql = queryStr.replaceAll(ARG_REGEX, questionMark);
            sql = SqlConfigParseUtils.processLoop(sql, paramsNamed, paramsValue);
            sqlParam = SqlConfigParseUtils.processNamedParamsQuery(sql);
        } else {
            String sql = queryStr.replaceAll(ARG_DBL_REGEX, DBL_QUESTMARK);
            int paramCnt = StringUtil.matchCnt(sql, ARG_NAME_PATTERN, 0);
            if (paramCnt == 1 && paramsValue.length > 1 && StringUtil.matches(sql, IN_PATTERN)) {
                paramsValue = new Object[]{paramsValue};
            }
            sqlParam = SqlConfigParseUtils.processNamedParamsQuery(sql);
        }
        sqlToyResult.setSql(sqlParam.getSql());
        sqlToyResult.setParamsValue(SqlConfigParseUtils.matchNamedParam(sqlParam.getParamsName(), paramsNamed, paramsValue));
        SqlConfigParseUtils.processNullConditions(sqlToyResult);
        SqlConfigParseUtils.processBlank(sqlToyResult);
        SqlConfigParseUtils.processLike(sqlToyResult);
        SqlConfigParseUtils.processValue(sqlToyResult, dialect, true);
        SqlConfigParseUtils.processIn(sqlToyResult);
        SqlConfigParseUtils.replaceNull(sqlToyResult, 0);
        SqlConfigParseUtils.processValue(sqlToyResult, dialect, false);
        if (isNamedArgs) {
            sqlToyResult.setSql(sqlToyResult.getSql().replaceAll(questionMark, ARG_NAME));
        } else {
            sqlToyResult.setSql(sqlToyResult.getSql().replaceAll(DBL_QUESTMARK, ARG_DBL_NAME));
        }
        return sqlToyResult;
    }

    public static String clearDblQuestMark(String sql) {
        if (StringUtil.isBlank(sql)) {
            return sql;
        }
        return sql.replaceAll(ARG_DBL_REGEX, DBL_QUESTMARK);
    }

    public static String recoverDblQuestMark(String sql) {
        if (StringUtil.isBlank(sql)) {
            return sql;
        }
        return sql.replaceAll(DBL_QUESTMARK, ARG_DBL_NAME);
    }

    public static boolean hasQuestMarkArgs(String sql) {
        if (StringUtil.isBlank(sql)) {
            return false;
        }
        String lastSql = SqlConfigParseUtils.clearDblQuestMark(sql);
        return lastSql.indexOf(ARG_NAME) != -1;
    }

    public static Object[] matchNamedParam(String[] sqlParamsName, String[] paramsNameOrder, Object[] paramsValue) {
        if (null == sqlParamsName || sqlParamsName.length == 0) {
            if (null == paramsNameOrder || paramsNameOrder.length == 0) {
                return paramsValue;
            }
            return null;
        }
        Object[] result = new Object[sqlParamsName.length];
        if (null != paramsNameOrder && paramsNameOrder.length > 0) {
            HashMap<String, Object> nameValueMap = new HashMap<String, Object>();
            int i = 0;
            for (String name : paramsNameOrder) {
                nameValueMap.put(name.toLowerCase(), paramsValue[i]);
                ++i;
            }
            i = 0;
            for (String name : sqlParamsName) {
                KeyAndIndex keyAndIndex;
                String nameLow = name.toLowerCase();
                result[i] = nameValueMap.get(nameLow);
                if (result[i] == null && (keyAndIndex = BeanUtil.getKeyAndIndex(nameLow)) != null) {
                    result[i] = BeanUtil.getArrayIndexValue(nameValueMap.get(keyAndIndex.getKey()), keyAndIndex.getIndex());
                }
                ++i;
            }
        }
        return result;
    }

    public static SqlParamsModel processNamedParamsQuery(String queryStr) {
        SqlParamsModel sqlParam = new SqlParamsModel();
        sqlParam.setSql(queryStr);
        Matcher m = SqlToyConstants.SQL_NAMED_PATTERN.matcher(queryStr);
        ArrayList<String> paramsName = new ArrayList<String>();
        StringBuilder lastSql = new StringBuilder();
        int start = 0;
        while (m.find(start)) {
            String group = m.group();
            paramsName.add(group.substring(2).trim());
            lastSql.append(queryStr.substring(start, m.start() + 1)).append(ARG_NAME);
            if (StringUtil.matches(group, SqlToyConstants.BLANK_END)) {
                start = m.end() - 1;
                continue;
            }
            start = m.end();
        }
        if (start == 0) {
            return sqlParam;
        }
        lastSql.append(queryStr.substring(start));
        sqlParam.setSql(lastSql.toString());
        sqlParam.setParamsName(paramsName.toArray(new String[paramsName.size()]));
        return sqlParam;
    }

    public static String[] getSqlParamsName(String queryStr, boolean distinct) {
        Matcher matcher = SqlToyConstants.SQL_NAMED_PATTERN.matcher(queryStr);
        ArrayList<String> paramsNameList = new ArrayList<String>();
        HashSet<String> distinctSet = new HashSet<String>();
        int start = 0;
        while (matcher.find(start)) {
            String paramName = matcher.group().substring(2).trim();
            if (distinct) {
                if (!distinctSet.contains(paramName.toLowerCase())) {
                    paramsNameList.add(paramName);
                    distinctSet.add(paramName.toLowerCase());
                }
            } else {
                paramsNameList.add(paramName);
            }
            start = matcher.end() - 1;
        }
        if (paramsNameList.isEmpty()) {
            return null;
        }
        return paramsNameList.toArray(new String[paramsNameList.size()]);
    }

    public static String[] getNoSqlParamsName(String queryStr, boolean distinct) {
        Matcher m = SqlToyConstants.NOSQL_NAMED_PATTERN.matcher(queryStr);
        ArrayList<String> paramsNameList = new ArrayList<String>();
        HashSet<String> distinctSet = new HashSet<String>();
        while (m.find()) {
            String groupStr = m.group();
            String paramName = groupStr.substring(groupStr.indexOf(":") + 1, groupStr.indexOf(")")).trim();
            if (distinct) {
                if (distinctSet.contains(paramName.toLowerCase())) continue;
                paramsNameList.add(paramName);
                distinctSet.add(paramName.toLowerCase());
                continue;
            }
            paramsNameList.add(paramName);
        }
        if (paramsNameList.isEmpty()) {
            return null;
        }
        return paramsNameList.toArray(new String[paramsNameList.size()]);
    }

    private static void processNullConditions(SqlToyResult sqlToyResult) {
        String queryStr = sqlToyResult.getSql();
        int pseudoMarkStart = queryStr.indexOf(SQL_PSEUDO_START_MARK);
        if (pseudoMarkStart == -1) {
            return;
        }
        List paramValuesList = CollectionUtil.arrayToList(sqlToyResult.getParamsValue());
        boolean isEndWithAndOr = false;
        int ifLogicCnt = 0;
        while (pseudoMarkStart != -1) {
            int paramCnt;
            ifLogicCnt = 0;
            isEndWithAndOr = false;
            int beginMarkIndex = queryStr.lastIndexOf(SQL_PSEUDO_START_MARK);
            int endMarkIndex = StringUtil.getSymMarkIndex(SQL_PSEUDO_SYM_START_MARK, SQL_PSEUDO_END_MARK, queryStr, beginMarkIndex);
            if (endMarkIndex == -1) {
                throw new IllegalFormatFlagsException("sql\u8bed\u53e5\u4e2d\u7f3a\u4e4f\"#[\" \u76f8\u5bf9\u79f0\u7684\"]\"\u7b26\u53f7,\u8bf7\u68c0\u67e5sql\u683c\u5f0f!");
            }
            String preSql = queryStr.substring(0, beginMarkIndex).concat(BLANK);
            String markContentSql = BLANK.concat(queryStr.substring(beginMarkIndex + SQL_PSEUDO_START_MARK_LENGTH, endMarkIndex)).concat(BLANK);
            int ifLogicSignStart = StringUtil.matchIndex(markContentSql, IF_ALL_PATTERN);
            int ifStart = StringUtil.matchIndex(markContentSql, IF_PATTERN);
            if (ifStart == ifLogicSignStart && ifStart > 0) {
                ifLogicCnt = 1;
            } else if (ifStart == -1 && ifLogicSignStart > 0) {
                int symIfIndex = SqlConfigParseUtils.getStartIfIndex(preSql, SQL_PSEUDO_SYM_START_MARK, SQL_PSEUDO_END_MARK);
                if (symIfIndex == -1) {
                    throw new IllegalFormatFlagsException("sql\u7f16\u5199\u6a21\u5f0f\u5b58\u5728\u9519\u8bef:@elseif(?==xx) @else \u6761\u4ef6\u5224\u65ad\u5fc5\u987b\u8981\u6709\u5bf9\u5e94\u7684@if()\u5f62\u6210\u5bf9\u79f0\u683c\u5f0f!");
                }
                beginMarkIndex = queryStr.substring(0, symIfIndex).lastIndexOf(SQL_PSEUDO_START_MARK);
                preSql = queryStr.substring(0, beginMarkIndex).concat(BLANK);
                markContentSql = BLANK.concat(queryStr.substring(beginMarkIndex + SQL_PSEUDO_START_MARK_LENGTH, endMarkIndex)).concat(BLANK);
                ifLogicCnt = StringUtil.matchCnt(markContentSql, IF_ALL_PATTERN);
            }
            String tailSql = queryStr.substring(endMarkIndex + SQL_PSEUDO_END_MARK_LENGTH);
            int preParamCnt = StringUtil.matchCnt(preSql, ARG_NAME_PATTERN, 0);
            markContentSql = SqlConfigParseUtils.processIfLogic(markContentSql, SQL_PSEUDO_START_MARK, SQL_PSEUDO_END_MARK, ARG_NAME_PATTERN, paramValuesList, preSql, preParamCnt, ifLogicCnt, 0, 0);
            if (ifLogicCnt == 0) {
                isEndWithAndOr = StringUtil.matches(markContentSql, SqlToyConstants.AND_OR_END);
                paramCnt = StringUtil.matchCnt(markContentSql, ARG_NAME_PATTERN, 0);
                markContentSql = paramCnt == 0 ? BLANK : SqlConfigParseUtils.processMarkContent(markContentSql, ARG_NAME_PATTERN, paramValuesList, preParamCnt, paramCnt, true);
            } else {
                boolean isDynamicSql = SqlConfigParseUtils.isDynamicSql(markContentSql, SQL_PSEUDO_START_MARK, SQL_PSEUDO_END_MARK);
                if (!isDynamicSql) {
                    isEndWithAndOr = StringUtil.matches(markContentSql, SqlToyConstants.AND_OR_END);
                    paramCnt = StringUtil.matchCnt(markContentSql, ARG_NAME_PATTERN, 0);
                    markContentSql = SqlConfigParseUtils.processMarkContent(markContentSql, ARG_NAME_PATTERN, paramValuesList, preParamCnt, paramCnt, true);
                } else {
                    String clearSymMarkStr = StringUtil.clearSymMarkContent(markContentSql, SQL_PSEUDO_START_MARK, SQL_PSEUDO_END_MARK);
                    int clearAfterArgCnt = StringUtil.matchCnt(clearSymMarkStr, ARG_NAME_PATTERN, 0);
                    if (clearAfterArgCnt > 0) {
                        markContentSql = SQL_PSEUDO_START_MARK.concat(markContentSql).concat(SQL_PSEUDO_END_MARK);
                    } else {
                        isEndWithAndOr = StringUtil.matches(markContentSql, SqlToyConstants.AND_OR_END);
                    }
                }
            }
            queryStr = SqlConfigParseUtils.processWhereLinkAnd(preSql, markContentSql, isEndWithAndOr, tailSql);
            pseudoMarkStart = queryStr.indexOf(SQL_PSEUDO_START_MARK);
        }
        sqlToyResult.setSql(queryStr);
        sqlToyResult.setParamsValue(paramValuesList.toArray());
    }

    public static boolean isDynamicSql(String sql, String startMark, String endMark) {
        int startMarkIndex = sql.indexOf(startMark);
        return startMarkIndex >= 0 && sql.indexOf(endMark, startMarkIndex) > 0;
    }

    public static int getStartIfIndex(String preSql, String startMark, String endMark) {
        int endIndex;
        String sql = preSql;
        int startIndex = -1;
        int ifIndex = -1;
        while ((endIndex = sql.lastIndexOf(endMark)) != -1 && (startIndex = StringUtil.getSymMarkReverseIndex(startMark, endMark, sql, endIndex + endMark.length())) != -1) {
            ifIndex = StringUtil.matchIndex(sql.substring(startIndex + startMark.length()), START_IF_PATTERN);
            if (ifIndex != -1) {
                return ifIndex + startIndex + startMark.length();
            }
            sql = sql.substring(0, startIndex);
        }
        if (ifIndex == -1) {
            throw new IllegalFormatFlagsException("sql\u8bed\u53e5@elseif\u3001@else \u7f3a\u5c11\u5bf9\u5e94\u7684@if");
        }
        return ifIndex;
    }

    public static String processMarkContent(String markContentSql, Pattern namedPattern, List paramValuesList, int preParamCnt, int paramCnt, boolean sqlMode) {
        String resultStr = markContentSql;
        int beginIndex = 0;
        int endIndex = 0;
        int offset = sqlMode ? 1 : 2;
        for (int i = preParamCnt; i < preParamCnt + paramCnt; ++i) {
            Object paramValue = paramValuesList.get(i);
            beginIndex = endIndex;
            endIndex = StringUtil.matchIndex(markContentSql, namedPattern, beginIndex + offset)[0];
            boolean sqlhasIs = false;
            if (sqlMode) {
                String sqlPart = markContentSql.substring(beginIndex + offset, endIndex);
                sqlhasIs = StringUtil.matches(BLANK + sqlPart.toLowerCase() + BLANK, IS_END_PATTERN);
            }
            if (!(null == paramValue && !sqlhasIs || null != paramValue && paramValue.getClass().isArray() && CollectionUtil.convertArray(paramValue).length == 0 || null != paramValue && paramValue instanceof Collection && ((Collection)paramValue).isEmpty()) && (!sqlhasIs || null == paramValue || paramValue instanceof Boolean)) continue;
            resultStr = BLANK;
            for (int k = paramCnt; k > 0; --k) {
                paramValuesList.remove(k + preParamCnt - 1);
            }
            break;
        }
        return resultStr;
    }

    private static void processBlank(SqlToyResult sqlToyResult) {
        if (null == sqlToyResult.getParamsValue() || sqlToyResult.getParamsValue().length == 0) {
            return;
        }
        String queryStr = sqlToyResult.getSql();
        Matcher m = BLANK_PATTERN.matcher(queryStr);
        int index = 0;
        int paramCnt = 0;
        int blankCnt = 0;
        List paramValueList = null;
        while (m.find()) {
            if (blankCnt == 0) {
                paramValueList = CollectionUtil.arrayToList(sqlToyResult.getParamsValue());
            }
            index = m.start();
            paramCnt = StringUtil.matchCnt(queryStr.substring(0, index), ARG_NAME_PATTERN, 0);
            paramValueList.remove(paramCnt - blankCnt);
            ++blankCnt;
        }
        if (blankCnt > 0) {
            sqlToyResult.setSql(sqlToyResult.getSql().replaceAll(BLANK_REGEX, BLANK));
            sqlToyResult.setParamsValue(paramValueList.toArray());
        }
    }

    private static void processValue(SqlToyResult sqlToyResult, String dialect, boolean hasNotArgRun) {
        if (null == sqlToyResult.getParamsValue() || sqlToyResult.getParamsValue().length == 0) {
            return;
        }
        String queryStr = sqlToyResult.getSql();
        Matcher m = VALUE_PATTERN.matcher(queryStr);
        int index = 0;
        int paramCnt = 0;
        int atValueCnt = 0;
        List paramValueList = null;
        Object paramValue = null;
        int skipAtValueCnt = 0;
        while (m.find()) {
            if (atValueCnt == 0) {
                paramValueList = CollectionUtil.arrayToList(sqlToyResult.getParamsValue());
            }
            index = m.start();
            if (m.group().contains(ARG_NAME)) {
                paramCnt = StringUtil.matchCnt(queryStr.substring(0, index), ARG_NAME_PATTERN, 0);
                paramValue = paramValueList.get(paramCnt - atValueCnt);
                String valueStr = SqlUtil.toSqlString(paramValue, false);
                boolean hasArg = valueStr.contains(ARG_NAME);
                if (!hasArg || !hasNotArgRun) {
                    if (dialect != null && valueStr.contains("(") && valueStr.contains(")")) {
                        valueStr = FunctionUtils.getDialectSql(valueStr, dialect);
                    }
                    sqlToyResult.setSql(StringUtil.replaceRegex(sqlToyResult.getSql(), VALUE_PATTERN, Matcher.quoteReplacement(valueStr), skipAtValueCnt + 1, 6));
                    paramValueList.remove(paramCnt - atValueCnt);
                    ++atValueCnt;
                    continue;
                }
                ++skipAtValueCnt;
                continue;
            }
            sqlToyResult.setSql(StringUtil.replaceRegex(sqlToyResult.getSql(), VALUE_PATTERN, "null", skipAtValueCnt + 1, 6));
        }
        if (atValueCnt > 0) {
            sqlToyResult.setParamsValue(paramValueList.toArray());
        }
    }

    private static String processLoop(String queryStr, String[] paramsNamed, Object[] paramsValue) {
        if (null == paramsValue || paramsValue.length == 0) {
            return queryStr;
        }
        IgnoreKeyCaseMap<String, Object> keyValues = new IgnoreKeyCaseMap<String, Object>();
        for (int i = 0; i < paramsNamed.length; ++i) {
            keyValues.put(paramsNamed[i], paramsValue[i]);
        }
        return MacroUtils.replaceMacros(queryStr, keyValues, null, false, macros, null);
    }

    private static void processLike(SqlToyResult sqlToyResult) {
        if (null == sqlToyResult.getParamsValue() || sqlToyResult.getParamsValue().length == 0) {
            return;
        }
        String queryStr = sqlToyResult.getSql();
        Matcher m = LIKE_PATTERN.matcher(queryStr);
        int index = 0;
        int paramCnt = 0;
        while (m.find()) {
            index = m.start();
            paramCnt = StringUtil.matchCnt(queryStr.substring(0, index), ARG_NAME_PATTERN, 0);
            String likeValStr = sqlToyResult.getParamsValue()[paramCnt] == null ? null : sqlToyResult.getParamsValue()[paramCnt].toString();
            if (null == likeValStr || likeValStr.indexOf("%") != -1) continue;
            sqlToyResult.getParamsValue()[paramCnt] = "%".concat(likeValStr).concat("%");
        }
    }

    private static void processIn(SqlToyResult sqlToyResult) {
        if (null == sqlToyResult.getParamsValue() || sqlToyResult.getParamsValue().length == 0) {
            return;
        }
        int end = 0;
        String queryStr = sqlToyResult.getSql();
        Matcher m = IN_PATTERN.matcher(queryStr);
        boolean matched = m.find(end);
        if (!matched) {
            return;
        }
        int start = 0;
        Object[] paramsValue = sqlToyResult.getParamsValue();
        List paramValueList = CollectionUtil.arrayToList(paramsValue);
        int parameterMarkCnt = 0;
        int incrementIndex = 0;
        StringBuilder lastSql = new StringBuilder();
        String partSql = null;
        Object[] inParamArray = null;
        boolean overSize = false;
        int paramCnt = 0;
        while (matched) {
            end = m.end();
            partSql = ARG_NAME;
            parameterMarkCnt = StringUtil.matchCnt(queryStr, ARG_REGEX, 0, end);
            paramCnt = StringUtil.matchCnt(m.group(), ARG_REGEX);
            overSize = false;
            if (paramCnt > 1) {
                int nullCnt = 0;
                int startIndex = parameterMarkCnt - paramCnt;
                int commTypeCnt = 0;
                for (int i = 0; i < paramCnt; ++i) {
                    if (paramsValue[startIndex + i] == null) {
                        ++nullCnt;
                        ++commTypeCnt;
                        continue;
                    }
                    if (paramsValue[startIndex + i].getClass().isArray() || paramsValue[startIndex + i] instanceof Collection) continue;
                    ++commTypeCnt;
                }
                if (commTypeCnt == paramCnt) {
                    partSql = StringUtil.loopAppendWithSign(ARG_NAME, ",", paramCnt);
                    if (StringUtil.matches(m.group().trim(), "(\\(\\s*){2}") || SqlConfigParseUtils.isMoreFieldIn(queryStr.substring(start, m.start()))) {
                        partSql = "(".concat(partSql).concat(")");
                    }
                } else {
                    if (nullCnt > 0 && nullCnt < paramCnt || commTypeCnt > 0) {
                        throw new IllegalArgumentException("\u591a\u5b57\u6bb5in\u7684:(field1,field2) in (:field1Set,:field2Set) \u5bf9\u5e94\u53c2\u6570\u503c\u975e\u6cd5\uff0c\u8981\u6c42\u662f\u6570\u7ec4\u7c7b\u578b\u4e14\u4e0d\u80fd\u4e3anull!");
                    }
                    String loopArgs = "(".concat(StringUtil.loopAppendWithSign(ARG_NAME, ",", paramCnt)).concat(")");
                    List<Object[]> inParamsList = new ArrayList<Object[]>();
                    for (int i = 0; i < paramCnt; ++i) {
                        inParamArray = paramsValue[startIndex + i] instanceof Collection ? ((Collection)paramsValue[startIndex + i]).toArray() : CollectionUtil.convertArray(paramsValue[startIndex + i]);
                        inParamsList.add(inParamArray);
                        if (i <= 0 || inParamArray.length == inParamsList.get(i - 1).length) continue;
                        throw new IllegalArgumentException("\u591a\u5b57\u6bb5in\u7684:(field1,field2) in (:field1Set,:field2Set) \u6570\u7ec4\u53c2\u6570\u7684\u957f\u5ea6:" + inParamArray.length + "<>" + inParamsList.get(i - 1).length + "!");
                    }
                    int inArgLength = (inParamsList = CollectionUtil.clearRepeat(inParamsList)).get(0).length;
                    if (inArgLength > 1000) {
                        overSize = true;
                        partSql = SqlConfigParseUtils.wrapOverSizeInSql(queryStr.substring(start, m.start()), loopArgs, inArgLength);
                        lastSql.append(BLANK).append(partSql).append(BLANK);
                    } else {
                        partSql = inArgLength == 0 ? "(".concat(StringUtil.loopAppendWithSign("null", ",", paramCnt)).concat(")") : StringUtil.loopAppendWithSign(loopArgs, ",", inArgLength);
                    }
                    for (int i = 0; i < paramCnt; ++i) {
                        paramValueList.remove(startIndex + incrementIndex);
                    }
                    int addIndex = startIndex + incrementIndex;
                    for (int i = 0; i < inArgLength; ++i) {
                        for (int j = 0; j < paramCnt; ++j) {
                            paramValueList.add(addIndex, inParamsList.get(j)[i]);
                            ++addIndex;
                        }
                    }
                    incrementIndex += inArgLength * paramCnt - paramCnt;
                }
            } else if (null != paramsValue[parameterMarkCnt - 1]) {
                String argValue;
                Object inValueObject = paramsValue[parameterMarkCnt - 1];
                if (inValueObject.getClass().isArray() || inValueObject instanceof Collection) {
                    inParamArray = inValueObject instanceof HashSet ? ((HashSet)inValueObject).toArray() : (inValueObject instanceof Collection ? new HashSet((Collection)inValueObject).toArray() : new HashSet<Object>(Arrays.asList(CollectionUtil.convertArray(inValueObject))).toArray());
                    int inArgLength = inParamArray.length;
                    if (inArgLength > 1000) {
                        overSize = true;
                        partSql = SqlConfigParseUtils.wrapOverSizeInSql(queryStr.substring(start, m.start()), ARG_NAME, inArgLength);
                        lastSql.append(BLANK).append(partSql).append(BLANK);
                    } else {
                        partSql = inArgLength == 0 ? "null" : StringUtil.loopAppendWithSign(ARG_NAME, ",", inArgLength);
                    }
                    paramValueList.remove(parameterMarkCnt - 1 + incrementIndex);
                    paramValueList.addAll(parameterMarkCnt - 1 + incrementIndex, CollectionUtil.arrayToList(inParamArray));
                    incrementIndex += inArgLength - 1;
                } else if (paramsValue[parameterMarkCnt - 1] instanceof String && SqlUtil.validateInArg(argValue = (String)paramsValue[parameterMarkCnt - 1])) {
                    partSql = argValue;
                    paramValueList.remove(parameterMarkCnt - 1 + incrementIndex);
                    --incrementIndex;
                }
            }
            if (!overSize) {
                lastSql.append(queryStr.substring(start, m.start())).append(" in (").append(partSql).append(") ");
            }
            start = end;
            matched = m.find(end);
        }
        if (end != 0 && null != partSql) {
            lastSql.append(queryStr.substring(end));
            sqlToyResult.setSql(lastSql.toString());
            sqlToyResult.setParamsValue(paramValueList.toArray());
        }
    }

    private static String wrapOverSizeInSql(String sqlPart, String loopArgs, int paramsSize) {
        String paramName;
        int paramIndex;
        String sql = sqlPart.trim();
        int notIndex = StringUtil.matchIndex(sql.toLowerCase(), NOT_IN_REGEX);
        boolean isNotIn = false;
        if (notIndex > 0) {
            isNotIn = true;
            sql = sql.substring(0, notIndex);
        }
        if ((sql = BLANK.concat(sql)).trim().endsWith(")")) {
            String reverseSql = new StringBuilder(sql).reverse().toString();
            int symIndex = StringUtil.getSymMarkIndex(")", "(", reverseSql, 0);
            int start = sql.length() - symIndex - 1;
            paramIndex = StringUtil.matchLastIndex(sql.substring(0, start), MORE_IN_FIELDS_REGEX) + 1;
            paramName = sql.substring(paramIndex);
        } else {
            paramIndex = StringUtil.matchLastIndex(sql, MORE_IN_FIELDS_REGEX) + 1;
            paramName = sql.substring(paramIndex);
        }
        sql = sql.substring(0, paramIndex);
        StringBuilder result = new StringBuilder(sql);
        result.append(" (");
        int index = 0;
        while (paramsSize > 0) {
            result.append(BLANK);
            if (index > 0) {
                if (isNotIn) {
                    result.append(" and ");
                } else {
                    result.append(" or ");
                }
            }
            result.append(paramName);
            if (isNotIn) {
                result.append(" not in (");
            } else {
                result.append(" in (");
            }
            result.append(StringUtil.loopAppendWithSign(loopArgs, ",", paramsSize > 1000 ? 1000 : paramsSize));
            result.append(") ");
            paramsSize -= 1000;
            ++index;
        }
        result.append(") ");
        return result.toString();
    }

    private static boolean isMoreFieldIn(String sqlPart) {
        String paramName;
        String sql = sqlPart.trim();
        int notIndex = StringUtil.matchIndex(sql.toLowerCase(), NOT_IN_REGEX);
        if (notIndex > 0) {
            sql = sql.substring(0, notIndex);
        }
        if ((sql = BLANK.concat(sql)).trim().endsWith(")")) {
            String reverseSql = new StringBuilder(sql).reverse().toString();
            int symIndex = StringUtil.getSymMarkIndex(")", "(", reverseSql, 0);
            int start = sql.length() - symIndex - 1;
            int paramIndex = StringUtil.matchLastIndex(sql.substring(0, start), MORE_IN_FIELDS_REGEX) + 1;
            paramName = sql.substring(paramIndex);
        } else {
            int paramIndex = StringUtil.matchLastIndex(sql, MORE_IN_FIELDS_REGEX) + 1;
            paramName = sql.substring(paramIndex);
        }
        return paramName.contains(",");
    }

    public static String processWhereLinkAnd(String preSql, String markContentSql, boolean isEndWithAndOr, String tailSql) {
        String subStr = markContentSql.concat(tailSql);
        String tmp = subStr.trim();
        int index = StringUtil.matchIndex(preSql, WHERE_END_PATTERN);
        if (index >= 0) {
            if ("".equals(tmp)) {
                return preSql.substring(0, index + 1).concat(BLANK);
            }
            if (StringUtil.matches(tmp, AND_START_PATTERN)) {
                return preSql.concat(BLANK).concat(subStr.trim().substring(3)).concat(BLANK);
            }
            if (StringUtil.matches(tmp, OR_START_PATTERN)) {
                return preSql.concat(BLANK).concat(subStr.trim().substring(2)).concat(BLANK);
            }
            if ("".equals(markContentSql.trim())) {
                String tailTrim = tailSql.trim();
                if (tailTrim.startsWith(")")) {
                    return preSql.substring(0, index + 1).concat(BLANK).concat(tailSql).concat(BLANK);
                }
                if (StringUtil.matches(tailTrim.toLowerCase(), WHERE_CLOSE_PATTERN)) {
                    return preSql.substring(0, index + 1).concat(BLANK).concat(tailSql).concat(BLANK);
                }
                if (isEndWithAndOr) {
                    return preSql.concat(BLANK).concat(tailSql).concat(BLANK);
                }
                return preSql.concat(" 1=1 ").concat(tailSql).concat(BLANK);
            }
        }
        if ((index = StringUtil.matchIndex(preSql, WHERE_ONE_EQUAL_PATTERN)) >= 0) {
            if (StringUtil.matches(tmp, AND_START_PATTERN)) {
                return preSql.substring(0, index + 1).concat(" where ").concat(subStr.trim().substring(3)).concat(BLANK);
            }
            if (StringUtil.matches(tmp, OR_START_PATTERN)) {
                return preSql.substring(0, index + 1).concat(" where ").concat(subStr.trim().substring(2)).concat(BLANK);
            }
            if (tmp.startsWith(")")) {
                return preSql.substring(0, index + 1).concat(subStr).concat(BLANK);
            }
            if (StringUtil.matches(tmp.toLowerCase(), WHERE_CLOSE_PATTERN)) {
                return preSql.substring(0, index + 1).concat(subStr).concat(BLANK);
            }
            if (!"".equals(markContentSql.trim())) {
                if (StringUtil.matches(tmp, BLANK_START_PATTERN)) {
                    return preSql.concat(BLANK).concat(subStr).concat(BLANK);
                }
                return preSql.substring(0, index + 1).concat(" where ").concat(subStr).concat(BLANK);
            }
        }
        if (StringUtil.matches(preSql, UPDATE_SET_PATTERN) && tmp.startsWith(",")) {
            return preSql.concat(BLANK).concat(subStr.trim().substring(1)).concat(BLANK);
        }
        return preSql.concat(BLANK).concat(subStr);
    }

    public static void replaceNull(SqlToyResult sqlToyResult, int afterParamIndex) {
        if (null == sqlToyResult.getParamsValue()) {
            return;
        }
        String sql = sqlToyResult.getSql().concat(BLANK);
        int index = StringUtil.indexOrder(sql, ARG_NAME, afterParamIndex);
        if (index == -1) {
            return;
        }
        List paramList = CollectionUtil.arrayToList(sqlToyResult.getParamsValue());
        for (int i = 0; i < paramList.size(); ++i) {
            if (null == paramList.get(i)) {
                String preSql = sql.substring(0, index);
                String tailSql = sql.substring(index + 1);
                int compareIndex = StringUtil.matchIndex(preSql, NOT_EQUAL_PATTERN);
                String sqlPart = " is not ";
                if (compareIndex == -1) {
                    compareIndex = StringUtil.matchIndex(preSql, EQUAL_PATTERN);
                    if (compareIndex != -1 && (StringUtil.matches(preSql, UPDATE_EQUAL_PATTERN) || !StringUtil.matches(preSql.concat(BLANK), WHERE_PATTERN))) {
                        compareIndex = -1;
                    }
                    if (compareIndex != -1) {
                        ++compareIndex;
                    }
                    sqlPart = " is ";
                }
                if (compareIndex != -1) {
                    preSql = preSql.substring(0, compareIndex).concat(sqlPart);
                }
                sql = preSql.concat("null").concat(tailSql);
                paramList.remove(i);
                --i;
                index = sql.indexOf(ARG_NAME, index);
                continue;
            }
            index = sql.indexOf(ARG_NAME, index + 1);
        }
        sqlToyResult.setSql(sql);
        sqlToyResult.setParamsValue(paramList.toArray());
    }

    public static SqlToyConfig parseSqlToyConfig(String querySql, String dialect, SqlType sqlType) {
        SqlToyConfig sqlToyConfig = new SqlToyConfig(dialect);
        if (StringUtil.matches(querySql, SqlToyConstants.NOT_PRINT_REGEX)) {
            sqlToyConfig.setShowSql(false);
        } else if (StringUtil.matches(querySql, SqlToyConstants.DO_PRINT_REGEX)) {
            sqlToyConfig.setShowSql(true);
        }
        sqlToyConfig.setIgnoreEmpty(StringUtil.matches(querySql, SqlToyConstants.IGNORE_EMPTY_REGEX));
        String originalSql = SqlUtil.clearMistyChars(SqlUtil.clearMark(querySql), BLANK).concat(BLANK);
        originalSql = FunctionUtils.getDialectSql(originalSql, dialect);
        originalSql = ReservedWordsUtil.convertSql(originalSql, DataSourceUtils.getDBType(dialect));
        sqlToyConfig.setHasWith(SqlConfigParseUtils.hasWith(originalSql));
        sqlToyConfig.setHasUnion(SqlUtil.hasUnion(originalSql, false));
        if (SqlType.search.equals((Object)sqlType)) {
            Matcher matcher = FAST_PATTERN.matcher(originalSql);
            if (matcher.find()) {
                int start = matcher.start();
                String preSql = originalSql.substring(0, start);
                String matchedFastSql = matcher.group();
                int endMarkIndex = StringUtil.getSymMarkIndex("(", ")", matchedFastSql, 0);
                String fastSql = matchedFastSql.substring(matchedFastSql.indexOf("(") + 1, endMarkIndex);
                String tailSql = originalSql.substring(start + endMarkIndex + 1);
                if (preSql.trim().endsWith("(") && tailSql.trim().startsWith(")")) {
                    sqlToyConfig.setSql(preSql.concat(fastSql).concat(tailSql));
                    sqlToyConfig.setIgnoreBracket(true);
                } else {
                    sqlToyConfig.setSql(preSql.concat(" (").concat(fastSql).concat(") ").concat(tailSql));
                }
                sqlToyConfig.setFastSql(fastSql);
                sqlToyConfig.setFastPreSql(preSql);
                sqlToyConfig.setFastTailSql(tailSql);
                sqlToyConfig.setHasFast(true);
            } else {
                sqlToyConfig.setSql(originalSql);
            }
        } else {
            sqlToyConfig.setSql(originalSql);
        }
        sqlToyConfig.setSqlType(sqlType);
        SqlConfigParseUtils.processFastWith(sqlToyConfig, dialect);
        sqlToyConfig.setParamsName(SqlConfigParseUtils.getSqlParamsName(sqlToyConfig.getSql(dialect), true));
        return sqlToyConfig;
    }

    public static void processFastWith(SqlToyConfig sqlToyConfig, String dialect) {
        if (!sqlToyConfig.isHasFast() || !sqlToyConfig.isHasWith()) {
            return;
        }
        SqlWithAnalysis sqlWith = new SqlWithAnalysis(sqlToyConfig.getSql(dialect));
        if (null != sqlWith.getWithSqlSet()) {
            String[] aliasTableAs;
            int endIndex = -1;
            int withSqlSize = sqlWith.getWithSqlSet().size();
            for (int i = withSqlSize - 1; i >= 0; --i) {
                aliasTableAs = sqlWith.getWithSqlSet().get(i);
                if (!StringUtil.matches(sqlToyConfig.getFastSql(dialect).concat(BLANK), "\\W".concat(aliasTableAs[0]).concat("\\W"))) continue;
                endIndex = i;
                sqlToyConfig.setFastWithIndex(endIndex);
                break;
            }
            if (endIndex != -1) {
                if (endIndex == withSqlSize - 1) {
                    sqlToyConfig.setFastWithSql(sqlWith.getWithSql());
                } else {
                    StringBuilder buffer = new StringBuilder();
                    for (int i = 0; i < endIndex + 1; ++i) {
                        aliasTableAs = sqlWith.getWithSqlSet().get(i);
                        if (i == 0) {
                            buffer.append(" with ").append(aliasTableAs[3]);
                        }
                        if (i > 0) {
                            buffer.append(" , ").append(aliasTableAs[3]);
                        }
                        buffer.append(BLANK);
                        buffer.append(aliasTableAs[0]).append(aliasTableAs[4]).append(" as ").append(aliasTableAs[1]).append(" ( ").append(aliasTableAs[2]).append(" ) ");
                    }
                    sqlToyConfig.setFastWithSql(buffer.toString());
                }
            }
        }
    }

    public static String processIfLogic(String contentSql, String startMark, String endMark, Pattern namedPattern, List paramsList, String preSql, int preParamsCnt, int ifLogicCnt, int offset, int sqlParamType) {
        if (ifLogicCnt == 0) {
            return contentSql;
        }
        ArrayList<IfLogicModel> ifLogicModelAry = new ArrayList<IfLogicModel>();
        String fullIfSql = startMark.concat(contentSql).concat(endMark);
        int preParamsAccount = preParamsCnt;
        boolean logicResult = false;
        int startMarkLenght = startMark.length();
        int endMarkLength = endMark.length();
        int logicType = 0;
        String realStartMark = startMark.equals(SQL_PSEUDO_START_MARK) ? SQL_PSEUDO_SYM_START_MARK : startMark;
        for (int i = 0; i < ifLogicCnt; ++i) {
            logicType = 0;
            IfLogicModel ifLogicModel = new IfLogicModel();
            int start = fullIfSql.indexOf(startMark);
            int end = StringUtil.getSymMarkIndex(realStartMark, endMark, fullIfSql, 0);
            if (start == -1 || end == -1) break;
            String sqlPart = fullIfSql.substring(start + startMarkLenght, end);
            ifLogicModel.setPreParamsCnt(preParamsAccount);
            ifLogicModel.setParamsCnt(StringUtil.matchCnt(sqlPart, namedPattern, offset));
            preParamsAccount += ifLogicModel.getParamsCnt();
            int ifStart = StringUtil.matchIndex(sqlPart, START_IF_PATTERN);
            if (ifStart >= 0) {
                logicType = 1;
            } else {
                ifStart = StringUtil.matchIndex(sqlPart, START_ELSEIF_PATTERN);
                if (ifStart >= 0) {
                    logicType = 2;
                } else {
                    ifStart = StringUtil.matchIndex(sqlPart, START_ELSE_PATTERN);
                    if (ifStart >= 0) {
                        logicType = 3;
                    } else {
                        ifStart = StringUtil.matchIndex(sqlPart, IF_PATTERN);
                        if (ifStart >= 0 && ifLogicCnt == 1) {
                            logicType = 1;
                        }
                    }
                }
            }
            ifLogicModel.setType(logicType);
            if (logicType == 1 || logicType == 2) {
                int ifEnd = StringUtil.getSymMarkIndex("(", ")", sqlPart, ifStart);
                ifLogicModel.setLogicExpression(sqlPart.substring(sqlPart.indexOf("(", ifStart) + 1, ifEnd));
                sqlPart = ifLogicCnt == 1 && logicType == 1 ? sqlPart.substring(0, ifStart).concat(sqlPart.substring(ifEnd + 1)) : sqlPart.substring(ifEnd + 1);
                ifLogicModel.setLogicParamsCnt(StringUtil.matchCnt(ifLogicModel.getLogicExpression(), namedPattern, offset));
            } else if (logicType == 3) {
                int[] indexes = StringUtil.matchIndex(sqlPart, ELSE_PATTERN, 0);
                sqlPart = sqlPart.substring(indexes[1]);
                ifLogicModel.setLogicExpression("");
                ifLogicModel.setLogicParamsCnt(0);
            }
            ifLogicModel.setSqlPart(sqlPart);
            if (!logicResult) {
                boolean evalValue;
                if (logicType == 3) {
                    logicResult = true;
                    ifLogicModel.setLogicResult(true);
                } else if ((logicType == 1 || logicType == 2) && (evalValue = MacroIfLogic.evalLogic(ifLogicModel.getLogicExpression(), paramsList, ifLogicModel.getPreParamsCnt(), ifLogicModel.getLogicParamsCnt(), sqlParamType))) {
                    ifLogicModel.setLogicResult(true);
                    logicResult = true;
                }
            }
            if (logicType <= 0) break;
            ifLogicModelAry.add(ifLogicModel);
            fullIfSql = fullIfSql.substring(end + endMarkLength);
        }
        String resultSql = BLANK;
        for (int j = ifLogicModelAry.size(); j > 0; --j) {
            int k;
            IfLogicModel ifLogicModel = (IfLogicModel)ifLogicModelAry.get(j - 1);
            if (!ifLogicModel.isLogicResult()) {
                for (k = ifLogicModel.getParamsCnt(); k > 0; --k) {
                    paramsList.remove(k + ifLogicModel.getPreParamsCnt() - 1);
                }
                continue;
            }
            resultSql = ifLogicModel.getSqlPart();
            for (k = 0; k < ifLogicModel.getLogicParamsCnt(); ++k) {
                paramsList.remove(ifLogicModel.getPreParamsCnt());
            }
        }
        return resultSql;
    }

    static {
        macros.put("@loop", new SqlLoop(true));
        macros.put("@loop-full", new SqlLoop(false));
    }
}

