/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.config;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.sagacity.sqltoy.SqlToyConstants;
import org.sagacity.sqltoy.config.SqlConfigParseUtils;
import org.sagacity.sqltoy.config.model.CacheFilterModel;
import org.sagacity.sqltoy.config.model.ColsChainRelativeModel;
import org.sagacity.sqltoy.config.model.FieldTranslate;
import org.sagacity.sqltoy.config.model.FormatModel;
import org.sagacity.sqltoy.config.model.LinkModel;
import org.sagacity.sqltoy.config.model.NoSqlConfigModel;
import org.sagacity.sqltoy.config.model.PageOptimize;
import org.sagacity.sqltoy.config.model.ParamFilterModel;
import org.sagacity.sqltoy.config.model.PivotModel;
import org.sagacity.sqltoy.config.model.ReverseModel;
import org.sagacity.sqltoy.config.model.RowsChainRelativeModel;
import org.sagacity.sqltoy.config.model.SecureMask;
import org.sagacity.sqltoy.config.model.ShardingStrategyConfig;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.config.model.SqlType;
import org.sagacity.sqltoy.config.model.SummaryGroupMeta;
import org.sagacity.sqltoy.config.model.SummaryModel;
import org.sagacity.sqltoy.config.model.Translate;
import org.sagacity.sqltoy.config.model.TreeSortModel;
import org.sagacity.sqltoy.config.model.UnpivotModel;
import org.sagacity.sqltoy.dialect.utils.PageOptimizeUtils;
import org.sagacity.sqltoy.model.IgnoreCaseSet;
import org.sagacity.sqltoy.model.TimeUnit;
import org.sagacity.sqltoy.plugins.function.FunctionUtils;
import org.sagacity.sqltoy.utils.DataSourceUtils;
import org.sagacity.sqltoy.utils.NumberUtil;
import org.sagacity.sqltoy.utils.ReservedWordsUtil;
import org.sagacity.sqltoy.utils.SqlUtil;
import org.sagacity.sqltoy.utils.StringUtil;
import org.sagacity.sqltoy.utils.XMLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SqlXMLConfigParse {
    protected static final Logger logger = LoggerFactory.getLogger(SqlXMLConfigParse.class);
    private static final Pattern ES_AGGS_PATTERN = Pattern.compile("(?i)\\W(\"|')(aggregations|aggs)(\"|')\\s*\\:\\s*\\{");
    private static final Pattern MONGO_AGGS_PATTERN = Pattern.compile("(?i)\\$group\\s*\\:");
    private static final Pattern GROUP_BY_PATTERN = Pattern.compile("(?i)\\Wgroup\\s+by\\W");
    private static DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
    private static String[] WHERE_COMPARE = new String[]{"!=", "==", "=", " in ", " out ", " neq ", " eq "};
    private static String[] WHERE_COMPARE_TYPES = new String[]{"neq", "eq", "eq", "in", "out", "neq", "eq"};
    private static String[] WHERE_SPLIT_REGEX = new String[]{"\\!\\=", "\\=\\=", "\\=", "\\s+in\\s+", "\\s+out\\s+", "\\s+neq\\s+", "\\s+eq\\s+"};
    public static HashMap<String, String> filters = new HashMap<String, String>(){
        private static final long serialVersionUID = 1636155921862321269L;
        {
            this.put("[", "]");
            this.put("{", "}");
        }
    };

    public static void parseXML(List xmlFiles, ConcurrentHashMap<String, Long> filesLastModifyMap, ConcurrentHashMap<String, SqlToyConfig> cache, String encoding, String dialect) throws Exception {
        if (xmlFiles == null || xmlFiles.isEmpty()) {
            return;
        }
        boolean isDebug = logger.isDebugEnabled();
        for (int i = 0; i < xmlFiles.size(); ++i) {
            Object resource = xmlFiles.get(i);
            if (!(resource instanceof File)) continue;
            File sqlFile = (File)resource;
            String fileName = sqlFile.getName();
            Long lastModified = sqlFile.lastModified();
            Long preModified = filesLastModifyMap.get(fileName);
            if (preModified != null && lastModified <= preModified) continue;
            filesLastModifyMap.put(fileName, lastModified);
            if (isDebug) {
                logger.debug("sql\u6587\u4ef6:{}\u5df2\u7ecf\u88ab\u4fee\u6539,\u8fdb\u884c\u91cd\u65b0\u89e3\u6790!", (Object)fileName);
            } else {
                System.out.println("sql\u6587\u4ef6:" + fileName + " \u5df2\u7ecf\u88ab\u4fee\u6539,\u8fdb\u884c\u91cd\u65b0\u89e3\u6790!");
            }
            SqlXMLConfigParse.parseSingleFile(sqlFile, filesLastModifyMap, cache, encoding, dialect, true, -1);
        }
    }

    public static List<String> parseSingleFile(Object xmlFile, ConcurrentHashMap<String, Long> filesLastModifyMap, ConcurrentHashMap<String, SqlToyConfig> cache, String encoding, String dialect, boolean isReload, int index) throws Exception {
        ArrayList<String> repeatSql = new ArrayList<String>();
        try (InputStream fileIS = null;){
            String sqlFile;
            if (xmlFile instanceof File) {
                File file = (File)xmlFile;
                sqlFile = file.getName();
                filesLastModifyMap.put(sqlFile, file.lastModified());
                fileIS = new FileInputStream(file);
            } else {
                sqlFile = (String)xmlFile;
                fileIS = SqlXMLConfigParse.getResourceAsStream(sqlFile);
            }
            logger.debug("\u6b63\u5728\u89e3\u6790".concat(index != -1 ? "\u7b2c:[" + index + "]\u4e2a" : "").concat("sql\u6587\u4ef6:").concat(sqlFile));
            if (fileIS != null) {
                domFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
                Document doc = domBuilder.parse(fileIS);
                NodeList sqlElts = doc.getDocumentElement().getChildNodes();
                if (sqlElts == null || sqlElts.getLength() == 0) {
                    ArrayList<String> arrayList = repeatSql;
                    return arrayList;
                }
                for (int i = 0; i < sqlElts.getLength(); ++i) {
                    Element sqlElt;
                    SqlToyConfig sqlToyConfig;
                    Node obj = sqlElts.item(i);
                    if (obj.getNodeType() != 1 || (sqlToyConfig = SqlXMLConfigParse.parseSingleSql(sqlElt = (Element)obj, dialect)) == null) continue;
                    if (cache.containsKey(sqlToyConfig.getId())) {
                        repeatSql.add(StringUtil.fillArgs("sql\u6587\u4ef6:{} \u4e2d\u53d1\u73b0\u91cd\u590d\u7684SQL\u8bed\u53e5id={} \u5df2\u7ecf\u88ab\u8986\u76d6!", sqlFile, sqlToyConfig.getId()));
                        if (isReload) {
                            PageOptimizeUtils.remove(sqlToyConfig.getId());
                        }
                    }
                    cache.put(sqlToyConfig.getId(), sqlToyConfig);
                }
            }
        }
        return repeatSql;
    }

    public static SqlToyConfig parseSagment(Object sqlSegment, String encoding, String dialect) throws Exception {
        Element elt = null;
        if (sqlSegment instanceof String) {
            Document doc = domFactory.newDocumentBuilder().parse(new ByteArrayInputStream(((String)sqlSegment).getBytes(encoding == null ? "UTF-8" : encoding)));
            elt = doc.getDocumentElement();
        } else if (sqlSegment instanceof Element) {
            elt = (Element)sqlSegment;
        }
        if (elt == null) {
            logger.error("sqlSegment type must is String or org.w3c.dom.Element!");
            throw new IllegalArgumentException("sqlSegment type must is String or org.w3c.dom.Element!");
        }
        return SqlXMLConfigParse.parseSingleSql(elt, dialect);
    }

    private static String getElementPrefixName(Element sqlElement) {
        NodeList nodeList = sqlElement.getChildNodes();
        String nodeName = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            nodeName = node.getNodeName();
            int index = nodeName.indexOf(":");
            if (index > 0) {
                nodeName = nodeName.substring(0, index);
                break;
            }
            nodeName = null;
            break;
        }
        return nodeName;
    }

    public static SqlToyConfig parseSingleSql(Element sqlElt, String dialect) throws Exception {
        String realDialect = dialect;
        String nodeName = sqlElt.getNodeName().toLowerCase();
        int prefixIndex = nodeName.indexOf(":");
        if (prefixIndex > 0) {
            nodeName = nodeName.substring(prefixIndex + 1);
        }
        if (!("sql".equals(nodeName) || "eql".equals(nodeName) || "mql".equals(nodeName))) {
            return null;
        }
        String id = sqlElt.getAttribute("id");
        if (id == null) {
            throw new RuntimeException("\u8bf7\u68c0\u67e5sql\u914d\u7f6e,\u6ca1\u6709\u7ed9\u5b9asql\u5bf9\u5e94\u7684 id\u503c!");
        }
        String localName = SqlXMLConfigParse.getElementPrefixName(sqlElt);
        String local = StringUtil.isBlank(localName) ? "" : localName.concat(":");
        NodeList nodeList = sqlElt.getElementsByTagName(local.concat("value"));
        String sqlContent = null;
        sqlContent = nodeList.getLength() > 0 ? StringUtil.trim(nodeList.item(0).getTextContent()) : StringUtil.trim(sqlElt.getTextContent());
        if (StringUtil.isBlank(sqlContent)) {
            throw new RuntimeException("\u8bf7\u68c0\u67e5sql-id='" + id + "' \u7684\u914d\u7f6e,\u6ca1\u6709\u6b63\u786e\u586b\u5199sql\u5185\u5bb9!");
        }
        nodeList = sqlElt.getElementsByTagName(local.concat("count-sql"));
        String countSql = null;
        if (nodeList.getLength() > 0) {
            countSql = StringUtil.trim(nodeList.item(0).getTextContent());
        }
        sqlContent = sqlContent.replaceAll("\u3000", " ");
        if (countSql != null) {
            countSql = countSql.replaceAll("\u3000", " ");
        }
        SqlType sqlType = sqlElt.hasAttribute("type") ? SqlType.getSqlType(sqlElt.getAttribute("type")) : SqlType.search;
        boolean isNoSql = false;
        if ("mql".equals(nodeName) || "eql".equals(nodeName)) {
            if ("mql".equals(nodeName)) {
                realDialect = "mongo";
            } else if ("eql".equals(nodeName)) {
                realDialect = "elastic";
            }
            isNoSql = true;
        }
        SqlToyConfig sqlToyConfig = SqlConfigParseUtils.parseSqlToyConfig(sqlContent, realDialect, sqlType);
        if (StringUtil.matches(sqlContent, SqlToyConstants.INCLUDE_PATTERN)) {
            sqlToyConfig.setHasIncludeSql(true);
        }
        if (sqlElt.hasAttribute("debug")) {
            sqlToyConfig.setShowSql(Boolean.valueOf(sqlElt.getAttribute("debug")));
        }
        sqlToyConfig.setId(id);
        if (sqlElt.hasAttribute("dataSource")) {
            sqlToyConfig.setDataSource(sqlElt.getAttribute("dataSource"));
        } else if (sqlElt.hasAttribute("datasource")) {
            sqlToyConfig.setDataSource(sqlElt.getAttribute("datasource"));
        }
        if (countSql != null) {
            countSql = SqlUtil.clearMistyChars(SqlUtil.clearMark(countSql), " ").concat(" ");
            countSql = FunctionUtils.getDialectSql(countSql, dialect);
            countSql = ReservedWordsUtil.convertSql(countSql, DataSourceUtils.getDBType(dialect));
            sqlToyConfig.setCountSql(countSql);
            if (StringUtil.matches(countSql, SqlToyConstants.INCLUDE_PATTERN)) {
                sqlToyConfig.setHasIncludeSql(true);
            }
        }
        if (sqlElt.hasAttribute("union-all-count")) {
            sqlToyConfig.setUnionAllCount(Boolean.parseBoolean(sqlElt.getAttribute("union-all-count")));
        }
        SqlXMLConfigParse.parseShardingDataSource(sqlToyConfig, sqlElt.getElementsByTagName(local.concat("sharding-datasource")));
        SqlXMLConfigParse.parseShardingTables(sqlToyConfig, sqlElt.getElementsByTagName(local.concat("sharding-table")));
        SqlXMLConfigParse.parseFormat(sqlToyConfig, sqlElt.getElementsByTagName(local.concat("date-format")), sqlElt.getElementsByTagName(local.concat("number-format")));
        int blankToNull = -1;
        if (sqlElt.hasAttribute("blank-to-null")) {
            int n = blankToNull = Boolean.parseBoolean(sqlElt.getAttribute("blank-to-null")) ? 1 : 0;
        }
        if ((nodeList = sqlElt.getElementsByTagName(local.concat("filters"))).getLength() > 0) {
            SqlXMLConfigParse.parseFilters(sqlToyConfig, nodeList.item(0).getChildNodes(), blankToNull, local);
        } else if (SqlType.search.equals((Object)sqlType) || SqlToyConstants.executeSqlBlankToNull) {
            SqlXMLConfigParse.parseFilters(sqlToyConfig, null, blankToNull, local);
        }
        nodeList = sqlElt.getElementsByTagName(local.concat("page-optimize"));
        if (nodeList.getLength() > 0) {
            PageOptimize optimize = new PageOptimize();
            Element pageOptimize = (Element)nodeList.item(0);
            if (pageOptimize.hasAttribute("alive-max")) {
                optimize.aliveMax(Integer.parseInt(pageOptimize.getAttribute("alive-max")));
            }
            if (pageOptimize.hasAttribute("alive-seconds")) {
                optimize.aliveSeconds(Integer.parseInt(pageOptimize.getAttribute("alive-seconds")));
            }
            if (pageOptimize.hasAttribute("parallel")) {
                optimize.parallel(Boolean.parseBoolean(pageOptimize.getAttribute("parallel")));
            }
            if (pageOptimize.hasAttribute("parallel-maxwait-seconds")) {
                optimize.parallelMaxWaitSeconds(Long.parseLong(pageOptimize.getAttribute("parallel-maxwait-seconds")));
            }
            if (pageOptimize.hasAttribute("skip-zero-count")) {
                optimize.skipZeroCount(Boolean.parseBoolean(pageOptimize.getAttribute("skip-zero-count")));
            }
            sqlToyConfig.setPageOptimize(optimize);
        }
        SqlXMLConfigParse.parseTranslate(sqlToyConfig, sqlElt.getElementsByTagName(local.concat("translate")));
        SqlXMLConfigParse.parseLink(sqlToyConfig, sqlElt.getElementsByTagName(local.concat("link")), local);
        SqlXMLConfigParse.parseCalculator(sqlToyConfig, sqlElt, local);
        SqlXMLConfigParse.parseSecureDecrypt(sqlToyConfig, sqlElt.getElementsByTagName(local.concat("secure-decrypt")));
        SqlXMLConfigParse.parseSecureMask(sqlToyConfig, sqlElt.getElementsByTagName(local.concat("secure-mask")));
        if (isNoSql) {
            SqlXMLConfigParse.parseNoSql(sqlToyConfig, sqlElt, local);
        }
        return sqlToyConfig;
    }

    private static void parseNoSql(SqlToyConfig sqlToyConfig, Element sqlElt, String local) {
        NoSqlConfigModel noSqlConfig = new NoSqlConfigModel();
        if (sqlElt.hasAttribute("collection")) {
            noSqlConfig.setCollection(sqlElt.getAttribute("collection"));
        }
        if (sqlElt.hasAttribute("url")) {
            noSqlConfig.setEndpoint(SqlToyConstants.replaceParams(sqlElt.getAttribute("url")));
        } else if (sqlElt.hasAttribute("end-point")) {
            noSqlConfig.setEndpoint(SqlToyConstants.replaceParams(sqlElt.getAttribute("end-point")));
        } else if (sqlElt.hasAttribute("endpoint")) {
            noSqlConfig.setEndpoint(SqlToyConstants.replaceParams(sqlElt.getAttribute("endpoint")));
        }
        if (sqlElt.hasAttribute("index")) {
            noSqlConfig.setIndex(sqlElt.getAttribute("index"));
        }
        if (sqlElt.hasAttribute("type")) {
            noSqlConfig.setType(sqlElt.getAttribute("type"));
        }
        if (sqlElt.hasAttribute("request-timeout")) {
            noSqlConfig.setRequestTimeout(Integer.parseInt(sqlElt.getAttribute("request-timeout")));
        }
        if (sqlElt.hasAttribute("connection-timeout")) {
            noSqlConfig.setConnectTimeout(Integer.parseInt(sqlElt.getAttribute("connection-timeout")));
        }
        if (sqlElt.hasAttribute("socket-timeout")) {
            noSqlConfig.setSocketTimeout(Integer.parseInt(sqlElt.getAttribute("socket-timeout")));
        }
        if (sqlElt.hasAttribute("charset")) {
            noSqlConfig.setCharset(sqlElt.getAttribute("charset"));
        }
        if (sqlElt.hasAttribute("fields")) {
            if (StringUtil.isNotBlank(sqlElt.getAttribute("fields"))) {
                noSqlConfig.setFields(SqlXMLConfigParse.splitFields(sqlElt.getAttribute("fields")));
            }
        } else {
            NodeList nodeList = sqlElt.getElementsByTagName(local.concat("fields"));
            if (nodeList.getLength() > 0) {
                noSqlConfig.setFields(SqlXMLConfigParse.splitFields(nodeList.item(0).getTextContent()));
            }
        }
        if (sqlElt.hasAttribute("value-root")) {
            noSqlConfig.setValueRoot(StringUtil.trimArray(sqlElt.getAttribute("value-root").split("\\,")));
        } else if (sqlElt.hasAttribute("value-path")) {
            noSqlConfig.setValueRoot(StringUtil.trimArray(sqlElt.getAttribute("value-path").split("\\,")));
        }
        String nodeName = sqlElt.getNodeName().toLowerCase();
        if ("eql".equals(nodeName)) {
            String sql = sqlToyConfig.getSql(null);
            if (sqlElt.hasAttribute("aggregate")) {
                noSqlConfig.setHasAggs(Boolean.parseBoolean(sqlElt.getAttribute("aggregate")));
            } else if (sqlElt.hasAttribute("is-aggregate")) {
                noSqlConfig.setHasAggs(Boolean.parseBoolean(sqlElt.getAttribute("is-aggregate")));
            } else {
                noSqlConfig.setHasAggs(StringUtil.matches(sql, ES_AGGS_PATTERN));
            }
            if (StringUtil.matches(sql.trim(), "(?i)^select\\W")) {
                noSqlConfig.setSqlMode(true);
                if (StringUtil.matches(sql, "(?i)\\Wfrom\\W") && StringUtil.matches(sql, GROUP_BY_PATTERN)) {
                    noSqlConfig.setHasAggs(true);
                }
            }
        } else if ("mql".equals(nodeName)) {
            if (sqlElt.hasAttribute("aggregate")) {
                noSqlConfig.setHasAggs(Boolean.parseBoolean(sqlElt.getAttribute("aggregate")));
            } else if (sqlElt.hasAttribute("is-aggregate")) {
                noSqlConfig.setHasAggs(Boolean.parseBoolean(sqlElt.getAttribute("is-aggregate")));
            } else {
                noSqlConfig.setHasAggs(StringUtil.matches(sqlToyConfig.getSql(null), MONGO_AGGS_PATTERN));
            }
        }
        sqlToyConfig.setNoSqlConfigModel(noSqlConfig);
        if (!noSqlConfig.isSqlMode()) {
            sqlToyConfig.setParamsName(SqlConfigParseUtils.getNoSqlParamsName(sqlToyConfig.getSql(null), true));
        }
    }

    public static void parseSecureDecrypt(SqlToyConfig sqlToyConfig, NodeList decryptElts) {
        if (decryptElts == null || decryptElts.getLength() == 0) {
            return;
        }
        Element decryptElt = (Element)decryptElts.item(0);
        if (decryptElt.hasAttribute("columns")) {
            String[] columns = StringUtil.trimArray(decryptElt.getAttribute("columns").toLowerCase().split("\\,"));
            IgnoreCaseSet decryptColumns = new IgnoreCaseSet();
            for (String col : columns) {
                decryptColumns.add(col);
            }
            sqlToyConfig.setDecryptColumns(decryptColumns);
        }
    }

    public static void parseSecureMask(SqlToyConfig sqlToyConfig, NodeList maskElts) {
        if (maskElts == null || maskElts.getLength() == 0) {
            return;
        }
        ArrayList<SecureMask> secureMasks = new ArrayList<SecureMask>();
        for (int i = 0; i < maskElts.getLength(); ++i) {
            Element elt = (Element)maskElts.item(i);
            String tmp = SqlXMLConfigParse.getAttrValue(elt, "columns");
            if (tmp == null) {
                tmp = SqlXMLConfigParse.getAttrValue(elt, "column");
            }
            String[] columns = StringUtil.trimArray(tmp.toLowerCase().split("\\,"));
            String type = SqlXMLConfigParse.getAttrValue(elt, "type").toLowerCase();
            String maskCode = SqlXMLConfigParse.getAttrValue(elt, "mask-code");
            String headSize = SqlXMLConfigParse.getAttrValue(elt, "head-size");
            String tailSize = SqlXMLConfigParse.getAttrValue(elt, "tail-size");
            String maskRate = SqlXMLConfigParse.getAttrValue(elt, "mask-rate");
            if (maskRate == null) {
                maskRate = SqlXMLConfigParse.getAttrValue(elt, "mask-percent");
            }
            if (maskRate != null) {
                maskRate = maskRate.replace("%", "").trim();
            }
            for (String col : columns) {
                SecureMask secureMask = new SecureMask();
                secureMask.setColumn(col);
                secureMask.setType(type);
                secureMask.setMaskCode(maskCode);
                if (secureMask.getMaskCode() == null) {
                    if ("id-card".equals(secureMask.getType()) || "bank-card".equals(secureMask.getType()) || "email".equals(secureMask.getType()) || "address".equals(secureMask.getType())) {
                        secureMask.setMaskCode("******");
                    } else if ("name".equals(secureMask.getType())) {
                        secureMask.setMaskCode("**");
                    } else {
                        secureMask.setMaskCode("****");
                    }
                }
                if (StringUtil.isNotBlank(headSize)) {
                    secureMask.setHeadSize(Integer.parseInt(headSize));
                }
                if (StringUtil.isNotBlank(tailSize)) {
                    secureMask.setTailSize(Integer.parseInt(tailSize));
                }
                if (StringUtil.isNotBlank(maskRate)) {
                    if (Double.parseDouble(maskRate) < 1.0) {
                        secureMask.setMaskRate(Double.valueOf(Double.parseDouble(maskRate) * 100.0).intValue());
                    } else {
                        secureMask.setMaskRate(Double.valueOf(maskRate).intValue());
                    }
                }
                secureMasks.add(secureMask);
            }
        }
        sqlToyConfig.setSecureMasks(secureMasks);
    }

    private static String getAttrValue(Element elt, String attrName) {
        if (elt.hasAttribute(attrName)) {
            return elt.getAttribute(attrName);
        }
        return null;
    }

    private static void parseShardingDataSource(SqlToyConfig sqlToyConfig, NodeList shardingDBNode) {
        if (shardingDBNode == null || shardingDBNode.getLength() == 0) {
            return;
        }
        Element shardingDataSource = (Element)shardingDBNode.item(0);
        ShardingStrategyConfig shardingConfig = new ShardingStrategyConfig(0);
        if (shardingDataSource.hasAttribute("strategy-value")) {
            shardingConfig.setDecisionType(shardingDataSource.getAttribute("strategy-value"));
        } else if (shardingDataSource.hasAttribute("strategy-type")) {
            shardingConfig.setDecisionType(shardingDataSource.getAttribute("strategy-type"));
        } else if (shardingDataSource.hasAttribute("decision-type")) {
            shardingConfig.setDecisionType(shardingDataSource.getAttribute("decision-type"));
        }
        ArrayList<String> params = new ArrayList<String>();
        if (shardingDataSource.hasAttribute("params")) {
            String[] fields = shardingDataSource.getAttribute("params").replace(";", ",").toLowerCase().split("\\,");
            int size = fields.length;
            String[] paramsAlias = new String[size];
            for (int i = 0; i < size; ++i) {
                String[] paramName = fields[i].split("\\:");
                fields[i] = paramName[0].trim();
                if (!params.contains(fields[i])) {
                    params.add(fields[i]);
                }
                paramsAlias[i] = paramName[paramName.length - 1].trim();
            }
            shardingConfig.setFields(fields);
            shardingConfig.setAliasNames(paramsAlias);
        }
        if (!params.isEmpty()) {
            String[] paramAry = new String[params.size()];
            params.toArray(paramAry);
            sqlToyConfig.setDbShardingParams(paramAry);
        }
        shardingConfig.setStrategy(shardingDataSource.getAttribute("strategy"));
        sqlToyConfig.setDataSourceSharding(shardingConfig);
    }

    private static void parseShardingTables(SqlToyConfig sqlToyConfig, NodeList shardingTables) {
        if (shardingTables == null || shardingTables.getLength() == 0) {
            return;
        }
        ArrayList<ShardingStrategyConfig> tablesShardings = new ArrayList<ShardingStrategyConfig>();
        ArrayList<String> params = new ArrayList<String>();
        for (int i = 0; i < shardingTables.getLength(); ++i) {
            Element elt = (Element)shardingTables.item(i);
            if (!elt.hasAttribute("tables") || !elt.hasAttribute("strategy")) continue;
            ShardingStrategyConfig shardingModel = new ShardingStrategyConfig(1);
            shardingModel.setTables(StringUtil.trimArray(elt.getAttribute("tables").split("\\,")));
            if (elt.hasAttribute("params")) {
                String[] fields = elt.getAttribute("params").replace(";", ",").toLowerCase().split("\\,");
                int size = fields.length;
                String[] paramsAlias = new String[size];
                for (int j = 0; j < size; ++j) {
                    String[] paramName = fields[j].split("\\:");
                    fields[j] = paramName[0].trim();
                    if (!params.contains(fields[j])) {
                        params.add(fields[j]);
                    }
                    paramsAlias[j] = paramName[paramName.length - 1].trim();
                }
                shardingModel.setFields(fields);
                shardingModel.setAliasNames(paramsAlias);
            }
            if (elt.hasAttribute("strategy-value")) {
                shardingModel.setDecisionType(elt.getAttribute("strategy-value"));
            } else if (elt.hasAttribute("strategy-type")) {
                shardingModel.setDecisionType(elt.getAttribute("strategy-type"));
            } else if (elt.hasAttribute("decision-type")) {
                shardingModel.setDecisionType(elt.getAttribute("decision-type"));
            }
            shardingModel.setStrategy(elt.getAttribute("strategy"));
            tablesShardings.add(shardingModel);
        }
        if (!params.isEmpty()) {
            String[] paramAry = new String[params.size()];
            params.toArray(paramAry);
            sqlToyConfig.setTableShardingParams(paramAry);
        }
        sqlToyConfig.setTableShardings(tablesShardings);
    }

    private static void parseFilters(SqlToyConfig sqlToyConfig, NodeList filterSet, int blankToNull, String local) {
        ArrayList<ParamFilterModel> filterModels = new ArrayList<ParamFilterModel>();
        if (blankToNull == 1) {
            filterModels.add(new ParamFilterModel("blank", new String[]{"*"}));
        }
        boolean hasBlank = false;
        if (filterSet != null && filterSet.getLength() > 0) {
            boolean blank = false;
            for (int i = 0; i < filterSet.getLength(); ++i) {
                if (filterSet.item(i).getNodeType() != 1) continue;
                Element filter = (Element)filterSet.item(i);
                blank = false;
                String filterType = filter.getNodeName();
                int prefixIndex = filterType.indexOf(":");
                if (prefixIndex > 0) {
                    filterType = filterType.substring(prefixIndex + 1);
                }
                if ("blank".equals(filterType)) {
                    hasBlank = true;
                    blank = true;
                }
                if ((!blank || blankToNull == 1) && blank) continue;
                ParamFilterModel filterModel = new ParamFilterModel();
                if ("equals".equals(filterType) || "any".equals(filterType) || "in".equals(filterType)) {
                    filterType = "eq";
                } else if ("moreThan".equals(filterType) || "more".equals(filterType)) {
                    filterType = "gt";
                } else if ("moreEquals".equals(filterType) || "more-equals".equals(filterType)) {
                    filterType = "gte";
                } else if ("lessThan".equals(filterType) || "less".equals(filterType)) {
                    filterType = "lt";
                } else if ("lessEquals".equals(filterType) || "less-equals".equals(filterType)) {
                    filterType = "lte";
                } else if ("not-any".equals(filterType)) {
                    filterType = "neq";
                } else if ("dateFormat".equals(filterType)) {
                    filterType = "date-format";
                } else if ("to-str".equals(filterType)) {
                    filterType = "to-string";
                }
                filterModel.setFilterType(filterType);
                SqlXMLConfigParse.parseFilterElt(sqlToyConfig, filterModel, filter, local);
                filterModels.add(filterModel);
            }
        }
        if (!hasBlank && blankToNull == -1) {
            filterModels.add(0, new ParamFilterModel("blank", new String[]{"*"}));
        }
        if (filterModels.isEmpty()) {
            return;
        }
        sqlToyConfig.addFilters(filterModels);
    }

    private static void parseFilterElt(SqlToyConfig sqlToyConfig, ParamFilterModel filterModel, Element filter, String local) {
        if (!filter.hasAttribute("params")) {
            filterModel.setParams(new String[]{"*"});
        } else {
            filterModel.setParams(StringUtil.trimArray(filter.getAttribute("params").toLowerCase().split("\\,")));
        }
        if (filter.hasAttribute("value")) {
            filterModel.setValues(StringUtil.splitExcludeSymMark(filter.getAttribute("value"), ",", SqlToyConstants.filters));
        } else if (filter.hasAttribute("start-value") && filter.hasAttribute("end-value")) {
            filterModel.setValues(new String[]{filter.getAttribute("start-value"), filter.getAttribute("end-value")});
        }
        if (filter.hasAttribute("increment-time")) {
            filterModel.setIncrementTime(Double.valueOf(filter.getAttribute("increment-time")));
        } else if (filter.hasAttribute("increment-days")) {
            filterModel.setIncrementTime(Double.valueOf(filter.getAttribute("increment-days")));
        }
        if (filter.hasAttribute("increment-unit")) {
            String timeUnit = filter.getAttribute("increment-unit").toUpperCase();
            if ("DAYS".equals(timeUnit) || "DAY".equals(timeUnit)) {
                filterModel.setTimeUnit(TimeUnit.DAYS);
            } else if ("HOURS".equals(timeUnit) || "HOUR".equals(timeUnit)) {
                filterModel.setTimeUnit(TimeUnit.HOURS);
            } else if ("MINUTES".equals(timeUnit) || "MINUTE".equals(timeUnit)) {
                filterModel.setTimeUnit(TimeUnit.MINUTES);
            } else if ("SECONDS".equals(timeUnit) || "SECOND".equals(timeUnit)) {
                filterModel.setTimeUnit(TimeUnit.SECONDS);
            } else if ("MILLISECONDS".equals(timeUnit) || "MILLISECOND".equals(timeUnit)) {
                filterModel.setTimeUnit(TimeUnit.MILLISECONDS);
            } else if ("MONTHS".equals(timeUnit) || "MONTH".equals(timeUnit)) {
                filterModel.setTimeUnit(TimeUnit.MONTHS);
            } else if ("YEARS".equals(timeUnit) || "YEAR".equals(timeUnit)) {
                filterModel.setTimeUnit(TimeUnit.YEARS);
            }
        }
        if (filter.hasAttribute("format")) {
            String fmt = filter.getAttribute("format");
            if ("first_day".equalsIgnoreCase(fmt) || "first_month_day".equalsIgnoreCase(fmt)) {
                filterModel.setFormat("FIRST_OF_MONTH");
            } else if ("last_day".equalsIgnoreCase(fmt) || "last_month_day".equalsIgnoreCase(fmt)) {
                filterModel.setFormat("LAST_OF_MONTH");
            } else if ("first_year_day".equalsIgnoreCase(fmt)) {
                filterModel.setFormat("FIRST_OF_YEAR");
            } else if ("last_year_day".equalsIgnoreCase(fmt)) {
                filterModel.setFormat("LAST_OF_YEAR");
            } else if ("first_week_day".equalsIgnoreCase(fmt)) {
                filterModel.setFormat("FIRST_OF_WEEK");
            } else if ("last_week_day".equalsIgnoreCase(fmt)) {
                filterModel.setFormat("LAST_OF_WEEK");
            } else {
                filterModel.setFormat(fmt);
            }
        }
        if (filter.hasAttribute("type")) {
            filterModel.setType(filter.getAttribute("type").toLowerCase());
        }
        if (filter.hasAttribute("regex")) {
            filterModel.setRegex(filter.getAttribute("regex"));
        }
        if (filter.hasAttribute("is-first")) {
            filterModel.setFirst(Boolean.parseBoolean(filter.getAttribute("is-first")));
        }
        if (filter.hasAttribute("single-quote")) {
            filterModel.setSingleQuote(Boolean.parseBoolean(filter.getAttribute("single-quote")));
        }
        if (filter.hasAttribute("add-quote")) {
            filterModel.setAddQuote(filter.getAttribute("add-quote").toLowerCase());
        }
        if (filter.hasAttribute("split-sign")) {
            filterModel.setSplit(filter.getAttribute("split-sign"));
        }
        if (filter.hasAttribute("excludes")) {
            String[] excludeParams;
            for (String excludeParam : excludeParams = filter.getAttribute("excludes").toLowerCase().split("\\,")) {
                filterModel.addExclude(excludeParam.trim());
            }
        }
        if (filter.hasAttribute("param")) {
            filterModel.setParam(filter.getAttribute("param").toLowerCase());
        }
        if (filter.hasAttribute("cache-name")) {
            NodeList nodeList;
            sqlToyConfig.addCacheArgParam(filterModel.getParam());
            filterModel.setCacheName(filter.getAttribute("cache-name"));
            if (filter.hasAttribute("cache-type")) {
                filterModel.setCacheType(filter.getAttribute("cache-type"));
            }
            if (filter.hasAttribute("prior-match-equal")) {
                filterModel.setPriorMatchEqual(Boolean.parseBoolean(filter.getAttribute("prior-match-equal")));
            }
            if (filter.hasAttribute("cache-key-index")) {
                filterModel.setCacheKeyIndex(Integer.parseInt(filter.getAttribute("cache-key-index")));
            }
            if (filter.hasAttribute("cache-mapping-max")) {
                filterModel.setCacheMappingMax(Integer.parseInt(filter.getAttribute("cache-mapping-max")));
                if (filterModel.getCacheMappingMax() > SqlToyConstants.SQL_IN_MAX) {
                    filterModel.setCacheMappingMax(SqlToyConstants.SQL_IN_MAX);
                }
            }
            if (filter.hasAttribute("cache-mapping-indexes")) {
                String[] cacheIndexes = StringUtil.trimArray(filter.getAttribute("cache-mapping-indexes").split("\\,"));
                int[] mappingIndexes = new int[cacheIndexes.length];
                for (int i = 0; i < cacheIndexes.length; ++i) {
                    mappingIndexes[i] = Integer.parseInt(cacheIndexes[i]);
                }
                filterModel.setCacheMappingIndexes(mappingIndexes);
            }
            if (filter.hasAttribute("alias-name")) {
                filterModel.setAliasName(filter.getAttribute("alias-name").toLowerCase());
                sqlToyConfig.addCacheArgParam(filterModel.getAliasName());
            }
            if (filter.hasAttribute("cache-not-matched-value")) {
                filterModel.setCacheNotMatchedValue(filter.getAttribute("cache-not-matched-value"));
            }
            if (filter.hasAttribute("unmatched-return-self")) {
                filterModel.setCacheNotMatchedReturnSelf(Boolean.parseBoolean(filter.getAttribute("unmatched-return-self")));
            }
            if ((nodeList = filter.getElementsByTagName(local.concat("filter"))).getLength() > 0) {
                CacheFilterModel[] cacheFilterModels = new CacheFilterModel[nodeList.getLength()];
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element cacheFilter = (Element)nodeList.item(i);
                    CacheFilterModel cacheFilterModel = new CacheFilterModel();
                    cacheFilterModel.setCacheIndex(Integer.parseInt(cacheFilter.getAttribute("cache-index")));
                    String compareParam = cacheFilter.getAttribute("compare-param").toLowerCase();
                    if (cacheFilter.hasAttribute("split")) {
                        String split = cacheFilter.getAttribute("split");
                        cacheFilterModel.setCompareValues(StringUtil.splitRegex(compareParam, split, true));
                    } else {
                        cacheFilterModel.setCompareParam(compareParam);
                        if (!(NumberUtil.isNumber(compareParam) || "true".equals(compareParam) || "false".equals(compareParam))) {
                            sqlToyConfig.addCacheArgParam(compareParam);
                        }
                    }
                    if (cacheFilter.hasAttribute("compare-type")) {
                        cacheFilterModel.setCompareType(cacheFilter.getAttribute("compare-type").toLowerCase());
                    }
                    cacheFilterModels[i] = cacheFilterModel;
                }
                filterModel.setCacheFilters(cacheFilterModels);
            }
        }
        if (filter.hasAttribute("set-params")) {
            filterModel.setUpdateParams(StringUtil.trimArray(filter.getAttribute("set-params").toLowerCase().split("\\,")));
        } else if (filter.hasAttribute("exclusive-params")) {
            filterModel.setUpdateParams(StringUtil.trimArray(filter.getAttribute("exclusive-params").toLowerCase().split("\\,")));
        }
        if (filter.hasAttribute("set-value")) {
            filterModel.setUpdateValue(filter.getAttribute("set-value"));
        }
        if (filter.hasAttribute("as-param")) {
            filterModel.setUpdateParams(new String[]{filter.getAttribute("as-param")});
        }
        if (filter.hasAttribute("compare-type")) {
            String compareType = filter.getAttribute("compare-type");
            if ("eq".equals(compareType) || "==".equals(compareType) || "equals".equals(compareType) || "=".equals(compareType)) {
                filterModel.setCompareType("==");
            } else if ("neq".equals(compareType) || "<>".equals(compareType) || "!=".equals(compareType) || "ne".equals(compareType)) {
                filterModel.setCompareType("<>");
            } else if (">".equals(compareType) || "gt".equals(compareType) || "more".equals(compareType)) {
                filterModel.setCompareType(">");
            } else if (">=".equals(compareType) || "gte".equals(compareType) || "ge".equals(compareType)) {
                filterModel.setCompareType(">=");
            } else if ("<".equals(compareType) || "lt".equals(compareType) || "less".equals(compareType)) {
                filterModel.setCompareType("<");
            } else if ("<=".equals(compareType) || "lte".equals(compareType) || "le".equals(compareType)) {
                filterModel.setCompareType("<=");
            } else if ("between".equals(compareType)) {
                filterModel.setCompareType("between");
            } else if ("any".equals(compareType) || "in".equals(compareType)) {
                filterModel.setCompareType("any");
            }
        }
        if (filter.hasAttribute("compare-values")) {
            String compareValue = filter.getAttribute("compare-values");
            if (compareValue.indexOf(";") != -1) {
                filterModel.setCompareValues(StringUtil.trimArray(compareValue.split("\\;")));
            } else {
                filterModel.setCompareValues(StringUtil.trimArray(compareValue.split("\\,")));
            }
        }
        if (filter.hasAttribute("data-type")) {
            filterModel.setDataType(filter.getAttribute("data-type").toLowerCase());
        }
        if (filter.hasAttribute("is-array")) {
            filterModel.setIsArray(Boolean.parseBoolean(filter.getAttribute("is-array")));
        }
    }

    public static void parseTranslate(SqlToyConfig sqlToyConfig, NodeList translates) {
        if (translates == null || translates.getLength() == 0) {
            return;
        }
        HashMap<String, FieldTranslate> translateMap = new HashMap<String, FieldTranslate>();
        String splitRegex = null;
        String linkSign = ",";
        boolean hasLink = false;
        String where = null;
        for (int k = 0; k < translates.getLength(); ++k) {
            int i;
            String[] cacheIndexStr;
            Element translate = (Element)translates.item(k);
            hasLink = false;
            where = null;
            String cacheName = translate.getAttribute("cache");
            String cacheType = translate.hasAttribute("cache-type") ? translate.getAttribute("cache-type") : null;
            String[] columns = StringUtil.trimArray(translate.getAttribute("columns").toLowerCase().split("\\,"));
            String[] aliasNames = null;
            String uncachedTemplate = null;
            if (translate.hasAttribute("undefine-template")) {
                uncachedTemplate = translate.getAttribute("undefine-template");
            } else if (translate.hasAttribute("uncached-template")) {
                uncachedTemplate = translate.getAttribute("uncached-template");
            } else if (translate.hasAttribute("uncached")) {
                uncachedTemplate = translate.getAttribute("uncached");
            }
            if (translate.hasAttribute("where")) {
                where = translate.getAttribute("where");
            }
            if (translate.hasAttribute("split-regex")) {
                splitRegex = translate.getAttribute("split-regex");
                if (translate.hasAttribute("link-sign")) {
                    linkSign = translate.getAttribute("link-sign");
                    hasLink = true;
                }
                if (",".equals(splitRegex) || "\uff0c".equals(splitRegex)) {
                    splitRegex = "\\,";
                } else if (";".equals(splitRegex) || "\uff1b".equals(splitRegex)) {
                    splitRegex = "\\;";
                    if (!hasLink) {
                        linkSign = ";";
                    }
                } else if ("\u3001".equals(splitRegex)) {
                    splitRegex = "\\\u3001";
                } else if ("->".equals(splitRegex)) {
                    splitRegex = "\\-\\>";
                    if (!hasLink) {
                        linkSign = "->";
                    }
                }
            }
            if (translate.hasAttribute("alias-name")) {
                aliasNames = StringUtil.trimArray(translate.getAttribute("alias-name").toLowerCase().split("\\,"));
            } else if (translate.hasAttribute("original-columns")) {
                aliasNames = StringUtil.trimArray(translate.getAttribute("original-columns").toLowerCase().split("\\,"));
            }
            Integer[] cacheIndexs = null;
            if (translate.hasAttribute("cache-indexs")) {
                cacheIndexStr = StringUtil.trimArray(translate.getAttribute("cache-indexs").split("\\,"));
                cacheIndexs = new Integer[cacheIndexStr.length];
                for (i = 0; i < cacheIndexStr.length; ++i) {
                    cacheIndexs[i] = Integer.parseInt(cacheIndexStr[i]);
                }
            } else if (translate.hasAttribute("cache-indexes")) {
                cacheIndexStr = StringUtil.trimArray(translate.getAttribute("cache-indexes").split("\\,"));
                cacheIndexs = new Integer[cacheIndexStr.length];
                for (i = 0; i < cacheIndexStr.length; ++i) {
                    cacheIndexs[i] = Integer.parseInt(cacheIndexStr[i]);
                }
            }
            if (cacheIndexs == null || cacheIndexs.length == columns.length) {
                for (i = 0; i < columns.length; ++i) {
                    Translate translateModel = new Translate(cacheName);
                    translateModel.setColumn(columns[i]);
                    translateModel.setAlias(aliasNames == null ? columns[i] : aliasNames[i]);
                    translateModel.setCacheType(cacheType);
                    translateModel.setSplitRegex(splitRegex);
                    translateModel.setLinkSign(linkSign);
                    SqlXMLConfigParse.parseTranslateWhere(translateModel, where);
                    if (uncachedTemplate != null) {
                        if (uncachedTemplate.trim().equals("")) {
                            translateModel.setUncached(null);
                        } else {
                            translateModel.setUncached(uncachedTemplate.replaceAll("(?i)\\$?\\{\\s*key\\s*\\}", "\\$\\{value\\}"));
                        }
                    }
                    if (cacheIndexs != null) {
                        if (i < cacheIndexs.length - 1) {
                            translateModel.setIndex(cacheIndexs[i]);
                        } else {
                            translateModel.setIndex(cacheIndexs[cacheIndexs.length - 1]);
                        }
                    }
                    if (translateMap.containsKey(translateModel.getExtend().column)) {
                        FieldTranslate translateAry = translateMap.get(translateModel.getExtend().column);
                        translateAry.put(translateModel);
                        continue;
                    }
                    FieldTranslate fieldTranslate = new FieldTranslate();
                    fieldTranslate.colName = translateModel.getExtend().column;
                    fieldTranslate.put(translateModel);
                    translateMap.put(translateModel.getExtend().column, fieldTranslate);
                }
                continue;
            }
            if (cacheIndexs == null || cacheIndexs.length == columns.length) continue;
            logger.warn("sqlId:{} \u5bf9\u5e94\u7684cache translate columns suggest config with cache-indexs!", (Object)sqlToyConfig.getId());
        }
        sqlToyConfig.setTranslateMap(translateMap);
    }

    public static void parseTranslateWhere(Translate translate, String whereStr) {
        if (StringUtil.isBlank(whereStr)) {
            return;
        }
        String where = whereStr.trim().toLowerCase();
        where = where.replace(" in(", " in (").replace(" out(", " out (");
        String compareColumn = null;
        String compareType = "eq";
        String[] compareValues = null;
        for (int i = 0; i < WHERE_COMPARE.length; ++i) {
            if (where.indexOf(WHERE_COMPARE[i]) == -1) continue;
            compareType = WHERE_COMPARE_TYPES[i];
            String[] params = where.split(WHERE_SPLIT_REGEX[i]);
            compareColumn = params[0].replace("${", "").replace("{", "").replace("}", "").trim();
            compareValues = StringUtil.trimArray(params[1].replace("(", "").replace(")", "").replace("'", "").replace("\"", "").split("\\,"));
            break;
        }
        if (StringUtil.isNotBlank(compareColumn) && compareValues != null && compareValues.length > 0) {
            translate.setCompareColumn(compareColumn);
            translate.setCompareType(compareType);
            translate.setCompareValues(compareValues);
        }
    }

    private static void parseLink(SqlToyConfig sqlToyConfig, NodeList linkNode, String local) {
        NodeList nodeList;
        if (linkNode == null || linkNode.getLength() == 0) {
            return;
        }
        Element link = (Element)linkNode.item(0);
        LinkModel linkModel = new LinkModel();
        if (link.hasAttribute("column")) {
            linkModel.setColumns(StringUtil.trimArray(link.getAttribute("column").split("\\,")));
        } else if (link.hasAttribute("columns")) {
            linkModel.setColumns(StringUtil.trimArray(link.getAttribute("columns").split("\\,")));
        }
        if (link.hasAttribute("id-columns")) {
            linkModel.setGroupColumns(StringUtil.trimArray(link.getAttribute("id-columns").split("\\,")));
        } else if (link.hasAttribute("group-columns")) {
            linkModel.setGroupColumns(StringUtil.trimArray(link.getAttribute("group-columns").split("\\,")));
        } else if (link.hasAttribute("id-column")) {
            linkModel.setGroupColumns(StringUtil.trimArray(link.getAttribute("id-column").split("\\,")));
        }
        if (link.hasAttribute("sign")) {
            linkModel.setSign(link.getAttribute("sign"));
        } else if (link.hasAttribute("result-type") && linkModel.getColumns() != null && linkModel.getColumns().length == 1) {
            String resultType = link.getAttribute("result-type");
            if (resultType.equalsIgnoreCase("LIST")) {
                linkModel.setResultType(1);
            } else if (resultType.equalsIgnoreCase("ARRAY")) {
                linkModel.setResultType(2);
            } else if (resultType.equalsIgnoreCase("SET") || resultType.equalsIgnoreCase("HASHSET")) {
                linkModel.setResultType(3);
            }
        }
        if (link.hasAttribute("distinct")) {
            linkModel.setDistinct(Boolean.parseBoolean(link.getAttribute("distinct")));
        }
        if ((nodeList = link.getElementsByTagName(local.concat("decorate"))).getLength() > 0) {
            Element decorateElt = (Element)nodeList.item(0);
            if (decorateElt.hasAttribute("align")) {
                linkModel.setDecorateAlign(decorateElt.getAttribute("align").toLowerCase());
            }
            linkModel.setDecorateAppendChar(decorateElt.getAttribute("char"));
            linkModel.setDecorateSize(Integer.parseInt(decorateElt.getAttribute("size")));
        }
        sqlToyConfig.setLinkModel(linkModel);
    }

    private static void parseFormat(SqlToyConfig sqlToyConfig, NodeList dfElts, NodeList nfElts) {
        String format;
        String[] columns;
        int i;
        ArrayList<FormatModel> formatModels = new ArrayList<FormatModel>();
        if (dfElts != null && dfElts.getLength() > 0) {
            for (i = 0; i < dfElts.getLength(); ++i) {
                Element df = (Element)dfElts.item(i);
                columns = StringUtil.trimArray(df.getAttribute("columns").toLowerCase().split("\\,"));
                format = df.hasAttribute("format") ? df.getAttribute("format") : "yyyy-MM-dd";
                String locale = df.hasAttribute("locale") ? df.getAttribute("locale") : null;
                for (String col : columns) {
                    FormatModel formatModel = new FormatModel();
                    formatModel.setColumn(col);
                    formatModel.setType(1);
                    formatModel.setFormat(format);
                    formatModel.setLocale(locale);
                    formatModels.add(formatModel);
                }
            }
        }
        if (nfElts != null && nfElts.getLength() > 0) {
            for (i = 0; i < nfElts.getLength(); ++i) {
                Element nf = (Element)nfElts.item(i);
                columns = StringUtil.trimArray(nf.getAttribute("columns").toLowerCase().split("\\,"));
                format = nf.hasAttribute("format") ? nf.getAttribute("format") : "capital";
                String roundStr = nf.hasAttribute("roundingMode") ? nf.getAttribute("roundingMode").toUpperCase() : null;
                String locale = nf.hasAttribute("locale") ? nf.getAttribute("locale") : null;
                RoundingMode roundMode = null;
                if (roundStr != null) {
                    if ("HALF_UP".equals(roundStr)) {
                        roundMode = RoundingMode.HALF_UP;
                    } else if ("HALF_DOWN".equals(roundStr)) {
                        roundMode = RoundingMode.HALF_DOWN;
                    } else if ("ROUND_DOWN".equals(roundStr)) {
                        roundMode = RoundingMode.DOWN;
                    } else if ("ROUND_UP".equals(roundStr)) {
                        roundMode = RoundingMode.UP;
                    }
                }
                for (String col : columns) {
                    FormatModel formatModel = new FormatModel();
                    formatModel.setColumn(col);
                    formatModel.setRoundingMode(roundMode);
                    formatModel.setType(2);
                    formatModel.setFormat(format);
                    formatModel.setLocale(locale);
                    formatModels.add(formatModel);
                }
            }
        }
        sqlToyConfig.setFormatModels(formatModels);
    }

    private static void parseCalculator(SqlToyConfig sqlToyConfig, Element sqlElt, String local) throws Exception {
        NodeList elements = sqlElt.getChildNodes();
        ArrayList<Serializable> resultProcessor = new ArrayList<Serializable>();
        for (int i = 0; i < elements.getLength(); ++i) {
            NodeList nodeList;
            if (elements.item(i).getNodeType() != 1) continue;
            Element elt = (Element)elements.item(i);
            String eltName = elt.getNodeName();
            if (eltName.equals(local.concat("pivot"))) {
                String[] startEndCols;
                PivotModel pivotModel = new PivotModel();
                if (elt.hasAttribute("group-columns")) {
                    pivotModel.setGroupCols(StringUtil.trimArray(elt.getAttribute("group-columns").toLowerCase().split("\\,")));
                }
                if (elt.hasAttribute("category-columns")) {
                    pivotModel.setCategoryCols(StringUtil.trimArray(elt.getAttribute("category-columns").toLowerCase().split("\\,")));
                }
                if (elt.hasAttribute("category-sql")) {
                    pivotModel.setCategorySql(elt.getAttribute("category-sql"));
                }
                startEndCols = new String[]{elt.getAttribute("start-column").toLowerCase(), elt.hasAttribute("end-column") ? elt.getAttribute("end-column").toLowerCase() : startEndCols[0]};
                if (elt.hasAttribute("default-value")) {
                    String defaultValue = elt.getAttribute("default-value");
                    if (elt.hasAttribute("default-type")) {
                        String defaultType = elt.getAttribute("default-type").toLowerCase();
                        pivotModel.setDefaultValue(XMLUtil.convertType(defaultValue, defaultType));
                    } else {
                        pivotModel.setDefaultValue(defaultValue);
                    }
                }
                pivotModel.setStartEndCols(startEndCols);
                resultProcessor.add(pivotModel);
                continue;
            }
            if (eltName.equals(local.concat("unpivot"))) {
                UnpivotModel unpivotModel = new UnpivotModel();
                XMLUtil.setAttributes(elt, unpivotModel, new String[0]);
                if (unpivotModel.getColumnsToRows().length <= 1) continue;
                String cols = elt.getAttribute("columns-to-rows").trim().replace("[", "{").replace("]", "}");
                unpivotModel.setColumnsToRows(StringUtil.splitExcludeSymMark(cols, ",", filters));
                if (cols.startsWith("{") && cols.endsWith("}")) {
                    unpivotModel.setGroupSize(unpivotModel.getColumnsToRows().length);
                    String[] colsToRows = unpivotModel.getColumnsToRows();
                    for (int t = 0; t < unpivotModel.getGroupSize(); ++t) {
                        colsToRows[t] = colsToRows[t].replace("{", "").replace("}", "").trim();
                    }
                    unpivotModel.setColumnsToRows(colsToRows);
                }
                resultProcessor.add(unpivotModel);
                continue;
            }
            if (eltName.equals(local.concat("summary"))) {
                SummaryModel summaryModel = new SummaryModel();
                if (elt.hasAttribute("reverse")) {
                    summaryModel.setReverse(Boolean.parseBoolean(elt.getAttribute("reverse")));
                }
                if (elt.hasAttribute("has-grouped")) {
                    summaryModel.setHasGrouped(Boolean.parseBoolean(elt.getAttribute("has-grouped")));
                }
                if (elt.hasAttribute("sum-columns")) {
                    summaryModel.setSumColumns(elt.getAttribute("sum-columns").toLowerCase());
                } else if (elt.hasAttribute("columns")) {
                    summaryModel.setSumColumns(elt.getAttribute("columns").toLowerCase());
                }
                if (elt.hasAttribute("average-columns")) {
                    summaryModel.setAveColumns(elt.getAttribute("average-columns").toLowerCase());
                }
                if (elt.hasAttribute("average-radix-sizes")) {
                    summaryModel.setRadixSize(SqlXMLConfigParse.trimParamsToInt(elt.getAttribute("average-radix-sizes").split("\\,")));
                } else if (elt.hasAttribute("radix-size")) {
                    summaryModel.setRadixSize(SqlXMLConfigParse.trimParamsToInt(elt.getAttribute("radix-size").split("\\,")));
                }
                if (elt.hasAttribute("average-rounding-modes")) {
                    String[] roundingModeAry = StringUtil.trimArray(elt.getAttribute("average-rounding-modes").toUpperCase().split("\\,"));
                    RoundingMode[] roudingModes = new RoundingMode[roundingModeAry.length];
                    RoundingMode roundMode = null;
                    for (int k = 0; k < roundingModeAry.length; ++k) {
                        String roundingMode = roundingModeAry[k];
                        roundMode = "HALF_UP".equals(roundingMode) ? RoundingMode.HALF_UP : ("HALF_DOWN".equals(roundingMode) ? RoundingMode.HALF_DOWN : ("ROUND_DOWN".equals(roundingMode) ? RoundingMode.DOWN : ("ROUND_UP".equals(roundingMode) ? RoundingMode.UP : RoundingMode.HALF_UP)));
                        roudingModes[k] = roundMode;
                    }
                    summaryModel.setRoundingModes(roudingModes);
                }
                if (elt.hasAttribute("sum-site")) {
                    summaryModel.setSumSite(elt.getAttribute("sum-site"));
                }
                if (elt.hasAttribute("link-sign")) {
                    summaryModel.setLinkSign(elt.getAttribute("link-sign"));
                }
                if (elt.hasAttribute("average-skip-null")) {
                    summaryModel.setAveSkipNull(Boolean.parseBoolean(elt.getAttribute("average-skip-null")));
                }
                if (elt.hasAttribute("skip-single-row")) {
                    summaryModel.setSkipSingleRow(Boolean.parseBoolean(elt.getAttribute("skip-single-row")));
                }
                nodeList = elt.getElementsByTagName(local.concat("global"));
                ArrayList<SummaryGroupMeta> groupMetaList = new ArrayList<SummaryGroupMeta>();
                if (nodeList.getLength() > 0) {
                    SummaryGroupMeta globalMeta = new SummaryGroupMeta();
                    Element globalSummary = (Element)nodeList.item(0);
                    if (globalSummary.hasAttribute("label-column")) {
                        globalMeta.setLabelColumn(globalSummary.getAttribute("label-column").toLowerCase());
                    }
                    if (globalSummary.hasAttribute("average-label")) {
                        globalMeta.setAverageTitle(globalSummary.getAttribute("average-label"));
                    }
                    if (globalSummary.hasAttribute("group-column")) {
                        globalMeta.setGroupColumn(globalSummary.getAttribute("group-column").toLowerCase());
                    }
                    if (globalSummary.hasAttribute("sum-label")) {
                        globalMeta.setSumTitle(globalSummary.getAttribute("sum-label"));
                    }
                    if (globalSummary.hasAttribute("reverse")) {
                        globalMeta.setGlobalReverse(Boolean.parseBoolean(globalSummary.getAttribute("reverse")));
                    }
                    if (summaryModel.isReverse()) {
                        globalMeta.setGlobalReverse(false);
                    }
                    groupMetaList.add(globalMeta);
                }
                if ((nodeList = elt.getElementsByTagName(local.concat("group"))).getLength() > 0) {
                    for (int j = 0; j < nodeList.getLength(); ++j) {
                        Element groupElt = (Element)nodeList.item(j);
                        SummaryGroupMeta groupMeta = new SummaryGroupMeta();
                        groupMeta.setGroupColumn(groupElt.getAttribute("group-column").toLowerCase());
                        if (groupElt.hasAttribute("average-label")) {
                            groupMeta.setAverageTitle(groupElt.getAttribute("average-label"));
                        }
                        if (groupElt.hasAttribute("sum-label")) {
                            groupMeta.setSumTitle(groupElt.getAttribute("sum-label"));
                        }
                        if (groupElt.hasAttribute("label-column")) {
                            groupMeta.setLabelColumn(groupElt.getAttribute("label-column"));
                        }
                        if (groupElt.hasAttribute("order-column")) {
                            groupMeta.setOrderColumn(groupElt.getAttribute("order-column"));
                            if (groupElt.hasAttribute("order-way")) {
                                groupMeta.setOrderWay(groupElt.getAttribute("order-way"));
                            }
                            if (groupElt.hasAttribute("order-with-sum")) {
                                groupMeta.setOrderWithSum(Boolean.parseBoolean(groupElt.getAttribute("order-with-sum")));
                            }
                        }
                        groupMetaList.add(groupMeta);
                    }
                }
                if (!groupMetaList.isEmpty()) {
                    SummaryGroupMeta[] groupMetas = new SummaryGroupMeta[groupMetaList.size()];
                    groupMetaList.toArray(groupMetas);
                    summaryModel.setGroupMeta(groupMetas);
                }
                resultProcessor.add(summaryModel);
                continue;
            }
            if (eltName.equals(local.concat("cols-chain-relative"))) {
                ColsChainRelativeModel colsRelativeModel = new ColsChainRelativeModel();
                XMLUtil.setAttributes(elt, colsRelativeModel, new String[0]);
                resultProcessor.add(colsRelativeModel);
                continue;
            }
            if (eltName.equals(local.concat("rows-chain-relative"))) {
                RowsChainRelativeModel rowsRelativeModel = new RowsChainRelativeModel();
                XMLUtil.setAttributes(elt, rowsRelativeModel, new String[0]);
                resultProcessor.add(rowsRelativeModel);
                continue;
            }
            if (eltName.equals(local.concat("reverse"))) {
                ReverseModel reverseModel = new ReverseModel();
                XMLUtil.setAttributes(elt, reverseModel, new String[0]);
                resultProcessor.add(reverseModel);
                continue;
            }
            if (!eltName.equals(local.concat("tree-sort"))) continue;
            TreeSortModel treeSortModel = new TreeSortModel();
            XMLUtil.setAttributes(elt, treeSortModel, new String[0]);
            nodeList = elt.getElementsByTagName(local.concat("sum-filter"));
            if (nodeList.getLength() > 0) {
                Element sumFilter = (Element)nodeList.item(0);
                if (sumFilter.hasAttribute("column")) {
                    treeSortModel.setFilterColumn(sumFilter.getAttribute("column"));
                }
                if (sumFilter.hasAttribute("compare-type")) {
                    treeSortModel.setCompareType(sumFilter.getAttribute("compare-type"));
                    if ("eq".equals(treeSortModel.getCompareType())) {
                        treeSortModel.setCompareType("==");
                    } else if ("neq".equals(treeSortModel.getCompareType())) {
                        treeSortModel.setCompareType("!=");
                    } else if ("gt".equals(treeSortModel.getCompareType())) {
                        treeSortModel.setCompareType(">");
                    } else if ("gte".equals(treeSortModel.getCompareType())) {
                        treeSortModel.setCompareType(">=");
                    } else if ("lt".equals(treeSortModel.getCompareType())) {
                        treeSortModel.setCompareType("<");
                    } else if ("lte".equals(treeSortModel.getCompareType())) {
                        treeSortModel.setCompareType("<=");
                    }
                }
                if (sumFilter.hasAttribute("compare-values")) {
                    treeSortModel.setCompareValues(sumFilter.getAttribute("compare-values"));
                }
            }
            resultProcessor.add(treeSortModel);
        }
        sqlToyConfig.setResultProcessor(resultProcessor);
    }

    private static InputStream getResourceAsStream(String resource) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(resource.length() > 0 && resource.charAt(0) == '/' ? resource.substring(1) : resource);
    }

    private static Integer[] trimParamsToInt(String[] paramNames) {
        if (paramNames == null || paramNames.length == 0) {
            return null;
        }
        Integer[] realParamNames = new Integer[paramNames.length];
        for (int i = 0; i < paramNames.length; ++i) {
            realParamNames[i] = paramNames[i] == null || "".equals(paramNames[i].trim()) ? null : Integer.valueOf(Integer.parseInt(paramNames[i].trim()));
        }
        return realParamNames;
    }

    private static String[] splitFields(String fields) {
        String[] strs;
        if (StringUtil.isBlank(fields)) {
            return null;
        }
        ArrayList<String> fieldSet = new ArrayList<String>();
        for (String str : strs = StringUtil.splitExcludeSymMark(fields, ",", filters)) {
            if (str.contains("[") && str.contains("]")) {
                String[] params;
                String pre = str.substring(0, str.indexOf("[")).trim();
                for (String param : params = str.substring(str.indexOf("[") + 1, str.indexOf("]")).split("\\,")) {
                    fieldSet.add(pre.concat(".").concat(param.trim()));
                }
                continue;
            }
            fieldSet.add(str.trim());
        }
        String[] result = new String[fieldSet.size()];
        fieldSet.toArray(result);
        return result;
    }
}

