/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.config.model;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.sagacity.sqltoy.config.model.SqlExecuteLog;
import org.sagacity.sqltoy.model.OperateDetailType;
import org.sagacity.sqltoy.utils.IdUtil;

public class SqlExecuteTrace
implements Serializable {
    private static final long serialVersionUID = 6050450953137017285L;
    private Long start;
    private String id;
    private String uid;
    private boolean isPrint = true;
    private boolean overTime = false;
    private String dialect;
    private OperateDetailType operateDetailType;
    private Long batchSize;
    private boolean error = false;
    private List<SqlExecuteLog> executeLogs = new CopyOnWriteArrayList<SqlExecuteLog>();

    public SqlExecuteTrace(String id, OperateDetailType operateDetailType, boolean isPrint) {
        this.id = id;
        this.operateDetailType = operateDetailType;
        this.start = System.currentTimeMillis();
        this.isPrint = isPrint;
        this.uid = IdUtil.getDebugId();
    }

    public boolean isPrint() {
        return this.isPrint;
    }

    public Long getStart() {
        return this.start;
    }

    public long getExecuteTime() {
        if (this.start == null) {
            return -1L;
        }
        return System.currentTimeMillis() - this.start;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return this.operateDetailType == null ? "" : this.operateDetailType.value();
    }

    public OperateDetailType getOperateDetailType() {
        return this.operateDetailType;
    }

    public void setOperateDetailType(OperateDetailType operateDetailType) {
        this.operateDetailType = operateDetailType;
    }

    public List<SqlExecuteLog> getExecuteLogs() {
        return this.executeLogs;
    }

    public void addSqlLog(String topic, String sql, Object ... paramsValue) {
        this.executeLogs.add(new SqlExecuteLog(0, topic, sql, paramsValue));
    }

    public void addLog(String topic, String content, Object ... paramsValue) {
        this.executeLogs.add(new SqlExecuteLog(1, topic, content, paramsValue));
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(String errorMsg) {
        this.error = true;
        this.executeLogs.add(new SqlExecuteLog(1, "\u9519\u8bef\u4fe1\u606f", errorMsg, null));
    }

    public String getUid() {
        return this.uid;
    }

    public boolean isOverTime() {
        return this.overTime;
    }

    public void setOverTime(boolean overTime) {
        this.overTime = overTime;
    }

    public String getDialect() {
        return this.dialect;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public Long getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(Long batchSize) {
        this.batchSize = batchSize;
    }
}

