/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.config.model;

import java.io.Serializable;
import org.sagacity.sqltoy.model.inner.TranslateExtend;
import org.sagacity.sqltoy.utils.StringUtil;

public class Translate
implements Serializable {
    private static final long serialVersionUID = 6616462798500953675L;
    private TranslateExtend extend = new TranslateExtend();

    public Translate(String cacheName) {
        this.extend.cache = cacheName;
    }

    public Translate setColumn(String column) {
        this.extend.column = column.toLowerCase();
        return this;
    }

    public Translate setCacheType(String cacheType) {
        this.extend.cacheType = cacheType;
        return this;
    }

    public Translate setCache(String cache) {
        this.extend.cache = cache;
        return this;
    }

    public Translate setIndex(int index) {
        this.extend.index = index;
        return this;
    }

    public Translate setAlias(String alias) {
        this.extend.alias = alias;
        return this;
    }

    public Translate setKeyColumn(String keyColumn) {
        this.extend.keyColumn = keyColumn;
        return this;
    }

    public Translate setUncached(String uncached) {
        this.extend.uncached = uncached;
        return this;
    }

    public Translate setSplitRegex(String splitRegex) {
        this.extend.splitRegex = splitRegex;
        return this;
    }

    public Translate setLinkSign(String linkSign) {
        this.extend.linkSign = linkSign;
        return this;
    }

    public Translate setCompareColumn(String compareColumn) {
        if (compareColumn != null && !compareColumn.trim().equals("")) {
            this.extend.compareColumn = compareColumn.toLowerCase();
            this.extend.hasLogic = true;
        }
        return this;
    }

    public Translate setCompareType(String compareType) {
        if (compareType != null) {
            String lowCompareType = compareType.toLowerCase();
            if (lowCompareType.equals("!=") || lowCompareType.equals("<>")) {
                lowCompareType = "neq";
            } else if (lowCompareType.equals("==") || lowCompareType.equals("=")) {
                lowCompareType = "eq";
            }
            if (!(lowCompareType.equals("eq") || lowCompareType.equals("neq") || lowCompareType.equals("in") || lowCompareType.equals("out"))) {
                throw new IllegalArgumentException("\u7f13\u5b58\u7ffb\u8bd1\u4e2d\u903b\u8f91\u5224\u65ad:compareType\u53ea\u652f\u6301eq\u3001neq\u3001in\u3001out\u56db\u79cd\u7c7b\u578b!");
            }
            this.extend.compareType = lowCompareType;
        }
        return this;
    }

    public Translate setCompareValues(String ... compareValues) {
        this.extend.compareValues = compareValues;
        return this;
    }

    public Translate setKeyTemplate(String keyTemplate) {
        if (StringUtil.isNotBlank(keyTemplate)) {
            this.extend.keyTemplate = keyTemplate.replaceFirst("(?i)\\$?\\{\\s*(key|0|cacheKey)?\\s*\\}", "{}");
        }
        return this;
    }

    public TranslateExtend getExtend() {
        return this.extend;
    }

    public Translate clone() {
        Translate result = new Translate(this.getExtend().cache);
        result.extend = this.getExtend().clone();
        return result;
    }
}

