/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.dialect.impl;

import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.callback.DecryptHandler;
import org.sagacity.sqltoy.callback.GenerateSavePKStrategy;
import org.sagacity.sqltoy.callback.GenerateSqlHandler;
import org.sagacity.sqltoy.callback.ReflectPropsHandler;
import org.sagacity.sqltoy.callback.UpdateRowHandler;
import org.sagacity.sqltoy.config.model.EntityMeta;
import org.sagacity.sqltoy.config.model.PKStrategy;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.config.model.SqlType;
import org.sagacity.sqltoy.dialect.impl.PostgreSqlDialect;
import org.sagacity.sqltoy.dialect.model.SavePKStrategy;
import org.sagacity.sqltoy.dialect.utils.DialectExtUtils;
import org.sagacity.sqltoy.dialect.utils.DialectUtils;
import org.sagacity.sqltoy.dialect.utils.H2DialectUtils;
import org.sagacity.sqltoy.model.LockMode;
import org.sagacity.sqltoy.model.QueryResult;
import org.sagacity.sqltoy.model.inner.QueryExecutorExtend;
import org.sagacity.sqltoy.utils.SqlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2Dialect
extends PostgreSqlDialect {
    protected final Logger logger = LoggerFactory.getLogger(H2Dialect.class);
    public static final String VIRTUAL_TABLE = "dual";

    @Override
    public QueryResult findBySql(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, String sql, Object[] paramsValue, QueryExecutorExtend queryExecutorExtend, DecryptHandler decryptHandler, Connection conn, LockMode lockMode, Integer dbType, String dialect, int fetchSize, int maxRows) throws Exception {
        String realSql = sql.concat(this.getLockSql(sql, dbType, lockMode));
        return DialectUtils.findBySql(sqlToyContext, sqlToyConfig, realSql, paramsValue, queryExecutorExtend, decryptHandler, conn, dbType, 0, fetchSize, maxRows);
    }

    @Override
    public Serializable load(SqlToyContext sqlToyContext, Serializable entity, boolean onlySubTables, List<Class> cascadeTypes, LockMode lockMode, Connection conn, Integer dbType, String dialect, String tableName) throws Exception {
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entity.getClass());
        SqlToyConfig sqlToyConfig = sqlToyContext.getSqlToyConfig(entityMeta.getLoadSql(tableName), SqlType.search, dialect, null);
        String loadSql = sqlToyConfig.getSql(dialect);
        loadSql = loadSql.concat(this.getLockSql(loadSql, dbType, lockMode));
        return DialectUtils.load(sqlToyContext, sqlToyConfig, loadSql, entityMeta, entity, onlySubTables, cascadeTypes, conn, dbType);
    }

    @Override
    public Long update(final SqlToyContext sqlToyContext, Serializable entity, String[] forceUpdateFields, boolean cascade, Class[] forceCascadeClasses, HashMap<Class, String[]> subTableForceUpdateProps, Connection conn, final Integer dbType, String dialect, String tableName) throws Exception {
        return DialectUtils.update(sqlToyContext, entity, "COALESCE", forceUpdateFields, cascade, !cascade ? null : new GenerateSqlHandler(){

            @Override
            public String generateSql(EntityMeta entityMeta, String[] forceUpdateFields) {
                PKStrategy pkStrategy = entityMeta.getIdStrategy();
                String sequence = "nextval('" + entityMeta.getSequence() + "')";
                return DialectUtils.getSaveOrUpdateSql(sqlToyContext, sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, pkStrategy, forceUpdateFields, H2Dialect.VIRTUAL_TABLE, "COALESCE", sequence, H2DialectUtils.isAssignPKValue(pkStrategy), null);
            }
        }, forceCascadeClasses, subTableForceUpdateProps, conn, dbType, tableName);
    }

    @Override
    public Object save(final SqlToyContext sqlToyContext, Serializable entity, Connection conn, final Integer dbType, String dialect, String tableName) throws Exception {
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entity.getClass());
        String sequence = "nextval('" + entityMeta.getSequence() + "')";
        PKStrategy pkStrategy = DialectUtils.getSavePKStrategy(entityMeta, entity, dbType);
        boolean isAssignPK = H2DialectUtils.isAssignPKValue(pkStrategy);
        String insertSql = DialectExtUtils.generateInsertSql(sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, pkStrategy, "COALESCE", sequence, isAssignPK, tableName);
        return DialectUtils.save(sqlToyContext, entityMeta, pkStrategy, isAssignPK, insertSql, entity, new GenerateSqlHandler(){

            @Override
            public String generateSql(EntityMeta entityMeta, String[] forceUpdateField) {
                PKStrategy pkStrategy = entityMeta.getIdStrategy();
                String sequence = "nextval('" + entityMeta.getSequence() + "')";
                return DialectExtUtils.generateInsertSql(sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, pkStrategy, "COALESCE", sequence, H2DialectUtils.isAssignPKValue(pkStrategy), null);
            }
        }, new GenerateSavePKStrategy(){

            @Override
            public SavePKStrategy generate(EntityMeta entityMeta) {
                return new SavePKStrategy(entityMeta.getIdStrategy(), H2DialectUtils.isAssignPKValue(entityMeta.getIdStrategy()));
            }
        }, conn, dbType);
    }

    @Override
    public Long saveAll(SqlToyContext sqlToyContext, List<?> entities, int batchSize, ReflectPropsHandler reflectPropsHandler, Connection conn, Integer dbType, String dialect, Boolean autoCommit, String tableName) throws Exception {
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entities.get(0).getClass());
        PKStrategy pkStrategy = entityMeta.getIdStrategy();
        String sequence = "nextval('" + entityMeta.getSequence() + "')";
        boolean isAssignPK = H2DialectUtils.isAssignPKValue(pkStrategy);
        String insertSql = DialectExtUtils.generateInsertSql(sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, pkStrategy, "COALESCE", sequence, isAssignPK, tableName);
        return DialectUtils.saveAll(sqlToyContext, entityMeta, pkStrategy, isAssignPK, insertSql, entities, batchSize, reflectPropsHandler, conn, dbType, autoCommit);
    }

    @Override
    public Long saveOrUpdate(SqlToyContext sqlToyContext, Serializable entity, String[] forceUpdateFields, Connection conn, Integer dbType, String dialect, Boolean autoCommit, String tableName) throws Exception {
        ArrayList<Serializable> entities = new ArrayList<Serializable>();
        entities.add(entity);
        return this.saveOrUpdateAll(sqlToyContext, entities, sqlToyContext.getBatchSize(), null, forceUpdateFields, conn, dbType, dialect, autoCommit, tableName);
    }

    @Override
    public Long saveOrUpdateAll(final SqlToyContext sqlToyContext, List<?> entities, int batchSize, ReflectPropsHandler reflectPropsHandler, String[] forceUpdateFields, Connection conn, final Integer dbType, String dialect, Boolean autoCommit, final String tableName) throws Exception {
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entities.get(0).getClass());
        return DialectUtils.saveOrUpdateAll(sqlToyContext, entities, batchSize, entityMeta, forceUpdateFields, new GenerateSqlHandler(){

            @Override
            public String generateSql(EntityMeta entityMeta, String[] forceUpdateFields) {
                PKStrategy pkStrategy = entityMeta.getIdStrategy();
                String sequence = "nextval('" + entityMeta.getSequence() + "')";
                return DialectUtils.getSaveOrUpdateSql(sqlToyContext, sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, pkStrategy, forceUpdateFields, H2Dialect.VIRTUAL_TABLE, "COALESCE", sequence, H2DialectUtils.isAssignPKValue(pkStrategy), tableName);
            }
        }, reflectPropsHandler, conn, dbType, autoCommit);
    }

    @Override
    public Long saveAllIgnoreExist(final SqlToyContext sqlToyContext, List<?> entities, int batchSize, ReflectPropsHandler reflectPropsHandler, Connection conn, final Integer dbType, String dialect, Boolean autoCommit, final String tableName) throws Exception {
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entities.get(0).getClass());
        return DialectUtils.saveAllIgnoreExist(sqlToyContext, entities, batchSize, entityMeta, new GenerateSqlHandler(){

            @Override
            public String generateSql(EntityMeta entityMeta, String[] forceUpdateFields) {
                PKStrategy pkStrategy = entityMeta.getIdStrategy();
                String sequence = "nextval('" + entityMeta.getSequence() + "')";
                return DialectExtUtils.mergeIgnore(sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, pkStrategy, H2Dialect.VIRTUAL_TABLE, "COALESCE", sequence, H2DialectUtils.isAssignPKValue(pkStrategy), tableName);
            }
        }, reflectPropsHandler, conn, dbType, autoCommit);
    }

    @Override
    public QueryResult updateFetch(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, String sql, Object[] paramsValue, UpdateRowHandler updateRowHandler, Connection conn, Integer dbType, String dialect, LockMode lockMode, int fetchSize, int maxRows) throws Exception {
        String realSql = sql.concat(this.getLockSql(sql, dbType, lockMode == null ? LockMode.UPGRADE : lockMode));
        return DialectUtils.updateFetchBySql(sqlToyContext, sqlToyConfig, realSql, paramsValue, updateRowHandler, conn, dbType, 0, fetchSize, maxRows);
    }

    private String getLockSql(String sql, Integer dbType, LockMode lockMode) {
        if (lockMode == null || SqlUtil.hasLock(sql, dbType)) {
            return "";
        }
        if (lockMode == LockMode.UPGRADE_NOWAIT) {
            return " for update nowait ";
        }
        return " for update ";
    }
}

