/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.dialect.impl;

import java.io.Serializable;
import java.sql.Connection;
import org.sagacity.sqltoy.SqlToyConstants;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.callback.DecryptHandler;
import org.sagacity.sqltoy.config.model.OperateType;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.config.model.SqlToyResult;
import org.sagacity.sqltoy.dialect.impl.OracleDialect;
import org.sagacity.sqltoy.dialect.utils.DialectExtUtils;
import org.sagacity.sqltoy.dialect.utils.DialectUtils;
import org.sagacity.sqltoy.model.QueryExecutor;
import org.sagacity.sqltoy.model.QueryResult;
import org.sagacity.sqltoy.model.inner.QueryExecutorExtend;
import org.sagacity.sqltoy.utils.SqlUtil;
import org.sagacity.sqltoy.utils.SqlUtilsExt;

public class Oracle11gDialect
extends OracleDialect {
    @Override
    public boolean isUnique(SqlToyContext sqlToyContext, Serializable entity, String[] paramsNamed, Connection conn, Integer dbType, String tableName) {
        return DialectUtils.isUnique(sqlToyContext, entity, paramsNamed, conn, dbType, tableName, (entityMeta, realParamNamed, table, topSize) -> {
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT sag_uniqueTop.* FROM ( ");
            sql.append(DialectExtUtils.wrapUniqueSql(entityMeta, realParamNamed, dbType, table));
            sql.append(") sag_uniqueTop where ROWNUM <=");
            sql.append(topSize);
            return sql.toString();
        });
    }

    @Override
    public QueryResult findPageBySql(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, QueryExecutor queryExecutor, DecryptHandler decryptHandler, Long pageNo, Integer pageSize, Connection conn, Integer dbType, String dialect, int fetchSize, int maxRows) throws Exception {
        StringBuilder sql = new StringBuilder();
        boolean isNamed = sqlToyConfig.isNamedParam();
        String innerSql = sqlToyConfig.isHasFast() ? sqlToyConfig.getFastSql(dialect) : sqlToyConfig.getSql(dialect);
        boolean hasOrderBy = SqlUtil.hasOrderBy(innerSql, true);
        innerSql = SqlUtilsExt.markOriginalSql(innerSql);
        int startIndex = 1;
        if (sqlToyConfig.isHasFast()) {
            sql.append(sqlToyConfig.getFastPreSql(dialect));
            if (!sqlToyConfig.isIgnoreBracket()) {
                sql.append(" (");
            }
            startIndex = 0;
        }
        sql.append("SELECT * FROM (SELECT ROWNUM page_row_id," + SqlToyConstants.INTERMEDIATE_TABLE + ".* FROM ( ");
        sql.append(innerSql);
        sql.append(") ");
        sql.append(SqlToyConstants.INTERMEDIATE_TABLE);
        sql.append(" ");
        if (SqlToyConstants.oraclePageIgnoreOrder() || !hasOrderBy) {
            sql.append(" where ROWNUM <=");
            sql.append(isNamed ? ":pageFirstParamName" : "?");
            sql.append(" ) WHERE page_row_id>");
            sql.append(isNamed ? ":pageLastParamName" : "?");
        } else {
            sql.append(" ) WHERE page_row_id<=");
            sql.append(isNamed ? ":pageFirstParamName" : "?");
            sql.append(" and page_row_id >");
            sql.append(isNamed ? ":pageLastParamName" : "?");
        }
        if (sqlToyConfig.isHasFast()) {
            if (!sqlToyConfig.isIgnoreBracket()) {
                sql.append(") ");
            }
            sql.append(sqlToyConfig.getFastTailSql(dialect));
        }
        SqlToyResult queryParam = DialectUtils.wrapPageSqlParams(sqlToyContext, sqlToyConfig, queryExecutor, sql.toString(), pageNo * (long)pageSize.intValue(), (pageNo - 1L) * (long)pageSize.intValue(), dialect);
        QueryExecutorExtend extend = queryExecutor.getInnerModel();
        queryParam = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, extend.entityClass == null ? OperateType.page : OperateType.singleTable, queryParam, extend.entityClass, dbType);
        return DialectUtils.findBySql(sqlToyContext, sqlToyConfig, queryParam.getSql(), queryParam.getParamsValue(), extend, decryptHandler, conn, dbType, startIndex, fetchSize, maxRows);
    }

    @Override
    public QueryResult findTopBySql(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, QueryExecutor queryExecutor, DecryptHandler decryptHandler, Integer topSize, Connection conn, Integer dbType, String dialect, int fetchSize, int maxRows) throws Exception {
        StringBuilder sql = new StringBuilder();
        String innerSql = sqlToyConfig.isHasFast() ? sqlToyConfig.getFastSql(dialect) : sqlToyConfig.getSql(dialect);
        innerSql = SqlUtilsExt.markOriginalSql(innerSql);
        if (sqlToyConfig.isHasFast()) {
            sql.append(sqlToyConfig.getFastPreSql(dialect));
            if (!sqlToyConfig.isIgnoreBracket()) {
                sql.append(" (");
            }
        }
        sql.append("SELECT " + SqlToyConstants.INTERMEDIATE_TABLE + ".* FROM ( ");
        sql.append(innerSql);
        sql.append(") " + SqlToyConstants.INTERMEDIATE_TABLE + " where ROWNUM <=");
        sql.append(Double.valueOf(topSize.intValue()).intValue());
        if (sqlToyConfig.isHasFast()) {
            if (!sqlToyConfig.isIgnoreBracket()) {
                sql.append(") ");
            }
            sql.append(sqlToyConfig.getFastTailSql(dialect));
        }
        SqlToyResult queryParam = DialectUtils.wrapPageSqlParams(sqlToyContext, sqlToyConfig, queryExecutor, sql.toString(), null, null, dialect);
        QueryExecutorExtend extend = queryExecutor.getInnerModel();
        queryParam = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, extend.entityClass == null ? OperateType.top : OperateType.singleTable, queryParam, extend.entityClass, dbType);
        return DialectUtils.findBySql(sqlToyContext, sqlToyConfig, queryParam.getSql(), queryParam.getParamsValue(), extend, decryptHandler, conn, dbType, 0, fetchSize, maxRows);
    }
}

