/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.dialect.utils;

import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.sagacity.sqltoy.SqlExecuteStat;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.callback.PreparedStatementResultHandler;
import org.sagacity.sqltoy.callback.ReflectPropsHandler;
import org.sagacity.sqltoy.config.model.EntityMeta;
import org.sagacity.sqltoy.config.model.FieldMeta;
import org.sagacity.sqltoy.config.model.OperateType;
import org.sagacity.sqltoy.config.model.PKStrategy;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.config.model.SqlToyResult;
import org.sagacity.sqltoy.config.model.SqlType;
import org.sagacity.sqltoy.dialect.utils.DefaultDialectUtils;
import org.sagacity.sqltoy.dialect.utils.DialectUtils;
import org.sagacity.sqltoy.model.ColumnMeta;
import org.sagacity.sqltoy.model.IgnoreCaseSet;
import org.sagacity.sqltoy.plugins.IUnifyFieldsHandler;
import org.sagacity.sqltoy.utils.BeanUtil;
import org.sagacity.sqltoy.utils.CollectionUtil;
import org.sagacity.sqltoy.utils.DataSourceUtils;
import org.sagacity.sqltoy.utils.ReservedWordsUtil;
import org.sagacity.sqltoy.utils.SqlUtil;
import org.sagacity.sqltoy.utils.SqlUtilsExt;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClickHouseDialectUtils {
    protected static final Logger logger = LoggerFactory.getLogger(ClickHouseDialectUtils.class);

    public static Object save(final SqlToyContext sqlToyContext, EntityMeta entityMeta, PKStrategy pkStrategy, String insertSql, Serializable entity, final Connection conn, final Integer dbType) throws Exception {
        boolean hasId;
        final boolean isIdentity = pkStrategy != null && pkStrategy.equals((Object)PKStrategy.IDENTITY);
        final boolean isSequence = pkStrategy != null && pkStrategy.equals((Object)PKStrategy.SEQUENCE);
        boolean isAssignPK = ClickHouseDialectUtils.isAssignPKValue(pkStrategy);
        String[] reflectColumns = isIdentity && !isAssignPK || isSequence && !isAssignPK ? entityMeta.getRejectIdFieldArray() : entityMeta.getFieldsArray();
        ReflectPropsHandler handler = DialectUtils.getAddReflectHandler(entityMeta, null, sqlToyContext.getUnifyFieldsHandler());
        handler = DialectUtils.getSecureReflectHandler(handler, sqlToyContext.getFieldsSecureProvider(), sqlToyContext.getDesensitizeProvider(), entityMeta.getSecureFields());
        Object[] fullParamValues = BeanUtil.reflectBeanToAry((Object)entity, reflectColumns, SqlUtilsExt.getDefaultValues(entityMeta), handler);
        boolean needUpdatePk = false;
        int pkIndex = entityMeta.getIdIndex();
        boolean hasBizId = entityMeta.getBusinessIdGenerator() != null;
        int bizIdColIndex = hasBizId ? entityMeta.getFieldIndex(entityMeta.getBusinessIdField()) : 0;
        boolean bl = hasId = pkStrategy != null && null != entityMeta.getIdGenerator();
        if (hasId || hasBizId) {
            Object[] relatedColValue = null;
            Integer[] relatedColumn = entityMeta.getBizIdRelatedColIndex();
            if (relatedColumn != null) {
                int relatedColumnSize = relatedColumn.length;
                relatedColValue = new Object[relatedColumnSize];
                for (int meter = 0; meter < relatedColumnSize; ++meter) {
                    relatedColValue[meter] = fullParamValues[relatedColumn[meter]];
                    if (!StringUtil.isBlank(relatedColValue[meter])) continue;
                    throw new IllegalArgumentException("\u5bf9\u8c61:" + entityMeta.getEntityClass().getName() + " \u751f\u6210\u4e1a\u52a1\u4e3b\u952e\u4f9d\u8d56\u7684\u5173\u8054\u5b57\u6bb5:" + entityMeta.getBizIdRelatedColumns()[meter] + " \u503c\u4e3anull!");
                }
            }
            if (hasId && StringUtil.isBlank(fullParamValues[pkIndex])) {
                fullParamValues[pkIndex] = entityMeta.getIdGenerator().getId(entityMeta.getTableName(), entityMeta.getBizIdSignature(), entityMeta.getBizIdRelatedColumns(), relatedColValue, null, entityMeta.getIdType(), entityMeta.getIdLength(), entityMeta.getBizIdSequenceSize());
                needUpdatePk = true;
            }
            if (hasBizId && StringUtil.isBlank(fullParamValues[bizIdColIndex])) {
                fullParamValues[bizIdColIndex] = entityMeta.getBusinessIdGenerator().getId(entityMeta.getTableName(), entityMeta.getBizIdSignature(), entityMeta.getBizIdRelatedColumns(), relatedColValue, null, entityMeta.getColumnJavaType(entityMeta.getBusinessIdField()), entityMeta.getBizIdLength(), entityMeta.getBizIdSequenceSize());
                BeanUtil.setProperty(entity, entityMeta.getBusinessIdField(), fullParamValues[bizIdColIndex]);
            }
        }
        SqlToyConfig sqlToyConfig = new SqlToyConfig("clickhouse");
        sqlToyConfig.setSqlType(SqlType.insert);
        sqlToyConfig.setSql(insertSql);
        sqlToyConfig.setParamsName(reflectColumns);
        SqlToyResult sqlToyResult = new SqlToyResult(insertSql, fullParamValues);
        sqlToyResult = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, OperateType.insert, sqlToyResult, entity.getClass(), dbType);
        String realInsertSql = sqlToyResult.getSql();
        SqlExecuteStat.showSql("\u6267\u884c\u5355\u8bb0\u5f55\u63d2\u5165", realInsertSql, null);
        final Object[] paramValues = sqlToyResult.getParamsValue();
        final Integer[] paramsType = entityMeta.getFieldsTypeArray();
        PreparedStatement pst = null;
        pst = isIdentity || isSequence ? conn.prepareStatement(insertSql, new String[]{DataSourceUtils.getReturnPrimaryKeyColumn(entityMeta.getColumnName(entityMeta.getIdArray()[0]), dbType)}) : conn.prepareStatement(insertSql);
        Object result = SqlUtil.preparedStatementProcess(null, pst, null, new PreparedStatementResultHandler(){

            @Override
            public void execute(Object obj, PreparedStatement pst, ResultSet rs) throws SQLException, IOException {
                ResultSet keyResult;
                SqlUtil.setParamsValue(sqlToyContext.getTypeHandler(), conn, dbType, pst, paramValues, paramsType, 0);
                pst.execute();
                if ((isIdentity || isSequence) && (keyResult = pst.getGeneratedKeys()) != null) {
                    while (keyResult.next()) {
                        this.setResult(keyResult.getObject(1));
                    }
                    keyResult.close();
                }
            }
        });
        if (entityMeta.getDataVersion() != null) {
            String dataVersionField = entityMeta.getDataVersion().getField();
            int dataVersionIndex = entityMeta.getFieldIndex(dataVersionField);
            BeanUtil.setProperty(entity, dataVersionField, fullParamValues[dataVersionIndex]);
        }
        if (entityMeta.getIdArray() == null) {
            return null;
        }
        if (result == null) {
            result = fullParamValues[pkIndex];
        }
        if (needUpdatePk || isIdentity || isSequence) {
            BeanUtil.setProperty(entity, entityMeta.getIdArray()[0], result);
        }
        return result;
    }

    public static Long saveAll(SqlToyContext sqlToyContext, EntityMeta entityMeta, String insertSql, List<?> entities, int batchSize, ReflectPropsHandler reflectPropsHandler, Connection conn, Integer dbType, Boolean autoCommit) throws Exception {
        PKStrategy pkStrategy = entityMeta.getIdStrategy();
        boolean isIdentity = pkStrategy != null && pkStrategy.equals((Object)PKStrategy.IDENTITY);
        boolean isSequence = pkStrategy != null && pkStrategy.equals((Object)PKStrategy.SEQUENCE);
        boolean isAssignPK = ClickHouseDialectUtils.isAssignPKValue(pkStrategy);
        String[] reflectColumns = isIdentity && !isAssignPK || isSequence && !isAssignPK ? entityMeta.getRejectIdFieldArray() : entityMeta.getFieldsArray();
        ReflectPropsHandler handler = DialectUtils.getAddReflectHandler(entityMeta, reflectPropsHandler, sqlToyContext.getUnifyFieldsHandler());
        handler = DialectUtils.getSecureReflectHandler(handler, sqlToyContext.getFieldsSecureProvider(), sqlToyContext.getDesensitizeProvider(), entityMeta.getSecureFields());
        List paramValues = BeanUtil.reflectBeansToInnerAry(entities, reflectColumns, SqlUtilsExt.getDefaultValues(entityMeta), handler);
        int pkIndex = entityMeta.getIdIndex();
        boolean hasBizId = entityMeta.getBusinessIdGenerator() != null;
        int bizIdColIndex = hasBizId ? entityMeta.getFieldIndex(entityMeta.getBusinessIdField()) : 0;
        Integer[] relatedColumn = entityMeta.getBizIdRelatedColIndex();
        String[] relatedColumnNames = entityMeta.getBizIdRelatedColumns();
        boolean hasDataVersion = entityMeta.getDataVersion() != null;
        int dataVerIndex = hasDataVersion ? entityMeta.getFieldIndex(entityMeta.getDataVersion().getField()) : 0;
        int relatedColumnSize = relatedColumn == null ? 0 : relatedColumn.length;
        boolean hasId = pkStrategy != null && null != entityMeta.getIdGenerator();
        Object[] relatedColValue = null;
        String businessIdType = hasBizId ? entityMeta.getColumnJavaType(entityMeta.getBusinessIdField()) : "";
        int end = paramValues.size();
        for (int i = 0; i < end; ++i) {
            Object[] rowData = paramValues.get(i);
            if (relatedColumn != null) {
                relatedColValue = new Object[relatedColumnSize];
                for (int meter = 0; meter < relatedColumnSize; ++meter) {
                    relatedColValue[meter] = rowData[relatedColumn[meter]];
                    if (!StringUtil.isBlank(relatedColValue[meter])) continue;
                    throw new IllegalArgumentException("\u5bf9\u8c61:" + entityMeta.getEntityClass().getName() + " \u751f\u6210\u4e1a\u52a1\u4e3b\u952e\u4f9d\u8d56\u7684\u5173\u8054\u5b57\u6bb5:" + relatedColumnNames[meter] + " \u503c\u4e3anull!");
                }
            }
            if (hasId && StringUtil.isBlank(rowData[pkIndex])) {
                rowData[pkIndex] = entityMeta.getIdGenerator().getId(entityMeta.getTableName(), entityMeta.getBizIdSignature(), relatedColumnNames, relatedColValue, null, entityMeta.getIdType(), entityMeta.getIdLength(), entityMeta.getBizIdSequenceSize());
                BeanUtil.setProperty(entities.get(i), entityMeta.getIdArray()[0], rowData[pkIndex]);
            }
            if (hasBizId && StringUtil.isBlank(rowData[bizIdColIndex])) {
                rowData[bizIdColIndex] = entityMeta.getBusinessIdGenerator().getId(entityMeta.getTableName(), entityMeta.getBizIdSignature(), relatedColumnNames, relatedColValue, null, businessIdType, entityMeta.getBizIdLength(), entityMeta.getBizIdSequenceSize());
                BeanUtil.setProperty(entities.get(i), entityMeta.getBusinessIdField(), rowData[bizIdColIndex]);
            }
            if (!hasDataVersion) continue;
            BeanUtil.setProperty(entities.get(i), entityMeta.getDataVersion().getField(), rowData[dataVerIndex]);
        }
        List realParams = paramValues;
        String realSql = insertSql;
        if (sqlToyContext.hasSqlInterceptors()) {
            SqlToyConfig sqlToyConfig = new SqlToyConfig("clickhouse");
            sqlToyConfig.setSqlType(SqlType.insert);
            sqlToyConfig.setSql(insertSql);
            sqlToyConfig.setParamsName(reflectColumns);
            SqlToyResult sqlToyResult = new SqlToyResult(insertSql, paramValues.toArray());
            sqlToyResult = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, OperateType.insertAll, sqlToyResult, entities.get(0).getClass(), dbType);
            realSql = sqlToyResult.getSql();
            realParams = CollectionUtil.arrayToList(sqlToyResult.getParamsValue());
        }
        SqlExecuteStat.showSql("\u6279\u91cf\u4fdd\u5b58[" + realParams.size() + "]\u6761\u8bb0\u5f55", realSql, null);
        return SqlUtilsExt.batchUpdateForPOJO(sqlToyContext.getTypeHandler(), realSql, realParams, entityMeta.getFieldsTypeArray(), entityMeta.getFieldsDefaultValue(), entityMeta.getFieldsNullable(), batchSize, autoCommit, conn, dbType);
    }

    public static Long delete(SqlToyContext sqlToyContext, Serializable entity, Connection conn, Integer dbType, String tableName) throws Exception {
        if (entity == null) {
            return 0L;
        }
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entity.getClass());
        if (null == entityMeta.getIdArray()) {
            throw new IllegalArgumentException("delete table:" + entityMeta.getSchemaTable(tableName, dbType) + " no primary key,please check table design!");
        }
        Object[] idValues = BeanUtil.reflectBeanToAry((Object)entity, entityMeta.getIdArray());
        Integer[] parameterTypes = new Integer[idValues.length];
        boolean validator = true;
        int n = idValues.length;
        for (int i = 0; i < n; ++i) {
            parameterTypes[i] = entityMeta.getColumnJdbcType(entityMeta.getIdArray()[i]);
            if (!StringUtil.isBlank(idValues[i])) continue;
            validator = false;
            break;
        }
        if (!validator) {
            throw new IllegalArgumentException(entityMeta.getSchemaTable(tableName, dbType) + "delete operate is illegal,table must has primary key and all primaryKey's value must has value!");
        }
        String deleteSql = "alter table ".concat(entityMeta.getSchemaTable(tableName, dbType)).concat(" delete ").concat(entityMeta.getIdArgWhereSql());
        SqlToyConfig sqlToyConfig = new SqlToyConfig("clickhouse");
        sqlToyConfig.setSqlType(SqlType.delete);
        sqlToyConfig.setSql(deleteSql);
        sqlToyConfig.setParamsName(entityMeta.getIdArray());
        SqlToyResult sqlToyResult = new SqlToyResult(deleteSql, idValues);
        sqlToyResult = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, OperateType.delete, sqlToyResult, entity.getClass(), dbType);
        return SqlUtil.executeSql(sqlToyContext.getTypeHandler(), sqlToyResult.getSql(), sqlToyResult.getParamsValue(), parameterTypes, conn, dbType, null, true);
    }

    public static Long update(SqlToyContext sqlToyContext, Serializable entity, String nullFunction, String[] forceUpdateFields, Connection conn, Integer dbType, String tableName) throws Exception {
        int pkIndex;
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entity.getClass());
        String realTable = entityMeta.getSchemaTable(tableName, dbType);
        if (entityMeta.getIdArray() == null) {
            throw new IllegalArgumentException("\u8868:" + realTable + " \u65e0\u4e3b\u952e,\u4e0d\u7b26\u5408update/updateAll\u89c4\u5219,\u8bf7\u68c0\u67e5\u8868\u8bbe\u8ba1\u662f\u5426\u5408\u7406!");
        }
        if (entityMeta.getRejectIdFieldArray() == null) {
            logger.warn("\u8868:" + realTable + " \u5b57\u6bb5\u5168\u90e8\u662f\u4e3b\u952e\u4e0d\u5b58\u5728\u66f4\u65b0\u5b57\u6bb5,\u65e0\u9700\u6267\u884c\u66f4\u65b0\u64cd\u4f5c!");
            return 0L;
        }
        ReflectPropsHandler handler = DialectUtils.getUpdateReflectHandler(null, forceUpdateFields, sqlToyContext.getUnifyFieldsHandler());
        handler = DialectUtils.getSecureReflectHandler(handler, sqlToyContext.getFieldsSecureProvider(), sqlToyContext.getDesensitizeProvider(), entityMeta.getSecureFields());
        String[] fields = entityMeta.getFieldsNotPartitionKey();
        Object[] fieldsValues = BeanUtil.reflectBeanToAry((Object)entity, fields, null, handler);
        int end = fields.length;
        for (int i = pkIndex = end - entityMeta.getIdArray().length; i < end; ++i) {
            if (!StringUtil.isBlank(fieldsValues[i])) continue;
            throw new IllegalArgumentException("\u901a\u8fc7\u5bf9\u8c61\u5bf9\u8868:" + realTable + " \u8fdb\u884cupdate\u64cd\u4f5c,\u4e3b\u952e\u5b57\u6bb5\u5fc5\u987b\u8981\u8d4b\u503c!");
        }
        String updateSql = ClickHouseDialectUtils.generateUpdateSql(sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, nullFunction, forceUpdateFields, realTable);
        if (updateSql == null) {
            throw new IllegalArgumentException("update sql is null,\u5f15\u8d77\u95ee\u9898\u7684\u539f\u56e0\u662f\u6ca1\u6709\u8bbe\u7f6e\u9700\u8981\u4fee\u6539\u7684\u5b57\u6bb5!");
        }
        SqlToyConfig sqlToyConfig = new SqlToyConfig("clickhouse");
        sqlToyConfig.setSqlType(SqlType.update);
        sqlToyConfig.setSql(updateSql);
        sqlToyConfig.setParamsName(fields);
        SqlToyResult sqlToyResult = new SqlToyResult(updateSql, fieldsValues);
        sqlToyResult = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, OperateType.update, sqlToyResult, entity.getClass(), dbType);
        Long updateCnt = SqlUtil.executeSql(sqlToyContext.getTypeHandler(), sqlToyResult.getSql(), sqlToyResult.getParamsValue(), ClickHouseDialectUtils.getIgnorePartionFieldsTypes(entityMeta), conn, dbType, null, false);
        return updateCnt;
    }

    public static Long updateAll(SqlToyContext sqlToyContext, List<?> entities, int batchSize, String[] forceUpdateFields, ReflectPropsHandler reflectPropsHandler, String nullFunction, Connection conn, Integer dbType, Boolean autoCommit, String tableName, boolean skipNull) throws Exception {
        String updateSql;
        if (entities == null || entities.isEmpty()) {
            return 0L;
        }
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entities.get(0).getClass());
        String realTable = entityMeta.getSchemaTable(tableName, dbType);
        if (entityMeta.getIdArray() == null) {
            throw new IllegalArgumentException("\u8868:" + realTable + " \u65e0\u4e3b\u952e,\u4e0d\u7b26\u5408update/updateAll\u89c4\u5219,\u8bf7\u68c0\u67e5\u8868\u8bbe\u8ba1\u662f\u5426\u5408\u7406!");
        }
        if (entityMeta.getRejectIdFieldArray() == null) {
            logger.warn("\u8868:" + realTable + " \u5b57\u6bb5\u5168\u90e8\u662f\u4e3b\u952e\u4e0d\u5b58\u5728\u66f4\u65b0\u5b57\u6bb5,\u65e0\u9700\u6267\u884c\u66f4\u65b0\u64cd\u4f5c!");
            return 0L;
        }
        ReflectPropsHandler handler = DialectUtils.getUpdateReflectHandler(reflectPropsHandler, forceUpdateFields, sqlToyContext.getUnifyFieldsHandler());
        handler = DialectUtils.getSecureReflectHandler(handler, sqlToyContext.getFieldsSecureProvider(), sqlToyContext.getDesensitizeProvider(), entityMeta.getSecureFields());
        String[] fields = entityMeta.getFieldsNotPartitionKey();
        List paramsValues = BeanUtil.reflectBeansToInnerAry(entities, fields, null, handler);
        int end = fields.length;
        int pkIndex = end - entityMeta.getIdArray().length;
        int index = 0;
        int skipCount = 0;
        Iterator<Object[]> iter = paramsValues.iterator();
        while (iter.hasNext()) {
            Object[] rowValues = iter.next();
            for (int i = pkIndex; i < end; ++i) {
                if (!StringUtil.isBlank(rowValues[i])) continue;
                if (skipNull) {
                    ++skipCount;
                    iter.remove();
                    break;
                }
                throw new IllegalArgumentException("\u901a\u8fc7\u5bf9\u8c61\u5bf9\u8868" + realTable + " \u8fdb\u884cupdateAll\u64cd\u4f5c,\u4e3b\u952e\u5b57\u6bb5\u5fc5\u987b\u8981\u8d4b\u503c!\u7b2c:" + index + " \u6761\u8bb0\u5f55\u4e3b\u952e\u4e3anull!");
            }
            ++index;
        }
        if (skipCount > 0) {
            logger.debug("\u5171\u6709:{}\u884c\u8bb0\u5f55\u56e0\u4e3a\u4e3b\u952e\u503c\u4e3a\u7a7a\u8df3\u8fc7\u4fee\u6539\u64cd\u4f5c!", (Object)skipCount);
        }
        if ((updateSql = ClickHouseDialectUtils.generateUpdateSql(sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, nullFunction, forceUpdateFields, realTable)) == null) {
            throw new IllegalArgumentException("updateAll sql is null,\u5f15\u8d77\u95ee\u9898\u7684\u539f\u56e0\u662f\u6ca1\u6709\u8bbe\u7f6e\u9700\u8981\u4fee\u6539\u7684\u5b57\u6bb5!");
        }
        List realParams = paramsValues;
        String realSql = updateSql;
        if (sqlToyContext.hasSqlInterceptors()) {
            SqlToyConfig sqlToyConfig = new SqlToyConfig("clickhouse");
            sqlToyConfig.setSqlType(SqlType.update);
            sqlToyConfig.setSql(updateSql);
            sqlToyConfig.setParamsName(fields);
            SqlToyResult sqlToyResult = new SqlToyResult(updateSql, paramsValues.toArray());
            sqlToyResult = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, OperateType.updateAll, sqlToyResult, entities.get(0).getClass(), dbType);
            realSql = sqlToyResult.getSql();
            realParams = CollectionUtil.arrayToList(sqlToyResult.getParamsValue());
        }
        SqlExecuteStat.showSql("\u6279\u91cf\u4fee\u6539[" + realParams.size() + "]\u6761\u8bb0\u5f55", realSql, null);
        return SqlUtilsExt.batchUpdateForPOJO(sqlToyContext.getTypeHandler(), realSql, realParams, ClickHouseDialectUtils.getIgnorePartionFieldsTypes(entityMeta), null, null, batchSize, autoCommit, conn, dbType);
    }

    private static Integer[] getIgnorePartionFieldsTypes(EntityMeta entityMeta) {
        ArrayList<Integer> fieldTypes = new ArrayList<Integer>();
        String[] fields = entityMeta.getFieldsArray();
        Integer[] fieldTypesArray = entityMeta.getFieldsTypeArray();
        for (int i = 0; i < fields.length; ++i) {
            FieldMeta fieldMeta = entityMeta.getFieldMeta(fields[i]);
            if (fieldMeta.isPartitionKey()) continue;
            fieldTypes.add(fieldTypesArray[i]);
        }
        Integer[] result = new Integer[fieldTypes.size()];
        fieldTypes.toArray(result);
        return result;
    }

    private static String generateUpdateSql(IUnifyFieldsHandler unifyFieldsHandler, Integer dbType, EntityMeta entityMeta, String nullFunction, String[] forceUpdateFields, String tableName) {
        String columnName;
        int i;
        if (entityMeta.getIdArray() == null) {
            return null;
        }
        IgnoreCaseSet updateSqlTimeFields = unifyFieldsHandler == null || unifyFieldsHandler.updateSqlTimeFields() == null ? new IgnoreCaseSet() : unifyFieldsHandler.updateSqlTimeFields();
        StringBuilder sql = new StringBuilder(entityMeta.getFieldsArray().length * 30 + 30);
        sql.append(" alter table  ");
        sql.append(tableName);
        sql.append(" update ");
        HashSet<String> fupc = new HashSet<String>();
        if (forceUpdateFields != null) {
            for (String field : forceUpdateFields) {
                fupc.add(ReservedWordsUtil.convertWord(entityMeta.getColumnName(field), dbType));
            }
        }
        int meter = 0;
        int n = entityMeta.getRejectIdFieldArray().length;
        for (i = 0; i < n; ++i) {
            FieldMeta fieldMeta = entityMeta.getFieldMeta(entityMeta.getRejectIdFieldArray()[i]);
            if (fieldMeta.isPartitionKey()) continue;
            columnName = ReservedWordsUtil.convertWord(fieldMeta.getColumnName(), dbType);
            if (meter > 0) {
                sql.append(",");
            }
            sql.append(columnName);
            sql.append("=");
            if (fupc.contains(columnName)) {
                sql.append("?");
            } else {
                String currentTimeStr = SqlUtil.getDBTime(dbType, fieldMeta, updateSqlTimeFields);
                sql.append(nullFunction);
                sql.append("(?,");
                if (null != currentTimeStr) {
                    sql.append(currentTimeStr);
                } else {
                    sql.append(columnName);
                }
                sql.append(")");
            }
            ++meter;
        }
        sql.append(" where ");
        n = entityMeta.getIdArray().length;
        for (i = 0; i < n; ++i) {
            columnName = entityMeta.getColumnName(entityMeta.getIdArray()[i]);
            columnName = ReservedWordsUtil.convertWord(columnName, dbType);
            if (i > 0) {
                sql.append(" and ");
            }
            sql.append(columnName);
            sql.append("=?");
        }
        return sql.toString();
    }

    public static List<ColumnMeta> getTableColumns(String catalog, String schema, final String tableName, Connection conn, Integer dbType, String dialect) throws Exception {
        List<ColumnMeta> tableColumns = DefaultDialectUtils.getTableColumns(catalog, schema, tableName, conn, dbType, dialect);
        String sql = "SELECT name COLUMN_NAME,comment COMMENTS,is_in_primary_key PRIMARY_KEY,is_in_partition_key PARTITION_KEY from system.columns t where t.table=?";
        PreparedStatement pst = conn.prepareStatement(sql);
        ResultSet rs = null;
        Map colMap = (Map)SqlUtil.preparedStatementProcess(null, pst, rs, new PreparedStatementResultHandler(){

            @Override
            public void execute(Object rowData, PreparedStatement pst, ResultSet rs) throws Exception {
                try {
                    pst.setString(1, tableName);
                    rs = pst.executeQuery();
                    HashMap<String, ColumnMeta> colComments = new HashMap<String, ColumnMeta>();
                    while (rs.next()) {
                        ColumnMeta colMeta = new ColumnMeta();
                        colMeta.setColName(rs.getString("COLUMN_NAME"));
                        colMeta.setComments(rs.getString("COMMENTS"));
                        colMeta.setPK("1".equals(rs.getString("PRIMARY_KEY")));
                        colMeta.setPartitionKey("1".equals(rs.getString("PARTITION_KEY")));
                        colComments.put(colMeta.getColName(), colMeta);
                    }
                    this.setResult(colComments);
                }
                catch (Exception e) {
                    throw e;
                }
                finally {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
            }
        });
        for (ColumnMeta col : tableColumns) {
            ColumnMeta mapColMeta = (ColumnMeta)colMap.get(col.getColName());
            if (mapColMeta == null) continue;
            col.setComments(mapColMeta.getComments());
            col.setPK(mapColMeta.isPK());
            col.setPartitionKey(mapColMeta.isPartitionKey());
        }
        return tableColumns;
    }

    public static boolean isAssignPKValue(PKStrategy pkStrategy) {
        if (pkStrategy == null) {
            return true;
        }
        if (pkStrategy.equals((Object)PKStrategy.SEQUENCE)) {
            return true;
        }
        return !pkStrategy.equals((Object)PKStrategy.IDENTITY);
    }

    public static String wrapDelOrUpdate(EntityMeta entityMeta, String sql, SqlType sqlType) {
        String startSql = "alter table ".concat(entityMeta.getSchemaTable(null, 60));
        if (sqlType == SqlType.delete) {
            sql = startSql.concat(" delete ").concat(sql.substring(StringUtil.matchIndex(sql, "(?i)\\swhere\\s")));
        } else if (sqlType == SqlType.update) {
            sql = startSql.concat(" update ").concat(sql.substring(StringUtil.matchIndex(sql, "(?i)\\sset\\s") + 4));
        }
        return sql;
    }
}

