/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.dialect.utils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import org.sagacity.sqltoy.config.model.EntityMeta;
import org.sagacity.sqltoy.config.model.FieldMeta;
import org.sagacity.sqltoy.config.model.PKStrategy;
import org.sagacity.sqltoy.dialect.utils.DB2DialectUtils;
import org.sagacity.sqltoy.dialect.utils.H2DialectUtils;
import org.sagacity.sqltoy.dialect.utils.PostgreSqlDialectUtils;
import org.sagacity.sqltoy.model.IgnoreCaseSet;
import org.sagacity.sqltoy.model.IgnoreKeyCaseMap;
import org.sagacity.sqltoy.plugins.IUnifyFieldsHandler;
import org.sagacity.sqltoy.utils.DateUtil;
import org.sagacity.sqltoy.utils.ReservedWordsUtil;
import org.sagacity.sqltoy.utils.SqlUtil;
import org.sagacity.sqltoy.utils.SqlUtilsExt;
import org.sagacity.sqltoy.utils.StringUtil;

public class DialectExtUtils {
    private static ConcurrentHashMap<String, String> insertSqlCache = new ConcurrentHashMap(256);
    private static ConcurrentHashMap<String, String> mergeIgnoreSqlCache = new ConcurrentHashMap(256);
    private static ConcurrentHashMap<String, String> insertIgnoreSqlCache = new ConcurrentHashMap(256);

    public static String generateInsertSql(IUnifyFieldsHandler unifyFieldsHandler, Integer dbType, EntityMeta entityMeta, PKStrategy pkStrategy, String isNullFunction, String sequence, boolean isAssignPK, String tableName) {
        String sqlCacheKey = DialectExtUtils.getCacheKey(entityMeta, tableName, dbType, pkStrategy);
        String insertSql = insertSqlCache.get(sqlCacheKey);
        if (null != insertSql) {
            return insertSql;
        }
        int columnSize = entityMeta.getFieldsArray().length;
        StringBuilder sql = new StringBuilder(columnSize * 20 + 30);
        StringBuilder values = new StringBuilder(columnSize * 2 - 1);
        sql.append("insert into ");
        sql.append(entityMeta.getSchemaTable(tableName, dbType));
        sql.append(" (");
        boolean isStart = true;
        boolean isSupportNULL = !StringUtil.isBlank(isNullFunction);
        IgnoreCaseSet createSqlTimeFields = unifyFieldsHandler == null || unifyFieldsHandler.createSqlTimeFields() == null ? new IgnoreCaseSet() : unifyFieldsHandler.createSqlTimeFields();
        boolean isString = false;
        for (int i = 0; i < columnSize; ++i) {
            String field = entityMeta.getFieldsArray()[i];
            FieldMeta fieldMeta = entityMeta.getFieldMeta(field);
            isString = false;
            if ("java.lang.string".equals(fieldMeta.getFieldType())) {
                isString = true;
            }
            String columnName = ReservedWordsUtil.convertWord(fieldMeta.getColumnName(), dbType);
            if (fieldMeta.isPK()) {
                if (pkStrategy.equals((Object)PKStrategy.IDENTITY)) {
                    if (!isAssignPK) continue;
                    if (!isStart) {
                        sql.append(",");
                        values.append(",");
                    }
                    sql.append(columnName);
                    values.append("?");
                    isStart = false;
                    continue;
                }
                if (pkStrategy.equals((Object)PKStrategy.SEQUENCE)) {
                    if (!isStart) {
                        sql.append(",");
                        values.append(",");
                    }
                    sql.append(columnName);
                    if (isAssignPK && isSupportNULL) {
                        values.append(isNullFunction);
                        values.append("(?,").append(sequence).append(")");
                    } else {
                        values.append(sequence);
                    }
                    isStart = false;
                    continue;
                }
                if (!isStart) {
                    sql.append(",");
                    values.append(",");
                }
                sql.append(columnName);
                values.append("?");
                isStart = false;
                continue;
            }
            if (!isStart) {
                sql.append(",");
                values.append(",");
            }
            sql.append(columnName);
            if (dbType == 160 && isString) {
                values.append("cast(? as string)");
            } else {
                String currentTimeStr = SqlUtil.getDBTime(dbType, fieldMeta, createSqlTimeFields);
                if (null != currentTimeStr) {
                    values.append(isNullFunction).append("(?,").append(currentTimeStr).append(")");
                } else {
                    values.append("?");
                }
            }
            isStart = false;
        }
        sql.append(") ");
        sql.append(" values (");
        sql.append((CharSequence)values);
        sql.append(")");
        insertSql = sql.toString();
        insertSqlCache.put(sqlCacheKey, insertSql);
        return insertSql;
    }

    public static void processDefaultValue(StringBuilder sql, int dbType, FieldMeta fieldMeta, String defaultValue) {
        String fieldType = fieldMeta.getFieldType();
        if ("java.lang.string".equals(fieldType)) {
            if (!defaultValue.startsWith("'")) {
                sql.append("'");
            }
            sql.append(defaultValue);
            if (!defaultValue.endsWith("'")) {
                sql.append("'");
            }
            return;
        }
        String defaultLow = defaultValue.toLowerCase();
        boolean isCurrentTime = SqlUtilsExt.isCurrentTime(defaultLow);
        int dateType = -1;
        if ("java.time.localtime".equals(fieldType) || "java.sql.time".equals(fieldType)) {
            dateType = 1;
        } else if ("java.time.localdate".equals(fieldType)) {
            dateType = 2;
        } else if ("java.time.localdatetime".equals(fieldType) || "java.util.date".equals(fieldType) || "java.sql.date".equals(fieldType)) {
            dateType = 3;
        } else if ("java.sql.timestamp".equals(fieldType) || "oracle.sql.timestamp".equals(fieldType)) {
            dateType = 4;
        }
        String result = defaultValue;
        if (isCurrentTime && dateType != -1) {
            if (dateType == 1) {
                result = DateUtil.formatDate(DateUtil.getNowTime(), "HH:mm:ss");
            } else if (dateType == 2) {
                result = DateUtil.formatDate(DateUtil.getNowTime(), "yyyy-MM-dd");
            } else if (dateType == 3) {
                result = DateUtil.formatDate(DateUtil.getNowTime(), "yyyy-MM-dd HH:mm:ss");
            } else if (dateType == 4) {
                result = DateUtil.formatDate(DateUtil.getNowTime(), "yyyy-MM-dd HH:mm:ss.SSS");
            }
        }
        if (dateType != -1) {
            if (!result.startsWith("'") && !result.endsWith("'")) {
                result = "'".concat(result).concat("'");
            }
            if (dateType == 1) {
                if (dbType == 20) {
                    result = "time(" + result + ")";
                } else if (dbType == 10 || dbType == 11) {
                    result = "to_date(" + result + ",'HH24:mi:ss')";
                }
            } else if (dateType == 2) {
                if (dbType == 20) {
                    result = "date(" + result + ")";
                } else if (dbType == 10 || dbType == 11) {
                    result = "to_date(" + result + ",'yyyy-MM-dd')";
                }
            } else if (dateType == 3) {
                if (dbType == 20) {
                    result = "timestamp(" + result + ")";
                } else if (dbType == 10 || dbType == 11) {
                    result = "to_date(" + result + ",'yyyy-MM-dd HH24:mi:ss')";
                }
            } else if (dateType == 4) {
                if (dbType == 20) {
                    result = isCurrentTime ? "CURRENT TIMESTAMP" : "timestamp(" + result + ")";
                } else if (dbType == 10 || dbType == 11) {
                    result = isCurrentTime ? "CURRENT_TIMESTAMP" : "TO_TIMESTAMP(" + result + ",'yyyy-MM-dd HH24:mi:ss.FF')";
                } else if ((dbType == 40 || dbType == 42 || dbType == 50 || dbType == 51 || dbType == 110 || dbType == 70 || dbType == 210 || dbType == 190 || dbType == 220 || dbType == 180 || dbType == 200 || dbType == 100 || dbType == 80 || dbType == 120 || dbType == 30 || dbType == 90 || dbType == 170) && isCurrentTime) {
                    result = "CURRENT_TIMESTAMP";
                }
            }
        }
        sql.append(result);
    }

    public static String wrapUniqueSql(EntityMeta entityMeta, String[] realParamNamed, Integer dbType, String tableName) {
        StringBuilder queryStr = new StringBuilder("select 1 ");
        if (null != entityMeta.getIdArray()) {
            for (String idFieldName : entityMeta.getIdArray()) {
                queryStr.append(",");
                queryStr.append(ReservedWordsUtil.convertWord(entityMeta.getColumnName(idFieldName), dbType));
            }
        }
        queryStr.append(" from ");
        queryStr.append(entityMeta.getSchemaTable(tableName, dbType));
        queryStr.append(" where  ");
        for (int i = 0; i < realParamNamed.length; ++i) {
            if (i > 0) {
                queryStr.append(" and ");
            }
            queryStr.append(ReservedWordsUtil.convertWord(entityMeta.getColumnName(realParamNamed[i]), dbType)).append("=:" + realParamNamed[i]);
        }
        return queryStr.toString();
    }

    public static String mergeIgnore(IUnifyFieldsHandler unifyFieldsHandler, Integer dbType, EntityMeta entityMeta, PKStrategy pkStrategy, String fromTable, String isNullFunction, String sequence, boolean isAssignPK, String tableName) {
        boolean allIds;
        String columnName;
        FieldMeta fieldMeta;
        String realTable = entityMeta.getSchemaTable(tableName, dbType);
        if (entityMeta.getIdArray() == null && entityMeta.getUniqueIndex() == null) {
            return DialectExtUtils.generateInsertSql(unifyFieldsHandler, dbType, entityMeta, pkStrategy, isNullFunction, sequence, isAssignPK, realTable);
        }
        String sqlCacheKey = DialectExtUtils.getCacheKey(entityMeta, tableName, dbType, pkStrategy);
        String mergeIgnoreSql = mergeIgnoreSqlCache.get(sqlCacheKey);
        if (null != mergeIgnoreSql) {
            return mergeIgnoreSql;
        }
        IgnoreCaseSet createSqlTimeFields = unifyFieldsHandler == null || unifyFieldsHandler.createSqlTimeFields() == null ? new IgnoreCaseSet() : unifyFieldsHandler.createSqlTimeFields();
        IgnoreCaseSet forceUpdateSqlTimeFields = new IgnoreCaseSet();
        if (unifyFieldsHandler != null && unifyFieldsHandler.forceUpdateFields() != null) {
            forceUpdateSqlTimeFields = unifyFieldsHandler.forceUpdateFields();
        }
        int columnSize = entityMeta.getFieldsArray().length;
        StringBuilder sql = new StringBuilder(columnSize * 30 + 100);
        sql.append("merge into ");
        sql.append(realTable);
        if (51 != dbType) {
            sql.append(" ta ");
        }
        sql.append(" using (select ");
        for (int i = 0; i < columnSize; ++i) {
            fieldMeta = entityMeta.getFieldMeta(entityMeta.getFieldsArray()[i]);
            columnName = ReservedWordsUtil.convertWord(fieldMeta.getColumnName(), dbType);
            if (i > 0) {
                sql.append(",");
            }
            if (51 == dbType) {
                PostgreSqlDialectUtils.wrapSelectFields(sql, columnName, fieldMeta);
                continue;
            }
            if (170 == dbType) {
                H2DialectUtils.wrapSelectFields(sql, columnName, fieldMeta);
                continue;
            }
            if (20 == dbType) {
                DB2DialectUtils.wrapSelectFields(sql, columnName, fieldMeta);
                continue;
            }
            sql.append("? as ");
            sql.append(columnName);
        }
        if (StringUtil.isNotBlank(fromTable)) {
            sql.append(" from ").append(fromTable);
        }
        sql.append(") tv on (");
        StringBuilder idColumns = new StringBuilder();
        boolean hasId = entityMeta.getIdArray() != null;
        String[] fields = hasId ? entityMeta.getIdArray() : entityMeta.getUniqueIndex().getColumns();
        int n = fields.length;
        for (int i = 0; i < n; ++i) {
            columnName = hasId ? entityMeta.getColumnName(fields[i]) : fields[i];
            columnName = ReservedWordsUtil.convertWord(columnName, dbType);
            if (i > 0) {
                sql.append(" and ");
                idColumns.append(",");
            }
            if (51 == dbType) {
                sql.append(realTable + ".");
            } else {
                sql.append("ta.");
            }
            sql.append(columnName).append("=tv.").append(columnName);
            idColumns.append("ta.").append(columnName);
        }
        sql.append(" ) ");
        StringBuilder insertRejIdCols = new StringBuilder();
        StringBuilder insertRejIdColValues = new StringBuilder();
        boolean bl = allIds = entityMeta.getRejectIdFieldArray() == null;
        if (!allIds) {
            int rejectIdColumnSize = entityMeta.getRejectIdFieldArray().length;
            for (int i = 0; i < rejectIdColumnSize; ++i) {
                fieldMeta = entityMeta.getFieldMeta(entityMeta.getRejectIdFieldArray()[i]);
                columnName = ReservedWordsUtil.convertWord(fieldMeta.getColumnName(), dbType);
                if (i > 0) {
                    insertRejIdCols.append(",");
                    insertRejIdColValues.append(",");
                }
                insertRejIdCols.append(columnName);
                String currentTimeStr = SqlUtil.getDBTime(dbType, fieldMeta, createSqlTimeFields);
                if (null != currentTimeStr) {
                    if (forceUpdateSqlTimeFields.contains(fieldMeta.getFieldName())) {
                        insertRejIdColValues.append(currentTimeStr);
                        continue;
                    }
                    insertRejIdColValues.append(isNullFunction);
                    insertRejIdColValues.append("(tv.").append(columnName);
                    insertRejIdColValues.append(",").append(currentTimeStr);
                    insertRejIdColValues.append(")");
                    continue;
                }
                insertRejIdColValues.append("tv.").append(columnName);
            }
        }
        sql.append(" when not matched then insert ");
        sql.append(" (");
        String idsColumnStr = idColumns.toString();
        if (allIds) {
            sql.append(idsColumnStr.replace("ta.", ""));
            sql.append(") values (");
            sql.append(idsColumnStr.replace("ta.", "tv."));
        } else {
            sql.append(insertRejIdCols.toString());
            if (pkStrategy == null) {
                sql.append(") values (");
                sql.append((CharSequence)insertRejIdColValues);
            } else if (pkStrategy.equals((Object)PKStrategy.SEQUENCE)) {
                columnName = entityMeta.getColumnName(entityMeta.getIdArray()[0]);
                columnName = ReservedWordsUtil.convertWord(columnName, dbType);
                sql.append(",");
                sql.append(columnName);
                sql.append(") values (");
                sql.append((CharSequence)insertRejIdColValues).append(",");
                if (isAssignPK) {
                    sql.append(isNullFunction);
                    sql.append("(tv.").append(columnName).append(",");
                    sql.append(sequence).append(") ");
                } else {
                    sql.append(sequence);
                }
            } else if (pkStrategy.equals((Object)PKStrategy.IDENTITY)) {
                columnName = entityMeta.getColumnName(entityMeta.getIdArray()[0]);
                columnName = ReservedWordsUtil.convertWord(columnName, dbType);
                if (isAssignPK) {
                    sql.append(",");
                    sql.append(columnName);
                }
                sql.append(") values (");
                sql.append((CharSequence)insertRejIdColValues);
                if (isAssignPK) {
                    sql.append(",").append("tv.").append(columnName);
                }
            } else {
                sql.append(",");
                sql.append(idsColumnStr.replace("ta.", ""));
                sql.append(") values (");
                sql.append((CharSequence)insertRejIdColValues).append(",");
                sql.append(idsColumnStr.replace("ta.", "tv."));
            }
        }
        sql.append(")");
        mergeIgnoreSql = sql.toString();
        mergeIgnoreSqlCache.put(sqlCacheKey, mergeIgnoreSql);
        return mergeIgnoreSql;
    }

    public static String insertIgnore(IUnifyFieldsHandler unifyFieldsHandler, Integer dbType, EntityMeta entityMeta, PKStrategy pkStrategy, String isNullFunction, String sequence, boolean isAssignPK, String tableName) {
        String columnName;
        int i;
        String sqlCacheKey = DialectExtUtils.getCacheKey(entityMeta, tableName, dbType, pkStrategy);
        String insertIgnoreSql = insertIgnoreSqlCache.get(sqlCacheKey);
        if (null != insertIgnoreSql) {
            return insertIgnoreSql;
        }
        int columnSize = entityMeta.getFieldsArray().length;
        StringBuilder sql = new StringBuilder(columnSize * 20 + 30);
        StringBuilder values = new StringBuilder(columnSize * 2 - 1);
        if (dbType == 70) {
            sql.append("insert ignore into ");
        } else {
            sql.append("insert into ");
        }
        sql.append(entityMeta.getSchemaTable(tableName, dbType));
        sql.append(" (");
        boolean isStart = true;
        IgnoreCaseSet createSqlTimeFields = unifyFieldsHandler == null || unifyFieldsHandler.createSqlTimeFields() == null ? new IgnoreCaseSet() : unifyFieldsHandler.createSqlTimeFields();
        for (i = 0; i < columnSize; ++i) {
            String field = entityMeta.getFieldsArray()[i];
            FieldMeta fieldMeta = entityMeta.getFieldMeta(field);
            columnName = ReservedWordsUtil.convertWord(fieldMeta.getColumnName(), dbType);
            if (fieldMeta.isPK()) {
                if (pkStrategy.equals((Object)PKStrategy.IDENTITY)) {
                    if (!isAssignPK) continue;
                    if (!isStart) {
                        sql.append(",");
                        values.append(",");
                    }
                    sql.append(columnName);
                    values.append("?");
                    isStart = false;
                    continue;
                }
                if (pkStrategy.equals((Object)PKStrategy.SEQUENCE)) {
                    if (!isStart) {
                        sql.append(",");
                        values.append(",");
                    }
                    sql.append(columnName);
                    values.append(isNullFunction).append("(?,").append(sequence).append(")");
                    isStart = false;
                    continue;
                }
                if (!isStart) {
                    sql.append(",");
                    values.append(",");
                }
                sql.append(columnName);
                values.append("?");
                isStart = false;
                continue;
            }
            if (!isStart) {
                sql.append(",");
                values.append(",");
            }
            sql.append(columnName);
            String currentTimeStr = SqlUtil.getDBTime(dbType, fieldMeta, createSqlTimeFields);
            if (null != currentTimeStr) {
                values.append(isNullFunction);
                values.append("(?,");
                values.append(currentTimeStr);
                values.append(")");
            } else {
                values.append("?");
            }
            isStart = false;
        }
        sql.append(") values ( ");
        sql.append((CharSequence)values);
        sql.append(")");
        if (dbType != 70 && entityMeta.getIdArray() != null) {
            sql.append(" ON CONFLICT (");
            int n = entityMeta.getIdArray().length;
            for (i = 0; i < n; ++i) {
                if (i > 0) {
                    sql.append(",");
                }
                columnName = entityMeta.getColumnName(entityMeta.getIdArray()[i]);
                sql.append(ReservedWordsUtil.convertWord(columnName, dbType));
            }
            sql.append(" ) DO NOTHING ");
        }
        insertIgnoreSql = sql.toString();
        insertIgnoreSqlCache.put(sqlCacheKey, insertIgnoreSql);
        return insertIgnoreSql;
    }

    public static String getInsertDefaultValue(IgnoreKeyCaseMap<String, Object> createUnifyFields, Integer dbType, FieldMeta fieldMeta) {
        if (createUnifyFields == null || createUnifyFields.isEmpty() || !createUnifyFields.containsKey(fieldMeta.getFieldName())) {
            return fieldMeta.getDefaultValue();
        }
        Object unifyFieldValue = createUnifyFields.get(fieldMeta.getFieldName());
        if (unifyFieldValue != null) {
            if (unifyFieldValue instanceof String) {
                return (String)unifyFieldValue;
            }
            if (unifyFieldValue instanceof Number) {
                return unifyFieldValue.toString();
            }
            String fieldType = fieldMeta.getFieldType();
            if ("java.time.localdate".equals(fieldType)) {
                return DateUtil.formatDate(unifyFieldValue, "yyyy-MM-dd");
            }
            if ("java.time.localtime".equals(fieldType) || "java.sql.time".equals(fieldType)) {
                return DateUtil.formatDate(unifyFieldValue, "HH:mm:ss");
            }
            if ("java.time.localdatetime".equals(fieldType) || "java.sql.timestamp".equals(fieldType) || "java.util.date".equals(fieldType) || "java.sql.date".equals(fieldType)) {
                return DateUtil.formatDate(unifyFieldValue, "yyyy-MM-dd HH:mm:ss");
            }
            if (unifyFieldValue instanceof Date || unifyFieldValue instanceof LocalDate || unifyFieldValue instanceof LocalDateTime) {
                if ("java.lang.integer".equals(fieldType) || "int".equals(fieldType)) {
                    return DateUtil.formatDate(unifyFieldValue, "yyyyMMdd");
                }
                if ("java.lang.long".equals(fieldType) || "java.math.biginteger".equals(fieldType) || "long".equals(fieldType)) {
                    return DateUtil.formatDate(unifyFieldValue, "yyyyMMddHHmmss");
                }
                if ("java.lang.string".equals(fieldType)) {
                    if (fieldMeta.getLength() >= 19) {
                        return DateUtil.formatDate(unifyFieldValue, "yyyy-MM-dd HH:mm:ss");
                    }
                    if (fieldMeta.getLength() >= 14) {
                        return DateUtil.formatDate(unifyFieldValue, "yyyyMMddHHmmss");
                    }
                    if (fieldMeta.getLength() >= 8) {
                        return DateUtil.formatDate(unifyFieldValue, "yyyyMMdd");
                    }
                }
            }
        }
        return fieldMeta.getDefaultValue();
    }

    private static String getCacheKey(EntityMeta entityMeta, String tableName, int dbType, PKStrategy pkStrategy) {
        return entityMeta.getEntityClass().getName() + "[" + tableName + "]dbType=" + dbType + (pkStrategy == null ? "" : pkStrategy.getValue());
    }
}

