/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.dialect.utils;

import java.io.IOException;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.sagacity.sqltoy.SqlExecuteStat;
import org.sagacity.sqltoy.SqlToyConstants;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.SqlToyThreadDataHolder;
import org.sagacity.sqltoy.callback.CallableStatementResultHandler;
import org.sagacity.sqltoy.callback.DecryptHandler;
import org.sagacity.sqltoy.callback.GenerateSavePKStrategy;
import org.sagacity.sqltoy.callback.GenerateSqlHandler;
import org.sagacity.sqltoy.callback.LockSqlHandler;
import org.sagacity.sqltoy.callback.PreparedStatementResultHandler;
import org.sagacity.sqltoy.callback.ReflectPropsHandler;
import org.sagacity.sqltoy.callback.UniqueSqlHandler;
import org.sagacity.sqltoy.callback.UpdateRowHandler;
import org.sagacity.sqltoy.config.SqlConfigParseUtils;
import org.sagacity.sqltoy.config.model.DataVersionConfig;
import org.sagacity.sqltoy.config.model.EntityMeta;
import org.sagacity.sqltoy.config.model.FieldMeta;
import org.sagacity.sqltoy.config.model.FieldSecureConfig;
import org.sagacity.sqltoy.config.model.FieldTranslate;
import org.sagacity.sqltoy.config.model.OperateType;
import org.sagacity.sqltoy.config.model.PKStrategy;
import org.sagacity.sqltoy.config.model.ShardingStrategyConfig;
import org.sagacity.sqltoy.config.model.SqlParamsModel;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.config.model.SqlToyResult;
import org.sagacity.sqltoy.config.model.SqlType;
import org.sagacity.sqltoy.config.model.SqlWithAnalysis;
import org.sagacity.sqltoy.config.model.TableCascadeModel;
import org.sagacity.sqltoy.config.model.Translate;
import org.sagacity.sqltoy.dialect.model.SavePKStrategy;
import org.sagacity.sqltoy.dialect.utils.DB2DialectUtils;
import org.sagacity.sqltoy.dialect.utils.DialectExtUtils;
import org.sagacity.sqltoy.dialect.utils.H2DialectUtils;
import org.sagacity.sqltoy.dialect.utils.MySqlDialectUtils;
import org.sagacity.sqltoy.dialect.utils.OpenGaussDialectUtils;
import org.sagacity.sqltoy.dialect.utils.OracleDialectUtils;
import org.sagacity.sqltoy.dialect.utils.PostgreSqlDialectUtils;
import org.sagacity.sqltoy.dialect.utils.SqliteDialectUtils;
import org.sagacity.sqltoy.exception.DataAccessException;
import org.sagacity.sqltoy.model.IgnoreCaseSet;
import org.sagacity.sqltoy.model.IgnoreKeyCaseMap;
import org.sagacity.sqltoy.model.LockMode;
import org.sagacity.sqltoy.model.MapKit;
import org.sagacity.sqltoy.model.QueryExecutor;
import org.sagacity.sqltoy.model.QueryResult;
import org.sagacity.sqltoy.model.SecureType;
import org.sagacity.sqltoy.model.StoreResult;
import org.sagacity.sqltoy.model.inner.QueryExecutorExtend;
import org.sagacity.sqltoy.plugins.IUnifyFieldsHandler;
import org.sagacity.sqltoy.plugins.SqlInterceptor;
import org.sagacity.sqltoy.plugins.secure.DesensitizeProvider;
import org.sagacity.sqltoy.plugins.secure.FieldsSecureProvider;
import org.sagacity.sqltoy.plugins.sharding.ShardingUtils;
import org.sagacity.sqltoy.utils.BeanUtil;
import org.sagacity.sqltoy.utils.CollectionUtil;
import org.sagacity.sqltoy.utils.DataSourceUtils;
import org.sagacity.sqltoy.utils.DateUtil;
import org.sagacity.sqltoy.utils.QueryExecutorBuilder;
import org.sagacity.sqltoy.utils.ReservedWordsUtil;
import org.sagacity.sqltoy.utils.ResultUtils;
import org.sagacity.sqltoy.utils.SqlUtil;
import org.sagacity.sqltoy.utils.SqlUtilsExt;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialectUtils {
    protected static final Logger logger = LoggerFactory.getLogger(DialectUtils.class);
    public static final Pattern UNION_PATTERN = Pattern.compile("(?i)\\W+union\\W+");
    public static final Pattern ORDER_BY_PATTERN = Pattern.compile("(?i)\\Worder\\s+by\\W");
    public static final Pattern GROUP_BY_PATTERN = Pattern.compile("(?i)\\Wgroup\\s+by\\W");
    public static final Pattern STORE_PATTERN = Pattern.compile("^(\\s*\\{)?\\s*\\?");
    public static final Pattern DISTINCT_PATTERN = Pattern.compile("(?i)^select\\s+distinct\\s+");
    public static final Pattern STAT_PATTERN = Pattern.compile("\\W(sum|avg|min|max|first|last|first_value|last_value)\\(");
    private static final String SELECT_REGEX = "select\\s+";
    private static final String FROM_REGEX = "\\s+from[\\(\\s+]";
    private static final String WHERE_REGEX = "\\s+where[\\(\\s+]";
    private static final HashMap<String, String> QuesFilters = new HashMap<String, String>(){
        private static final long serialVersionUID = 7135705054559913831L;
        {
            this.put("'", "'");
            this.put("\"", "\"");
        }
    };

    public static SqlToyResult wrapPageSqlParams(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, QueryExecutor queryExecutor, String pageSql, Object startIndex, Object endIndex, String dialect) throws Exception {
        int extendSize;
        QueryExecutorExtend extend = queryExecutor.getInnerModel();
        String[] paramsNamed = extend.getParamsName();
        Object[] paramsValue = extend.getParamsValue(sqlToyContext, sqlToyConfig);
        if (startIndex == null && endIndex == null) {
            return SqlConfigParseUtils.processSql(pageSql, paramsNamed, paramsValue, dialect);
        }
        String[] realParamNamed = null;
        Object[] realParamValue = null;
        int n = extendSize = endIndex == null ? 1 : 2;
        if (sqlToyConfig.isNamedParam()) {
            int paramLength = paramsNamed.length;
            if (paramsValue == null) {
                paramsValue = new Object[paramLength];
            }
            realParamValue = new Object[paramLength + extendSize];
            realParamNamed = new String[paramLength + extendSize];
            if (paramLength > 0) {
                System.arraycopy(paramsNamed, 0, realParamNamed, 0, paramLength);
                System.arraycopy(paramsValue, 0, realParamValue, 0, paramLength);
            }
            realParamNamed[paramLength] = "pageFirstParamName";
            realParamValue[paramLength] = startIndex;
            if (extendSize == 2) {
                realParamNamed[paramLength + 1] = "pageLastParamName";
                realParamValue[paramLength + 1] = endIndex;
            }
        } else {
            int totalParamCnt = DialectUtils.getParamsCount(sqlToyConfig.getSql(null));
            if (totalParamCnt == 0) {
                realParamValue = new Object[extendSize];
                realParamValue[0] = startIndex;
                if (extendSize == 2) {
                    realParamValue[1] = endIndex;
                }
            } else {
                if (paramsValue == null && totalParamCnt > 0) {
                    paramsValue = new Object[totalParamCnt];
                }
                int paramLength = paramsValue == null ? 0 : paramsValue.length;
                realParamValue = new Object[paramLength + extendSize];
                if (sqlToyConfig.isHasFast()) {
                    int tailSqlParamCnt = DialectUtils.getParamsCount(sqlToyConfig.getFastTailSql(null));
                    int tailPreParamCnt = totalParamCnt - tailSqlParamCnt;
                    System.arraycopy(paramsValue, 0, realParamValue, 0, tailPreParamCnt);
                    realParamValue[tailPreParamCnt] = startIndex;
                    if (extendSize == 2) {
                        realParamValue[tailPreParamCnt + 1] = endIndex;
                    }
                    if (tailSqlParamCnt > 0) {
                        System.arraycopy(paramsValue, tailPreParamCnt, realParamValue, tailPreParamCnt + extendSize, tailSqlParamCnt);
                    }
                } else {
                    if (paramLength > 0) {
                        System.arraycopy(paramsValue, 0, realParamValue, 0, paramLength);
                    }
                    realParamValue[paramLength] = startIndex;
                    if (extendSize == 2) {
                        realParamValue[paramLength + 1] = endIndex;
                    }
                }
            }
        }
        return SqlConfigParseUtils.processSql(pageSql, realParamNamed, realParamValue, dialect);
    }

    public static QueryResult findBySql(final SqlToyContext sqlToyContext, final SqlToyConfig sqlToyConfig, String sql, final Object[] paramsValue, final QueryExecutorExtend extend, final DecryptHandler decryptHandler, final Connection conn, final Integer dbType, final int startIndex, int fetchSize, int maxRows) throws Exception {
        String lastSql = SqlUtilsExt.clearOriginalSqlMark(sql);
        lastSql = SqlUtilsExt.signSql(lastSql, dbType, sqlToyConfig);
        SqlExecuteStat.showSql("\u6267\u884c\u67e5\u8be2", lastSql, paramsValue);
        PreparedStatement pst = null;
        if (extend == null || !extend.sqlSegment) {
            pst = conn.prepareStatement(lastSql, 1003, 1007);
            if (fetchSize > 0) {
                pst.setFetchSize(fetchSize);
            }
            if (maxRows > 0) {
                pst.setMaxRows(maxRows);
            }
        } else {
            pst = conn.prepareStatement(lastSql);
        }
        ResultSet rs = null;
        return (QueryResult)SqlUtil.preparedStatementProcess(null, pst, rs, new PreparedStatementResultHandler(){

            @Override
            public void execute(Object obj, PreparedStatement pst, ResultSet rs) throws Exception {
                try {
                    SqlUtil.setParamsValue(sqlToyContext.getTypeHandler(), conn, dbType, pst, paramsValue, null, 0);
                    rs = pst.executeQuery();
                    this.setResult(ResultUtils.processResultSet(sqlToyContext, sqlToyConfig, conn, rs, extend, null, decryptHandler, startIndex));
                }
                catch (Exception e) {
                    throw e;
                }
                finally {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
            }
        });
    }

    public static QueryResult updateFetchBySql(final SqlToyContext sqlToyContext, final SqlToyConfig sqlToyConfig, String sql, final Object[] paramsValue, final UpdateRowHandler updateRowHandler, final Connection conn, final Integer dbType, final int startIndex, int fetchSize, int maxRows) throws Exception {
        String lastSql = SqlUtilsExt.signSql(sql, dbType, sqlToyConfig);
        SqlExecuteStat.showSql("\u6267\u884cupdateFetch", lastSql, paramsValue);
        PreparedStatement pst = null;
        pst = updateRowHandler == null ? conn.prepareStatement(lastSql, 1003, 1007) : conn.prepareStatement(lastSql, 1003, 1008);
        if (fetchSize > 0) {
            pst.setFetchSize(fetchSize);
        }
        if (maxRows > 0) {
            pst.setMaxRows(maxRows);
        }
        ResultSet rs = null;
        return (QueryResult)SqlUtil.preparedStatementProcess(null, pst, rs, new PreparedStatementResultHandler(){

            @Override
            public void execute(Object obj, PreparedStatement pst, ResultSet rs) throws Exception {
                try {
                    SqlUtil.setParamsValue(sqlToyContext.getTypeHandler(), conn, dbType, pst, paramsValue, null, 0);
                    rs = pst.executeQuery();
                    this.setResult(ResultUtils.processResultSet(sqlToyContext, sqlToyConfig, conn, rs, null, updateRowHandler, null, startIndex));
                }
                catch (Exception e) {
                    throw e;
                }
                finally {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
            }
        });
    }

    public static Long getCountBySql(final SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, String sql, Object[] paramsValue, boolean isLastSql, final Connection conn, final Integer dbType) throws Exception {
        String lastCountSql;
        int paramCnt = 0;
        int withParamCnt = 0;
        int orderByParamsCnt = 0;
        if (isLastSql) {
            lastCountSql = sql;
        } else {
            int orderByIndex;
            SqlWithAnalysis sqlWith;
            String countPart = " count(1) ";
            if (dbType.equals(140)) {
                countPart = " count(*) ";
            }
            String query_tmp = sql;
            String withSql = "";
            if (sqlToyConfig != null && sqlToyConfig.isHasWith() && StringUtil.isBlank((sqlWith = new SqlWithAnalysis(sql)).getPreSql())) {
                query_tmp = sqlWith.getRejectWithSql();
                withSql = sqlWith.getWithSql();
            }
            int lastBracketIndex = query_tmp.lastIndexOf(")");
            int sql_from_index = 0;
            if (StringUtil.indexOfIgnoreCase(query_tmp, "from") != 0) {
                sql_from_index = SqlUtil.getSymMarkIndexExcludeKeyWords(query_tmp, SELECT_REGEX, FROM_REGEX, 0);
            }
            if ((orderByIndex = StringUtil.matchLastIndex(query_tmp, ORDER_BY_PATTERN, 1)) > sql_from_index) {
                String orderBySql = null;
                if (orderByIndex > lastBracketIndex) {
                    orderBySql = query_tmp.substring(orderByIndex + 1);
                    query_tmp = query_tmp.substring(0, orderByIndex + 1);
                } else {
                    String orderJudgeSql = DialectUtils.clearDisturbSql(query_tmp.substring(orderByIndex + 1));
                    if (orderJudgeSql.indexOf(")") == -1) {
                        orderBySql = query_tmp.substring(orderByIndex + 1);
                        query_tmp = query_tmp.substring(0, orderByIndex + 1);
                    }
                }
                if (null != orderBySql) {
                    orderByParamsCnt = DialectUtils.getParamsCount(orderBySql);
                }
            }
            int groupIndex = StringUtil.matchLastIndex(query_tmp, GROUP_BY_PATTERN, 1);
            boolean isInnerGroup = false;
            if (groupIndex != -1) {
                isInnerGroup = DialectUtils.clearDisturbSql(query_tmp.substring(groupIndex + 1)).lastIndexOf(")") != -1;
            }
            StringBuilder countQueryStr = new StringBuilder();
            boolean hasUnion = SqlUtil.hasUnion(query_tmp, false);
            if (!StringUtil.matches(query_tmp.trim(), DISTINCT_PATTERN) && !hasUnion && (groupIndex == -1 || groupIndex < lastBracketIndex && isInnerGroup)) {
                int selectIndex = StringUtil.matchIndex(query_tmp.toLowerCase(), SELECT_REGEX);
                String selectFields = sql_from_index < 1 ? "" : query_tmp.substring(selectIndex + 6, sql_from_index).toLowerCase();
                if (StringUtil.matches(selectFields = DialectUtils.clearSymSelectFromSql(selectFields), STAT_PATTERN)) {
                    countQueryStr.append("select ").append(countPart).append(" from (").append(query_tmp).append(") sag_count_tmpTable ");
                } else {
                    countQueryStr.append("select ").append(countPart).append(sql_from_index != -1 ? query_tmp.substring(sql_from_index) : query_tmp);
                }
            } else {
                countQueryStr.append("select ").append(countPart).append(" from (").append(query_tmp).append(") sag_count_tmpTable ");
            }
            paramCnt = DialectUtils.getParamsCount(countQueryStr.toString());
            withParamCnt = DialectUtils.getParamsCount(withSql);
            countQueryStr.insert(0, withSql + " ");
            lastCountSql = countQueryStr.toString();
        }
        Object[] realParamsTemp = paramsValue;
        if (realParamsTemp != null && !isLastSql) {
            if (orderByParamsCnt > 0) {
                realParamsTemp = CollectionUtil.subtractArray(realParamsTemp, realParamsTemp.length - orderByParamsCnt, orderByParamsCnt);
            }
            realParamsTemp = CollectionUtil.subtractArray(realParamsTemp, withParamCnt, realParamsTemp.length - withParamCnt - paramCnt);
        }
        final Object[] realParams = realParamsTemp;
        lastCountSql = SqlUtilsExt.signSql(lastCountSql, dbType, sqlToyConfig);
        SqlExecuteStat.showSql("\u6267\u884ccount\u67e5\u8be2", lastCountSql, realParams);
        PreparedStatement pst = conn.prepareStatement(lastCountSql);
        ResultSet rs = null;
        return (Long)SqlUtil.preparedStatementProcess(null, pst, rs, new PreparedStatementResultHandler(){

            @Override
            public void execute(Object obj, PreparedStatement pst, ResultSet rs) throws SQLException, IOException {
                long resultCount = 0L;
                try {
                    if (realParams != null) {
                        SqlUtil.setParamsValue(sqlToyContext.getTypeHandler(), conn, dbType, pst, realParams, null, 0);
                    }
                    if ((rs = pst.executeQuery()).next()) {
                        resultCount = rs.getLong(1);
                    }
                    this.setResult(resultCount);
                }
                catch (Exception e) {
                    throw e;
                }
                finally {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
            }
        });
    }

    public static SqlToyConfig getUnifyParamsNamedConfig(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, QueryExecutor queryExecutor, String dialect, boolean wrapNamed) throws Exception {
        QueryExecutorExtend extend = queryExecutor.getInnerModel();
        boolean isNamed = false;
        if (!extend.wrappedParamNames) {
            boolean hasQuestArg = SqlConfigParseUtils.hasQuestMarkArgs(sqlToyConfig.getSql());
            isNamed = extend.paramsName != null && extend.paramsName.length > 0 || !hasQuestArg;
        }
        List<ShardingStrategyConfig> tableShardings = sqlToyConfig.getTableShardings();
        if (!extend.tableShardings.isEmpty()) {
            tableShardings = extend.tableShardings;
        }
        if ((isNamed || !wrapNamed) && tableShardings.isEmpty() && extend.translates.isEmpty() && extend.linkModel == null) {
            return sqlToyConfig;
        }
        SqlToyConfig result = sqlToyConfig.clone();
        if (!extend.translates.isEmpty()) {
            HashMap<String, FieldTranslate> transMap = result.getTranslateMap();
            extend.translates.forEach(translate -> {
                String colName = translate.getExtend().column.toLowerCase();
                if (transMap.containsKey(colName)) {
                    ((FieldTranslate)transMap.get(colName)).put((Translate)translate);
                } else {
                    FieldTranslate fieldTranslate = new FieldTranslate();
                    fieldTranslate.colName = colName;
                    fieldTranslate.put((Translate)translate);
                    transMap.put(colName, fieldTranslate);
                }
            });
            result.setTranslateMap(transMap);
        }
        if (extend.linkModel != null) {
            result.setLinkModel(extend.linkModel);
        }
        if (!isNamed && wrapNamed) {
            SqlParamsModel sqlParams;
            if (result.isHasFast()) {
                String fastPreSql = SqlConfigParseUtils.clearDblQuestMark(result.getFastPreSql(null));
                sqlParams = DialectUtils.convertParamsToNamed(fastPreSql, 0);
                fastPreSql = SqlConfigParseUtils.recoverDblQuestMark(sqlParams.getSql());
                result.setFastPreSql(fastPreSql);
                int index = sqlParams.getParamCnt();
                String fastSql = SqlConfigParseUtils.clearDblQuestMark(result.getFastSql(null));
                sqlParams = DialectUtils.convertParamsToNamed(fastSql, index);
                fastSql = SqlConfigParseUtils.recoverDblQuestMark(sqlParams.getSql());
                result.setFastSql(fastSql);
                index += sqlParams.getParamCnt();
                String tailSql = SqlConfigParseUtils.clearDblQuestMark(result.getFastTailSql(null));
                sqlParams = DialectUtils.convertParamsToNamed(tailSql, index);
                tailSql = SqlConfigParseUtils.recoverDblQuestMark(sqlParams.getSql());
                result.setFastTailSql(tailSql);
                result.setSql(fastPreSql.concat(" (").concat(fastSql).concat(") ").concat(tailSql));
                String[] paramsName = new String[index];
                for (int i = 0; i < index; ++i) {
                    paramsName[i] = SqlToyConstants.DEFAULT_PARAM_NAME + (i + 1);
                }
                result.setParamsName(paramsName);
            } else {
                sqlParams = DialectUtils.convertParamsToNamed(SqlConfigParseUtils.clearDblQuestMark(result.getSql(null)), 0);
                result.setSql(SqlConfigParseUtils.recoverDblQuestMark(sqlParams.getSql()));
                result.setParamsName(sqlParams.getParamsName());
            }
            sqlParams = DialectUtils.convertParamsToNamed(SqlConfigParseUtils.clearDblQuestMark(result.getCountSql(null)), 0);
            result.setCountSql(SqlConfigParseUtils.recoverDblQuestMark(sqlParams.getSql()));
            result.clearDialectSql();
            SqlConfigParseUtils.processFastWith(result, dialect);
        }
        ShardingUtils.replaceShardingSqlToyConfig(sqlToyContext, result, tableShardings, dialect, extend.getTableShardingParamsName(), extend.getTableShardingParamsValue());
        return result;
    }

    public static SqlParamsModel convertParamsToNamed(String sql, int startIndex) {
        SqlParamsModel sqlParam = new SqlParamsModel();
        if (sql == null || "".equals(sql.trim())) {
            return sqlParam;
        }
        String[] strs = StringUtil.splitExcludeSymMark(sql, "?", QuesFilters);
        int size = strs.length;
        if (size == 1) {
            sqlParam.setSql(sql);
            return sqlParam;
        }
        String preName = SqlToyConstants.DEFAULT_PARAM_NAME;
        StringBuilder result = new StringBuilder();
        String[] paramsName = new String[size - 1];
        for (int i = 0; i < size - 1; ++i) {
            int index = i + startIndex + 1;
            result.append(strs[i]).append(":" + preName + index);
            paramsName[i] = preName + index;
        }
        result.append(strs[size - 1]);
        sqlParam.setSql(result.toString());
        sqlParam.setParamsName(paramsName);
        sqlParam.setParamCnt(size - 1);
        return sqlParam;
    }

    public static Long saveOrUpdateAll(SqlToyContext sqlToyContext, List<?> entities, int batchSize, EntityMeta entityMeta, String[] forceUpdateFields, GenerateSqlHandler generateSqlHandler, ReflectPropsHandler reflectPropsHandler, Connection conn, Integer dbType, Boolean autoCommit) throws Exception {
        boolean hasId;
        ReflectPropsHandler handler = DialectUtils.getSaveOrUpdateReflectHandler(entityMeta.getIdArray(), reflectPropsHandler, forceUpdateFields, sqlToyContext.getUnifyFieldsHandler());
        handler = DialectUtils.getSecureReflectHandler(handler, sqlToyContext.getFieldsSecureProvider(), sqlToyContext.getDesensitizeProvider(), entityMeta.getSecureFields());
        List paramValues = BeanUtil.reflectBeansToInnerAry(entities, entityMeta.getFieldsArray(), null, handler);
        int pkIndex = entityMeta.getIdIndex();
        boolean hasBizId = entityMeta.getBusinessIdGenerator() != null;
        int bizIdColIndex = hasBizId ? entityMeta.getFieldIndex(entityMeta.getBusinessIdField()) : 0;
        String signature = entityMeta.getBizIdSignature();
        Integer[] relatedColumn = entityMeta.getBizIdRelatedColIndex();
        int relatedColumnSize = relatedColumn == null ? 0 : relatedColumn.length;
        boolean bl = hasId = null != entityMeta.getIdStrategy() && null != entityMeta.getIdGenerator();
        if (hasId || hasBizId) {
            int bizIdLength = entityMeta.getBizIdLength();
            int idLength = entityMeta.getIdLength();
            Object[] relatedColValue = null;
            String idJdbcType = entityMeta.getIdType();
            String businessIdType = hasBizId ? entityMeta.getColumnJavaType(entityMeta.getBusinessIdField()) : "";
            int end = paramValues.size();
            for (int i = 0; i < end; ++i) {
                Object[] rowData = paramValues.get(i);
                if (relatedColumn != null) {
                    relatedColValue = new Object[relatedColumnSize];
                    for (int meter = 0; meter < relatedColumnSize; ++meter) {
                        relatedColValue[meter] = rowData[relatedColumn[meter]];
                    }
                }
                if (hasId && StringUtil.isBlank(rowData[pkIndex])) {
                    rowData[pkIndex] = entityMeta.getIdGenerator().getId(entityMeta.getTableName(), signature, entityMeta.getBizIdRelatedColumns(), relatedColValue, null, idJdbcType, idLength, entityMeta.getBizIdSequenceSize());
                    BeanUtil.setProperty(entities.get(i), entityMeta.getIdArray()[0], rowData[pkIndex]);
                }
                if (!hasBizId || !StringUtil.isBlank(rowData[bizIdColIndex])) continue;
                rowData[bizIdColIndex] = entityMeta.getBusinessIdGenerator().getId(entityMeta.getTableName(), signature, entityMeta.getBizIdRelatedColumns(), relatedColValue, null, businessIdType, bizIdLength, entityMeta.getBizIdSequenceSize());
                BeanUtil.setProperty(entities.get(i), entityMeta.getBusinessIdField(), rowData[bizIdColIndex]);
            }
        }
        String saveOrUpdateSql = generateSqlHandler.generateSql(entityMeta, forceUpdateFields);
        List realParams = paramValues;
        String realSql = saveOrUpdateSql;
        if (sqlToyContext.hasSqlInterceptors()) {
            SqlToyConfig sqlToyConfig = new SqlToyConfig(DataSourceUtils.getDialect(dbType));
            sqlToyConfig.setSqlType(SqlType.insert);
            sqlToyConfig.setSql(saveOrUpdateSql);
            sqlToyConfig.setParamsName(entityMeta.getFieldsArray());
            SqlToyResult sqlToyResult = new SqlToyResult(saveOrUpdateSql, paramValues.toArray());
            sqlToyResult = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, OperateType.saveOrUpdate, sqlToyResult, entities.get(0).getClass(), dbType);
            realSql = sqlToyResult.getSql();
            realParams = CollectionUtil.arrayToList(sqlToyResult.getParamsValue());
        }
        SqlExecuteStat.showSql("\u6267\u884csaveOrUpdate\u8bed\u53e5", realSql, null);
        return SqlUtil.batchUpdateByJdbc(sqlToyContext.getTypeHandler(), realSql, realParams, batchSize, null, entityMeta.getFieldsTypeArray(), autoCommit, conn, dbType);
    }

    public static String getSaveOrUpdateSql(SqlToyContext sqlToyContext, IUnifyFieldsHandler unifyFieldsHandler, Integer dbType, EntityMeta entityMeta, PKStrategy pkStrategy, String[] forceUpdateFields, String fromTable, String isNullFunction, String sequence, boolean isAssignPK, String tableName) {
        String columnName;
        FieldMeta fieldMeta;
        String realTable = entityMeta.getSchemaTable(tableName, dbType);
        if (entityMeta.getIdArray() == null) {
            return DialectExtUtils.generateInsertSql(unifyFieldsHandler, dbType, entityMeta, pkStrategy, isNullFunction, sequence, isAssignPK, realTable);
        }
        IgnoreKeyCaseMap<String, Object> createUnifyFields = null;
        if (unifyFieldsHandler != null && unifyFieldsHandler.createUnifyFields() != null && !unifyFieldsHandler.createUnifyFields().isEmpty()) {
            createUnifyFields = new IgnoreKeyCaseMap<String, Object>();
            createUnifyFields.putAll(unifyFieldsHandler.createUnifyFields());
        }
        IgnoreCaseSet createSqlTimeFields = unifyFieldsHandler == null || unifyFieldsHandler.createSqlTimeFields() == null ? new IgnoreCaseSet() : unifyFieldsHandler.createSqlTimeFields();
        IgnoreCaseSet updateSqlTimeFields = unifyFieldsHandler == null || unifyFieldsHandler.updateSqlTimeFields() == null ? new IgnoreCaseSet() : unifyFieldsHandler.updateSqlTimeFields();
        IgnoreCaseSet forceUpdateSqlTimeFields = unifyFieldsHandler == null || unifyFieldsHandler.forceUpdateFields() == null ? new IgnoreCaseSet() : unifyFieldsHandler.forceUpdateFields();
        int columnSize = entityMeta.getFieldsArray().length;
        StringBuilder sql = new StringBuilder(columnSize * 30 + 100);
        sql.append("merge into ");
        sql.append(realTable);
        if (51 != dbType) {
            sql.append(" ta ");
        }
        sql.append(" using (select ");
        for (int i = 0; i < columnSize; ++i) {
            fieldMeta = entityMeta.getFieldMeta(entityMeta.getFieldsArray()[i]);
            columnName = ReservedWordsUtil.convertWord(fieldMeta.getColumnName(), dbType);
            if (i > 0) {
                sql.append(",");
            }
            if (51 == dbType) {
                PostgreSqlDialectUtils.wrapSelectFields(sql, columnName, fieldMeta);
                continue;
            }
            if (170 == dbType) {
                H2DialectUtils.wrapSelectFields(sql, columnName, fieldMeta);
                continue;
            }
            if (20 == dbType) {
                DB2DialectUtils.wrapSelectFields(sql, columnName, fieldMeta);
                continue;
            }
            sql.append("? as ");
            sql.append(columnName);
        }
        if (StringUtil.isNotBlank(fromTable)) {
            sql.append(" from ").append(fromTable);
        }
        sql.append(") tv on (");
        StringBuilder idColumns = new StringBuilder();
        int n = entityMeta.getIdArray().length;
        for (int i = 0; i < n; ++i) {
            columnName = entityMeta.getColumnName(entityMeta.getIdArray()[i]);
            columnName = ReservedWordsUtil.convertWord(columnName, dbType);
            if (i > 0) {
                sql.append(" and ");
                idColumns.append(",");
            }
            if (51 == dbType) {
                sql.append(realTable + ".");
            } else {
                sql.append("ta.");
            }
            sql.append(columnName).append("=tv.").append(columnName);
            idColumns.append("ta.").append(columnName);
        }
        sql.append(" ) ");
        StringBuilder insertRejIdCols = new StringBuilder();
        StringBuilder insertRejIdColValues = new StringBuilder();
        boolean allIds = entityMeta.getRejectIdFieldArray() == null;
        IgnoreCaseSet tenantFields = DialectUtils.getTenantFields(sqlToyContext.getSqlInterceptors(), entityMeta, OperateType.saveOrUpdate);
        if (!allIds) {
            sql.append(" when matched then update set ");
            int rejectIdColumnSize = entityMeta.getRejectIdFieldArray().length;
            HashSet<String> fupc = new HashSet<String>();
            if (forceUpdateFields != null) {
                for (String field : forceUpdateFields) {
                    fupc.add(ReservedWordsUtil.convertWord(entityMeta.getColumnName(field), dbType));
                }
            }
            boolean ignoreUpdate = false;
            boolean notFirst = false;
            for (int i = 0; i < rejectIdColumnSize; ++i) {
                fieldMeta = entityMeta.getFieldMeta(entityMeta.getRejectIdFieldArray()[i]);
                columnName = ReservedWordsUtil.convertWord(fieldMeta.getColumnName(), dbType);
                ignoreUpdate = tenantFields.contains(fieldMeta.getFieldName());
                String currentTimeStr = SqlUtil.getDBTime(dbType, fieldMeta, updateSqlTimeFields);
                if (!ignoreUpdate) {
                    if (notFirst) {
                        sql.append(",");
                    }
                    if (51 != dbType) {
                        sql.append(" ta.");
                    }
                    sql.append(columnName).append("=");
                    if (null != currentTimeStr && forceUpdateSqlTimeFields.contains(fieldMeta.getFieldName())) {
                        sql.append(currentTimeStr);
                    } else if (fupc.contains(columnName)) {
                        sql.append("tv.").append(columnName);
                    } else {
                        sql.append(isNullFunction);
                        sql.append("(tv.").append(columnName);
                        sql.append(",");
                        if (null != currentTimeStr) {
                            sql.append(currentTimeStr);
                        } else {
                            if (51 == dbType) {
                                sql.append(realTable + ".");
                            } else {
                                sql.append("ta.");
                            }
                            sql.append(columnName);
                        }
                        sql.append(")");
                    }
                    notFirst = true;
                }
                if (i > 0) {
                    insertRejIdCols.append(",");
                    insertRejIdColValues.append(",");
                }
                insertRejIdCols.append(columnName);
                currentTimeStr = SqlUtil.getDBTime(dbType, fieldMeta, createSqlTimeFields);
                if (null != currentTimeStr && forceUpdateSqlTimeFields.contains(fieldMeta.getFieldName())) {
                    insertRejIdColValues.append(currentTimeStr);
                    continue;
                }
                String defaultValue = DialectExtUtils.getInsertDefaultValue(createUnifyFields, dbType, fieldMeta);
                if (null != defaultValue) {
                    insertRejIdColValues.append(isNullFunction);
                    insertRejIdColValues.append("(tv.").append(columnName).append(",");
                    DialectExtUtils.processDefaultValue(insertRejIdColValues, dbType, fieldMeta, defaultValue);
                    insertRejIdColValues.append(")");
                    continue;
                }
                if (null != currentTimeStr) {
                    insertRejIdColValues.append(isNullFunction);
                    insertRejIdColValues.append("(tv.").append(columnName).append(",");
                    insertRejIdColValues.append(currentTimeStr);
                    insertRejIdColValues.append(")");
                    continue;
                }
                insertRejIdColValues.append("tv.").append(columnName);
            }
        }
        sql.append(" when not matched then insert ");
        sql.append(" (");
        String idsColumnStr = idColumns.toString();
        if (allIds) {
            sql.append(idsColumnStr.replace("ta.", ""));
            sql.append(") values (");
            sql.append(idsColumnStr.replace("ta.", "tv."));
        } else {
            sql.append(insertRejIdCols.toString());
            if (pkStrategy.equals((Object)PKStrategy.SEQUENCE)) {
                columnName = entityMeta.getColumnName(entityMeta.getIdArray()[0]);
                columnName = ReservedWordsUtil.convertWord(columnName, dbType);
                sql.append(",");
                sql.append(columnName);
                sql.append(") values (");
                sql.append((CharSequence)insertRejIdColValues).append(",");
                if (isAssignPK) {
                    sql.append(isNullFunction);
                    sql.append("(tv.").append(columnName).append(",");
                    sql.append(sequence).append(") ");
                } else {
                    sql.append(sequence);
                }
            } else if (pkStrategy.equals((Object)PKStrategy.IDENTITY)) {
                columnName = entityMeta.getColumnName(entityMeta.getIdArray()[0]);
                columnName = ReservedWordsUtil.convertWord(columnName, dbType);
                if (isAssignPK) {
                    sql.append(",");
                    sql.append(columnName);
                }
                sql.append(") values (");
                sql.append((CharSequence)insertRejIdColValues);
                if (isAssignPK) {
                    sql.append(",").append("tv.").append(columnName);
                }
            } else {
                sql.append(",");
                sql.append(idsColumnStr.replace("ta.", ""));
                sql.append(") values (");
                sql.append((CharSequence)insertRejIdColValues).append(",");
                sql.append(idsColumnStr.replace("ta.", "tv."));
            }
        }
        sql.append(")");
        return sql.toString();
    }

    private static IgnoreCaseSet getTenantFields(List<SqlInterceptor> sqlInterceptors, EntityMeta entityMeta, OperateType operateType) {
        IgnoreCaseSet result = new IgnoreCaseSet();
        if (sqlInterceptors == null || sqlInterceptors.isEmpty()) {
            return result;
        }
        for (SqlInterceptor sqlInterceptor : sqlInterceptors) {
            String[] fields = sqlInterceptor.tenantFieldNames(entityMeta, operateType);
            if (fields == null) continue;
            for (String str : fields) {
                if (null == str) continue;
                result.add(str);
            }
        }
        return result;
    }

    private static String generateUpdateSql(IUnifyFieldsHandler unifyFieldsHandler, Integer dbType, EntityMeta entityMeta, String nullFunction, String[] forceUpdateFields, String tableName) {
        String columnName;
        int i;
        if (entityMeta.getIdArray() == null) {
            return null;
        }
        StringBuilder sql = new StringBuilder(entityMeta.getFieldsArray().length * 30 + 30);
        sql.append(" update  ");
        sql.append(tableName);
        sql.append(" set ");
        HashSet<String> fupc = new HashSet<String>();
        if (forceUpdateFields != null) {
            for (String field : forceUpdateFields) {
                fupc.add(ReservedWordsUtil.convertWord(entityMeta.getColumnName(field), dbType));
            }
        }
        IgnoreCaseSet updateSqlTimeFields = new IgnoreCaseSet();
        if (unifyFieldsHandler != null && unifyFieldsHandler.updateSqlTimeFields() != null) {
            updateSqlTimeFields = unifyFieldsHandler.updateSqlTimeFields();
        }
        boolean convertBlob = dbType == 50 || dbType == 51;
        boolean isMSsql = dbType == 30;
        int meter = 0;
        int n = entityMeta.getRejectIdFieldArray().length;
        for (i = 0; i < n; ++i) {
            FieldMeta fieldMeta = entityMeta.getFieldMeta(entityMeta.getRejectIdFieldArray()[i]);
            if (isMSsql && fieldMeta.getType() == 93) continue;
            columnName = ReservedWordsUtil.convertWord(fieldMeta.getColumnName(), dbType);
            if (meter > 0) {
                sql.append(",");
            }
            sql.append(columnName);
            sql.append("=");
            if (fupc.contains(columnName)) {
                sql.append("?");
            } else if (convertBlob && "byte[]".equals(fieldMeta.getFieldType())) {
                sql.append(nullFunction);
                sql.append("(cast(? as bytea),").append(columnName).append(" )");
            } else {
                sql.append(nullFunction);
                if (isMSsql && fieldMeta.getType() == 3) {
                    int decimalLength = fieldMeta.getLength() > 35 ? fieldMeta.getLength() : 35;
                    int decimalScale = fieldMeta.getScale() > 5 ? fieldMeta.getScale() : 5;
                    sql.append("(cast(? as decimal(" + decimalLength + "," + decimalScale + ")),").append(columnName).append(")");
                } else {
                    sql.append("(?,");
                    String currentTimeStr = SqlUtil.getDBTime(dbType, fieldMeta, updateSqlTimeFields);
                    if (null != currentTimeStr) {
                        sql.append(currentTimeStr);
                    } else {
                        sql.append(columnName);
                    }
                    sql.append(")");
                }
            }
            ++meter;
        }
        sql.append(" where ");
        n = entityMeta.getIdArray().length;
        for (i = 0; i < n; ++i) {
            columnName = entityMeta.getColumnName(entityMeta.getIdArray()[i]);
            columnName = ReservedWordsUtil.convertWord(columnName, dbType);
            if (i > 0) {
                sql.append(" and ");
            }
            sql.append(columnName);
            sql.append("=?");
        }
        return sql.toString();
    }

    public static Serializable load(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, String sql, EntityMeta entityMeta, Serializable entity, boolean onlySubTables, List<Class> cascadeTypes, Connection conn, Integer dbType) throws Exception {
        Object[] pkValues = BeanUtil.reflectBeanToAry((Object)entity, entityMeta.getIdArray());
        for (int i = 0; i < pkValues.length; ++i) {
            if (!StringUtil.isBlank(pkValues[i])) continue;
            throw new IllegalArgumentException(entityMeta.getSchemaTable(null, dbType) + " load method must assign value for pk,null pk field is:" + entityMeta.getIdArray()[i]);
        }
        SqlToyResult sqlToyResult = null;
        Serializable result = null;
        if (!onlySubTables) {
            QueryResult queryResult;
            List rows;
            sqlToyResult = SqlConfigParseUtils.processSql(sql, entityMeta.getIdArray(), pkValues, null);
            DecryptHandler decryptHandler = null;
            if (entityMeta.getSecureColumns() != null) {
                decryptHandler = new DecryptHandler(sqlToyContext.getFieldsSecureProvider(), entityMeta.getSecureColumns());
            }
            if ((rows = (queryResult = DialectUtils.findBySql(sqlToyContext, sqlToyConfig, (sqlToyResult = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, OperateType.load, sqlToyResult, entity.getClass(), dbType)).getSql(), sqlToyResult.getParamsValue(), null, decryptHandler, conn, dbType, 0, -1, -1)).getRows()) != null && rows.size() > 0) {
                Class entityClass = BeanUtil.getEntityClass(entity.getClass());
                rows = BeanUtil.reflectListToBean(sqlToyContext.getTypeHandler(), rows, ResultUtils.humpFieldNames(queryResult.getLabelNames(), entityMeta.getColumnFieldMap()), entityClass);
                result = (Serializable)rows.get(0);
                ResultUtils.wrapResultTranslate(sqlToyContext, result, entityClass);
            }
            if (result == null) {
                return null;
            }
        } else {
            result = entity;
        }
        if (null != cascadeTypes && !cascadeTypes.isEmpty() && !entityMeta.getCascadeModels().isEmpty()) {
            for (TableCascadeModel cascadeModel : entityMeta.getCascadeModels()) {
                if (!cascadeTypes.contains(cascadeModel.getMappedType())) continue;
                Object[] mainFieldValues = BeanUtil.reflectBeanToAry((Object)result, cascadeModel.getFields());
                String loadSubTableSql = ReservedWordsUtil.convertSql(cascadeModel.getLoadSubTableSql(), dbType);
                sqlToyResult = SqlConfigParseUtils.processSql(loadSubTableSql, cascadeModel.getMappedFields(), mainFieldValues, null);
                SqlExecuteStat.showSql("\u7ea7\u8054\u5b50\u8868\u52a0\u8f7d\u67e5\u8be2", sqlToyResult.getSql(), sqlToyResult.getParamsValue());
                EntityMeta mappedMeta = sqlToyContext.getEntityMeta(cascadeModel.getMappedType());
                DecryptHandler subDecryptHandler = null;
                if (mappedMeta.getSecureColumns() != null) {
                    subDecryptHandler = new DecryptHandler(sqlToyContext.getFieldsSecureProvider(), mappedMeta.getSecureColumns());
                }
                SqlToyConfig subLoadConfig = new SqlToyConfig(DataSourceUtils.getDialect(dbType));
                subLoadConfig.setSql(sqlToyResult.getSql());
                subLoadConfig.setParamsName(cascadeModel.getFields());
                sqlToyResult = DialectUtils.doInterceptors(sqlToyContext, subLoadConfig, OperateType.load, sqlToyResult, cascadeModel.getMappedType(), dbType);
                List pkRefDetails = SqlUtil.findByJdbcQuery(sqlToyContext.getTypeHandler(), sqlToyResult.getSql(), sqlToyResult.getParamsValue(), cascadeModel.getMappedType(), null, subDecryptHandler, conn, dbType, false, mappedMeta.getColumnFieldMap(), SqlToyConstants.FETCH_SIZE, -1);
                ResultUtils.wrapResultTranslate(sqlToyContext, pkRefDetails, cascadeModel.getMappedType());
                if (null == pkRefDetails || pkRefDetails.isEmpty()) continue;
                if (cascadeModel.getCascadeType() == 1) {
                    BeanUtil.setProperty(result, cascadeModel.getProperty(), pkRefDetails);
                    continue;
                }
                if (pkRefDetails.size() > 1) {
                    throw new DataAccessException("\u8bf7\u68c0\u67e5\u5bf9\u8c61:" + entityMeta.getEntityClass().getName() + "\u4e2d\u7684@OneToOne\u7ea7\u8054\u914d\u7f6e,\u7ea7\u8054\u67e5\u51fa\u7684\u6570\u636esize=" + pkRefDetails.size() + ">1,\u4e0d\u7b26\u5408\u9884\u671f!");
                }
                BeanUtil.setProperty(result, cascadeModel.getProperty(), pkRefDetails.get(0));
            }
        }
        return result;
    }

    public static List<?> loadAll(SqlToyContext sqlToyContext, List<?> entities, boolean onlySubTables, List<Class> cascadeTypes, LockMode lockMode, Connection conn, Integer dbType, String tableName, LockSqlHandler lockSqlHandler, int fetchSize, int maxRows) throws Exception {
        if (entities == null || entities.isEmpty()) {
            return entities;
        }
        Class entityClass = BeanUtil.getEntityClass(entities.get(0).getClass());
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entityClass);
        if (null == entityMeta.getIdArray() || entityMeta.getIdArray().length < 1) {
            throw new IllegalArgumentException(entityClass.getName() + " Entity Object hasn't primary key,cann't use loadAll method!");
        }
        ArrayList entitySet = null;
        if (!onlySubTables) {
            int j;
            Object idValues;
            SqlToyResult sqlToyResult = null;
            DecryptHandler decryptHandler = null;
            if (entityMeta.getSecureColumns() != null) {
                decryptHandler = new DecryptHandler(sqlToyContext.getFieldsSecureProvider(), entityMeta.getSecureColumns());
            }
            int idSize = entityMeta.getIdArray().length;
            Object sortIds = new ArrayList();
            if (idSize == 1) {
                idValues = BeanUtil.sliceToArray(entities, entityMeta.getIdArray()[0]);
                if (idValues == null || ((Object[])idValues).length == 0) {
                    throw new IllegalArgumentException(tableName + " loadAll method must assign value for pk field:" + entityMeta.getIdArray()[0]);
                }
                for (int i = 0; i < ((Object)idValues).length; ++i) {
                    sortIds.add(new Object[]{idValues[i]});
                }
                String sql = DialectUtils.wrapLoadAll(entityMeta, ((Object)idValues).length, tableName, lockSqlHandler, lockMode, dbType);
                sqlToyResult = SqlConfigParseUtils.processSql(sql, null, new Object[]{idValues}, null);
            } else {
                sortIds = idValues = BeanUtil.reflectBeansToInnerAry(entities, entityMeta.getIdArray(), null, null);
                Object[] realValues = new Object[idValues.size() * idSize];
                int index = 0;
                int n = idValues.size();
                for (int i = 0; i < n; ++i) {
                    Object[] rowData = (Object[])idValues.get(i);
                    for (j = 0; j < idSize; ++j) {
                        Object cellValue = rowData[j];
                        if (StringUtil.isBlank(cellValue)) {
                            throw new IllegalArgumentException(tableName + " loadAll method must assign value for pk,row:" + i + " pk field:" + entityMeta.getIdArray()[j]);
                        }
                        realValues[index] = cellValue;
                        ++index;
                    }
                }
                String sql = DialectUtils.wrapLoadAll(entityMeta, idValues.size(), tableName, lockSqlHandler, lockMode, dbType);
                sqlToyResult = new SqlToyResult(sql, realValues);
            }
            SqlToyConfig sqlToyConfig = new SqlToyConfig(DataSourceUtils.getDialect(dbType));
            sqlToyConfig.setSqlType(SqlType.search);
            sqlToyConfig.setSql(sqlToyResult.getSql());
            sqlToyConfig.setParamsName(entityMeta.getIdArray());
            sqlToyResult = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, OperateType.loadAll, sqlToyResult, entityClass, dbType);
            SqlExecuteStat.showSql("\u6267\u884c\u4f9d\u636e\u4e3b\u952e\u6279\u91cf\u67e5\u8be2", sqlToyResult.getSql(), sqlToyResult.getParamsValue());
            entitySet = SqlUtil.findByJdbcQuery(sqlToyContext.getTypeHandler(), sqlToyResult.getSql(), sqlToyResult.getParamsValue(), entityClass, null, decryptHandler, conn, dbType, false, entityMeta.getColumnFieldMap(), fetchSize, maxRows);
            ResultUtils.wrapResultTranslate(sqlToyContext, entitySet, entityClass);
            if (entitySet == null || entitySet.isEmpty()) {
                return entitySet;
            }
            List<Object[]> resultIds = BeanUtil.reflectBeansToInnerAry(entitySet, entityMeta.getIdArray(), null, null);
            ArrayList sortEntities = new ArrayList();
            block3: for (int i = 0; i < sortIds.size(); ++i) {
                Object[] ids = (Object[])sortIds.get(i);
                for (j = 0; j < resultIds.size(); ++j) {
                    Object[] idVars = resultIds.get(j);
                    boolean isEqual = true;
                    for (int k = 0; k < idSize; ++k) {
                        if (ids[k].equals(idVars[k])) continue;
                        isEqual = false;
                    }
                    if (!isEqual) continue;
                    sortEntities.add(entitySet.remove(j));
                    resultIds.remove(j);
                    continue block3;
                }
            }
            entitySet = sortEntities;
        } else {
            entitySet = entities;
        }
        if (null != cascadeTypes && !cascadeTypes.isEmpty() && !entityMeta.getCascadeModels().isEmpty()) {
            StringBuilder subTableSql = new StringBuilder();
            List<Object[]> idValues = null;
            int dataSize = entitySet.size();
            boolean supportMultiFieldIn = DataSourceUtils.isSupportMultiFieldIn(dbType);
            for (TableCascadeModel cascadeModel : entityMeta.getCascadeModels()) {
                SqlToyResult subToyResult;
                String colName;
                if (!cascadeTypes.contains(cascadeModel.getMappedType())) continue;
                EntityMeta mappedMeta = sqlToyContext.getEntityMeta(cascadeModel.getMappedType());
                subTableSql.delete(0, subTableSql.length());
                subTableSql.append(ReservedWordsUtil.convertSimpleSql(mappedMeta.getLoadAllSql(), dbType)).append(" where ");
                String orderCols = "";
                boolean hasOrder = StringUtil.isNotBlank(cascadeModel.getOrderBy());
                boolean hasExtCondtion = StringUtil.isNotBlank(cascadeModel.getLoadExtCondition());
                int fieldSize = cascadeModel.getMappedFields().length;
                if (fieldSize == 1) {
                    colName = cascadeModel.getMappedColumns()[0];
                    colName = ReservedWordsUtil.convertWord(colName, dbType);
                    subTableSql.append(colName);
                    subTableSql.append(" in (?) ");
                    if (hasOrder) {
                        orderCols = orderCols.concat(colName).concat(",");
                    }
                } else if (supportMultiFieldIn) {
                    String columns = "(";
                    String condition = "(";
                    for (int i = 0; i < fieldSize; ++i) {
                        if (i > 0) {
                            columns = columns.concat(",");
                            condition = condition.concat(",");
                        }
                        colName = cascadeModel.getMappedColumns()[i];
                        colName = ReservedWordsUtil.convertWord(colName, dbType);
                        condition = condition.concat("?");
                        columns = columns.concat(colName);
                        if (!hasOrder) continue;
                        orderCols = orderCols.concat(colName).concat(",");
                    }
                    condition = condition.concat(")");
                    columns = columns.concat(")");
                    StringBuilder conditionStr = new StringBuilder();
                    int groupIndex = 0;
                    int groupCnt = 0;
                    int groupSize = 1000;
                    if (dataSize > groupSize) {
                        subTableSql.append(" ( ");
                    }
                    for (int i = 0; i < dataSize; ++i) {
                        if (groupIndex > 0) {
                            conditionStr.append(",");
                        }
                        conditionStr.append(condition);
                        ++groupIndex;
                        if ((i + 1) % groupSize != 0 && i + 1 != dataSize) continue;
                        if (groupCnt > 0) {
                            subTableSql.append(" or ");
                        }
                        subTableSql.append(columns).append(" in (").append(conditionStr.toString()).append(")");
                        groupIndex = 0;
                        ++groupCnt;
                        conditionStr.setLength(0);
                    }
                    if (dataSize > groupSize) {
                        subTableSql.append(" ) ");
                    }
                } else {
                    int i;
                    String condition = " (";
                    for (i = 0; i < fieldSize; ++i) {
                        colName = cascadeModel.getMappedColumns()[i];
                        colName = ReservedWordsUtil.convertWord(colName, dbType);
                        if (i > 0) {
                            condition = condition.concat(" and ");
                        }
                        condition = condition.concat(colName).concat("=?");
                        if (!hasOrder) continue;
                        orderCols = orderCols.concat(colName).concat(",");
                    }
                    condition = condition.concat(") ");
                    if (hasExtCondtion) {
                        subTableSql.append(" (");
                    }
                    for (i = 0; i < dataSize; ++i) {
                        if (i > 0) {
                            subTableSql.append(" or ");
                        }
                        subTableSql.append(condition);
                    }
                    if (hasExtCondtion) {
                        subTableSql.append(") ");
                    }
                }
                if (hasExtCondtion) {
                    subTableSql.append(" and ").append(cascadeModel.getLoadExtCondition());
                }
                if (hasOrder) {
                    subTableSql.append(" order by ").append(orderCols).append(cascadeModel.getOrderBy());
                }
                if (fieldSize == 1) {
                    Object[] pkValues = BeanUtil.sliceToArray(entitySet, cascadeModel.getFields()[0]);
                    subToyResult = SqlConfigParseUtils.processSql(subTableSql.toString(), null, new Object[]{pkValues}, null);
                } else {
                    idValues = BeanUtil.reflectBeansToInnerAry(entitySet, cascadeModel.getFields(), null, null);
                    Object[] realValues = new Object[idValues.size() * fieldSize];
                    int index = 0;
                    int n = idValues.size();
                    for (int i = 0; i < n; ++i) {
                        Object[] rowData = idValues.get(i);
                        for (int j = 0; j < fieldSize; ++j) {
                            Object cellValue;
                            realValues[index] = cellValue = rowData[j];
                            ++index;
                        }
                    }
                    subToyResult = new SqlToyResult(subTableSql.toString(), realValues);
                }
                DecryptHandler subDecryptHandler = null;
                if (mappedMeta.getSecureColumns() != null) {
                    subDecryptHandler = new DecryptHandler(sqlToyContext.getFieldsSecureProvider(), mappedMeta.getSecureColumns());
                }
                SqlToyConfig subLoadConfig = new SqlToyConfig(DataSourceUtils.getDialect(dbType));
                subLoadConfig.setSqlType(SqlType.search);
                subLoadConfig.setSql(subToyResult.getSql());
                subToyResult = DialectUtils.doInterceptors(sqlToyContext, subLoadConfig, OperateType.loadAll, subToyResult, cascadeModel.getMappedType(), dbType);
                SqlExecuteStat.showSql("\u6267\u884c\u7ea7\u8054\u52a0\u8f7d\u5b50\u8868", subToyResult.getSql(), subToyResult.getParamsValue());
                List items = SqlUtil.findByJdbcQuery(sqlToyContext.getTypeHandler(), subToyResult.getSql(), subToyResult.getParamsValue(), cascadeModel.getMappedType(), null, subDecryptHandler, conn, dbType, false, mappedMeta.getColumnFieldMap(), SqlToyConstants.FETCH_SIZE, maxRows);
                ResultUtils.wrapResultTranslate(sqlToyContext, items, cascadeModel.getMappedType());
                SqlExecuteStat.debug("\u5b50\u8868\u52a0\u8f7d\u7ed3\u679c", "\u5b50\u8bb0\u5f55\u6570:{} \u6761", items.size());
                BeanUtil.loadAllMapping(entitySet, items, cascadeModel);
            }
        }
        return entitySet;
    }

    private static String wrapLoadAll(EntityMeta entityMeta, int dataSize, String tableName, LockSqlHandler lockSqlHandler, LockMode lockMode, Integer dbType) {
        int idSize = entityMeta.getIdArray().length;
        StringBuilder loadSql = new StringBuilder();
        loadSql.append("select ").append(ReservedWordsUtil.convertSimpleSql(entityMeta.getAllColumnNames(), dbType));
        loadSql.append(" from ");
        loadSql.append(entityMeta.getSchemaTable(tableName, dbType));
        if (dbType == 30 && lockMode != null) {
            switch (lockMode) {
                case UPGRADE: {
                    loadSql.append(" with (rowlock xlock) ");
                    break;
                }
                case UPGRADE_NOWAIT: 
                case UPGRADE_SKIPLOCK: {
                    loadSql.append(" with (rowlock readpast) ");
                }
            }
        }
        loadSql.append(" where ");
        if (idSize == 1) {
            String field = entityMeta.getIdArray()[0];
            String colName = ReservedWordsUtil.convertWord(entityMeta.getColumnName(field), dbType);
            loadSql.append(colName);
            loadSql.append(" in (?) ");
        } else if (DataSourceUtils.isSupportMultiFieldIn(dbType)) {
            String columns = "(";
            String condition = "(";
            for (int i = 0; i < idSize; ++i) {
                if (i > 0) {
                    columns = columns.concat(",");
                    condition = condition.concat(",");
                }
                String field = entityMeta.getIdArray()[i];
                String colName = ReservedWordsUtil.convertWord(entityMeta.getColumnName(field), dbType);
                condition = condition.concat("?");
                columns = columns.concat(colName);
            }
            condition = condition.concat(")");
            columns = columns.concat(")");
            StringBuilder conditionStr = new StringBuilder();
            int groupIndex = 0;
            int groupCnt = 0;
            int groupSize = 1000;
            if (dataSize > groupSize) {
                loadSql.append(" ( ");
            }
            for (int i = 0; i < dataSize; ++i) {
                if (groupIndex > 0) {
                    conditionStr.append(",");
                }
                conditionStr.append(condition);
                ++groupIndex;
                if ((i + 1) % groupSize != 0 && i + 1 != dataSize) continue;
                if (groupCnt > 0) {
                    loadSql.append(" or ");
                }
                loadSql.append(columns).append(" in (").append(conditionStr.toString()).append(")");
                groupIndex = 0;
                ++groupCnt;
                conditionStr.setLength(0);
            }
            if (dataSize > groupSize) {
                loadSql.append(" ) ");
            }
        } else {
            int i;
            String condition = " (";
            for (i = 0; i < idSize; ++i) {
                String field = entityMeta.getIdArray()[i];
                String colName = ReservedWordsUtil.convertWord(entityMeta.getColumnName(field), dbType);
                if (i > 0) {
                    condition = condition.concat(" and ");
                }
                condition = condition.concat(colName).concat("=?");
            }
            condition = condition.concat(")");
            for (i = 0; i < dataSize; ++i) {
                if (i > 0) {
                    loadSql.append(" or ");
                }
                loadSql.append(condition);
            }
        }
        if (lockSqlHandler != null) {
            loadSql.append(lockSqlHandler.getLockSql(loadSql.toString(), dbType, lockMode));
        }
        return loadSql.toString();
    }

    public static Object save(final SqlToyContext sqlToyContext, EntityMeta entityMeta, PKStrategy pkStrategy, boolean isAssignPK, String insertSql, Serializable entity, GenerateSqlHandler generateSqlHandler, GenerateSavePKStrategy generateSavePKStrategy, final Connection conn, final Integer dbType) throws Exception {
        final boolean isIdentity = pkStrategy != null && pkStrategy.equals((Object)PKStrategy.IDENTITY);
        final boolean isSequence = pkStrategy != null && pkStrategy.equals((Object)PKStrategy.SEQUENCE);
        String[] reflectColumns = isIdentity && !isAssignPK || isSequence && !isAssignPK ? entityMeta.getRejectIdFieldArray() : entityMeta.getFieldsArray();
        ReflectPropsHandler handler = DialectUtils.getAddReflectHandler(entityMeta, null, sqlToyContext.getUnifyFieldsHandler());
        handler = DialectUtils.getSecureReflectHandler(handler, sqlToyContext.getFieldsSecureProvider(), sqlToyContext.getDesensitizeProvider(), entityMeta.getSecureFields());
        Object[] fullParamValues = BeanUtil.reflectBeanToAry((Object)entity, reflectColumns, SqlUtilsExt.getDefaultValues(entityMeta), handler);
        boolean hasId = pkStrategy != null && null != entityMeta.getIdGenerator();
        boolean hasBizId = entityMeta.getBusinessIdGenerator() != null;
        int bizIdColIndex = hasBizId ? entityMeta.getFieldIndex(entityMeta.getBusinessIdField()) : 0;
        boolean needUpdatePk = false;
        int pkIndex = entityMeta.getIdIndex();
        if (hasId || hasBizId) {
            Integer[] relatedColumn = entityMeta.getBizIdRelatedColIndex();
            Object[] relatedColValue = null;
            if (relatedColumn != null) {
                int relatedColumnSize = relatedColumn.length;
                relatedColValue = new Object[relatedColumnSize];
                for (int meter = 0; meter < relatedColumnSize; ++meter) {
                    relatedColValue[meter] = fullParamValues[relatedColumn[meter]];
                    if (!StringUtil.isBlank(relatedColValue[meter])) continue;
                    throw new IllegalArgumentException("\u5bf9\u8c61:" + entityMeta.getEntityClass().getName() + " \u751f\u6210\u4e1a\u52a1\u4e3b\u952e\u4f9d\u8d56\u7684\u5173\u8054\u5b57\u6bb5:" + entityMeta.getBizIdRelatedColumns()[meter] + " \u503c\u4e3anull!");
                }
            }
            if (hasId && StringUtil.isBlank(fullParamValues[pkIndex])) {
                fullParamValues[pkIndex] = entityMeta.getIdGenerator().getId(entityMeta.getTableName(), entityMeta.getBizIdSignature(), entityMeta.getBizIdRelatedColumns(), relatedColValue, null, entityMeta.getIdType(), entityMeta.getIdLength(), entityMeta.getBizIdSequenceSize());
                needUpdatePk = true;
            }
            if (hasBizId && StringUtil.isBlank(fullParamValues[bizIdColIndex])) {
                fullParamValues[bizIdColIndex] = entityMeta.getBusinessIdGenerator().getId(entityMeta.getTableName(), entityMeta.getBizIdSignature(), entityMeta.getBizIdRelatedColumns(), relatedColValue, null, entityMeta.getColumnJavaType(entityMeta.getBusinessIdField()), entityMeta.getBizIdLength(), entityMeta.getBizIdSequenceSize());
                BeanUtil.setProperty(entity, entityMeta.getBusinessIdField(), fullParamValues[bizIdColIndex]);
            }
        }
        SqlToyConfig sqlToyConfig = new SqlToyConfig(DataSourceUtils.getDialect(dbType));
        sqlToyConfig.setSqlType(SqlType.insert);
        sqlToyConfig.setSql(insertSql);
        sqlToyConfig.setParamsName(reflectColumns);
        SqlToyResult sqlToyResult = new SqlToyResult(insertSql, fullParamValues);
        sqlToyResult = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, OperateType.insert, sqlToyResult, entity.getClass(), dbType);
        String realInsertSql = sqlToyResult.getSql();
        SqlExecuteStat.showSql("\u6267\u884c\u5355\u8bb0\u5f55\u63d2\u5165", realInsertSql, null);
        final Object[] paramValues = sqlToyResult.getParamsValue();
        final Integer[] paramsType = entityMeta.getFieldsTypeArray();
        PreparedStatement pst = null;
        pst = isIdentity || isSequence ? conn.prepareStatement(realInsertSql, new String[]{DataSourceUtils.getReturnPrimaryKeyColumn(entityMeta.getColumnName(entityMeta.getIdArray()[0]), dbType)}) : conn.prepareStatement(realInsertSql);
        Object result = SqlUtil.preparedStatementProcess(null, pst, null, new PreparedStatementResultHandler(){

            @Override
            public void execute(Object obj, PreparedStatement pst, ResultSet rs) throws SQLException, IOException {
                ResultSet keyResult;
                SqlUtil.setParamsValue(sqlToyContext.getTypeHandler(), conn, dbType, pst, paramValues, paramsType, 0);
                pst.execute();
                if ((isIdentity || isSequence) && (keyResult = pst.getGeneratedKeys()) != null) {
                    while (keyResult.next()) {
                        this.setResult(keyResult.getObject(1));
                    }
                    keyResult.close();
                }
            }
        });
        if (entityMeta.getDataVersion() != null) {
            String dataVersionField = entityMeta.getDataVersion().getField();
            int dataVersionIndex = entityMeta.getFieldIndex(dataVersionField);
            BeanUtil.setProperty(entity, dataVersionField, fullParamValues[dataVersionIndex]);
        }
        if (entityMeta.getIdArray() == null) {
            return null;
        }
        if (result == null && pkIndex < fullParamValues.length) {
            result = fullParamValues[pkIndex];
        }
        if (needUpdatePk || isIdentity || isSequence) {
            BeanUtil.setProperty(entity, entityMeta.getIdArray()[0], result);
        }
        if (!entityMeta.getCascadeModels().isEmpty()) {
            List<Object> subTableData = null;
            for (TableCascadeModel cascadeModel : entityMeta.getCascadeModels()) {
                String[] mappedFields = cascadeModel.getMappedFields();
                Object[] mappedFieldValues = BeanUtil.reflectBeanToAry((Object)entity, cascadeModel.getFields());
                EntityMeta subTableEntityMeta = sqlToyContext.getEntityMeta(cascadeModel.getMappedType());
                if (cascadeModel.getCascadeType() == 1) {
                    subTableData = (List)BeanUtil.getProperty(entity, cascadeModel.getProperty());
                } else {
                    subTableData = new ArrayList();
                    Object item = BeanUtil.getProperty(entity, cascadeModel.getProperty());
                    if (item != null) {
                        subTableData.add(item);
                    }
                }
                if (subTableData != null && !subTableData.isEmpty()) {
                    logger.info("\u6267\u884csave\u64cd\u4f5c\u7684\u7ea7\u8054\u5b50\u8868{}\u6279\u91cf\u4fdd\u5b58!", (Object)subTableEntityMeta.getTableName());
                    SqlExecuteStat.debug("\u6267\u884c\u5b50\u8868\u7ea7\u8054\u4fdd\u5b58", null, new Object[0]);
                    BeanUtil.batchSetProperties(subTableData, mappedFields, mappedFieldValues, true);
                    String insertSubTableSql = generateSqlHandler.generateSql(subTableEntityMeta, null);
                    SavePKStrategy savePkStrategy = generateSavePKStrategy.generate(subTableEntityMeta);
                    DialectUtils.saveAll(sqlToyContext, subTableEntityMeta, savePkStrategy.getPkStrategy(), savePkStrategy.isAssginValue(), insertSubTableSql, subTableData, sqlToyContext.getBatchSize(), null, conn, dbType, null);
                    continue;
                }
                logger.info("\u672a\u6267\u884csave\u64cd\u4f5c\u7684\u7ea7\u8054\u5b50\u8868{}\u6279\u91cf\u4fdd\u5b58,\u5b50\u8868\u6570\u636e\u4e3a\u7a7a!", (Object)subTableEntityMeta.getTableName());
            }
        }
        return result;
    }

    public static Long saveAll(SqlToyContext sqlToyContext, EntityMeta entityMeta, PKStrategy pkStrategy, boolean isAssignPK, String insertSql, List<?> entities, int batchSize, ReflectPropsHandler reflectPropsHandler, Connection conn, Integer dbType, Boolean autoCommit) throws Exception {
        boolean isIdentity = pkStrategy != null && pkStrategy.equals((Object)PKStrategy.IDENTITY);
        boolean isSequence = pkStrategy != null && pkStrategy.equals((Object)PKStrategy.SEQUENCE);
        String[] reflectColumns = isIdentity && !isAssignPK || isSequence && !isAssignPK ? entityMeta.getRejectIdFieldArray() : entityMeta.getFieldsArray();
        ReflectPropsHandler handler = DialectUtils.getAddReflectHandler(entityMeta, reflectPropsHandler, sqlToyContext.getUnifyFieldsHandler());
        handler = DialectUtils.getSecureReflectHandler(handler, sqlToyContext.getFieldsSecureProvider(), sqlToyContext.getDesensitizeProvider(), entityMeta.getSecureFields());
        List paramValues = BeanUtil.reflectBeansToInnerAry(entities, reflectColumns, SqlUtilsExt.getDefaultValues(entityMeta), handler);
        int pkIndex = entityMeta.getIdIndex();
        boolean hasBizId = entityMeta.getBusinessIdGenerator() != null;
        int bizIdColIndex = hasBizId ? entityMeta.getFieldIndex(entityMeta.getBusinessIdField()) : 0;
        String signature = entityMeta.getBizIdSignature();
        Integer[] relatedColumn = entityMeta.getBizIdRelatedColIndex();
        String[] relatedColumnNames = entityMeta.getBizIdRelatedColumns();
        int relatedColumnSize = relatedColumn == null ? 0 : relatedColumn.length;
        boolean hasDataVersion = entityMeta.getDataVersion() != null;
        boolean hasId = pkStrategy != null && null != entityMeta.getIdGenerator();
        int dataVerIndex = hasDataVersion ? entityMeta.getFieldIndex(entityMeta.getDataVersion().getField()) : 0;
        Object[] relatedColValue = null;
        String businessIdType = hasBizId ? entityMeta.getColumnJavaType(entityMeta.getBusinessIdField()) : "";
        int end = paramValues.size();
        for (int i = 0; i < end; ++i) {
            Object[] rowData = paramValues.get(i);
            if (relatedColumn != null) {
                relatedColValue = new Object[relatedColumnSize];
                for (int meter = 0; meter < relatedColumnSize; ++meter) {
                    relatedColValue[meter] = rowData[relatedColumn[meter]];
                    if (!StringUtil.isBlank(relatedColValue[meter])) continue;
                    throw new IllegalArgumentException("\u5bf9\u8c61:" + entityMeta.getEntityClass().getName() + " \u751f\u6210\u4e1a\u52a1\u4e3b\u952e\u4f9d\u8d56\u7684\u5173\u8054\u5b57\u6bb5:" + relatedColumnNames[meter] + " \u503c\u4e3anull!");
                }
            }
            if (hasId && StringUtil.isBlank(rowData[pkIndex])) {
                rowData[pkIndex] = entityMeta.getIdGenerator().getId(entityMeta.getTableName(), signature, relatedColumnNames, relatedColValue, null, entityMeta.getIdType(), entityMeta.getIdLength(), entityMeta.getBizIdSequenceSize());
                BeanUtil.setProperty(entities.get(i), entityMeta.getIdArray()[0], rowData[pkIndex]);
            }
            if (hasBizId && StringUtil.isBlank(rowData[bizIdColIndex])) {
                rowData[bizIdColIndex] = entityMeta.getBusinessIdGenerator().getId(entityMeta.getTableName(), signature, relatedColumnNames, relatedColValue, null, businessIdType, entityMeta.getBizIdLength(), entityMeta.getBizIdSequenceSize());
                BeanUtil.setProperty(entities.get(i), entityMeta.getBusinessIdField(), rowData[bizIdColIndex]);
            }
            if (!hasDataVersion) continue;
            BeanUtil.setProperty(entities.get(i), entityMeta.getDataVersion().getField(), rowData[dataVerIndex]);
        }
        List realParams = paramValues;
        String realSql = insertSql;
        if (sqlToyContext.hasSqlInterceptors()) {
            SqlToyConfig sqlToyConfig = new SqlToyConfig(DataSourceUtils.getDialect(dbType));
            sqlToyConfig.setSqlType(SqlType.insert);
            sqlToyConfig.setSql(insertSql);
            sqlToyConfig.setParamsName(reflectColumns);
            SqlToyResult sqlToyResult = new SqlToyResult(insertSql, paramValues.toArray());
            sqlToyResult = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, OperateType.insertAll, sqlToyResult, entities.get(0).getClass(), dbType);
            realSql = sqlToyResult.getSql();
            realParams = CollectionUtil.arrayToList(sqlToyResult.getParamsValue());
        }
        SqlExecuteStat.showSql("\u6279\u91cf\u4fdd\u5b58[" + realParams.size() + "]\u6761\u8bb0\u5f55", realSql, null);
        return SqlUtilsExt.batchUpdateForPOJO(sqlToyContext.getTypeHandler(), realSql, realParams, entityMeta.getFieldsTypeArray(), entityMeta.getFieldsDefaultValue(), entityMeta.getFieldsNullable(), batchSize, autoCommit, conn, dbType);
    }

    public static Long saveAllIgnoreExist(SqlToyContext sqlToyContext, List<?> entities, int batchSize, EntityMeta entityMeta, GenerateSqlHandler generateSqlHandler, ReflectPropsHandler reflectPropsHandler, Connection conn, Integer dbType, Boolean autoCommit) throws Exception {
        boolean hasId;
        ReflectPropsHandler handler = DialectUtils.getAddReflectHandler(entityMeta, reflectPropsHandler, sqlToyContext.getUnifyFieldsHandler());
        handler = DialectUtils.getSecureReflectHandler(handler, sqlToyContext.getFieldsSecureProvider(), sqlToyContext.getDesensitizeProvider(), entityMeta.getSecureFields());
        List paramValues = BeanUtil.reflectBeansToInnerAry(entities, entityMeta.getFieldsArray(), SqlUtilsExt.getDefaultValues(entityMeta), handler);
        int pkIndex = entityMeta.getIdIndex();
        boolean hasBizId = entityMeta.getBusinessIdGenerator() != null;
        int bizIdColIndex = hasBizId ? entityMeta.getFieldIndex(entityMeta.getBusinessIdField()) : 0;
        String signature = entityMeta.getBizIdSignature();
        Integer[] relatedColumn = entityMeta.getBizIdRelatedColIndex();
        String[] relatedColumnNames = entityMeta.getBizIdRelatedColumns();
        int relatedColumnSize = relatedColumn == null ? 0 : relatedColumn.length;
        boolean bl = hasId = null != entityMeta.getIdStrategy() && null != entityMeta.getIdGenerator();
        if (hasId || hasBizId) {
            Object[] relatedColValue = null;
            String businessIdType = hasBizId ? entityMeta.getColumnJavaType(entityMeta.getBusinessIdField()) : "";
            int end = paramValues.size();
            for (int i = 0; i < end; ++i) {
                Object[] rowData = paramValues.get(i);
                if (relatedColumn != null) {
                    relatedColValue = new Object[relatedColumnSize];
                    for (int meter = 0; meter < relatedColumnSize; ++meter) {
                        relatedColValue[meter] = rowData[relatedColumn[meter]];
                        if (relatedColValue[meter] != null) continue;
                        throw new IllegalArgumentException("\u5bf9\u8c61:" + entityMeta.getEntityClass().getName() + " \u751f\u6210\u4e1a\u52a1\u4e3b\u952e\u4f9d\u8d56\u7684\u5173\u8054\u5b57\u6bb5:" + relatedColumnNames[meter] + " \u503c\u4e3anull!");
                    }
                }
                if (hasId && StringUtil.isBlank(rowData[pkIndex])) {
                    rowData[pkIndex] = entityMeta.getIdGenerator().getId(entityMeta.getTableName(), signature, relatedColumnNames, relatedColValue, null, entityMeta.getIdType(), entityMeta.getIdLength(), entityMeta.getBizIdSequenceSize());
                    BeanUtil.setProperty(entities.get(i), entityMeta.getIdArray()[0], rowData[pkIndex]);
                }
                if (!hasBizId || !StringUtil.isBlank(rowData[bizIdColIndex])) continue;
                rowData[bizIdColIndex] = entityMeta.getBusinessIdGenerator().getId(entityMeta.getTableName(), signature, relatedColumnNames, relatedColValue, null, businessIdType, entityMeta.getBizIdLength(), entityMeta.getBizIdSequenceSize());
                BeanUtil.setProperty(entities.get(i), entityMeta.getBusinessIdField(), rowData[bizIdColIndex]);
            }
        }
        String saveAllNotExistSql = generateSqlHandler.generateSql(entityMeta, null);
        List realParams = paramValues;
        String realSql = saveAllNotExistSql;
        if (sqlToyContext.hasSqlInterceptors()) {
            SqlToyConfig sqlToyConfig = new SqlToyConfig(DataSourceUtils.getDialect(dbType));
            sqlToyConfig.setSqlType(SqlType.insert);
            sqlToyConfig.setSql(saveAllNotExistSql);
            sqlToyConfig.setParamsName(entityMeta.getFieldsArray());
            SqlToyResult sqlToyResult = new SqlToyResult(saveAllNotExistSql, paramValues.toArray());
            sqlToyResult = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, OperateType.insertAll, sqlToyResult, entities.get(0).getClass(), dbType);
            realSql = sqlToyResult.getSql();
            realParams = CollectionUtil.arrayToList(sqlToyResult.getParamsValue());
        }
        SqlExecuteStat.showSql("\u6279\u91cf\u63d2\u5165\u4e14\u5ffd\u89c6\u5df2\u5b58\u5728\u8bb0\u5f55", realSql, null);
        return SqlUtilsExt.batchUpdateForPOJO(sqlToyContext.getTypeHandler(), realSql, realParams, entityMeta.getFieldsTypeArray(), entityMeta.getFieldsDefaultValue(), entityMeta.getFieldsNullable(), batchSize, autoCommit, conn, dbType);
    }

    public static Long update(SqlToyContext sqlToyContext, Serializable entity, EntityMeta entityMeta, String nullFunction, String[] forceUpdateFields, Connection conn, Integer dbType, String tableName) throws Exception {
        int pkIndex;
        String realTable = entityMeta.getSchemaTable(tableName, dbType);
        if (entityMeta.getIdArray() == null) {
            throw new IllegalArgumentException("\u8868:" + realTable + " \u65e0\u4e3b\u952e,\u4e0d\u7b26\u5408update/updateAll\u89c4\u5219,\u8bf7\u68c0\u67e5\u8868\u8bbe\u8ba1\u662f\u5426\u5408\u7406!");
        }
        if (entityMeta.getRejectIdFieldArray() == null) {
            logger.warn("\u8868:" + realTable + " \u5b57\u6bb5\u5168\u90e8\u662f\u4e3b\u952e\u4e0d\u5b58\u5728\u66f4\u65b0\u5b57\u6bb5,\u65e0\u9700\u6267\u884c\u66f4\u65b0\u64cd\u4f5c!");
            return 0L;
        }
        ReflectPropsHandler handler = DialectUtils.getUpdateReflectHandler(null, forceUpdateFields, sqlToyContext.getUnifyFieldsHandler());
        handler = DialectUtils.getSecureReflectHandler(handler, sqlToyContext.getFieldsSecureProvider(), sqlToyContext.getDesensitizeProvider(), entityMeta.getSecureFields());
        Object[] fieldsValues = BeanUtil.reflectBeanToAry((Object)entity, entityMeta.getFieldsArray(), null, handler);
        int end = pkIndex + entityMeta.getIdArray().length;
        for (int i = pkIndex = entityMeta.getIdIndex().intValue(); i < end; ++i) {
            if (!StringUtil.isBlank(fieldsValues[i])) continue;
            throw new IllegalArgumentException("\u901a\u8fc7\u5bf9\u8c61\u5bf9\u8868:" + realTable + " \u8fdb\u884cupdate\u64cd\u4f5c,\u4e3b\u952e\u5b57\u6bb5\u5fc5\u987b\u8981\u8d4b\u503c!");
        }
        String updateSql = DialectUtils.generateUpdateSql(sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, nullFunction, forceUpdateFields, realTable);
        if (updateSql == null) {
            throw new IllegalArgumentException("update sql is null,\u5f15\u8d77\u95ee\u9898\u7684\u539f\u56e0\u662f\u6ca1\u6709\u8bbe\u7f6e\u9700\u8981\u4fee\u6539\u7684\u5b57\u6bb5!");
        }
        SqlToyConfig sqlToyConfig = new SqlToyConfig(DataSourceUtils.getDialect(dbType));
        sqlToyConfig.setSqlType(SqlType.update);
        sqlToyConfig.setSql(updateSql);
        sqlToyConfig.setParamsName(entityMeta.getFieldsArray());
        SqlToyResult sqlToyResult = new SqlToyResult(updateSql, fieldsValues);
        sqlToyResult = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, OperateType.update, sqlToyResult, entity.getClass(), dbType);
        return SqlUtil.executeSql(sqlToyContext.getTypeHandler(), sqlToyResult.getSql(), sqlToyResult.getParamsValue(), entityMeta.getFieldsTypeArray(), conn, dbType, null, false);
    }

    public static Long update(SqlToyContext sqlToyContext, Serializable entity, String nullFunction, String[] forceUpdateFields, boolean cascade, GenerateSqlHandler generateSqlHandler, Class[] forceCascadeClasses, HashMap<Class, String[]> subTableForceUpdateProps, Connection conn, Integer dbType, String tableName) throws Exception {
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entity.getClass());
        String realTable = entityMeta.getSchemaTable(tableName, dbType);
        if (entityMeta.getIdArray() == null) {
            throw new IllegalArgumentException("\u8868:" + realTable + " \u65e0\u4e3b\u952e,\u4e0d\u7b26\u5408update/updateAll\u89c4\u5219,\u8bf7\u68c0\u67e5\u8868\u8bbe\u8ba1\u662f\u5426\u5408\u7406!");
        }
        if (entityMeta.getRejectIdFieldArray() == null) {
            logger.warn("\u8868:" + realTable + " \u5b57\u6bb5\u5168\u90e8\u662f\u4e3b\u952e\u4e0d\u5b58\u5728\u66f4\u65b0\u5b57\u6bb5,\u65e0\u9700\u6267\u884c\u66f4\u65b0\u64cd\u4f5c!");
            return 0L;
        }
        Long updateCnt = DialectUtils.update(sqlToyContext, entity, entityMeta, nullFunction, forceUpdateFields, conn, dbType, tableName);
        if (!cascade || entityMeta.getCascadeModels().isEmpty()) {
            return updateCnt;
        }
        HashMap<Class, String> typeMap = new HashMap<Class, String>();
        if (forceCascadeClasses != null) {
            for (Class type : forceCascadeClasses) {
                typeMap.put(type, "");
            }
        }
        List<Object> subTableData = null;
        String[] forceUpdateProps = null;
        for (TableCascadeModel cascadeModel : entityMeta.getCascadeModels()) {
            String[] mappedFields = cascadeModel.getMappedFields();
            Object[] mappedFieldValues = BeanUtil.reflectBeanToAry((Object)entity, cascadeModel.getFields());
            EntityMeta subTableEntityMeta = sqlToyContext.getEntityMeta(cascadeModel.getMappedType());
            String[] stringArray = forceUpdateProps = subTableForceUpdateProps == null ? null : subTableForceUpdateProps.get(cascadeModel.getMappedType());
            if (cascadeModel.getCascadeType() == 1) {
                subTableData = (List)BeanUtil.getProperty(entity, cascadeModel.getProperty());
            } else {
                subTableData = new ArrayList();
                Object item = BeanUtil.getProperty(entity, cascadeModel.getProperty());
                if (item != null) {
                    subTableData.add(item);
                }
            }
            if (cascadeModel.getCascadeUpdateSql() != null && (subTableData != null && !subTableData.isEmpty() || typeMap.containsKey(cascadeModel.getMappedType()))) {
                SqlExecuteStat.debug("\u6267\u884c\u5b50\u8868\u7ea7\u8054\u66f4\u65b0\u524d\u7684\u5b58\u91cf\u6570\u636e\u66f4\u65b0", null, new Object[0]);
                SqlToyResult sqlToyResult = SqlConfigParseUtils.processSql(cascadeModel.getCascadeUpdateSql(), mappedFields, mappedFieldValues, null);
                SqlToyConfig sqlToyConfig = new SqlToyConfig(DataSourceUtils.getDialect(dbType));
                sqlToyConfig.setSqlType(SqlType.update);
                sqlToyConfig.setSql(cascadeModel.getCascadeUpdateSql());
                sqlToyConfig.setParamsName(mappedFields);
                sqlToyResult = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, OperateType.execute, sqlToyResult, cascadeModel.getMappedType(), dbType);
                SqlUtil.executeSql(sqlToyContext.getTypeHandler(), sqlToyResult.getSql(), sqlToyResult.getParamsValue(), null, conn, dbType, null, true);
            }
            if (subTableData != null && !subTableData.isEmpty()) {
                logger.info("\u6267\u884cupdate\u4e3b\u8868:{} \u5bf9\u5e94\u7ea7\u8054\u5b50\u8868: {} \u66f4\u65b0\u64cd\u4f5c!", (Object)realTable, (Object)subTableEntityMeta.getTableName());
                SqlExecuteStat.debug("\u6267\u884c\u5b50\u8868\u7ea7\u8054\u66f4\u65b0\u64cd\u4f5c", null, new Object[0]);
                BeanUtil.batchSetProperties(subTableData, mappedFields, mappedFieldValues, true);
                if (dbType == 40 || dbType == 42 || dbType == 90) {
                    DialectUtils.mysqlSaveOrUpdateAll(sqlToyContext, subTableEntityMeta, subTableData, null, forceUpdateProps, conn, dbType);
                    continue;
                }
                if (dbType == 50) {
                    DialectUtils.postgreSaveOrUpdateAll(sqlToyContext, subTableEntityMeta, subTableData, null, forceUpdateProps, conn, dbType);
                    continue;
                }
                if (dbType == 100) {
                    DialectUtils.oceanBaseSaveOrUpdateAll(sqlToyContext, subTableEntityMeta, subTableData, null, forceUpdateProps, conn, dbType);
                    continue;
                }
                if (dbType == 80) {
                    DialectUtils.sqliteSaveOrUpdateAll(sqlToyContext, subTableEntityMeta, subTableData, null, forceUpdateProps, conn, dbType);
                    continue;
                }
                DialectUtils.saveOrUpdateAll(sqlToyContext, subTableData, sqlToyContext.getBatchSize(), subTableEntityMeta, forceUpdateProps, generateSqlHandler, null, conn, dbType, null);
                continue;
            }
            logger.info("\u672a\u6267\u884cupdate\u4e3b\u8868:{} \u5bf9\u5e94\u7ea7\u8054\u5b50\u8868: {} \u66f4\u65b0\u64cd\u4f5c,\u5b50\u8868\u6570\u636e\u4e3a\u7a7a!", (Object)realTable, (Object)subTableEntityMeta.getTableName());
        }
        return updateCnt;
    }

    private static void mysqlSaveOrUpdateAll(SqlToyContext sqlToyContext, EntityMeta entityMeta, List<?> entities, ReflectPropsHandler reflectPropsHandler, String[] forceUpdateFields, Connection conn, Integer dbType) throws Exception {
        String tableName;
        int batchSize = sqlToyContext.getBatchSize();
        Long updateCnt = DialectUtils.updateAll(sqlToyContext, entities, batchSize, forceUpdateFields, reflectPropsHandler, "ifnull", conn, dbType, null, tableName = entityMeta.getSchemaTable(null, dbType), true);
        if (updateCnt >= (long)entities.size()) {
            logger.debug("\u7ea7\u8054\u5b50\u8868{}\u4fee\u6539\u8bb0\u5f55\u6570\u4e3a:{}", (Object)tableName, (Object)updateCnt);
            return;
        }
        boolean isAssignPK = MySqlDialectUtils.isAssignPKValue(entityMeta.getIdStrategy());
        String insertSql = DialectExtUtils.generateInsertSql(sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, entityMeta.getIdStrategy(), "ifnull", "NEXTVAL FOR " + entityMeta.getSequence(), isAssignPK, tableName).replaceFirst("(?i)insert ", "insert ignore ");
        Long saveCnt = DialectUtils.saveAll(sqlToyContext, entityMeta, entityMeta.getIdStrategy(), isAssignPK, insertSql, entities, batchSize, reflectPropsHandler, conn, dbType, null);
        logger.debug("\u7ea7\u8054\u5b50\u8868:{} \u53d8\u66f4\u8bb0\u5f55\u6570:{},\u65b0\u5efa\u8bb0\u5f55\u6570\u4e3a:{}", new Object[]{tableName, updateCnt, saveCnt});
    }

    private static void oceanBaseSaveOrUpdateAll(final SqlToyContext sqlToyContext, EntityMeta entityMeta, List<?> entities, ReflectPropsHandler reflectPropsHandler, String[] forceUpdateFields, Connection conn, final Integer dbType) throws Exception {
        String tableName;
        int batchSize = sqlToyContext.getBatchSize();
        Long updateCnt = DialectUtils.updateAll(sqlToyContext, entities, batchSize, forceUpdateFields, reflectPropsHandler, "nvl", conn, dbType, null, tableName = entityMeta.getSchemaTable(null, dbType), true);
        if (updateCnt >= (long)entities.size()) {
            logger.debug("\u7ea7\u8054\u5b50\u8868{}\u4fee\u6539\u8bb0\u5f55\u6570\u4e3a:{}", (Object)tableName, (Object)updateCnt);
            return;
        }
        Long saveCnt = DialectUtils.saveAllIgnoreExist(sqlToyContext, entities, batchSize, entityMeta, new GenerateSqlHandler(){

            @Override
            public String generateSql(EntityMeta entityMeta, String[] forceUpdateFields) {
                PKStrategy pkStrategy = entityMeta.getIdStrategy();
                String sequence = entityMeta.getSequence() + ".nextval";
                if (pkStrategy != null && pkStrategy.equals((Object)PKStrategy.IDENTITY)) {
                    pkStrategy = PKStrategy.SEQUENCE;
                    sequence = entityMeta.getFieldMeta(entityMeta.getIdArray()[0]).getDefaultValue();
                }
                return DialectExtUtils.mergeIgnore(sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, pkStrategy, "dual", "nvl", sequence, OracleDialectUtils.isAssignPKValue(pkStrategy), tableName);
            }
        }, reflectPropsHandler, conn, dbType, null);
        logger.debug("\u7ea7\u8054\u5b50\u8868:{} \u53d8\u66f4\u8bb0\u5f55\u6570:{},\u65b0\u5efa\u8bb0\u5f55\u6570\u4e3a:{}", new Object[]{tableName, updateCnt, saveCnt});
    }

    private static void postgreSaveOrUpdateAll(final SqlToyContext sqlToyContext, EntityMeta entityMeta, List<?> entities, ReflectPropsHandler reflectPropsHandler, String[] forceUpdateFields, Connection conn, final Integer dbType) throws Exception {
        String tableName;
        int batchSize = sqlToyContext.getBatchSize();
        Long updateCnt = DialectUtils.updateAll(sqlToyContext, entities, batchSize, forceUpdateFields, reflectPropsHandler, "COALESCE", conn, dbType, null, tableName = entityMeta.getSchemaTable(null, dbType), true);
        if (updateCnt >= (long)entities.size()) {
            logger.debug("\u7ea7\u8054\u5b50\u8868{}\u4fee\u6539\u8bb0\u5f55\u6570\u4e3a:{}", (Object)tableName, (Object)updateCnt);
            return;
        }
        Long saveCnt = DialectUtils.saveAllIgnoreExist(sqlToyContext, entities, batchSize, entityMeta, new GenerateSqlHandler(){

            @Override
            public String generateSql(EntityMeta entityMeta, String[] forceUpdateFields) {
                PKStrategy pkStrategy = entityMeta.getIdStrategy();
                String sequence = "nextval('" + entityMeta.getSequence() + "')";
                if ((dbType == 70 || dbType == 210 || dbType == 220 || dbType == 180 || dbType == 190 || dbType == 200) && pkStrategy != null && pkStrategy.equals((Object)PKStrategy.SEQUENCE)) {
                    sequence = entityMeta.getSequence() + ".nextval";
                }
                if (pkStrategy != null && pkStrategy.equals((Object)PKStrategy.IDENTITY)) {
                    pkStrategy = PKStrategy.SEQUENCE;
                    sequence = "DEFAULT";
                }
                boolean isAssignPK = PostgreSqlDialectUtils.isAssignPKValue(pkStrategy);
                if (dbType == 70 || dbType == 190 || dbType == 220 || dbType == 180 || dbType == 210 || dbType == 200) {
                    isAssignPK = OpenGaussDialectUtils.isAssignPKValue(pkStrategy);
                }
                return DialectExtUtils.insertIgnore(sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, pkStrategy, "COALESCE", sequence, isAssignPK, tableName);
            }
        }, reflectPropsHandler, conn, dbType, null);
        logger.debug("\u7ea7\u8054\u5b50\u8868:{} \u53d8\u66f4\u8bb0\u5f55\u6570:{},\u65b0\u5efa\u8bb0\u5f55\u6570\u4e3a:{}", new Object[]{tableName, updateCnt, saveCnt});
    }

    private static void sqliteSaveOrUpdateAll(SqlToyContext sqlToyContext, EntityMeta entityMeta, List<?> entities, ReflectPropsHandler reflectPropsHandler, String[] forceUpdateFields, Connection conn, Integer dbType) throws Exception {
        String tableName;
        int batchSize = sqlToyContext.getBatchSize();
        Long updateCnt = DialectUtils.updateAll(sqlToyContext, entities, batchSize, forceUpdateFields, reflectPropsHandler, "ifnull", conn, dbType, null, tableName = entityMeta.getSchemaTable(null, dbType), true);
        if (updateCnt >= (long)entities.size()) {
            logger.debug("\u7ea7\u8054\u5b50\u8868{}\u4fee\u6539\u8bb0\u5f55\u6570\u4e3a:{}", (Object)tableName, (Object)updateCnt);
            return;
        }
        boolean isAssignPK = SqliteDialectUtils.isAssignPKValue(entityMeta.getIdStrategy());
        String insertSql = DialectExtUtils.generateInsertSql(sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, entityMeta.getIdStrategy(), "ifnull", "NEXTVAL FOR " + entityMeta.getSequence(), isAssignPK, tableName).replaceFirst("(?i)insert ", "insert or ignore ");
        Long saveCnt = DialectUtils.saveAll(sqlToyContext, entityMeta, entityMeta.getIdStrategy(), isAssignPK, insertSql, entities, batchSize, reflectPropsHandler, conn, dbType, null);
        logger.debug("\u7ea7\u8054\u5b50\u8868:{} \u53d8\u66f4\u8bb0\u5f55\u6570:{},\u65b0\u5efa\u8bb0\u5f55\u6570\u4e3a:{}", new Object[]{tableName, updateCnt, saveCnt});
    }

    public static Long updateAll(SqlToyContext sqlToyContext, List<?> entities, int batchSize, String[] forceUpdateFields, ReflectPropsHandler reflectPropsHandler, String nullFunction, Connection conn, Integer dbType, Boolean autoCommit, String tableName, boolean skipNull) throws Exception {
        String updateSql;
        if (entities == null || entities.isEmpty()) {
            return 0L;
        }
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entities.get(0).getClass());
        String realTable = entityMeta.getSchemaTable(tableName, dbType);
        if (entityMeta.getIdArray() == null) {
            throw new IllegalArgumentException("\u8868:" + realTable + " \u65e0\u4e3b\u952e,\u4e0d\u7b26\u5408update/updateAll\u89c4\u5219,\u8bf7\u68c0\u67e5\u8868\u8bbe\u8ba1\u662f\u5426\u5408\u7406!");
        }
        if (entityMeta.getRejectIdFieldArray() == null) {
            logger.warn("\u8868:" + realTable + " \u5b57\u6bb5\u5168\u90e8\u662f\u4e3b\u952e\u4e0d\u5b58\u5728\u66f4\u65b0\u5b57\u6bb5,\u65e0\u9700\u6267\u884c\u66f4\u65b0\u64cd\u4f5c!");
            return 0L;
        }
        ReflectPropsHandler handler = DialectUtils.getUpdateReflectHandler(reflectPropsHandler, forceUpdateFields, sqlToyContext.getUnifyFieldsHandler());
        handler = DialectUtils.getSecureReflectHandler(handler, sqlToyContext.getFieldsSecureProvider(), sqlToyContext.getDesensitizeProvider(), entityMeta.getSecureFields());
        List paramsValues = BeanUtil.reflectBeansToInnerAry(entities, entityMeta.getFieldsArray(), null, handler);
        int pkIndex = entityMeta.getIdIndex();
        int end = pkIndex + entityMeta.getIdArray().length;
        int index = 0;
        int skipCount = 0;
        Iterator<Object[]> iter = paramsValues.iterator();
        while (iter.hasNext()) {
            Object[] rowValues = iter.next();
            for (int i = pkIndex; i < end; ++i) {
                if (!StringUtil.isBlank(rowValues[i])) continue;
                if (skipNull) {
                    ++skipCount;
                    iter.remove();
                    break;
                }
                throw new IllegalArgumentException("\u901a\u8fc7\u5bf9\u8c61\u5bf9\u8868" + realTable + " \u8fdb\u884cupdateAll\u64cd\u4f5c,\u4e3b\u952e\u5b57\u6bb5\u5fc5\u987b\u8981\u8d4b\u503c!\u7b2c:" + index + " \u6761\u8bb0\u5f55\u4e3b\u952e\u4e3anull!");
            }
            ++index;
        }
        if (skipCount > 0) {
            logger.debug("\u5171\u6709:{}\u884c\u8bb0\u5f55\u56e0\u4e3a\u4e3b\u952e\u503c\u4e3a\u7a7a\u8df3\u8fc7\u4fee\u6539\u64cd\u4f5c!", (Object)skipCount);
        }
        if ((updateSql = DialectUtils.generateUpdateSql(sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, nullFunction, forceUpdateFields, realTable)) == null) {
            throw new IllegalArgumentException("updateAll sql is null,\u5f15\u8d77\u95ee\u9898\u7684\u539f\u56e0\u662f\u6ca1\u6709\u8bbe\u7f6e\u9700\u8981\u4fee\u6539\u7684\u5b57\u6bb5!");
        }
        List realParams = paramsValues;
        String realSql = updateSql;
        if (sqlToyContext.hasSqlInterceptors()) {
            SqlToyConfig sqlToyConfig = new SqlToyConfig(DataSourceUtils.getDialect(dbType));
            sqlToyConfig.setSqlType(SqlType.update);
            sqlToyConfig.setSql(updateSql);
            sqlToyConfig.setParamsName(entityMeta.getFieldsArray());
            SqlToyResult sqlToyResult = new SqlToyResult(updateSql, paramsValues.toArray());
            sqlToyResult = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, OperateType.updateAll, sqlToyResult, entities.get(0).getClass(), dbType);
            realSql = sqlToyResult.getSql();
            realParams = CollectionUtil.arrayToList(sqlToyResult.getParamsValue());
        }
        SqlExecuteStat.showSql("\u6279\u91cf\u4fee\u6539[" + realParams.size() + "]\u6761\u8bb0\u5f55", realSql, null);
        return SqlUtilsExt.batchUpdateForPOJO(sqlToyContext.getTypeHandler(), realSql, realParams, entityMeta.getFieldsTypeArray(), null, null, batchSize, autoCommit, conn, dbType);
    }

    public static Long delete(SqlToyContext sqlToyContext, Serializable entity, Connection conn, Integer dbType, String tableName) throws Exception {
        if (entity == null) {
            return 0L;
        }
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entity.getClass());
        String realTable = entityMeta.getSchemaTable(tableName, dbType);
        if (null == entityMeta.getIdArray()) {
            throw new IllegalArgumentException("delete \u64cd\u4f5c,\u8868:" + realTable + " \u6ca1\u6709\u4e3b\u952e,\u8bf7\u68c0\u67e5\u8868\u8bbe\u8ba1!");
        }
        Object[] idValues = BeanUtil.reflectBeanToAry((Object)entity, entityMeta.getIdArray());
        Integer[] parameterTypes = new Integer[idValues.length];
        boolean validator = true;
        int n = idValues.length;
        for (int i = 0; i < n; ++i) {
            parameterTypes[i] = entityMeta.getColumnJdbcType(entityMeta.getIdArray()[i]);
            if (!StringUtil.isBlank(idValues[i])) continue;
            validator = false;
            break;
        }
        if (!validator) {
            throw new IllegalArgumentException(realTable + " delete operate is illegal,table must has primary key and all primaryKey's value must has value!");
        }
        if (!entityMeta.getCascadeModels().isEmpty()) {
            for (TableCascadeModel cascadeModel : entityMeta.getCascadeModels()) {
                if (!cascadeModel.isDelete()) continue;
                EntityMeta subMeta = sqlToyContext.getEntityMeta(cascadeModel.getMappedType());
                Object[] mainFieldValues = BeanUtil.reflectBeanToAry((Object)entity, cascadeModel.getFields());
                int mapFieldSize = cascadeModel.getFields().length;
                for (int i = 0; i < mapFieldSize; ++i) {
                    if (mainFieldValues[i] != null) continue;
                    throw new IllegalArgumentException("\u8868:" + realTable + " \u7ea7\u8054\u5220\u9664\u5b50\u8868:" + subMeta.getTableName() + " \u5bf9\u5e94\u5c5e\u6027:" + cascadeModel.getFields()[i] + " \u503c\u4e3anull!");
                }
                Integer[] subTableFieldType = new Integer[mapFieldSize];
                int n2 = mapFieldSize;
                for (int i = 0; i < n2; ++i) {
                    subTableFieldType[i] = subMeta.getColumnJdbcType(cascadeModel.getMappedFields()[i]);
                }
                SqlExecuteStat.debug("\u6267\u884c\u7ea7\u8054\u5220\u9664\u64cd\u4f5c", null, new Object[0]);
                SqlToyConfig sqlToyConfig = new SqlToyConfig(DataSourceUtils.getDialect(dbType));
                sqlToyConfig.setSqlType(SqlType.delete);
                sqlToyConfig.setSql(cascadeModel.getDeleteSubTableSql());
                sqlToyConfig.setParamsName(cascadeModel.getFields());
                SqlToyResult sqlToyResult = new SqlToyResult(cascadeModel.getDeleteSubTableSql(), mainFieldValues);
                sqlToyResult = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, OperateType.deleteAll, sqlToyResult, cascadeModel.getMappedType(), dbType);
                SqlUtil.executeSql(sqlToyContext.getTypeHandler(), sqlToyResult.getSql(), sqlToyResult.getParamsValue(), subTableFieldType, conn, dbType, null, true);
            }
        }
        String deleteSql = "delete from ".concat(realTable).concat(" ").concat(entityMeta.getIdArgWhereSql());
        SqlToyConfig sqlToyConfig = new SqlToyConfig(DataSourceUtils.getDialect(dbType));
        sqlToyConfig.setSqlType(SqlType.delete);
        sqlToyConfig.setSql(deleteSql);
        sqlToyConfig.setParamsName(entityMeta.getIdArray());
        SqlToyResult sqlToyResult = new SqlToyResult(deleteSql, idValues);
        sqlToyResult = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, OperateType.delete, sqlToyResult, entity.getClass(), dbType);
        return SqlUtil.executeSql(sqlToyContext.getTypeHandler(), sqlToyResult.getSql(), sqlToyResult.getParamsValue(), parameterTypes, conn, dbType, null, true);
    }

    public static Long deleteAll(SqlToyContext sqlToyContext, List<?> entities, int batchSize, Connection conn, Integer dbType, Boolean autoCommit, String tableName) throws Exception {
        if (null == entities || entities.isEmpty()) {
            return 0L;
        }
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entities.get(0).getClass());
        String realTable = entityMeta.getSchemaTable(tableName, dbType);
        if (null == entityMeta.getIdArray()) {
            throw new IllegalArgumentException("delete/deleteAll \u64cd\u4f5c,\u8868:" + realTable + " \u6ca1\u6709\u4e3b\u952e,\u8bf7\u68c0\u67e5\u8868\u8bbe\u8ba1!");
        }
        List idValues = BeanUtil.reflectBeansToInnerAry(entities, entityMeta.getIdArray(), null, null);
        int n = idValues.size();
        for (int i = 0; i < n; ++i) {
            Object[] idsValue;
            for (Object obj : idsValue = idValues.get(i)) {
                if (!StringUtil.isBlank(obj)) continue;
                throw new IllegalArgumentException("\u7b2c[" + i + "]\u884c\u6570\u636e\u4e3b\u952e\u503c\u5b58\u5728\u7a7a,\u6279\u91cf\u5220\u9664\u4ee5\u4e3b\u952e\u4e3a\u4f9d\u636e\uff0c\u8868:" + realTable + " \u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a!");
            }
        }
        int idsLength = entityMeta.getIdArray().length;
        Integer[] parameterTypes = new Integer[idsLength];
        int n2 = idsLength;
        for (int i = 0; i < n2; ++i) {
            parameterTypes[i] = entityMeta.getColumnJdbcType(entityMeta.getIdArray()[i]);
        }
        boolean supportMultiFieldIn = DataSourceUtils.isSupportMultiFieldIn(dbType);
        if (!entityMeta.getCascadeModels().isEmpty()) {
            int meter = 0;
            for (TableCascadeModel cascadeModel : entityMeta.getCascadeModels()) {
                if (!cascadeModel.isDelete()) continue;
                EntityMeta subTableMeta = sqlToyContext.getEntityMeta(cascadeModel.getMappedType());
                List mainFieldValues = BeanUtil.reflectBeansToInnerAry(entities, cascadeModel.getFields(), null, null);
                int mapFieldSize = cascadeModel.getFields().length;
                meter = 0;
                for (Object[] row : mainFieldValues) {
                    for (int i = 0; i < mapFieldSize; ++i) {
                        if (row[i] != null) continue;
                        throw new IllegalArgumentException("\u7b2c:" + meter + "\u884c,\u8868:" + realTable + " \u7ea7\u8054\u5220\u9664\u5b50\u8868:" + subTableMeta.getTableName() + " \u5bf9\u5e94\u5c5e\u6027:" + cascadeModel.getFields()[i] + " \u503c\u4e3anull!");
                    }
                    ++meter;
                }
                if (mapFieldSize == 1 || supportMultiFieldIn) {
                    DialectUtils.deleteByIds(sqlToyContext, subTableMeta, cascadeModel.getFields(), cascadeModel.getMappedFields(), conn, dbType, autoCommit, subTableMeta.getSchemaTable(null, null), entities);
                    continue;
                }
                Integer[] subTableFieldType = new Integer[mapFieldSize];
                int n3 = mapFieldSize;
                for (int i = 0; i < n3; ++i) {
                    subTableFieldType[i] = subTableMeta.getColumnJdbcType(cascadeModel.getMappedFields()[i]);
                }
                String delSubTableSql = ReservedWordsUtil.convertSql(cascadeModel.getDeleteSubTableSql(), dbType);
                List realParams = mainFieldValues;
                String realSql = delSubTableSql;
                if (sqlToyContext.hasSqlInterceptors()) {
                    SqlToyConfig sqlToyConfig = new SqlToyConfig(DataSourceUtils.getDialect(dbType));
                    sqlToyConfig.setSqlType(SqlType.delete);
                    sqlToyConfig.setSql(delSubTableSql);
                    sqlToyConfig.setParamsName(cascadeModel.getFields());
                    SqlToyResult sqlToyResult = new SqlToyResult(delSubTableSql, mainFieldValues.toArray());
                    sqlToyResult = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, OperateType.deleteAll, sqlToyResult, cascadeModel.getMappedType(), dbType);
                    realSql = sqlToyResult.getSql();
                    realParams = CollectionUtil.arrayToList(sqlToyResult.getParamsValue());
                }
                SqlExecuteStat.showSql("\u7ea7\u8054\u5220\u9664\u5b50\u8868\u8bb0\u5f55", realSql, null);
                SqlUtilsExt.batchUpdateForPOJO(sqlToyContext.getTypeHandler(), realSql, realParams, subTableFieldType, null, null, sqlToyContext.getBatchSize(), null, conn, dbType);
            }
        }
        if (idsLength == 1 || supportMultiFieldIn) {
            return DialectUtils.deleteByIds(sqlToyContext, entityMeta, entityMeta.getIdArray(), entityMeta.getIdArray(), conn, dbType, autoCommit, realTable, entities);
        }
        String deleteSql = ReservedWordsUtil.convertSql("delete from ".concat(realTable).concat(" ").concat(entityMeta.getIdArgWhereSql()), dbType);
        List realParams = idValues;
        String realSql = deleteSql;
        if (sqlToyContext.hasSqlInterceptors()) {
            SqlToyConfig sqlToyConfig = new SqlToyConfig(DataSourceUtils.getDialect(dbType));
            sqlToyConfig.setSqlType(SqlType.delete);
            sqlToyConfig.setSql(deleteSql);
            sqlToyConfig.setParamsName(entityMeta.getIdArray());
            SqlToyResult sqlToyResult = new SqlToyResult(deleteSql, idValues.toArray());
            sqlToyResult = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, OperateType.deleteAll, sqlToyResult, entities.get(0).getClass(), dbType);
            realSql = sqlToyResult.getSql();
            realParams = CollectionUtil.arrayToList(sqlToyResult.getParamsValue());
        }
        SqlExecuteStat.showSql("\u6279\u91cf\u5220\u9664[" + realParams.size() + "]\u6761\u8bb0\u5f55", realSql, null);
        return SqlUtilsExt.batchUpdateForPOJO(sqlToyContext.getTypeHandler(), realSql, realParams, parameterTypes, null, null, batchSize, autoCommit, conn, dbType);
    }

    private static Long deleteByIds(SqlToyContext sqlToyContext, EntityMeta entityMeta, String[] fields, String[] mappedFields, Connection conn, Integer dbType, Boolean autoCommit, String tableName, List<?> entities) throws Exception {
        String key = "entities";
        StringBuilder sqlString = dbType == 60 ? new StringBuilder("alter table ".concat(tableName).concat(" delete where ")) : new StringBuilder("delete from ".concat(tableName).concat(" where "));
        int fieldsCnt = fields.length;
        if (fieldsCnt > 1) {
            sqlString.append(" (");
        }
        int index = 0;
        StringBuilder argsParamName = new StringBuilder();
        for (String mappedField : mappedFields) {
            if (index > 0) {
                sqlString.append(",");
                argsParamName.append(",");
            }
            sqlString.append(ReservedWordsUtil.convertWord(entityMeta.getColumnName(mappedField), dbType));
            argsParamName.append(":").append(key).append(".").append(fields[index]);
            ++index;
        }
        if (fieldsCnt > 1) {
            sqlString.append(") ");
        }
        sqlString.append(" in ");
        if (fieldsCnt > 1) {
            sqlString.append(" ((").append(argsParamName.toString()).append("))");
        } else {
            sqlString.append(" (").append(argsParamName.toString()).append(")");
        }
        String dialect = DataSourceUtils.getDialect(dbType);
        QueryExecutor query = new QueryExecutor(sqlString.toString(), MapKit.map(key, entities));
        SqlToyConfig sqlToyConfig = sqlToyContext.getSqlToyConfig(query, SqlType.delete, dialect);
        QueryExecutorBuilder.initQueryExecutor(sqlToyContext, query.getInnerModel(), sqlToyConfig, false, false);
        SqlToyResult queryParam = SqlConfigParseUtils.processSql(sqlToyConfig.getSql(null), sqlToyConfig.getParamsName(), query.getInnerModel().getParamsValue(sqlToyContext, sqlToyConfig), dialect);
        queryParam = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, OperateType.deleteAll, queryParam, entityMeta.getEntityClass(), dbType);
        return SqlUtil.executeSql(sqlToyContext.getTypeHandler(), queryParam.getSql(), queryParam.getParamsValue(), null, conn, dbType, autoCommit, false);
    }

    public static boolean isUnique(SqlToyContext sqlToyContext, Serializable entity, String[] paramsNamed, Connection conn, Integer dbType, String tableName, UniqueSqlHandler uniqueSqlHandler) {
        try {
            String[] realParamNamed;
            Object[] paramValues;
            int rejectIdFieldsSize;
            EntityMeta entityMeta = sqlToyContext.getEntityMeta(entity.getClass());
            int n = rejectIdFieldsSize = entityMeta.getRejectIdFieldArray() == null ? 0 : entityMeta.getRejectIdFieldArray().length;
            if (paramsNamed == null || paramsNamed.length == 0) {
                String[] fieldsArray = entityMeta.getFieldsArray();
                Object[] fieldValues = BeanUtil.reflectBeanToAry((Object)entity, fieldsArray);
                ArrayList<Object> paramValueList = new ArrayList<Object>();
                ArrayList<String> paramNames = new ArrayList<String>();
                boolean hasNoPkField = false;
                for (int i = 0; i < fieldValues.length; ++i) {
                    if (null == fieldValues[i]) continue;
                    if (i < rejectIdFieldsSize) {
                        hasNoPkField = true;
                    }
                    if (i >= rejectIdFieldsSize && hasNoPkField) break;
                    paramNames.add(fieldsArray[i]);
                    paramValueList.add(fieldValues[i]);
                }
                paramValues = paramValueList.toArray();
                realParamNamed = paramNames.toArray(new String[paramNames.size()]);
            } else {
                realParamNamed = paramsNamed;
                paramValues = BeanUtil.reflectBeanToAry((Object)entity, paramsNamed);
            }
            String queryStr = uniqueSqlHandler.process(entityMeta, realParamNamed, tableName, 2);
            SqlToyResult sqlToyResult = SqlConfigParseUtils.processSql(queryStr, realParamNamed, paramValues);
            SqlToyConfig sqlToyConfig = new SqlToyConfig(DataSourceUtils.getDialect(dbType));
            sqlToyConfig.setSqlType(SqlType.search);
            sqlToyConfig.setSql(queryStr);
            sqlToyConfig.setParamsName(realParamNamed);
            sqlToyResult = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, OperateType.unique, sqlToyResult, entity.getClass(), dbType);
            SqlExecuteStat.showSql("\u552f\u4e00\u6027\u9a8c\u8bc1", sqlToyResult.getSql(), sqlToyResult.getParamsValue());
            List result = SqlUtil.findByJdbcQuery(sqlToyContext.getTypeHandler(), sqlToyResult.getSql(), sqlToyResult.getParamsValue(), null, null, null, conn, dbType, false, null, -1, -1);
            SqlExecuteStat.debug("\u552f\u4e00\u6027\u6761\u4ef6\u7ed3\u679c", "\u8bb0\u5f55\u6570\u91cf:{}", result.size());
            if (result.size() == 0) {
                return true;
            }
            if (result.size() > 1) {
                return false;
            }
            if (null == entityMeta.getIdArray()) {
                return false;
            }
            boolean allPK = false;
            if (realParamNamed.length == entityMeta.getIdArray().length) {
                allPK = true;
                for (String field : realParamNamed) {
                    if (entityMeta.getFieldMeta(field).isPK()) continue;
                    allPK = false;
                    break;
                }
            }
            if (allPK) {
                return false;
            }
            Object[] idValues = BeanUtil.reflectBeanToAry((Object)entity, entityMeta.getIdArray());
            List compareValues = (List)result.get(0);
            boolean isEqual = true;
            int n2 = idValues.length;
            for (int i = 0; i < n2; ++i) {
                if (null != idValues[i] && null != compareValues.get(i + 1) && idValues[i].toString().equals(compareValues.get(i + 1).toString())) continue;
                isEqual = false;
                break;
            }
            return isEqual;
        }
        catch (Exception e) {
            logger.error("\u6267\u884c\u552f\u4e00\u6027\u67e5\u8be2\u5931\u8d25:{}", (Object)e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isComplexPageQuery(String queryStr) {
        String tmpQuery = SqlUtil.clearMistyChars(queryStr.toLowerCase(), " ");
        boolean isComplexQuery = SqlUtil.hasUnion(tmpQuery, false);
        if (!isComplexQuery) {
            String tmpColumn;
            String fromLastStr;
            int fromIndex = SqlUtil.getSymMarkIndexExcludeKeyWords(tmpQuery, SELECT_REGEX, FROM_REGEX, 0);
            int fromWhereIndex = SqlUtil.getSymMarkIndexExcludeKeyWords(tmpQuery, FROM_REGEX, WHERE_REGEX, fromIndex < 1 ? 0 : fromIndex - 1);
            String string = fromLastStr = fromWhereIndex == -1 ? tmpQuery.substring(fromIndex) : tmpQuery.substring(fromIndex, fromWhereIndex);
            if (fromLastStr.indexOf(",") != -1 || fromLastStr.indexOf(" join ") != -1 || fromLastStr.indexOf("(") != -1) {
                isComplexQuery = true;
            }
            if (!(isComplexQuery || (tmpColumn = tmpQuery.substring(0, fromIndex)).indexOf(" top ") == -1 && tmpColumn.indexOf(" distinct ") == -1)) {
                isComplexQuery = true;
            }
        }
        return isComplexQuery;
    }

    public static boolean hasOrderByOrUnion(String sql) {
        String unDisturbSql = DialectUtils.clearDisturbSql(sql);
        return StringUtil.matches(unDisturbSql, UNION_PATTERN) || StringUtil.matches(unDisturbSql, ORDER_BY_PATTERN);
    }

    public static String clearDisturbSql(String sql) {
        int symMarkEnd;
        StringBuilder lastSql = new StringBuilder(sql);
        int fromIndex = StringUtil.getSymMarkMatchIndex(SELECT_REGEX, FROM_REGEX, sql.toLowerCase(), 0);
        if (fromIndex != -1) {
            lastSql.delete(0, fromIndex);
        }
        int start = lastSql.indexOf("(");
        while (start != -1 && (symMarkEnd = StringUtil.getSymMarkIndex("(", ")", lastSql.toString(), start)) != -1) {
            lastSql.delete(start, symMarkEnd + 1);
            start = lastSql.indexOf("(");
        }
        return lastSql.toString();
    }

    private static String clearSymSelectFromSql(String sql) {
        int symMarkEnd;
        String realSql = sql.toLowerCase();
        StringBuilder lastSql = new StringBuilder(realSql);
        String SELECT_REGEX = "\\Wselect\\s+";
        String FROM_REGEX = "\\sfrom[\\(|\\s+]";
        int start = StringUtil.matchIndex(realSql, SELECT_REGEX);
        while (start != -1 && (symMarkEnd = StringUtil.getSymMarkMatchIndex(SELECT_REGEX, FROM_REGEX, lastSql.toString(), start)) != -1) {
            lastSql.delete(start + 1, symMarkEnd + 5);
            start = StringUtil.matchIndex(lastSql.toString(), SELECT_REGEX);
        }
        return lastSql.toString();
    }

    public static StoreResult executeStore(final SqlToyConfig sqlToyConfig, final SqlToyContext sqlToyContext, final String storeSql, final Object[] inParamValues, final Integer[] outParamTypes, final boolean moreResult, final Connection conn, final Integer dbType, final int fetchSize) throws Exception {
        CallableStatement callStat = null;
        ResultSet rs = null;
        return (StoreResult)SqlUtil.callableStatementProcess(null, callStat, rs, new CallableStatementResultHandler(){

            @Override
            public void execute(Object obj, CallableStatement callStat, ResultSet rs) throws Exception {
                try {
                    boolean hasResult;
                    int outCount;
                    boolean isFirstResult;
                    callStat = conn.prepareCall(storeSql);
                    if (fetchSize > 0) {
                        callStat.setFetchSize(fetchSize);
                    }
                    int addIndex = (isFirstResult = StringUtil.matches(storeSql, STORE_PATTERN)) ? 1 : 0;
                    SqlUtil.setParamsValue(sqlToyContext.getTypeHandler(), conn, dbType, callStat, inParamValues, null, addIndex);
                    int inCount = inParamValues == null ? 0 : inParamValues.length;
                    int n = outCount = outParamTypes == null ? 0 : outParamTypes.length;
                    if (outCount != 0) {
                        if (isFirstResult) {
                            callStat.registerOutParameter(1, (int)outParamTypes[0]);
                        }
                        for (int i = addIndex; i < outCount; ++i) {
                            callStat.registerOutParameter(i + inCount + 1, (int)outParamTypes[i]);
                        }
                    }
                    StoreResult storeResult = new StoreResult();
                    if (moreResult) {
                        hasResult = callStat.execute();
                        ArrayList<String[]> labelsList = new ArrayList<String[]>();
                        ArrayList<String[]> labelTypesList = new ArrayList<String[]>();
                        ArrayList dataSets = new ArrayList();
                        int meter = 0;
                        SqlToyConfig notFirstConfig = new SqlToyConfig(sqlToyConfig.getId(), sqlToyConfig.getSql());
                        while (hasResult) {
                            rs = callStat.getResultSet();
                            if (rs != null) {
                                QueryResult tempResult = ResultUtils.processResultSet(sqlToyContext, meter == 0 ? sqlToyConfig : notFirstConfig, conn, rs, null, null, null, 0);
                                labelsList.add(tempResult.getLabelNames());
                                labelTypesList.add(tempResult.getLabelTypes());
                                dataSets.add(tempResult.getRows());
                                ++meter;
                            }
                            hasResult = callStat.getMoreResults();
                        }
                        storeResult.setLabelsList(labelsList);
                        storeResult.setLabelTypesList(labelTypesList);
                        List[] moreResults = new List[dataSets.size()];
                        dataSets.toArray(moreResults);
                        storeResult.setMoreResults(moreResults);
                        if (dataSets.size() > 0) {
                            storeResult.setLabelNames((String[])labelsList.get(0));
                            storeResult.setLabelTypes((String[])labelTypesList.get(0));
                            storeResult.setRows((List)dataSets.get(0));
                        }
                    } else {
                        hasResult = callStat.execute();
                        if (hasResult && (rs = callStat.getResultSet()) != null) {
                            QueryResult tempResult = ResultUtils.processResultSet(sqlToyContext, sqlToyConfig, conn, rs, null, null, null, 0);
                            storeResult.setLabelNames(tempResult.getLabelNames());
                            storeResult.setLabelTypes(tempResult.getLabelTypes());
                            storeResult.setRows(tempResult.getRows());
                        }
                    }
                    if (outCount != 0) {
                        Object[] outParams = new Object[outCount];
                        if (isFirstResult) {
                            outParams[0] = callStat.getObject(1);
                        }
                        for (int i = addIndex; i < outCount; ++i) {
                            outParams[i] = callStat.getObject(i + inCount + 1);
                        }
                        storeResult.setOutResult(outParams);
                    }
                    storeResult.setUpdateCount(Long.valueOf(callStat.getUpdateCount()));
                    this.setResult(storeResult);
                }
                catch (Exception e) {
                    throw e;
                }
                finally {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (callStat != null) {
                        callStat.close();
                        callStat = null;
                    }
                }
            }
        });
    }

    public static ReflectPropsHandler getAddReflectHandler(EntityMeta entityMeta, final ReflectPropsHandler preHandler, IUnifyFieldsHandler unifyFieldsHandler) {
        Map<String, Object> keyValues;
        DataVersionConfig versionConfig;
        DataVersionConfig dataVersionConfig = versionConfig = entityMeta == null ? null : entityMeta.getDataVersion();
        if (unifyFieldsHandler == null && versionConfig == null) {
            return preHandler;
        }
        Map<String, Object> map = keyValues = unifyFieldsHandler == null ? null : unifyFieldsHandler.createUnifyFields();
        if ((keyValues == null || keyValues.isEmpty()) && versionConfig == null) {
            return preHandler;
        }
        Integer dataVersion = 1;
        if (versionConfig != null && versionConfig.isStartDate()) {
            dataVersion = Integer.valueOf(DateUtil.formatDate(DateUtil.getNowTime(), "yyyyMMdd") + 1);
        }
        IgnoreCaseSet tmpSet = unifyFieldsHandler == null ? null : unifyFieldsHandler.forceUpdateFields();
        final IgnoreCaseSet forceUpdateFields = !SqlToyThreadDataHolder.useUnifyFields() || tmpSet == null ? new IgnoreCaseSet() : tmpSet;
        final Integer realVersion = dataVersion;
        ReflectPropsHandler handler = new ReflectPropsHandler(){

            @Override
            public void process() {
                if (preHandler != null) {
                    preHandler.setPropertyIndexMap(this.getPropertyIndexMap());
                    preHandler.setRowIndex(this.getRowIndex());
                    preHandler.setRowData(this.getRowData());
                    preHandler.process();
                }
                if (keyValues != null) {
                    for (Map.Entry entry : keyValues.entrySet()) {
                        if (!StringUtil.isBlank(this.getValue((String)entry.getKey())) && !forceUpdateFields.contains(entry.getKey())) continue;
                        this.setValue((String)entry.getKey(), entry.getValue());
                    }
                }
                if (versionConfig != null) {
                    this.setValue(versionConfig.getField(), realVersion);
                }
            }
        };
        return handler;
    }

    public static ReflectPropsHandler getUpdateReflectHandler(final ReflectPropsHandler preHandler, String[] forceUpdateProps, IUnifyFieldsHandler unifyFieldsHandler) {
        IgnoreCaseSet tmpSet;
        if (unifyFieldsHandler == null || !SqlToyThreadDataHolder.useUnifyFields()) {
            return preHandler;
        }
        final Map<String, Object> keyValues = unifyFieldsHandler.updateUnifyFields();
        if (keyValues == null || keyValues.isEmpty()) {
            return preHandler;
        }
        final HashSet<String> forceSet = new HashSet<String>();
        if (forceUpdateProps != null && forceUpdateProps.length > 0) {
            for (String field : forceUpdateProps) {
                forceSet.add(field.toLowerCase().replace("_", ""));
            }
        }
        final IgnoreCaseSet forceUpdateFields = (tmpSet = unifyFieldsHandler.forceUpdateFields()) == null ? new IgnoreCaseSet() : tmpSet;
        ReflectPropsHandler handler = new ReflectPropsHandler(){

            @Override
            public void process() {
                if (preHandler != null) {
                    preHandler.setPropertyIndexMap(this.getPropertyIndexMap());
                    preHandler.setRowIndex(this.getRowIndex());
                    preHandler.setRowData(this.getRowData());
                    preHandler.process();
                }
                for (Map.Entry entry : keyValues.entrySet()) {
                    if (forceSet.contains(((String)entry.getKey()).toLowerCase()) || !StringUtil.isBlank(this.getValue((String)entry.getKey())) && !forceUpdateFields.contains(entry.getKey())) continue;
                    this.setValue((String)entry.getKey(), entry.getValue());
                }
            }
        };
        return handler;
    }

    public static ReflectPropsHandler getSecureReflectHandler(final ReflectPropsHandler preHandler, final FieldsSecureProvider fieldsSecureProvider, final DesensitizeProvider desensitizeProvider, final List<FieldSecureConfig> secureFields) {
        if (fieldsSecureProvider == null || secureFields == null || secureFields.isEmpty()) {
            return preHandler;
        }
        ReflectPropsHandler handler = new ReflectPropsHandler(){

            @Override
            public void process() {
                if (preHandler != null) {
                    preHandler.setPropertyIndexMap(this.getPropertyIndexMap());
                    preHandler.setRowIndex(this.getRowIndex());
                    preHandler.setRowData(this.getRowData());
                    preHandler.process();
                }
                HashSet<String> secureColumns = new HashSet<String>();
                for (FieldSecureConfig config : secureFields) {
                    if (!SecureType.ENCRYPT.equals((Object)config.getSecureType())) continue;
                    secureColumns.add(config.getField());
                }
                for (FieldSecureConfig config : secureFields) {
                    String contents;
                    String field = config.getField();
                    String sourceField = config.getSourceField();
                    Object value = StringUtil.isNotBlank(sourceField) ? this.getValue(sourceField) : this.getValue(field);
                    if (value == null || "".equals(contents = value.toString())) continue;
                    if (SecureType.ENCRYPT.equals((Object)config.getSecureType())) {
                        this.setValue(field, fieldsSecureProvider.encrypt(contents));
                        continue;
                    }
                    if (secureColumns.contains(field)) continue;
                    this.setValue(field, desensitizeProvider.desensitize(contents, config.getMask()));
                }
            }
        };
        return handler;
    }

    public static ReflectPropsHandler getSaveOrUpdateReflectHandler(final String[] idFields, final ReflectPropsHandler prepHandler, String[] forceUpdateProps, IUnifyFieldsHandler unifyFieldsHandler) {
        IgnoreCaseSet tmpSet;
        Map<String, Object> updateKeyValues;
        if (unifyFieldsHandler == null) {
            return prepHandler;
        }
        final Map<String, Object> addKeyValues = unifyFieldsHandler.createUnifyFields();
        Map<String, Object> map = updateKeyValues = SqlToyThreadDataHolder.useUnifyFields() ? unifyFieldsHandler.updateUnifyFields() : null;
        if ((addKeyValues == null || addKeyValues.isEmpty()) && (updateKeyValues == null || updateKeyValues.isEmpty())) {
            return prepHandler;
        }
        final HashSet<String> forceSet = new HashSet<String>();
        if (forceUpdateProps != null && forceUpdateProps.length > 0) {
            for (String field : forceUpdateProps) {
                forceSet.add(field.toLowerCase().replace("_", ""));
            }
        }
        final IgnoreCaseSet forceUpdateFields = (tmpSet = unifyFieldsHandler.forceUpdateFields()) == null ? new IgnoreCaseSet() : tmpSet;
        final int idLength = idFields == null ? 0 : idFields.length;
        ReflectPropsHandler handler = new ReflectPropsHandler(){

            @Override
            public void process() {
                if (prepHandler != null) {
                    prepHandler.setPropertyIndexMap(this.getPropertyIndexMap());
                    prepHandler.setRowIndex(this.getRowIndex());
                    prepHandler.setRowData(this.getRowData());
                    prepHandler.process();
                }
                if (idLength > 0 && this.getValue(idFields[0]) == null && addKeyValues != null) {
                    for (Map.Entry entry : addKeyValues.entrySet()) {
                        if (!StringUtil.isBlank(this.getValue((String)entry.getKey()))) continue;
                        this.setValue((String)entry.getKey(), entry.getValue());
                    }
                }
                if (updateKeyValues != null) {
                    for (Map.Entry entry : updateKeyValues.entrySet()) {
                        if (forceSet.contains(((String)entry.getKey()).toLowerCase()) || !StringUtil.isBlank(this.getValue((String)entry.getKey())) && !forceUpdateFields.contains(entry.getKey())) continue;
                        this.setValue((String)entry.getKey(), entry.getValue());
                    }
                }
            }
        };
        return handler;
    }

    public static int getParamsCount(String queryStr) {
        if (StringUtil.isBlank(queryStr)) {
            return 0;
        }
        String sql = SqlConfigParseUtils.clearDblQuestMark(queryStr);
        if (sql.indexOf("?") == -1) {
            return StringUtil.matchCnt(sql, SqlToyConstants.SQL_NAMED_PATTERN, 1);
        }
        return StringUtil.matchCnt(sql, "\\?");
    }

    public static boolean isEmptyPK(SqlToyContext sqlToyContext, Serializable entity) {
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entity.getClass());
        if (entityMeta.getIdArray() != null && entityMeta.getIdArray().length > 0) {
            Object[] idValues;
            for (Object obj : idValues = BeanUtil.reflectBeanToAry((Object)entity, entityMeta.getIdArray())) {
                if (null != obj) continue;
                return true;
            }
        }
        return false;
    }

    public static ReflectPropsHandler wrapReflectWithUnifyFields(String sql, ReflectPropsHandler reflectPropsHandler, IUnifyFieldsHandler unifyFieldsHandler) {
        if (reflectPropsHandler == null && unifyFieldsHandler == null || StringUtil.isBlank(sql)) {
            return null;
        }
        ReflectPropsHandler result = null;
        if (StringUtil.matches(sql.trim(), "(?i)^insert\\s+into\\W")) {
            result = DialectUtils.getAddReflectHandler(null, reflectPropsHandler, unifyFieldsHandler);
        } else if (StringUtil.matches(sql.trim(), "(?i)^update\\s+") || StringUtil.matches(sql.trim(), "(?i)^merge\\s+into\\W") || StringUtil.matches(sql.trim(), "(?i)^replace\\s+into\\W")) {
            result = DialectUtils.getUpdateReflectHandler(reflectPropsHandler, null, unifyFieldsHandler);
        }
        return result;
    }

    public static SqlToyResult doInterceptors(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, OperateType operateType, SqlToyResult sqlToyResult, Class entityClass, Integer dbType) {
        if (!sqlToyContext.hasSqlInterceptors()) {
            return sqlToyResult;
        }
        SqlToyResult result = sqlToyResult;
        for (SqlInterceptor interceptor : sqlToyContext.getSqlInterceptors()) {
            result = interceptor.decorate(sqlToyContext, sqlToyConfig, operateType, result, entityClass, dbType);
        }
        return result;
    }

    public static PKStrategy getSavePKStrategy(EntityMeta entityMeta, Serializable entity, Integer dbType) {
        Object id;
        PKStrategy pkStrategy = entityMeta.getIdStrategy();
        if (pkStrategy != null && pkStrategy.equals((Object)PKStrategy.SEQUENCE) && StringUtil.isNotBlank(id = BeanUtil.getProperty(entity, entityMeta.getIdArray()[0]))) {
            pkStrategy = PKStrategy.ASSIGN;
        }
        return pkStrategy;
    }
}

