/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.dialect.utils;

import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import org.sagacity.sqltoy.SqlToyConstants;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.callback.DecryptHandler;
import org.sagacity.sqltoy.callback.GenerateSavePKStrategy;
import org.sagacity.sqltoy.callback.GenerateSqlHandler;
import org.sagacity.sqltoy.callback.ReflectPropsHandler;
import org.sagacity.sqltoy.config.model.EntityMeta;
import org.sagacity.sqltoy.config.model.FieldMeta;
import org.sagacity.sqltoy.config.model.OperateType;
import org.sagacity.sqltoy.config.model.PKStrategy;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.config.model.SqlToyResult;
import org.sagacity.sqltoy.dialect.model.SavePKStrategy;
import org.sagacity.sqltoy.dialect.utils.DialectExtUtils;
import org.sagacity.sqltoy.dialect.utils.DialectUtils;
import org.sagacity.sqltoy.model.QueryExecutor;
import org.sagacity.sqltoy.model.QueryResult;
import org.sagacity.sqltoy.model.inner.QueryExecutorExtend;
import org.sagacity.sqltoy.utils.SqlUtilsExt;
import org.sagacity.sqltoy.utils.StringUtil;

public class PostgreSqlDialectUtils {
    public static final String NVL_FUNCTION = "COALESCE";

    public static QueryResult getRandomResult(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, QueryExecutor queryExecutor, DecryptHandler decryptHandler, Long totalCount, Long randomCount, Connection conn, Integer dbType, String dialect, int fetchSize, int maxRows) throws Exception {
        StringBuilder sql = new StringBuilder();
        String innerSql = sqlToyConfig.isHasFast() ? sqlToyConfig.getFastSql(dialect) : sqlToyConfig.getSql(dialect);
        boolean hasOrderOrUnion = DialectUtils.hasOrderByOrUnion(innerSql);
        innerSql = SqlUtilsExt.markOriginalSql(innerSql);
        if (sqlToyConfig.isHasFast()) {
            sql.append(sqlToyConfig.getFastPreSql(dialect));
            if (!sqlToyConfig.isIgnoreBracket()) {
                sql.append(" (");
            }
        }
        if (hasOrderOrUnion) {
            sql.append("select " + SqlToyConstants.INTERMEDIATE_TABLE + ".* from (");
        }
        sql.append(innerSql);
        if (hasOrderOrUnion) {
            sql.append(") ");
            sql.append(SqlToyConstants.INTERMEDIATE_TABLE);
            sql.append(" ");
        }
        sql.append(" order by random() limit ");
        sql.append(randomCount);
        if (sqlToyConfig.isHasFast()) {
            if (!sqlToyConfig.isIgnoreBracket()) {
                sql.append(") ");
            }
            sql.append(sqlToyConfig.getFastTailSql(dialect));
        }
        SqlToyResult queryParam = DialectUtils.wrapPageSqlParams(sqlToyContext, sqlToyConfig, queryExecutor, sql.toString(), null, null, dialect);
        QueryExecutorExtend extend = queryExecutor.getInnerModel();
        queryParam = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, extend.entityClass == null ? OperateType.random : OperateType.singleTable, queryParam, extend.entityClass, dbType);
        return DialectUtils.findBySql(sqlToyContext, sqlToyConfig, queryParam.getSql(), queryParam.getParamsValue(), extend, decryptHandler, conn, dbType, 0, fetchSize, maxRows);
    }

    public static Object save(final SqlToyContext sqlToyContext, Serializable entity, Connection conn, final Integer dbType, String tableName) throws Exception {
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entity.getClass());
        String sequence = "nextval('" + entityMeta.getSequence() + "')";
        PKStrategy pkStrategy = DialectUtils.getSavePKStrategy(entityMeta, entity, dbType);
        boolean isAssignPK = PostgreSqlDialectUtils.isAssignPKValue(pkStrategy);
        String insertSql = DialectExtUtils.generateInsertSql(sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, pkStrategy, NVL_FUNCTION, sequence, isAssignPK, tableName);
        return DialectUtils.save(sqlToyContext, entityMeta, pkStrategy, isAssignPK, insertSql, entity, new GenerateSqlHandler(){

            @Override
            public String generateSql(EntityMeta entityMeta, String[] forceUpdateField) {
                PKStrategy pkStrategy = entityMeta.getIdStrategy();
                String sequence = "nextval('" + entityMeta.getSequence() + "')";
                return DialectExtUtils.generateInsertSql(sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, pkStrategy, PostgreSqlDialectUtils.NVL_FUNCTION, sequence, PostgreSqlDialectUtils.isAssignPKValue(pkStrategy), null);
            }
        }, new GenerateSavePKStrategy(){

            @Override
            public SavePKStrategy generate(EntityMeta entityMeta) {
                return new SavePKStrategy(entityMeta.getIdStrategy(), PostgreSqlDialectUtils.isAssignPKValue(entityMeta.getIdStrategy()));
            }
        }, conn, dbType);
    }

    public static Long saveAll(SqlToyContext sqlToyContext, List<?> entities, int batchSize, ReflectPropsHandler reflectPropsHandler, Connection conn, Integer dbType, Boolean autoCommit, String tableName) throws Exception {
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entities.get(0).getClass());
        PKStrategy pkStrategy = entityMeta.getIdStrategy();
        String sequence = "nextval('" + entityMeta.getSequence() + "')";
        boolean isAssignPK = PostgreSqlDialectUtils.isAssignPKValue(pkStrategy);
        String insertSql = DialectExtUtils.generateInsertSql(sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, pkStrategy, NVL_FUNCTION, sequence, isAssignPK, tableName);
        return DialectUtils.saveAll(sqlToyContext, entityMeta, pkStrategy, isAssignPK, insertSql, entities, batchSize, reflectPropsHandler, conn, dbType, autoCommit);
    }

    public static Long saveOrUpdateAll(final SqlToyContext sqlToyContext, List<?> entities, int batchSize, ReflectPropsHandler reflectPropsHandler, String[] forceUpdateFields, Connection conn, final Integer dbType, String dialect, Boolean autoCommit, final String tableName) throws Exception {
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entities.get(0).getClass());
        return DialectUtils.saveOrUpdateAll(sqlToyContext, entities, batchSize, entityMeta, forceUpdateFields, new GenerateSqlHandler(){

            @Override
            public String generateSql(EntityMeta entityMeta, String[] forceUpdateFields) {
                PKStrategy pkStrategy = entityMeta.getIdStrategy();
                String sequence = "nextval('" + entityMeta.getSequence() + "')";
                return DialectUtils.getSaveOrUpdateSql(sqlToyContext, sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, pkStrategy, forceUpdateFields, null, PostgreSqlDialectUtils.NVL_FUNCTION, sequence, PostgreSqlDialectUtils.isAssignPKValue(pkStrategy), tableName);
            }
        }, reflectPropsHandler, conn, dbType, autoCommit);
    }

    public static void wrapSelectFields(StringBuilder sql, String columnName, FieldMeta fieldMeta) {
        int jdbcType = fieldMeta.getType();
        if (jdbcType == 12) {
            sql.append("?");
        } else if (jdbcType == 1) {
            sql.append("?");
        } else if (jdbcType == 91) {
            sql.append("cast(? as date)");
        } else if (jdbcType == 2) {
            sql.append("cast(? as numeric)");
        } else if (jdbcType == 3) {
            sql.append("cast(? as decimal)");
        } else if (jdbcType == -5) {
            sql.append("cast(? as bigint)");
        } else if (jdbcType == 4 || jdbcType == -6) {
            sql.append("cast(? as integer)");
        } else if (jdbcType == 93) {
            sql.append("cast(? as timestamp)");
        } else if (jdbcType == 8) {
            sql.append("cast(? as double)");
        } else if (jdbcType == 6) {
            sql.append("cast(? as double)");
        } else if (jdbcType == 92) {
            sql.append("cast(? as time)");
        } else if (jdbcType == 2005) {
            sql.append("cast(? as text)");
        } else if (jdbcType == 16) {
            sql.append("cast(? as boolean)");
        } else if (jdbcType == -2) {
            sql.append("cast(? as bytea)");
        } else if (jdbcType == 2004) {
            sql.append("cast(? as bytea)");
        } else if (StringUtil.isNotBlank(fieldMeta.getNativeType())) {
            sql.append("cast(? as " + fieldMeta.getNativeType() + ")");
        } else {
            sql.append("?");
        }
        sql.append(" as ");
        sql.append(columnName);
    }

    public static boolean isAssignPKValue(PKStrategy pkStrategy) {
        if (pkStrategy == null) {
            return true;
        }
        return !pkStrategy.equals((Object)PKStrategy.IDENTITY);
    }
}

