/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.link;

import java.io.Serializable;
import java.util.List;
import javax.sql.DataSource;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.link.BaseLink;
import org.sagacity.sqltoy.model.LockMode;
import org.sagacity.sqltoy.model.ParallelConfig;

public class Load
extends BaseLink {
    private static final long serialVersionUID = 9187056738357750608L;
    private LockMode lockMode;
    private Class<?>[] cascadeTypes;
    private boolean cascadeAll = false;
    private boolean onlyCascade = false;
    private ParallelConfig parallelConfig;

    public Load parallelConfig(ParallelConfig parallelConfig) {
        this.parallelConfig = parallelConfig;
        return this;
    }

    public Load(SqlToyContext sqlToyContext, DataSource dataSource) {
        super(sqlToyContext, dataSource);
    }

    public Load dataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.defaultDataSource = false;
        return this;
    }

    public Load cascade(Class<?> ... cascadeTypes) {
        this.cascadeTypes = cascadeTypes;
        return this;
    }

    public Load cascadeAll() {
        this.cascadeAll = true;
        return this;
    }

    public Load lock(LockMode lockMode) {
        this.lockMode = lockMode;
        return this;
    }

    public Load onlyCascade() {
        this.onlyCascade = true;
        return this;
    }

    public <T extends Serializable> T one(T entity) {
        if (entity == null) {
            throw new IllegalArgumentException("load entity is null!");
        }
        if ((this.cascadeTypes == null || this.cascadeTypes.length == 0) && (this.cascadeAll || this.onlyCascade)) {
            this.cascadeTypes = this.sqlToyContext.getEntityMeta(entity.getClass()).getCascadeTypes();
        }
        return this.dialectFactory.load(this.sqlToyContext, entity, this.onlyCascade, this.cascadeTypes, this.lockMode, this.getDataSource(null));
    }

    public <T extends Serializable> List<T> many(List<T> entities) {
        if (entities == null || entities.isEmpty()) {
            throw new IllegalArgumentException("loadAll entities is null or empty!");
        }
        if ((this.cascadeTypes == null || this.cascadeTypes.length == 0) && (this.cascadeAll || this.onlyCascade)) {
            this.cascadeTypes = this.sqlToyContext.getEntityMeta(((Serializable)entities.get(0)).getClass()).getCascadeTypes();
        }
        return this.dialectFactory.loadAll(this.sqlToyContext, entities, this.onlyCascade, this.cascadeTypes, this.lockMode, this.parallelConfig, this.getDataSource(null));
    }
}

