/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.link;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.link.BaseLink;
import org.sagacity.sqltoy.model.ParallelConfig;
import org.sagacity.sqltoy.model.SaveMode;

public class Save
extends BaseLink {
    private static final long serialVersionUID = 3086927739096637361L;
    private SaveMode saveMode = SaveMode.APPEND;
    private Boolean autoCommit = null;
    private String[] forceUpdateProps;
    private boolean deeply = false;
    private int batchSize = 0;
    private ParallelConfig parallelConfig;

    public Save parallelConfig(ParallelConfig parallelConfig) {
        this.parallelConfig = parallelConfig;
        return this;
    }

    public Save deeply(boolean deeply) {
        this.deeply = deeply;
        return this;
    }

    public Save(SqlToyContext sqlToyContext, DataSource dataSource) {
        super(sqlToyContext, dataSource);
    }

    public Save forceUpdateProps(String ... forceUpdateProps) {
        this.forceUpdateProps = forceUpdateProps;
        return this;
    }

    public Save dataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.defaultDataSource = false;
        return this;
    }

    public Save autoCommit(Boolean autoCommit) {
        this.autoCommit = autoCommit;
        return this;
    }

    public Save saveMode(SaveMode saveMode) {
        this.saveMode = saveMode;
        return this;
    }

    public Save batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public Object one(Serializable entity) {
        if (entity == null) {
            throw new IllegalArgumentException("save entity is null!");
        }
        if (this.saveMode == SaveMode.APPEND) {
            return this.dialectFactory.save(this.sqlToyContext, entity, this.getDataSource(null));
        }
        if (this.saveMode == SaveMode.UPDATE) {
            if (this.deeply) {
                this.forceUpdateProps = this.sqlToyContext.getEntityMeta(entity.getClass()).getRejectIdFieldArray();
            }
            return this.dialectFactory.saveOrUpdate(this.sqlToyContext, entity, this.forceUpdateProps, this.getDataSource(null));
        }
        if (this.saveMode == SaveMode.IGNORE) {
            ArrayList<Serializable> entities = new ArrayList<Serializable>();
            entities.add(entity);
            return this.dialectFactory.saveAllIgnoreExist(this.sqlToyContext, entities, 1, null, null, this.getDataSource(null), null);
        }
        return null;
    }

    public <T extends Serializable> Long many(List<T> entities) {
        int realBatchSize;
        if (entities == null || entities.isEmpty()) {
            throw new IllegalArgumentException("saveAll entities is null or empty!");
        }
        int n = realBatchSize = this.batchSize > 0 ? this.batchSize : this.sqlToyContext.getBatchSize();
        if (this.saveMode == SaveMode.IGNORE) {
            return this.dialectFactory.saveAllIgnoreExist(this.sqlToyContext, entities, realBatchSize, null, this.parallelConfig, this.getDataSource(null), this.autoCommit);
        }
        if (this.saveMode == SaveMode.UPDATE) {
            if (this.deeply) {
                this.forceUpdateProps = this.sqlToyContext.getEntityMeta(((Serializable)entities.get(0)).getClass()).getRejectIdFieldArray();
            }
            return this.dialectFactory.saveOrUpdateAll(this.sqlToyContext, entities, realBatchSize, this.forceUpdateProps, null, this.parallelConfig, this.getDataSource(null), this.autoCommit);
        }
        return this.dialectFactory.saveAll(this.sqlToyContext, entities, realBatchSize, null, this.parallelConfig, this.getDataSource(null), this.autoCommit);
    }
}

