/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import javax.sql.DataSource;
import org.sagacity.sqltoy.config.model.PageOptimize;
import org.sagacity.sqltoy.config.model.SecureMask;
import org.sagacity.sqltoy.config.model.ShardingStrategyConfig;
import org.sagacity.sqltoy.config.model.Translate;
import org.sagacity.sqltoy.model.IgnoreKeyCaseMap;
import org.sagacity.sqltoy.model.LockMode;
import org.sagacity.sqltoy.model.MaskType;
import org.sagacity.sqltoy.model.ParamsFilter;
import org.sagacity.sqltoy.model.inner.EntityQueryExtend;
import org.sagacity.sqltoy.model.inner.TranslateExtend;
import org.sagacity.sqltoy.utils.CollectionUtil;
import org.sagacity.sqltoy.utils.StringUtil;

public class EntityQuery
implements Serializable {
    private static final long serialVersionUID = 5223170071884950204L;
    private EntityQueryExtend innerModel = new EntityQueryExtend();

    public static EntityQuery create() {
        return new EntityQuery();
    }

    public EntityQuery select(String ... fields) {
        if (fields != null && fields.length > 0) {
            this.innerModel.fields = fields.length == 1 ? StringUtil.trimArray(fields[0].split("\\,")) : fields;
            this.innerModel.notSelectFields = null;
        }
        return this;
    }

    public EntityQuery fetchSize(int fetchSize) {
        this.innerModel.fetchSize = fetchSize;
        return this;
    }

    @Deprecated
    public EntityQuery maxRows(int maxRows) {
        this.innerModel.maxRows = maxRows;
        return this;
    }

    public EntityQuery distinct() {
        this.innerModel.distinct = true;
        return this;
    }

    public EntityQuery unselect(String ... fields) {
        if (fields != null && fields.length > 0) {
            String[] realFields = fields.length == 1 ? fields[0].split("\\,") : fields;
            HashSet<String> notFields = new HashSet<String>();
            for (String field : realFields) {
                notFields.add(field.trim().replace("_", "").toLowerCase());
            }
            this.innerModel.notSelectFields = notFields;
            this.innerModel.fields = null;
        }
        return this;
    }

    public EntityQuery where(String where) {
        this.innerModel.where = where;
        return this;
    }

    public EntityQuery names(String ... names) {
        this.innerModel.names = names;
        return this;
    }

    public EntityQuery values(Object ... values) {
        this.innerModel.values = values != null && values.length == 1 && values[0] != null && values[0] instanceof Map ? new Object[]{new IgnoreKeyCaseMap((Map)values[0])} : values;
        return this;
    }

    @Deprecated
    public EntityQuery paramsMap(Map<String, Object> paramsMap) {
        this.innerModel.values = new Object[]{new IgnoreKeyCaseMap<String, Object>(paramsMap)};
        return this;
    }

    public EntityQuery blankNotNull() {
        this.innerModel.blankToNull = false;
        return this;
    }

    public EntityQuery orderBy(String ... fields) {
        if (fields != null && fields.length > 0) {
            String[] realFields = fields.length == 1 ? fields[0].split("\\,") : fields;
            for (String field : realFields) {
                this.innerModel.orderBy.put(field.trim(), " ");
            }
        }
        return this;
    }

    public EntityQuery orderByDesc(String ... fields) {
        if (fields != null && fields.length > 0) {
            String[] realFields = fields.length == 1 ? fields[0].split("\\,") : fields;
            for (String field : realFields) {
                this.innerModel.orderBy.put(field.trim(), " desc ");
            }
        }
        return this;
    }

    public EntityQuery groupBy(String ... groups) {
        if (groups != null && groups.length > 0) {
            this.innerModel.groupBy = StringUtil.linkAry(",", true, groups);
        }
        return this;
    }

    public EntityQuery having(String having) {
        this.innerModel.having = having;
        return this;
    }

    public EntityQuery lock(LockMode lockMode) {
        this.innerModel.lockMode = lockMode;
        return this;
    }

    public EntityQuery secureMask(MaskType maskType, String ... columns) {
        if (maskType != null && columns != null && columns.length > 0) {
            for (String column : columns) {
                SecureMask mask = new SecureMask();
                mask.setColumn(column);
                mask.setType(maskType.getValue());
                this.innerModel.secureMask.put(column, mask);
            }
        }
        return this;
    }

    public EntityQuery filters(ParamsFilter ... filters) {
        if (filters != null && filters.length > 0) {
            for (ParamsFilter filter : filters) {
                if (StringUtil.isBlank(filter.getType()) || StringUtil.isBlank(filter.getParams())) {
                    throw new IllegalArgumentException("\u9488\u5bf9EntityQuery\u8bbe\u7f6e\u6761\u4ef6\u8fc7\u6ee4\u5fc5\u987b\u8981\u8bbe\u7f6efilterParams=[" + filter.getParams() + "],\u548cfilterType=[" + filter.getType() + "]!");
                }
                if (CollectionUtil.any((Object)filter.getType(), "eq", "neq", "gt", "gte", "lt", "lte", "between") && StringUtil.isBlank(filter.getValue())) {
                    throw new IllegalArgumentException("\u9488\u5bf9EntityQuery\u8bbe\u7f6e\u6761\u4ef6\u8fc7\u6ee4eq\u3001neq\u3001gt\u3001gte\u3001lt\u3001lte\u3001between\u7b49\u7c7b\u578b\u5fc5\u987b\u8981\u8bbe\u7f6evalues\u503c!");
                }
                if ("blank".equals(filter.getType())) {
                    this.innerModel.blankToNull = false;
                }
                this.innerModel.paramFilters.add(filter);
            }
        }
        return this;
    }

    public EntityQuery translates(Translate ... translates) {
        if (translates != null && translates.length > 0) {
            for (Translate trans : translates) {
                TranslateExtend extend = trans.getExtend();
                if (StringUtil.isBlank(extend.cache) || StringUtil.isBlank(extend.keyColumn) || StringUtil.isBlank(extend.column)) {
                    throw new IllegalArgumentException("\u9488\u5bf9EntityQuery\u8bbe\u7f6e\u7f13\u5b58\u7ffb\u8bd1\u5fc5\u987b\u8981\u660e\u786e:cacheName=[" + extend.cache + "]\u3001keyColumn=[" + extend.keyColumn + "](\u4f5c\u4e3akey\u7684\u5b57\u6bb5\u5217)\u3001 column=[" + extend.column + "](\u7ffb\u8bd1\u7ed3\u679c\u6620\u5c04\u7684\u5217)!");
                }
                this.innerModel.translates.add(trans);
            }
        }
        return this;
    }

    public EntityQuery dataSource(DataSource dataSource) {
        this.innerModel.dataSource = dataSource;
        return this;
    }

    public EntityQuery pageOptimize(PageOptimize pageOptimize) {
        if (pageOptimize != null) {
            this.innerModel.pageOptimize = pageOptimize;
        }
        return this;
    }

    public EntityQuery top(double topSize) {
        if (topSize <= 0.0) {
            throw new IllegalArgumentException("topSize \u503c\u5fc5\u987b\u8981\u5927\u4e8e0!");
        }
        this.innerModel.pickType = 0;
        this.innerModel.pickSize = topSize;
        return this;
    }

    public EntityQuery random(double randomSize) {
        if (randomSize <= 0.0) {
            throw new IllegalArgumentException("randomSize \u503c\u5fc5\u987b\u8981\u5927\u4e8e0!");
        }
        this.innerModel.pickType = 1;
        this.innerModel.pickSize = randomSize;
        return this;
    }

    public EntityQuery dbSharding(String strategy, String ... paramNames) {
        ShardingStrategyConfig sharding = new ShardingStrategyConfig(0);
        sharding.setStrategy(strategy);
        sharding.setFields(paramNames);
        sharding.setAliasNames(paramNames);
        this.innerModel.dbSharding = sharding;
        return this;
    }

    public EntityQuery tableSharding(String strategy, String ... paramNames) {
        ShardingStrategyConfig sharding = new ShardingStrategyConfig(1);
        sharding.setStrategy(strategy);
        sharding.setFields(paramNames);
        sharding.setAliasNames(paramNames);
        this.innerModel.tableSharding = sharding;
        return this;
    }

    public EntityQuery showSql(Boolean showSql) {
        this.innerModel.showSql = showSql;
        return this;
    }

    public EntityQueryExtend getInnerModel() {
        return this.innerModel;
    }
}

