/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.model;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.Queue;

public class PriorityLimitSizeQueue<T>
implements Queue<T> {
    private Queue<T> queue;
    private int limit = 1000;

    public PriorityLimitSizeQueue(int limit) {
        this.limit = limit;
        this.queue = new PriorityQueue<T>();
    }

    public PriorityLimitSizeQueue(int limit, Comparator<T> comparator) {
        this.limit = limit;
        this.queue = new PriorityQueue<T>(comparator);
    }

    @Override
    public boolean offer(T e) {
        if (this.queue.size() >= this.limit) {
            this.queue.poll();
        }
        return this.queue.offer(e);
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.queue.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.queue.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.queue.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.queue.toArray(a);
    }

    @Override
    public boolean remove(Object o) {
        return this.queue.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.queue.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        if (c == null || c.isEmpty()) {
            return true;
        }
        Iterator<T> iter = c.iterator();
        while (iter.hasNext()) {
            if (this.queue.size() >= this.limit) {
                this.queue.poll();
            }
            this.queue.offer(iter.next());
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.queue.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.queue.retainAll(c);
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    @Override
    public boolean add(T e) {
        if (this.queue.size() >= this.limit) {
            this.queue.poll();
        }
        return this.queue.offer(e);
    }

    @Override
    public T remove() {
        return this.queue.remove();
    }

    @Override
    public T poll() {
        return this.queue.poll();
    }

    @Override
    public T element() {
        return this.queue.element();
    }

    @Override
    public T peek() {
        return this.queue.peek();
    }
}

