/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.plugins.calculator;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.sagacity.sqltoy.config.model.ColsChainRelativeModel;
import org.sagacity.sqltoy.config.model.LabelIndexModel;
import org.sagacity.sqltoy.utils.CollectionUtil;
import org.sagacity.sqltoy.utils.ExpressionUtil;
import org.sagacity.sqltoy.utils.NumberUtil;
import org.sagacity.sqltoy.utils.StringUtil;

public class ColsChainRelative {
    public static void process(ColsChainRelativeModel relativeModel, LabelIndexModel labelIndexMap, List result) {
        Object[] relativeIndexs;
        if (result == null || result.isEmpty()) {
            return;
        }
        int dataSize = result.size();
        int dataWidth = ((List)result.get(0)).size();
        boolean isAppend = relativeModel.isInsert();
        int groupSize = relativeModel.getGroupSize();
        if (groupSize < 1) {
            groupSize = 1;
        }
        if ((relativeIndexs = relativeModel.getRelativeIndexs()) == null || relativeIndexs.length == 0) {
            relativeIndexs = new Integer[groupSize];
            for (int i = 0; i < groupSize; ++i) {
                relativeIndexs[i] = i;
            }
        }
        CollectionUtil.sortArray(relativeIndexs, true);
        int relativeSize = relativeIndexs.length;
        int radixSize = relativeModel.getRadixSize();
        boolean isIncrement = relativeModel.isReduceOne();
        BigDecimal multiply = BigDecimal.valueOf(relativeModel.getMultiply());
        String format = relativeModel.getFormat();
        int start = 0;
        if (StringUtil.isBlank(relativeModel.getStartColumn())) {
            start = 0;
        } else if (NumberUtil.isInteger(relativeModel.getStartColumn())) {
            start = Integer.parseInt(relativeModel.getStartColumn());
        } else if (labelIndexMap.containsKey(relativeModel.getStartColumn())) {
            start = labelIndexMap.get(relativeModel.getStartColumn());
        }
        String endCol = relativeModel.getEndColumn();
        int end = StringUtil.isBlank(endCol) ? dataWidth - 1 : (NumberUtil.isInteger(endCol) ? Integer.parseInt(endCol) : (labelIndexMap.containsKey(endCol) ? labelIndexMap.get(endCol) : (NumberUtil.isInteger(endCol = endCol.replaceAll("result\\.width\\(\\)", Integer.toString(dataWidth)).replaceAll("(?i)\\$\\{dataWidth\\}", Integer.toString(dataWidth))) ? Integer.parseInt(endCol) : new BigDecimal(ExpressionUtil.calculate(endCol).toString()).intValue())));
        if (end < 0) {
            end = dataWidth - 1 + end;
        }
        if (end > dataWidth - 1) {
            end = dataWidth - 1;
        }
        String defaultValue = relativeModel.getDefaultValue();
        for (int i = end; i > start; i -= groupSize) {
            for (int j = 0; j < dataSize; ++j) {
                List rowList = (List)result.get(j);
                for (int k = 0; k < relativeSize; ++k) {
                    int divIndex = i - groupSize + (Integer)relativeIndexs[k] + 1;
                    int divedIndex = i - 2 * groupSize + (Integer)relativeIndexs[k] + 1;
                    if (i - groupSize <= start) {
                        if (isAppend) {
                            rowList.add(divIndex + 1, defaultValue);
                            continue;
                        }
                        rowList.set(divIndex + 1, defaultValue);
                        continue;
                    }
                    BigDecimal divData = BigDecimal.ZERO;
                    BigDecimal divedData = BigDecimal.ZERO;
                    if (rowList.get(divIndex) != null) {
                        divData = new BigDecimal(rowList.get(divIndex).toString());
                    }
                    if (rowList.get(divedIndex) != null) {
                        divedData = new BigDecimal(rowList.get(divedIndex).toString());
                    }
                    if (divedData.compareTo(BigDecimal.ZERO) == 0) {
                        boolean divIsZero;
                        boolean bl = divIsZero = divData.compareTo(BigDecimal.ZERO) == 0;
                        if (isAppend) {
                            if (format == null) {
                                rowList.add(divIndex + 1, divIsZero ? BigDecimal.ZERO : defaultValue);
                                continue;
                            }
                            rowList.add(divIndex + 1, divIsZero ? NumberUtil.format(BigDecimal.ZERO, format) : defaultValue);
                            continue;
                        }
                        if (format == null) {
                            rowList.set(divIndex + 1, divIsZero ? BigDecimal.ZERO : defaultValue);
                            continue;
                        }
                        rowList.set(divIndex + 1, divIsZero ? NumberUtil.format(BigDecimal.ZERO, format) : defaultValue);
                        continue;
                    }
                    BigDecimal value = isIncrement ? divData.subtract(divedData).multiply(multiply).divide(divedData, radixSize, RoundingMode.FLOOR) : divData.multiply(multiply).divide(divedData, radixSize, RoundingMode.FLOOR);
                    if (isAppend) {
                        rowList.add(divIndex + 1, format == null ? value : NumberUtil.format(value, format));
                        continue;
                    }
                    rowList.set(divIndex + 1, format == null ? value : NumberUtil.format(value, format));
                }
            }
        }
    }
}

