/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.plugins.ddl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.callback.DataSourceCallbackHandler;
import org.sagacity.sqltoy.config.EntityManager;
import org.sagacity.sqltoy.config.model.EntityMeta;
import org.sagacity.sqltoy.model.TableMeta;
import org.sagacity.sqltoy.plugins.ddl.DDLUtils;
import org.sagacity.sqltoy.plugins.ddl.DialectDDLGenerator;
import org.sagacity.sqltoy.plugins.ddl.impl.DefaultDDLGenerator;
import org.sagacity.sqltoy.plugins.ddl.impl.H2DDLGenerator;
import org.sagacity.sqltoy.plugins.ddl.impl.MySqlDDLGenerator;
import org.sagacity.sqltoy.plugins.ddl.impl.OracleDDLGenerator;
import org.sagacity.sqltoy.plugins.ddl.impl.PostgreSqlDDLGenerator;
import org.sagacity.sqltoy.plugins.ddl.impl.SqlServerDDLGenerator;
import org.sagacity.sqltoy.utils.DataSourceUtils;
import org.sagacity.sqltoy.utils.FileUtil;
import org.sagacity.sqltoy.utils.SqlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDLFactory {
    private static final Logger logger = LoggerFactory.getLogger(DDLFactory.class);
    private static String NEWLINE = "\r\n";

    private static DialectDDLGenerator getGenerator(Integer dbType) {
        DialectDDLGenerator generator = null;
        switch (dbType) {
            case 40: 
            case 42: {
                generator = new MySqlDDLGenerator();
                break;
            }
            case 50: 
            case 51: 
            case 70: 
            case 180: 
            case 190: 
            case 200: 
            case 210: 
            case 220: {
                generator = new PostgreSqlDDLGenerator();
                break;
            }
            case 10: 
            case 11: 
            case 110: {
                generator = new OracleDDLGenerator();
                break;
            }
            case 30: {
                generator = new SqlServerDDLGenerator();
                break;
            }
            case 170: {
                generator = new H2DDLGenerator();
                break;
            }
            default: {
                generator = new DefaultDDLGenerator();
            }
        }
        return generator;
    }

    public static void createSqlFile(String[] scanPackages, String saveFile, Integer dbType, String schema, DialectDDLGenerator dialectDDLGenerator) throws Exception {
        EntityManager entityManager = new EntityManager();
        entityManager.setPackagesToScan(scanPackages);
        entityManager.initialize(null);
        ConcurrentHashMap<String, EntityMeta> entitysMetaMap = entityManager.getAllEntities();
        if (entitysMetaMap == null || entitysMetaMap.isEmpty()) {
            logger.warn("\u6ca1\u6709\u626b\u63cf\u5230\u5177\u4f53\u7684\u5b9e\u4f53\u5bf9\u8c61,\u8bf7\u68c0\u67e5scanPackages\u662f\u5426\u6b63\u786e!");
            return;
        }
        List<EntityMeta> allTableEntities = DDLUtils.sortTables(entitysMetaMap);
        ArrayList<TableMeta> tableMetas = new ArrayList<TableMeta>();
        for (EntityMeta entityMeta : allTableEntities) {
            tableMetas.add(DDLUtils.wrapTableMeta(entityMeta));
        }
        if (!tableMetas.isEmpty()) {
            DialectDDLGenerator generator = dialectDDLGenerator == null ? DDLFactory.getGenerator(dbType) : dialectDDLGenerator;
            FileUtil.delFile(saveFile);
            String splitSign = ";";
            int index = 0;
            logger.debug("\u4e00\u5171\u6709:[" + tableMetas.size() + "]\u4e2a\u5b9e\u4f53\u5bf9\u8c61\u9700\u751f\u6210\u5efa\u8868\u8bed\u53e5!");
            for (TableMeta tableMeta : tableMetas) {
                logger.debug("begin generate table:[" + tableMeta.getTableName() + "] ddl sql!");
                String tableSql = generator.createTableSql(tableMeta, schema, dbType);
                if (tableSql == null || tableSql.equals("")) continue;
                if (index > 0) {
                    tableSql = splitSign.concat(NEWLINE).concat(NEWLINE).concat(tableSql);
                }
                FileUtil.appendFileByStream(saveFile, tableSql);
                ++index;
            }
        }
    }

    public static void createDDL(final SqlToyContext sqlToyContext, ConcurrentHashMap<String, EntityMeta> entitysMetaMap, DataSource dataSource) {
        if (entitysMetaMap == null || entitysMetaMap.isEmpty()) {
            return;
        }
        try {
            List<EntityMeta> allTableEntities = DDLUtils.sortTables(entitysMetaMap);
            for (final EntityMeta entityMeta : allTableEntities) {
                DataSourceUtils.processDataSource(sqlToyContext, dataSource, new DataSourceCallbackHandler(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void doConnection(Connection conn, Integer dbType, String dialect) throws Exception {
                        ResultSet rs = null;
                        String tableName = null;
                        try {
                            rs = conn.getMetaData().getTables(conn.getCatalog(), entityMeta.getSchema() == null ? conn.getSchema() : entityMeta.getSchema(), entityMeta.getTableName(), new String[]{"TABLE"});
                            if (rs.next()) {
                                tableName = rs.getString("TABLE_NAME");
                            }
                        }
                        catch (Exception exception) {
                        }
                        finally {
                            if (rs != null) {
                                rs.close();
                                rs = null;
                            }
                        }
                        if (tableName == null) {
                            TableMeta tableMeta = DDLUtils.wrapTableMeta(entityMeta);
                            logger.debug("\u5f00\u59cb\u521b\u5efa\u8868:[" + tableMeta.getTableName() + "]\u7684\u8868\u7ed3\u6784!");
                            DialectDDLGenerator dialectDDLGenerator = sqlToyContext.getDialectDDLGenerator() == null ? DDLFactory.getGenerator(dbType) : sqlToyContext.getDialectDDLGenerator();
                            String createSql = dialectDDLGenerator.createTableSql(tableMeta, conn.getSchema(), dbType);
                            try {
                                if (createSql != null && !createSql.equals("")) {
                                    SqlUtil.executeSql(null, createSql, null, null, conn, dbType, null, true);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else {
                            logger.debug("\u8868:[" + tableName + "]\u5728\u6570\u636e\u5e93\u4e2d\u5df2\u7ecf\u5b58\u5728!");
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

