/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.plugins.ddl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.sagacity.sqltoy.config.model.EntityMeta;
import org.sagacity.sqltoy.config.model.FieldMeta;
import org.sagacity.sqltoy.config.model.ForeignModel;
import org.sagacity.sqltoy.config.model.IndexModel;
import org.sagacity.sqltoy.model.ColumnMeta;
import org.sagacity.sqltoy.model.TableMeta;
import org.sagacity.sqltoy.utils.StringUtil;

public class DDLUtils {
    public static String NEWLINE = "\r\n";
    public static String TAB = "   ";

    public static List<EntityMeta> sortTables(ConcurrentHashMap<String, EntityMeta> entitysMetaMap) {
        String tableName;
        EntityMeta entityMeta;
        LinkedHashMap<String, EntityMeta> tmpEntityMeta = new LinkedHashMap<String, EntityMeta>();
        for (Map.Entry<String, EntityMeta> entry : entitysMetaMap.entrySet()) {
            entityMeta = entry.getValue();
            tableName = entityMeta.getSchemaTable(null, null);
            tmpEntityMeta.put(tableName, entityMeta);
        }
        LinkedHashMap<String, EntityMeta> sortTables = new LinkedHashMap<String, EntityMeta>();
        LinkedHashMap swotTables = new LinkedHashMap();
        for (Map.Entry<String, EntityMeta> entry : entitysMetaMap.entrySet()) {
            entityMeta = entry.getValue();
            tableName = entityMeta.getSchemaTable(null, null);
            if (entityMeta.getForeignFields() != null) {
                for (Map.Entry<String, ForeignModel> iter : entityMeta.getForeignFields().entrySet()) {
                    String foreignTable = iter.getValue().getForeignTable();
                    if (entityMeta.getSchema() != null && !foreignTable.startsWith(entityMeta.getSchema().concat("."))) {
                        foreignTable = entityMeta.getSchema().concat(".").concat(foreignTable);
                    }
                    if (!sortTables.containsKey(foreignTable)) {
                        sortTables.put(foreignTable, (EntityMeta)tmpEntityMeta.get(foreignTable));
                        continue;
                    }
                    if (!sortTables.containsKey(tableName) || DDLUtils.isBefore(sortTables, foreignTable, tableName)) continue;
                    swotTables.clear();
                    swotTables.put(foreignTable, tmpEntityMeta.get(foreignTable));
                    sortTables.remove(foreignTable);
                    swotTables.putAll(sortTables);
                    sortTables.clear();
                    sortTables.putAll(swotTables);
                }
            }
            if (sortTables.containsKey(tableName)) continue;
            sortTables.put(tableName, entityMeta);
        }
        return new ArrayList<EntityMeta>(sortTables.values());
    }

    public static boolean isBefore(LinkedHashMap<String, EntityMeta> sortTables, String foreignTable, String nowTable) {
        int foreignTableIndex = 0;
        int nowTableIndex = 0;
        int index = 0;
        for (Map.Entry<String, EntityMeta> entry : sortTables.entrySet()) {
            String tableName = entry.getKey();
            if (foreignTable.equals(tableName)) {
                foreignTableIndex = index;
            } else if (nowTable.equals(tableName)) {
                nowTableIndex = index;
            }
            ++index;
        }
        return foreignTableIndex < nowTableIndex;
    }

    public static TableMeta wrapTableMeta(EntityMeta entityMeta) {
        TableMeta tableMeta = new TableMeta();
        tableMeta.setTableName(entityMeta.getTableName());
        tableMeta.setRemarks(DDLUtils.translateSpecialSymbols(entityMeta.getTableComment()));
        tableMeta.setSchema(entityMeta.getSchema());
        tableMeta.setPkConstraint(entityMeta.getPkConstraint());
        if (entityMeta.getIndexModels() != null) {
            ArrayList<IndexModel> indexModels = new ArrayList<IndexModel>();
            for (IndexModel indexModel : entityMeta.getIndexModels()) {
                indexModels.add(indexModel);
            }
            tableMeta.setIndexes(indexModels);
        }
        if (entityMeta.getForeignFields() != null) {
            ArrayList<ForeignModel> foreignModels = new ArrayList<ForeignModel>();
            for (Map.Entry entry : entityMeta.getForeignFields().entrySet()) {
                foreignModels.add((ForeignModel)entry.getValue());
            }
            tableMeta.setForeigns(foreignModels);
        }
        HashMap<String, FieldMeta> fieldMetaMap = entityMeta.getFieldsMeta();
        ArrayList<ColumnMeta> arrayList = new ArrayList<ColumnMeta>();
        for (Map.Entry entry : fieldMetaMap.entrySet()) {
            FieldMeta fieldMeta = (FieldMeta)entry.getValue();
            ColumnMeta columnMeta = new ColumnMeta();
            columnMeta.setColName(fieldMeta.getColumnName());
            columnMeta.setComments(DDLUtils.translateSpecialSymbols(fieldMeta.getComments()));
            columnMeta.setAutoIncrement(fieldMeta.isAutoIncrement());
            columnMeta.setColumnSize(fieldMeta.getLength());
            columnMeta.setPartitionKey(fieldMeta.isPartitionKey());
            columnMeta.setDefaultValue(fieldMeta.getDefaultValue());
            columnMeta.setNullable(fieldMeta.isNullable());
            columnMeta.setDataType(fieldMeta.getType());
            columnMeta.setTypeName(fieldMeta.getFieldType());
            columnMeta.setPK(fieldMeta.isPK());
            columnMeta.setDecimalDigits(fieldMeta.getPrecision());
            columnMeta.setNumPrecRadix(fieldMeta.getScale());
            columnMeta.setNativeType(fieldMeta.getNativeType());
            arrayList.add(columnMeta);
        }
        tableMeta.setColumns(arrayList);
        return tableMeta;
    }

    public static String convertType(ColumnMeta colMeta, int dbType) {
        if (colMeta.getNativeType() != null) {
            if (colMeta.getNativeType().equalsIgnoreCase("JSON")) {
                return "JSON";
            }
            if (colMeta.getNativeType().equalsIgnoreCase("BSON")) {
                if (dbType == 50 || dbType == 51 || dbType == 70 || dbType == 210 || dbType == 190 || dbType == 220 || dbType == 180 || dbType == 200) {
                    return "BSON";
                }
                return "JSON";
            }
        }
        boolean isBytes = false;
        String typeName = "VARCHAR";
        switch (colMeta.getDataType()) {
            case -5: {
                if (dbType == 10 || dbType == 11 || dbType == 110) {
                    typeName = "NUMBER";
                    typeName = DDLUtils.setLength(typeName, true, colMeta);
                    break;
                }
                typeName = "BIGINT";
                break;
            }
            case 4: {
                typeName = "INTEGER";
                break;
            }
            case -6: {
                if (dbType == 10 || dbType == 11 || dbType == 110) {
                    typeName = "INTEGER";
                    break;
                }
                typeName = "TINYINT";
                typeName = DDLUtils.setLength(typeName, true, colMeta);
                break;
            }
            case 5: {
                typeName = "SMALLINT";
                break;
            }
            case -15: 
            case 1: {
                typeName = "CHAR";
                typeName = DDLUtils.setLength(typeName, false, colMeta);
                break;
            }
            case -9: 
            case 12: {
                typeName = "VARCHAR";
                typeName = DDLUtils.setLength(typeName, false, colMeta);
                break;
            }
            case -16: {
                if (dbType == 10 || dbType == 11 || dbType == 110) {
                    typeName = "CLOB";
                    break;
                }
                typeName = "TEXT";
                break;
            }
            case 2004: {
                typeName = dbType == 50 || dbType == 51 || dbType == 70 || dbType == 210 || dbType == 190 || dbType == 220 || dbType == 180 || dbType == 200 ? "bytea" : (dbType == 30 ? "IMAGE" : "BLOB");
                isBytes = true;
                break;
            }
            case -2: {
                if (dbType == 50 || dbType == 51 || dbType == 70 || dbType == 210 || dbType == 220 || dbType == 180 || dbType == 190 || dbType == 200) {
                    typeName = "bytea";
                } else if (dbType == 10 || dbType == 11 || dbType == 110) {
                    typeName = "BLOB";
                } else if (dbType == 30) {
                    typeName = "IMAGE";
                } else {
                    typeName = "BINARY";
                    typeName = DDLUtils.setLength(typeName, false, colMeta);
                }
                isBytes = true;
                break;
            }
            case -4: 
            case -3: {
                if (dbType == 50 || dbType == 51 || dbType == 70 || dbType == 210 || dbType == 220 || dbType == 180 || dbType == 190 || dbType == 200) {
                    typeName = "bytea";
                } else if (dbType == 10 || dbType == 11 || dbType == 110) {
                    typeName = "BLOB";
                } else if (dbType == 30) {
                    typeName = "IMAGE";
                } else {
                    typeName = "VARBINARY";
                    typeName = DDLUtils.setLength(typeName, false, colMeta);
                }
                isBytes = true;
                break;
            }
            case 2005: 
            case 2011: {
                if (dbType == 10 || dbType == 11 || dbType == 110) {
                    typeName = "CLOB";
                    break;
                }
                typeName = "TEXT";
                break;
            }
            case 92: {
                typeName = "TIME";
                break;
            }
            case 93: {
                typeName = "TIMESTAMP";
                break;
            }
            case 91: {
                if (dbType == 40 || dbType == 42 || dbType == 30) {
                    typeName = "DATETIME";
                    break;
                }
                typeName = "DATE";
                break;
            }
            case 16: {
                if (colMeta.getTypeName().equals("string")) {
                    if (colMeta.getColumnSize() > 0) {
                        typeName = "VARCHAR";
                        typeName = DDLUtils.setLength(typeName, false, colMeta);
                        break;
                    }
                    typeName = "CHAR(1)";
                    break;
                }
                if (dbType == 10 || dbType == 11 || dbType == 110) {
                    typeName = "INTEGER";
                    break;
                }
                typeName = "TINYINT(1)";
                break;
            }
            case 6: {
                typeName = "FLOAT";
                break;
            }
            case 8: {
                typeName = "DOUBLE";
                break;
            }
            case 2: 
            case 3: {
                typeName = dbType == 10 || dbType == 11 || dbType == 110 ? "NUMBER" : (dbType == 50 || dbType == 51 ? "NUMERIC" : "DECIMAL");
                typeName = DDLUtils.setLength(typeName, true, colMeta);
                break;
            }
            default: {
                if (colMeta.getNativeType() != null) {
                    typeName = colMeta.getNativeType();
                    break;
                }
                typeName = "VARCHAR";
                typeName = DDLUtils.setLength(typeName, false, colMeta);
            }
        }
        if (!(dbType != 50 && dbType != 51 && dbType != 70 && dbType != 210 && dbType != 190 && dbType != 220 && dbType != 180 && dbType != 200 || !colMeta.getTypeName().endsWith("[]") || isBytes || typeName.startsWith("_"))) {
            return "_".concat(typeName);
        }
        return typeName;
    }

    public static String setLength(String typeName, boolean isNumber, ColumnMeta colMeta) {
        if (isNumber && colMeta.getNumPrecRadix() > 0) {
            return typeName + "(" + colMeta.getColumnSize() + "," + colMeta.getNumPrecRadix() + ")";
        }
        if (colMeta.getColumnSize() > 0) {
            if (typeName.equals("CHAR") || typeName.equals("VARCHAR")) {
                return typeName + "(" + (colMeta.getColumnSize() > 0xA00000 ? 0xA00000 : colMeta.getColumnSize()) + ")";
            }
            return typeName + "(" + colMeta.getColumnSize() + ")";
        }
        return typeName;
    }

    public static void wrapTablePrimaryKeys(TableMeta tableMeta, int dbType, StringBuilder tableSql) {
        String primaryKeys = "";
        for (ColumnMeta colMeta : tableMeta.getColumns()) {
            if (!colMeta.isPK()) continue;
            if (primaryKeys.equals("")) {
                primaryKeys = colMeta.getColName();
                continue;
            }
            primaryKeys = primaryKeys + "," + colMeta.getColName();
        }
        if (!primaryKeys.equals("")) {
            tableSql.append(",").append(NEWLINE);
            tableSql.append(TAB);
            tableSql.append("primary key (").append(primaryKeys).append(")");
        }
    }

    public static void wrapTableIndexes(TableMeta tableMeta, int dbType, StringBuilder tableSql, boolean outerTable) {
        if (tableMeta.getIndexes() == null || tableMeta.getIndexes().isEmpty()) {
            return;
        }
        String splitSign = ";";
        for (IndexModel indexModel : tableMeta.getIndexes()) {
            if (outerTable) {
                tableSql.append(splitSign).append(NEWLINE);
                tableSql.append("create ");
                if (indexModel.isUnique()) {
                    tableSql.append("UNIQUE ");
                }
                tableSql.append("index ").append(indexModel.getName());
                tableSql.append(" on ").append(tableMeta.getTableName());
            } else {
                tableSql.append(",").append(NEWLINE);
                tableSql.append(TAB);
                if (indexModel.isUnique()) {
                    tableSql.append("UNIQUE ");
                }
                tableSql.append("KEY ").append(indexModel.getName());
            }
            tableSql.append(" (");
            int meter = 0;
            String[] sortTypes = indexModel.getSortTypes();
            int typeLen = sortTypes == null ? 0 : sortTypes.length;
            for (String col : indexModel.getColumns()) {
                if (meter > 0) {
                    tableSql.append(",");
                }
                tableSql.append(col);
                if (meter < typeLen && StringUtil.isNotBlank(sortTypes[meter])) {
                    tableSql.append(" ").append(sortTypes[meter]);
                }
                ++meter;
            }
            tableSql.append(")");
        }
    }

    public static void wrapForeignKeys(TableMeta tableMeta, int dbType, StringBuilder tableSql, boolean outerTable) {
        if (tableMeta.getForeigns() == null || tableMeta.getForeigns().isEmpty()) {
            return;
        }
        boolean isOracle = false;
        String splitSign = ";";
        for (ForeignModel foreign : tableMeta.getForeigns()) {
            boolean bl = isOracle = dbType == 10 || dbType == 11 || dbType == 110;
            if (outerTable) {
                tableSql.append(splitSign).append(NEWLINE);
                tableSql.append("alter table ").append(tableMeta.getTableName());
                tableSql.append(" add ");
            } else {
                tableSql.append(",").append(NEWLINE);
                tableSql.append(TAB);
            }
            tableSql.append(" CONSTRAINT ").append(foreign.getConstraintName());
            tableSql.append(" FOREIGN KEY (").append(StringUtil.linkAry(",", true, foreign.getColumns())).append(")");
            tableSql.append(" REFERENCES ").append(foreign.getForeignTable()).append("(");
            tableSql.append(StringUtil.linkAry(",", true, foreign.getForeignColumns()));
            tableSql.append(")");
            if (foreign.getDeleteRestict() == 1) {
                if (!isOracle) {
                    tableSql.append(" ON DELETE RESTRICT");
                }
            } else if (foreign.getDeleteRestict() == 0) {
                tableSql.append(" ON DELETE CASCADE");
            } else if (foreign.getDeleteRestict() == 2) {
                tableSql.append(" ON DELETE SET NULL");
            } else if (foreign.getDeleteRestict() == 3) {
                tableSql.append(" ON DELETE NO ACTION");
            } else if (foreign.getDeleteRestict() == 4) {
                tableSql.append(" ON DELETE SET DEFAULT");
            }
            if (isOracle) continue;
            if (foreign.getUpdateRestict() == 1) {
                tableSql.append(" ON UPDATE RESTRICT");
                continue;
            }
            if (foreign.getUpdateRestict() == 0) {
                tableSql.append(" ON UPDATE CASCADE");
                continue;
            }
            if (foreign.getUpdateRestict() == 2) {
                tableSql.append(" ON UPDATE SET NULL");
                continue;
            }
            if (foreign.getUpdateRestict() == 3) {
                tableSql.append(" ON UPDATE NO ACTION");
                continue;
            }
            if (foreign.getUpdateRestict() != 4) continue;
            tableSql.append(" ON UPDATE SET DEFAULT");
        }
    }

    public static void wrapTableAndColumnsComment(TableMeta tableMeta, int dbType, StringBuilder tableSql) {
        String splitSign = ";";
        if (StringUtil.isNotBlank(tableMeta.getRemarks())) {
            tableSql.append(splitSign);
            tableSql.append(NEWLINE);
            tableSql.append("COMMENT ON TABLE ").append(tableMeta.getTableName()).append(" IS '").append(tableMeta.getRemarks()).append("'");
        }
        for (ColumnMeta colMeta : tableMeta.getColumns()) {
            if (!StringUtil.isNotBlank(colMeta.getComments())) continue;
            tableSql.append(splitSign);
            tableSql.append(NEWLINE);
            tableSql.append("COMMENT ON COLUMN ").append(tableMeta.getTableName()).append(".").append(colMeta.getColName()).append(" IS '").append(colMeta.getComments()).append("'");
        }
    }

    public static boolean isNotChar(int dataType) {
        return dataType == -5 || dataType == 4 || dataType == 16 || dataType == 3 || dataType == 8 || dataType == 2 || dataType == 6 || dataType == 7 || dataType == 5 || dataType == -6 || dataType == -7;
    }

    private static String translateSpecialSymbols(String str) {
        if (str == null) {
            return str;
        }
        return str.replaceAll("'", "\\\\'").replaceAll("\"", "\\\\\"");
    }
}

