/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.plugins.ddl.impl;

import org.sagacity.sqltoy.model.ColumnMeta;
import org.sagacity.sqltoy.model.TableMeta;
import org.sagacity.sqltoy.plugins.ddl.DDLUtils;
import org.sagacity.sqltoy.plugins.ddl.DialectDDLGenerator;
import org.sagacity.sqltoy.utils.StringUtil;

public class H2DDLGenerator
implements DialectDDLGenerator {
    private String NEWLINE = "\r\n";
    private String TAB = "   ";

    @Override
    public String createTableSql(TableMeta tableMeta, String schema, int dbType) {
        if (tableMeta == null) {
            return null;
        }
        StringBuilder tableSql = new StringBuilder();
        tableSql.append("create table ").append(tableMeta.getTableName()).append(this.NEWLINE);
        tableSql.append("(").append(this.NEWLINE);
        int index = 0;
        for (ColumnMeta colMeta : tableMeta.getColumns()) {
            if (index > 0) {
                tableSql.append(",").append(this.NEWLINE);
            }
            tableSql.append(this.TAB).append(colMeta.getColName());
            tableSql.append(" ").append(DDLUtils.convertType(colMeta, dbType));
            if (!colMeta.isNullable()) {
                tableSql.append(" not null");
            }
            if (colMeta.isAutoIncrement()) {
                tableSql.append(" auto_increment");
            } else if (StringUtil.isNotBlank(colMeta.getDefaultValue())) {
                tableSql.append(" default ");
                if (DDLUtils.isNotChar(colMeta.getDataType())) {
                    tableSql.append(colMeta.getDefaultValue());
                } else {
                    tableSql.append("'").append(colMeta.getDefaultValue()).append("'");
                }
            }
            if (StringUtil.isNotBlank(colMeta.getComments())) {
                tableSql.append(" comment '").append(colMeta.getComments().replaceAll("\\\\", "").replaceAll("\"", "").replaceAll("'", "")).append("'");
            }
            ++index;
        }
        DDLUtils.wrapTablePrimaryKeys(tableMeta, dbType, tableSql);
        tableSql.append(this.NEWLINE);
        tableSql.append(")");
        if (StringUtil.isNotBlank(tableMeta.getRemarks())) {
            tableSql.append(";");
            tableSql.append(this.NEWLINE);
            tableSql.append(" comment on table ").append(tableMeta.getTableName()).append(" is '").append(tableMeta.getRemarks().replaceAll("\\\\", "").replaceAll("\"", "").replaceAll("'", "")).append("'");
        }
        DDLUtils.wrapTableIndexes(tableMeta, dbType, tableSql, true);
        DDLUtils.wrapForeignKeys(tableMeta, dbType, tableSql, true);
        return tableSql.toString();
    }
}

