/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.plugins.ddl.impl;

import org.sagacity.sqltoy.model.ColumnMeta;
import org.sagacity.sqltoy.model.TableMeta;
import org.sagacity.sqltoy.plugins.ddl.DDLUtils;
import org.sagacity.sqltoy.plugins.ddl.DialectDDLGenerator;
import org.sagacity.sqltoy.utils.StringUtil;

public class SqlServerDDLGenerator
implements DialectDDLGenerator {
    private String NEWLINE = "\r\n";
    private String TAB = "   ";

    @Override
    public String createTableSql(TableMeta tableMeta, String schema, int dbType) {
        if (tableMeta == null) {
            return null;
        }
        StringBuilder tableSql = new StringBuilder();
        tableSql.append("create table ").append(tableMeta.getTableName()).append(this.NEWLINE);
        tableSql.append("(").append(this.NEWLINE);
        int index = 0;
        String splitSign = ";";
        for (ColumnMeta colMeta : tableMeta.getColumns()) {
            if (index > 0) {
                tableSql.append(",").append(this.NEWLINE);
            }
            tableSql.append(this.TAB).append(colMeta.getColName());
            tableSql.append(" ").append(DDLUtils.convertType(colMeta, dbType));
            if (!colMeta.isNullable()) {
                tableSql.append(" not null");
            }
            if (colMeta.isAutoIncrement()) {
                tableSql.append(" IDENTITY ");
            } else if (StringUtil.isNotBlank(colMeta.getDefaultValue())) {
                tableSql.append(" default ");
                if (DDLUtils.isNotChar(colMeta.getDataType())) {
                    tableSql.append(colMeta.getDefaultValue());
                } else {
                    tableSql.append("'").append(colMeta.getDefaultValue()).append("'");
                }
            }
            ++index;
        }
        DDLUtils.wrapTablePrimaryKeys(tableMeta, dbType, tableSql);
        tableSql.append(this.NEWLINE);
        tableSql.append(")");
        if (StringUtil.isNotBlank(schema)) {
            if (StringUtil.isNotBlank(tableMeta.getRemarks())) {
                tableSql.append(splitSign);
                tableSql.append(this.NEWLINE);
                tableSql.append(this.NEWLINE);
                tableSql.append("EXECUTE sp_addextendedproperty 'MS_Description','").append(tableMeta.getRemarks()).append("',");
                tableSql.append("'schema','" + schema + "',");
                tableSql.append("'table','").append(tableMeta.getTableName()).append("'");
            }
            for (ColumnMeta colMeta : tableMeta.getColumns()) {
                if (!StringUtil.isNotBlank(colMeta.getComments())) continue;
                tableSql.append(splitSign);
                tableSql.append(this.NEWLINE);
                tableSql.append(this.NEWLINE);
                tableSql.append("EXECUTE sp_addextendedproperty 'MS_Description','").append(colMeta.getComments()).append("',");
                tableSql.append("'schema','" + schema + "',");
                tableSql.append("'table','").append(tableMeta.getTableName()).append("',");
                tableSql.append("'column','").append(colMeta.getColName()).append("'");
            }
        }
        DDLUtils.wrapTableIndexes(tableMeta, dbType, tableSql, true);
        DDLUtils.wrapForeignKeys(tableMeta, dbType, tableSql, true);
        return tableSql.toString();
    }
}

