/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.plugins.function.impl;

import java.util.regex.Pattern;
import org.sagacity.sqltoy.plugins.function.IFunction;

public class DateDiff
extends IFunction {
    private static Pattern regex = Pattern.compile("(?i)\\W(datediff|timestampdiff)\\(");

    @Override
    public String dialects() {
        return "";
    }

    @Override
    public Pattern regex() {
        return regex;
    }

    @Override
    public String wrap(int dialect, String functionName, boolean hasArgs, String ... args) {
        if (args == null || args.length < 2) {
            return this.IGNORE;
        }
        String[] realArgs = args.length == 2 ? new String[]{"DAY", args[0], args[1]} : args;
        String unitType = realArgs[0].toUpperCase().replace("'", "").replace("\"", "");
        String realFunctionName = "datediff";
        String[][] unitConstracts = null;
        if (dialect == 40 || dialect == 42) {
            unitConstracts = new String[][]{{"DD", "DAY"}, {"MM", "MONTH"}, {"YY", "YEAR"}, {"YYYY", "YEAR"}};
            realFunctionName = "timestampdiff";
        } else if (dialect == 10 || dialect == 11) {
            if (unitType.equals("YEAR")) {
                return "TRUNC(MONTHS_BETWEEN(" + realArgs[1] + "," + realArgs[2] + ")/12,1)";
            }
            if (unitType.equals("MONTH")) {
                return "TRUNC(MONTHS_BETWEEN(" + realArgs[1] + "," + realArgs[2] + "),1)";
            }
            if (unitType.equals("DAY")) {
                return "EXTRACT(DAY FROM (" + realArgs[2] + "-" + realArgs[1] + "))";
            }
        } else if (dialect == 190 || dialect == 50 || dialect == 51 || dialect == 210 || dialect == 200 || dialect == 220) {
            if (unitType.equals("YEAR")) {
                return "(date_part('year'," + realArgs[2] + ")-date_part('year'," + realArgs[1] + "))";
            }
            if (unitType.equals("MONTH")) {
                return "((date_part('year'," + realArgs[2] + ")-date_part('year'," + realArgs[1] + "))*12+date_part('month'," + realArgs[2] + ")-date_part('month'," + realArgs[1] + "))";
            }
            if (unitType.equals("WEEK")) {
                return "round(date_part('day'," + realArgs[2] + "-" + realArgs[1] + ")/7,1)";
            }
            if (unitType.equals("DAY")) {
                return "date_part('day'," + realArgs[2] + "-" + realArgs[1] + ")";
            }
            if (unitType.equals("HOUR")) {
                return "round(extract(epoch from(" + realArgs[2] + "-" + realArgs[1] + "))/3600,1)";
            }
            if (unitType.equals("MINUTE")) {
                return "round(extract(epoch from(" + realArgs[2] + "-" + realArgs[1] + "))/60,1)";
            }
            if (unitType.equals("SECOND")) {
                return "round(extract(epoch from(" + realArgs[2] + "-" + realArgs[1] + ")),0)";
            }
        } else if (dialect == 30) {
            // empty if block
        }
        if (unitConstracts != null) {
            realArgs[0] = this.getMatchedType(unitType, unitConstracts);
            return this.wrapArgs(realFunctionName, realArgs);
        }
        return this.IGNORE;
    }

    private String getMatchedType(String unitType, String[][] matchConstract) {
        for (String[] constract : matchConstract) {
            if (!unitType.equals(constract[0])) continue;
            return constract[1];
        }
        return unitType;
    }
}

