/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.plugins.function.impl;

import java.util.regex.Pattern;
import org.sagacity.sqltoy.plugins.function.IFunction;

public class ToChar
extends IFunction {
    private static Pattern regex = Pattern.compile("(?i)\\W(to_char|FORMATDATETIME|date_format)\\(");

    @Override
    public String dialects() {
        return "";
    }

    @Override
    public String wrap(int dialect, String functionName, boolean hasArgs, String ... args) {
        if (args == null || args.length < 2) {
            return this.IGNORE;
        }
        switch (dialect) {
            case 40: 
            case 42: 
            case 90: {
                String format = args[1].replace("yyyy", "%Y").replace("yy", "%y").replace("MM", "%m").replace("dd", "%d");
                format = format.replace("hh24", "%H").replace("hh", "%h").replace("mi", "%i").replace("ss", "%s");
                return "date_format(" + args[0] + "," + format + ")";
            }
            case 10: 
            case 11: 
            case 50: 
            case 51: 
            case 70: 
            case 100: 
            case 110: 
            case 180: 
            case 190: 
            case 200: 
            case 210: 
            case 220: {
                String format = args[1].replace("%Y", "yyyy").replace("%y", "yy").replace("%m", "MM").replace("%d", "dd");
                format = format.replace("%T", "hh24:mi:ss");
                format = format.replace("%H", "hh24").replace("%h", "hh").replace("%i", "mi").replace("%s", "ss");
                return "to_char(" + args[0] + "," + format + ")";
            }
            case 170: {
                String format = args[1].replace("%Y", "yyyy").replace("%y", "yyyy").replace("%m", "MM").replace("%d", "dd");
                format = format.replace("%T", "hh:mm:ss");
                format = format.replace("%H", "hh").replace("%h", "hh").replace("%i", "mm").replace("%s", "ss");
                return "to_char(" + args[0] + "," + format + ")";
            }
        }
        return this.IGNORE;
    }

    @Override
    public Pattern regex() {
        return regex;
    }
}

