/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.plugins.id.impl;

import java.time.LocalDate;
import java.util.Date;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.integration.DistributeIdGenerator;
import org.sagacity.sqltoy.model.MapKit;
import org.sagacity.sqltoy.plugins.id.IdGenerator;
import org.sagacity.sqltoy.utils.DateUtil;
import org.sagacity.sqltoy.utils.IdUtil;
import org.sagacity.sqltoy.utils.SqlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisIdGenerator
implements IdGenerator {
    protected static final Logger logger = LoggerFactory.getLogger(RedisIdGenerator.class);
    private DistributeIdGenerator distributeIdGenerator;

    @Override
    public void initialize(SqlToyContext sqlToyContext) throws Exception {
        if (this.distributeIdGenerator == null) {
            this.distributeIdGenerator = (DistributeIdGenerator)Class.forName(sqlToyContext.getDistributeIdGeneratorClass()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.distributeIdGenerator.initialize(sqlToyContext.getAppContext());
        }
    }

    @Override
    public Object getId(String tableName, String signature, String[] relatedColumns, Object[] relatedColValue, Date bizDate, String idJavaType, int length, int sequenceSize) {
        LocalDate bizLocalDate = bizDate == null ? null : DateUtil.asLocalDate(bizDate);
        return SqlUtil.convertIdValueType(IdUtil.getId(this.distributeIdGenerator, tableName, signature, MapKit.keys(relatedColumns).values(relatedColValue), bizLocalDate, length, sequenceSize), idJavaType);
    }
}

