/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.plugins.id.macro.impl;

import java.util.Map;
import org.sagacity.sqltoy.SqlToyConstants;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.plugins.id.macro.AbstractMacro;
import org.sagacity.sqltoy.utils.BeanUtil;
import org.sagacity.sqltoy.utils.StringUtil;

public class Include
extends AbstractMacro {
    @Override
    public String execute(String[] params, Map<String, Object> keyValues, Object paramValues, String preSql, String dialect) {
        if (params.length == 0) {
            return "";
        }
        String sqlId = params[0].replaceAll("\"|'", "").trim();
        if ("".equals(sqlId)) {
            return "";
        }
        if (sqlId.contains("=")) {
            sqlId = sqlId.substring(sqlId.indexOf("=") + 1).trim();
        }
        if (sqlId.startsWith(":")) {
            String paramName = sqlId.substring(1).trim();
            if (paramValues == null) {
                return "@blank(:".concat(paramName).concat(")");
            }
            Object paramValue = BeanUtil.reflectBeanToAry(paramValues, paramName)[0];
            if (StringUtil.isBlank(paramValue)) {
                return "@blank(:".concat(paramName).concat(")");
            }
            return paramValue.toString();
        }
        SqlToyConfig sqlToyConfig = this.getSqlToyConfig(keyValues, sqlId, dialect);
        if (sqlToyConfig == null) {
            return "(sqlId='" + sqlId + "' not exists!)";
        }
        if (StringUtil.matches(sqlToyConfig.getSql(), SqlToyConstants.INCLUDE_PATTERN)) {
            return "(not support @include(sqlId) multinest!)";
        }
        return sqlToyConfig.getSql();
    }

    private SqlToyConfig getSqlToyConfig(Map<String, Object> sqlCache, String sqlId, String dialect) {
        SqlToyConfig result = null;
        if (StringUtil.isNotBlank(dialect)) {
            result = (SqlToyConfig)sqlCache.get(sqlId.concat("_").concat(dialect));
            if (result == null) {
                result = (SqlToyConfig)sqlCache.get(dialect.concat("_").concat(sqlId));
            }
            if (result == null && dialect.equals("sqlserver") && (result = (SqlToyConfig)sqlCache.get(sqlId.concat("_mssql"))) == null) {
                result = (SqlToyConfig)sqlCache.get("mssql_".concat(sqlId));
            }
            if (result == null && dialect.equals("postgresql") && (result = (SqlToyConfig)sqlCache.get(sqlId.concat("_postgres"))) == null) {
                result = (SqlToyConfig)sqlCache.get("postgres_".concat(sqlId));
            }
        }
        if (result == null) {
            result = (SqlToyConfig)sqlCache.get(sqlId);
        }
        return result;
    }
}

