/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.plugins.secure.impl;

import org.sagacity.sqltoy.config.model.SecureMask;
import org.sagacity.sqltoy.plugins.secure.DesensitizeProvider;
import org.sagacity.sqltoy.utils.StringUtil;

public class DesensitizeDefaultProvider
implements DesensitizeProvider {
    @Override
    public String desensitize(String content, SecureMask maskType) {
        if (content == null || "".equals(content)) {
            return content;
        }
        return this.maskStr(maskType, content);
    }

    private String maskStr(SecureMask mask, Object value) {
        String type = mask.getType();
        String realStr = value.toString();
        int size = realStr.length();
        if (size == 1) {
            return realStr;
        }
        String maskCode = mask.getMaskCode();
        int headSize = mask.getHeadSize();
        int tailSize = mask.getTailSize();
        if (headSize > 0 || tailSize > 0) {
            return StringUtil.secureMask(realStr, headSize > 0 ? headSize : 0, tailSize > 0 ? tailSize : 0, maskCode);
        }
        if (mask.getMaskRate() > 0) {
            int maskSize = Double.valueOf((double)(size * mask.getMaskRate()) * 1.0 / 100.0).intValue();
            if (maskSize < 1) {
                maskSize = 1;
            } else if (maskSize >= size) {
                maskSize = size - 1;
            }
            tailSize = (size - maskSize) / 2;
            headSize = size - maskSize - tailSize;
            if (maskCode == null) {
                maskCode = "*";
                if (maskSize > 3) {
                    maskCode = "***";
                } else if (maskSize == 2) {
                    maskCode = "**";
                }
            }
        }
        if ("tel".equals(type)) {
            if (size >= 11) {
                return StringUtil.secureMask(realStr, 3, 4, maskCode);
            }
            return StringUtil.secureMask(realStr, 4, 0, maskCode);
        }
        if ("email".equals(type)) {
            String maskStr = maskCode == null || "".equals(maskCode) ? "***" : maskCode;
            return realStr.substring(0, 1).concat(maskStr).concat(realStr.substring(realStr.indexOf("@")));
        }
        if ("id-card".equals(type)) {
            return StringUtil.secureMask(realStr, 0, 4, maskCode);
        }
        if ("bank-card".equals(type)) {
            return StringUtil.secureMask(realStr, 6, 4, maskCode);
        }
        if ("name".equals(type)) {
            if (size >= 4) {
                return StringUtil.secureMask(realStr, 2, 0, maskCode);
            }
            return StringUtil.secureMask(realStr, 1, 0, maskCode);
        }
        if ("address".equals(type)) {
            if (size >= 30) {
                return StringUtil.secureMask(realStr, 7, 0, maskCode);
            }
            if (size >= 12) {
                return StringUtil.secureMask(realStr, 6, 0, maskCode);
            }
            if (size >= 8) {
                return StringUtil.secureMask(realStr, 4, 0, maskCode);
            }
            return StringUtil.secureMask(realStr, 2, 0, maskCode);
        }
        if ("public-account".equals(type)) {
            return StringUtil.secureMask(realStr, 2, 0, maskCode);
        }
        return StringUtil.secureMask(realStr, headSize, tailSize, maskCode);
    }
}

