/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.translate;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.config.model.SqlType;
import org.sagacity.sqltoy.dialect.DialectFactory;
import org.sagacity.sqltoy.model.QueryExecutor;
import org.sagacity.sqltoy.model.QueryResult;
import org.sagacity.sqltoy.plugins.datasource.DataSourceSelector;
import org.sagacity.sqltoy.translate.model.CacheCheckResult;
import org.sagacity.sqltoy.translate.model.CheckerConfigModel;
import org.sagacity.sqltoy.translate.model.TranslateConfigModel;
import org.sagacity.sqltoy.utils.BeanUtil;
import org.sagacity.sqltoy.utils.CollectionUtil;
import org.sagacity.sqltoy.utils.DateUtil;
import org.sagacity.sqltoy.utils.HttpClientUtils;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslateFactory {
    protected static final Logger logger = LoggerFactory.getLogger(TranslateFactory.class);

    public static List<CacheCheckResult> doCheck(SqlToyContext sqlToyContext, CheckerConfigModel checkerConfig, Timestamp preCheckTime) {
        List result = null;
        try {
            if ("sql".equals(checkerConfig.getType())) {
                result = TranslateFactory.doSqlCheck(sqlToyContext, checkerConfig, preCheckTime);
            } else if ("service".equals(checkerConfig.getType())) {
                result = TranslateFactory.doServiceCheck(sqlToyContext, checkerConfig, preCheckTime);
            } else if ("rest".equals(checkerConfig.getType())) {
                result = TranslateFactory.doRestCheck(sqlToyContext, checkerConfig, preCheckTime);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u6267\u884c\u7f13\u5b58\u53d8\u66f4\u68c0\u6d4b\u53d1\u751f\u9519\u8bef,\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
        }
        if (checkerConfig.isIncrement()) {
            return TranslateFactory.wrapIncrementCheckResult(result, checkerConfig);
        }
        return TranslateFactory.wrapClearCheckResult(result, checkerConfig);
    }

    private static List doSqlCheck(SqlToyContext sqlToyContext, CheckerConfigModel checkerConfig, Timestamp preCheckTime) throws Exception {
        SqlToyConfig sqlToyConfig = sqlToyContext.getSqlToyConfig(checkerConfig.getSql(), SqlType.search, "", null);
        String dataSourceName = checkerConfig.getDataSource();
        if (dataSourceName == null) {
            dataSourceName = sqlToyConfig.getDataSource();
        }
        QueryExecutor query = new QueryExecutor(checkerConfig.getSql(), sqlToyConfig.getParamsName(), new Object[]{new Date(preCheckTime.getTime())});
        DataSourceSelector dataSourceSelector = sqlToyContext.getDataSourceSelector();
        DataSource dataSource = dataSourceSelector.getDataSource(sqlToyContext.getAppContext(), null, dataSourceName, null, sqlToyContext.getDefaultDataSource());
        return DialectFactory.getInstance().findByQuery(sqlToyContext, query, sqlToyConfig, null, dataSource).getRows();
    }

    private static List doServiceCheck(SqlToyContext sqlToyContext, CheckerConfigModel checkerConfig, Timestamp preCheckTime) throws Exception {
        return (List)sqlToyContext.getServiceData(checkerConfig.getService(), checkerConfig.getMethod(), new Object[]{preCheckTime});
    }

    private static List doRestCheck(SqlToyContext sqlToyContext, CheckerConfigModel checkerConfig, Timestamp preCheckTime) throws Exception {
        String[] paramNames = new String[]{"lastUpdateTime"};
        String[] paramValues = new String[]{DateUtil.formatDate(preCheckTime, "yyyy-MM-dd HH:mm:ss.SSS")};
        String jsonStr = HttpClientUtils.doPost(sqlToyContext, checkerConfig.getUrl(), checkerConfig.getUsername(), checkerConfig.getPassword(), paramNames, paramValues);
        if (jsonStr == null) {
            return null;
        }
        List result = null;
        boolean fatal = false;
        try {
            result = JSON.parseArray((String)jsonStr, CacheCheckResult.class);
        }
        catch (Exception e) {
            fatal = true;
        }
        if (fatal) {
            try {
                result = JSON.parseArray((String)jsonStr, Object[].class);
                fatal = false;
            }
            catch (Exception e) {
                fatal = true;
            }
        }
        if (fatal) {
            logger.warn("rest\u6a21\u5f0f\u68c0\u6d4b\u7f13\u5b58\u662f\u5426\u66f4\u65b0\u6570\u636e\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38,\u6570\u636e\u683c\u5f0f\u662f\u6570\u7ec4\u6216CacheCheckResult\u5bf9\u8c61\u7c7b\u578b\u7684\u6570\u7ec4!");
        }
        return result;
    }

    private static List<CacheCheckResult> wrapClearCheckResult(List result, CheckerConfigModel checkerConfig) {
        if (result == null || result.isEmpty()) {
            return null;
        }
        if (result.get(0) instanceof CacheCheckResult) {
            return result;
        }
        List<Object[]> cacheSet = null;
        if (result.get(0) instanceof Object[]) {
            cacheSet = result;
        } else if (result.get(0) instanceof List) {
            cacheSet = CollectionUtil.innerListToArray(result);
        } else if (checkerConfig.getProperties() != null && checkerConfig.getProperties().length > 0) {
            cacheSet = BeanUtil.reflectBeansToInnerAry(result, checkerConfig.getProperties(), null, null);
        }
        if (cacheSet == null) {
            return null;
        }
        ArrayList<CacheCheckResult> checkResult = new ArrayList<CacheCheckResult>();
        int n = cacheSet.size();
        for (int i = 0; i < n; ++i) {
            Object[] row = cacheSet.get(i);
            CacheCheckResult item = new CacheCheckResult();
            item.setCacheName((String)row[0]);
            if (row.length > 1) {
                item.setCacheType((String)row[1]);
            }
            checkResult.add(item);
        }
        return checkResult;
    }

    private static List<CacheCheckResult> wrapIncrementCheckResult(List result, CheckerConfigModel checkerConfig) {
        if (result == null || result.isEmpty()) {
            return null;
        }
        if (result.get(0) instanceof CacheCheckResult) {
            return result;
        }
        List<Object[]> cacheSet = null;
        if (result.get(0) instanceof List) {
            cacheSet = CollectionUtil.innerListToArray(result);
        } else if (result.get(0) instanceof Object[]) {
            cacheSet = result;
        } else if (checkerConfig.getProperties() != null && checkerConfig.getProperties().length > 0) {
            cacheSet = BeanUtil.reflectBeansToInnerAry(result, checkerConfig.getProperties(), null, null);
        }
        if (cacheSet == null) {
            return null;
        }
        String cacheName = checkerConfig.getCache();
        boolean hasInsideGroup = checkerConfig.isHasInsideGroup();
        ArrayList<CacheCheckResult> checkResult = new ArrayList<CacheCheckResult>();
        int n = cacheSet.size();
        for (int i = 0; i < n; ++i) {
            Object[] row = cacheSet.get(i);
            CacheCheckResult item = new CacheCheckResult();
            item.setCacheName(cacheName);
            if (hasInsideGroup) {
                item.setCacheType((String)row[0]);
                Object[] cacheValue = new Object[row.length - 1];
                System.arraycopy(row, 1, cacheValue, 0, row.length - 1);
                item.setItem(cacheValue);
            } else {
                item.setItem(row);
            }
            checkResult.add(item);
        }
        return checkResult;
    }

    public static HashMap<String, Object[]> getCacheData(SqlToyContext sqlToyContext, TranslateConfigModel cacheModel, String cacheType) {
        List<Object[]> result = null;
        try {
            if ("sql".equals(cacheModel.getType())) {
                result = TranslateFactory.getSqlCacheData(sqlToyContext, cacheModel, cacheType);
            } else if ("service".equals(cacheModel.getType())) {
                result = TranslateFactory.getServiceCacheData(sqlToyContext, cacheModel, cacheType);
            } else if ("rest".equals(cacheModel.getType())) {
                result = TranslateFactory.getRestCacheData(sqlToyContext, cacheModel, cacheType);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u83b7\u53d6\u7f13\u5b58\u6570\u636e\u5931\u8d25,\u8fd4\u56de\u7ed3\u679c\u5e94\u8be5\u662fList<List> \u6216List<Object[]> \u6216 Map<String,Object[]> \u7c7b\u578b,\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
        }
        HashMap<String, Object[]> cacheData = TranslateFactory.wrapCacheResult(result, cacheModel);
        if (cacheData == null || cacheData.isEmpty()) {
            logger.warn("\u7f13\u5b58cacheName={} \u6570\u636e\u96c6\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u5bf9\u5e94\u7684\u914d\u7f6e\u548c\u67e5\u8be2\u903b\u8f91\u662f\u5426\u6b63\u786e!", (Object)cacheModel.getCache());
        }
        return cacheData;
    }

    private static List getSqlCacheData(SqlToyContext sqlToyContext, TranslateConfigModel cacheModel, String cacheType) throws Exception {
        SqlToyConfig sqlToyConfig = sqlToyContext.getSqlToyConfig(cacheModel.getSql(), SqlType.search, "", null);
        QueryExecutor queryExecutor = null;
        queryExecutor = StringUtil.isBlank(cacheType) ? new QueryExecutor(cacheModel.getSql()) : new QueryExecutor(cacheModel.getSql(), sqlToyConfig.getParamsName(), new Object[]{cacheType.trim()});
        String dataSourceName = cacheModel.getDataSource();
        if (dataSourceName == null) {
            dataSourceName = sqlToyConfig.getDataSource();
        }
        DataSourceSelector dataSourceSelector = sqlToyContext.getDataSourceSelector();
        DataSource dataSource = dataSourceSelector.getDataSource(sqlToyContext.getAppContext(), null, dataSourceName, null, sqlToyContext.getDefaultDataSource());
        QueryResult result = DialectFactory.getInstance().findByQuery(sqlToyContext, queryExecutor, sqlToyConfig, null, dataSource);
        cacheModel.setProperties(result.getLabelNames());
        return result.getRows();
    }

    private static Object getServiceCacheData(SqlToyContext sqlToyContext, TranslateConfigModel cacheModel, String cacheType) throws Exception {
        Object[] objectArray;
        String string = cacheModel.getService();
        String string2 = cacheModel.getMethod();
        if (StringUtil.isBlank(cacheType)) {
            objectArray = new Object[]{};
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = cacheType.trim();
        }
        return sqlToyContext.getServiceData(string, string2, objectArray);
    }

    private static List<Object[]> getRestCacheData(SqlToyContext sqlToyContext, TranslateConfigModel cacheModel, String cacheType) throws Exception {
        String jsonStr;
        String[] paramNames = new String[]{"cacheType", "type"};
        String[] paramValues = null;
        if (StringUtil.isNotBlank(cacheType)) {
            paramValues = new String[]{cacheType.trim(), cacheType.trim()};
        }
        if ((jsonStr = HttpClientUtils.doPost(sqlToyContext, cacheModel.getUrl(), cacheModel.getUsername(), cacheModel.getPassword(), paramNames, paramValues)) == null) {
            return null;
        }
        if (cacheModel.getProperties() == null || cacheModel.getProperties().length == 0) {
            return JSON.parseArray((String)jsonStr, Object[].class);
        }
        JSONArray jsonSet = JSON.parseArray((String)jsonStr);
        if (jsonSet.isEmpty()) {
            return null;
        }
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        int size = cacheModel.getProperties().length;
        for (Object obj : jsonSet) {
            JSONObject jsonObj = (JSONObject)obj;
            Object[] row = new Object[size];
            for (int i = 0; i < size; ++i) {
                row[i] = jsonObj.get(cacheModel.getProperties()[i]);
            }
            result.add(row);
        }
        return result;
    }

    private static HashMap<String, Object[]> wrapCacheResult(Object target, TranslateConfigModel cacheModel) {
        LinkedHashMap<String, Object[]> result;
        block17: {
            List tempList;
            block16: {
                if (target == null) {
                    return null;
                }
                if (target instanceof HashMap && ((HashMap)target).isEmpty()) {
                    return null;
                }
                if (target instanceof HashMap && ((HashMap)target).values().iterator().next().getClass().isArray()) {
                    return (HashMap)target;
                }
                result = new LinkedHashMap<String, Object[]>();
                if (!(target instanceof HashMap)) break block16;
                if (((HashMap)target).isEmpty()) break block17;
                if (((HashMap)target).values().iterator().next() instanceof List) {
                    for (Map.Entry entry : ((HashMap)target).entrySet()) {
                        Object[] row = new Object[((List)entry.getValue()).size()];
                        ((List)entry.getValue()).toArray(row);
                        result.put((String)entry.getKey(), row);
                    }
                } else {
                    for (Map.Entry entry : ((HashMap)target).entrySet()) {
                        result.put((String)entry.getKey(), new Object[]{entry.getKey(), entry.getValue()});
                    }
                }
                break block17;
            }
            if (target instanceof List && !(tempList = (List)target).isEmpty()) {
                int cacheIndex = cacheModel.getKeyIndex();
                if (tempList.get(0) instanceof List) {
                    int n = tempList.size();
                    for (int i = 0; i < n; ++i) {
                        List row = (List)tempList.get(i);
                        Object[] rowAry = new Object[row.size()];
                        row.toArray(rowAry);
                        result.put(rowAry[cacheIndex].toString(), rowAry);
                    }
                } else if (tempList.get(0) instanceof Object[]) {
                    int n = tempList.size();
                    for (int i = 0; i < n; ++i) {
                        Object[] row = (Object[])tempList.get(i);
                        result.put(row[cacheIndex].toString(), row);
                    }
                } else if (cacheModel.getProperties() != null && cacheModel.getProperties().length > 1) {
                    List<Object[]> dataSet = BeanUtil.reflectBeansToInnerAry(tempList, cacheModel.getProperties(), null, null);
                    for (Object[] row : dataSet) {
                        result.put(row[cacheIndex].toString(), row);
                    }
                }
            }
        }
        return result;
    }
}

